/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address.proto

package com.google.maps.addressvalidation.v1;

public interface AddressOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.maps.addressvalidation.v1.Address)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The post-processed address, formatted as a single-line address following
   * the address formatting rules of the region where the address is located.
   * </pre>
   *
   * <code>string formatted_address = 2;</code>
   *
   * @return The formattedAddress.
   */
  java.lang.String getFormattedAddress();
  /**
   *
   *
   * <pre>
   * The post-processed address, formatted as a single-line address following
   * the address formatting rules of the region where the address is located.
   * </pre>
   *
   * <code>string formatted_address = 2;</code>
   *
   * @return The bytes for formattedAddress.
   */
  com.google.protobuf.ByteString getFormattedAddressBytes();

  /**
   *
   *
   * <pre>
   * The post-processed address represented as a postal address.
   * </pre>
   *
   * <code>.google.type.PostalAddress postal_address = 3;</code>
   *
   * @return Whether the postalAddress field is set.
   */
  boolean hasPostalAddress();
  /**
   *
   *
   * <pre>
   * The post-processed address represented as a postal address.
   * </pre>
   *
   * <code>.google.type.PostalAddress postal_address = 3;</code>
   *
   * @return The postalAddress.
   */
  com.google.type.PostalAddress getPostalAddress();
  /**
   *
   *
   * <pre>
   * The post-processed address represented as a postal address.
   * </pre>
   *
   * <code>.google.type.PostalAddress postal_address = 3;</code>
   */
  com.google.type.PostalAddressOrBuilder getPostalAddressOrBuilder();

  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  java.util.List<com.google.maps.addressvalidation.v1.AddressComponent> getAddressComponentsList();
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  com.google.maps.addressvalidation.v1.AddressComponent getAddressComponents(int index);
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  int getAddressComponentsCount();
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  java.util.List<? extends com.google.maps.addressvalidation.v1.AddressComponentOrBuilder>
      getAddressComponentsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Unordered list. The individual address components of the formatted and
   * corrected address, along with validation information. This provides
   * information on the validation status of the individual components.
   *
   * Address components are not ordered in a particular way. Do not make any
   * assumptions on the ordering of the address components in the list.
   * </pre>
   *
   * <code>
   * repeated .google.maps.addressvalidation.v1.AddressComponent address_components = 4 [(.google.api.field_behavior) = UNORDERED_LIST];
   * </code>
   */
  com.google.maps.addressvalidation.v1.AddressComponentOrBuilder getAddressComponentsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @return A list containing the missingComponentTypes.
   */
  java.util.List<java.lang.String> getMissingComponentTypesList();
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @return The count of missingComponentTypes.
   */
  int getMissingComponentTypesCount();
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The missingComponentTypes at the given index.
   */
  java.lang.String getMissingComponentTypes(int index);
  /**
   *
   *
   * <pre>
   * The types of components that were expected to be present in a correctly
   * formatted mailing address but were not found in the input AND could
   * not be inferred. Components of this type are not present in
   * `formatted_address`, `postal_address`, or `address_components`. An
   * example might be `['street_number', 'route']` for an input like
   * "Boulder, Colorado, 80301, USA". The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string missing_component_types = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the missingComponentTypes at the given index.
   */
  com.google.protobuf.ByteString getMissingComponentTypesBytes(int index);

  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @return A list containing the unconfirmedComponentTypes.
   */
  java.util.List<java.lang.String> getUnconfirmedComponentTypesList();
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @return The count of unconfirmedComponentTypes.
   */
  int getUnconfirmedComponentTypesCount();
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The unconfirmedComponentTypes at the given index.
   */
  java.lang.String getUnconfirmedComponentTypes(int index);
  /**
   *
   *
   * <pre>
   * The types of the components that are present in the `address_components`
   * but could not be confirmed to be correct. This field is provided for the
   * sake of convenience: its contents are equivalent to iterating through the
   * `address_components` to find the types of all the components where the
   * [confirmation_level][google.maps.addressvalidation.v1.AddressComponent.confirmation_level]
   * is not
   * [CONFIRMED][google.maps.addressvalidation.v1.AddressComponent.ConfirmationLevel.CONFIRMED]
   * or the
   * [inferred][google.maps.addressvalidation.v1.AddressComponent.inferred]
   * flag is not set to `true`. The list of possible types can be found
   * [here](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string unconfirmed_component_types = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unconfirmedComponentTypes at the given index.
   */
  com.google.protobuf.ByteString getUnconfirmedComponentTypesBytes(int index);

  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @return A list containing the unresolvedTokens.
   */
  java.util.List<java.lang.String> getUnresolvedTokensList();
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @return The count of unresolvedTokens.
   */
  int getUnresolvedTokensCount();
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The unresolvedTokens at the given index.
   */
  java.lang.String getUnresolvedTokens(int index);
  /**
   *
   *
   * <pre>
   * Any tokens in the input that could not be resolved. This might be an
   * input that was not recognized as a valid part of an address (for example
   * in an input like "123235253253 Main St, San Francisco, CA, 94105", the
   * unresolved tokens may look like `["123235253253"]` since that does not
   * look like a valid street number.
   * </pre>
   *
   * <code>repeated string unresolved_tokens = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unresolvedTokens at the given index.
   */
  com.google.protobuf.ByteString getUnresolvedTokensBytes(int index);
}
