/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/usps_data.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * The USPS data for the address. `uspsData` is not guaranteed to be fully
 * populated for every US or PR address sent to the Address Validation API. It's
 * recommended to integrate the backup address fields in the response if you
 * utilize uspsData as the primary part of the response.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.UspsData}
 */
public final class UspsData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.UspsData)
    UspsDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UspsData.newBuilder() to construct.
  private UspsData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UspsData() {
    deliveryPointCode_ = "";
    deliveryPointCheckDigit_ = "";
    dpvConfirmation_ = "";
    dpvFootnote_ = "";
    dpvCmra_ = "";
    dpvVacant_ = "";
    dpvNoStat_ = "";
    carrierRoute_ = "";
    carrierRouteIndicator_ = "";
    postOfficeCity_ = "";
    postOfficeState_ = "";
    abbreviatedCity_ = "";
    fipsCountyCode_ = "";
    county_ = "";
    elotNumber_ = "";
    elotFlag_ = "";
    lacsLinkReturnCode_ = "";
    lacsLinkIndicator_ = "";
    suitelinkFootnote_ = "";
    pmbDesignator_ = "";
    pmbNumber_ = "";
    addressRecordType_ = "";
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UspsData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.UspsDataProto
        .internal_static_google_maps_addressvalidation_v1_UspsData_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.UspsDataProto
        .internal_static_google_maps_addressvalidation_v1_UspsData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.UspsData.class,
            com.google.maps.addressvalidation.v1.UspsData.Builder.class);
  }

  public static final int STANDARDIZED_ADDRESS_FIELD_NUMBER = 1;
  private com.google.maps.addressvalidation.v1.UspsAddress standardizedAddress_;
  /**
   *
   *
   * <pre>
   * USPS standardized address.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
   *
   * @return Whether the standardizedAddress field is set.
   */
  @java.lang.Override
  public boolean hasStandardizedAddress() {
    return standardizedAddress_ != null;
  }
  /**
   *
   *
   * <pre>
   * USPS standardized address.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
   *
   * @return The standardizedAddress.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.UspsAddress getStandardizedAddress() {
    return standardizedAddress_ == null
        ? com.google.maps.addressvalidation.v1.UspsAddress.getDefaultInstance()
        : standardizedAddress_;
  }
  /**
   *
   *
   * <pre>
   * USPS standardized address.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.UspsAddressOrBuilder
      getStandardizedAddressOrBuilder() {
    return standardizedAddress_ == null
        ? com.google.maps.addressvalidation.v1.UspsAddress.getDefaultInstance()
        : standardizedAddress_;
  }

  public static final int DELIVERY_POINT_CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deliveryPointCode_ = "";
  /**
   *
   *
   * <pre>
   * 2 digit delivery point code
   * </pre>
   *
   * <code>string delivery_point_code = 2;</code>
   *
   * @return The deliveryPointCode.
   */
  @java.lang.Override
  public java.lang.String getDeliveryPointCode() {
    java.lang.Object ref = deliveryPointCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deliveryPointCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * 2 digit delivery point code
   * </pre>
   *
   * <code>string delivery_point_code = 2;</code>
   *
   * @return The bytes for deliveryPointCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeliveryPointCodeBytes() {
    java.lang.Object ref = deliveryPointCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deliveryPointCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELIVERY_POINT_CHECK_DIGIT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deliveryPointCheckDigit_ = "";
  /**
   *
   *
   * <pre>
   * The delivery point check digit. This number is added to the end of the
   * delivery_point_barcode for mechanically scanned mail. Adding all the
   * digits of the delivery_point_barcode, delivery_point_check_digit, postal
   * code, and ZIP+4 together should yield a number divisible by 10.
   * </pre>
   *
   * <code>string delivery_point_check_digit = 3;</code>
   *
   * @return The deliveryPointCheckDigit.
   */
  @java.lang.Override
  public java.lang.String getDeliveryPointCheckDigit() {
    java.lang.Object ref = deliveryPointCheckDigit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deliveryPointCheckDigit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The delivery point check digit. This number is added to the end of the
   * delivery_point_barcode for mechanically scanned mail. Adding all the
   * digits of the delivery_point_barcode, delivery_point_check_digit, postal
   * code, and ZIP+4 together should yield a number divisible by 10.
   * </pre>
   *
   * <code>string delivery_point_check_digit = 3;</code>
   *
   * @return The bytes for deliveryPointCheckDigit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeliveryPointCheckDigitBytes() {
    java.lang.Object ref = deliveryPointCheckDigit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deliveryPointCheckDigit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DPV_CONFIRMATION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dpvConfirmation_ = "";
  /**
   *
   *
   * <pre>
   * The possible values for DPV confirmation. Returns a single character.
   *
   * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
   * * `N`: Primary and any secondary number information failed to
   * DPV confirm.
   * * `S`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was present by not confirmed.
   * * `D`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was missing.
   * </pre>
   *
   * <code>string dpv_confirmation = 4;</code>
   *
   * @return The dpvConfirmation.
   */
  @java.lang.Override
  public java.lang.String getDpvConfirmation() {
    java.lang.Object ref = dpvConfirmation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dpvConfirmation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The possible values for DPV confirmation. Returns a single character.
   *
   * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
   * * `N`: Primary and any secondary number information failed to
   * DPV confirm.
   * * `S`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was present by not confirmed.
   * * `D`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was missing.
   * </pre>
   *
   * <code>string dpv_confirmation = 4;</code>
   *
   * @return The bytes for dpvConfirmation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDpvConfirmationBytes() {
    java.lang.Object ref = dpvConfirmation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dpvConfirmation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DPV_FOOTNOTE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dpvFootnote_ = "";
  /**
   *
   *
   * <pre>
   * The footnotes from delivery point validation.
   * Multiple footnotes may be strung together in the same string.
   *
   * * `AA`: Input address matched to the ZIP+4 file
   * * `A1`: Input address was not matched to the ZIP+4 file
   * * `BB`: Matched to DPV (all components)
   * * `CC`: Secondary number not matched (present but invalid)
   * * `N1`: High-rise address missing secondary number
   * * `M1`: Primary number missing
   * * `M3`: Primary number invalid
   * * `P1`: Input address RR or HC box number missing
   * * `P3`: Input address PO, RR, or HC Box number invalid
   * * `F1`: Input address matched to a military address
   * * `G1`: Input address matched to a general delivery address
   * * `U1`: Input address matched to a unique ZIP code
   * * `PB`: Input address matched to PBSA record
   * * `RR`: DPV confirmed address with PMB information
   * * `R1`: DPV confirmed address without PMB information
   * * `R7`: Carrier Route R777 or R779 record
   * </pre>
   *
   * <code>string dpv_footnote = 5;</code>
   *
   * @return The dpvFootnote.
   */
  @java.lang.Override
  public java.lang.String getDpvFootnote() {
    java.lang.Object ref = dpvFootnote_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dpvFootnote_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The footnotes from delivery point validation.
   * Multiple footnotes may be strung together in the same string.
   *
   * * `AA`: Input address matched to the ZIP+4 file
   * * `A1`: Input address was not matched to the ZIP+4 file
   * * `BB`: Matched to DPV (all components)
   * * `CC`: Secondary number not matched (present but invalid)
   * * `N1`: High-rise address missing secondary number
   * * `M1`: Primary number missing
   * * `M3`: Primary number invalid
   * * `P1`: Input address RR or HC box number missing
   * * `P3`: Input address PO, RR, or HC Box number invalid
   * * `F1`: Input address matched to a military address
   * * `G1`: Input address matched to a general delivery address
   * * `U1`: Input address matched to a unique ZIP code
   * * `PB`: Input address matched to PBSA record
   * * `RR`: DPV confirmed address with PMB information
   * * `R1`: DPV confirmed address without PMB information
   * * `R7`: Carrier Route R777 or R779 record
   * </pre>
   *
   * <code>string dpv_footnote = 5;</code>
   *
   * @return The bytes for dpvFootnote.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDpvFootnoteBytes() {
    java.lang.Object ref = dpvFootnote_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dpvFootnote_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DPV_CMRA_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dpvCmra_ = "";
  /**
   *
   *
   * <pre>
   * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
   * private business receiving mail for clients. Returns a single character.
   *
   * * `Y`: The address is a CMRA
   * * `N`: The address is not a CMRA
   * </pre>
   *
   * <code>string dpv_cmra = 6;</code>
   *
   * @return The dpvCmra.
   */
  @java.lang.Override
  public java.lang.String getDpvCmra() {
    java.lang.Object ref = dpvCmra_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dpvCmra_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
   * private business receiving mail for clients. Returns a single character.
   *
   * * `Y`: The address is a CMRA
   * * `N`: The address is not a CMRA
   * </pre>
   *
   * <code>string dpv_cmra = 6;</code>
   *
   * @return The bytes for dpvCmra.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDpvCmraBytes() {
    java.lang.Object ref = dpvCmra_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dpvCmra_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DPV_VACANT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dpvVacant_ = "";
  /**
   *
   *
   * <pre>
   * Is this place vacant?
   * Returns a single character.
   *
   * * `Y`: The address is vacant
   * * `N`: The address is not vacant
   * </pre>
   *
   * <code>string dpv_vacant = 7;</code>
   *
   * @return The dpvVacant.
   */
  @java.lang.Override
  public java.lang.String getDpvVacant() {
    java.lang.Object ref = dpvVacant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dpvVacant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Is this place vacant?
   * Returns a single character.
   *
   * * `Y`: The address is vacant
   * * `N`: The address is not vacant
   * </pre>
   *
   * <code>string dpv_vacant = 7;</code>
   *
   * @return The bytes for dpvVacant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDpvVacantBytes() {
    java.lang.Object ref = dpvVacant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dpvVacant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DPV_NO_STAT_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dpvNoStat_ = "";
  /**
   *
   *
   * <pre>
   * Is this a no stat address or an active address?
   * No stat addresses are ones which are not continuously occupied or addresses
   * that the USPS does not service. Returns a single character.
   *
   * * `Y`: The address is not active
   * * `N`: The address is active
   * </pre>
   *
   * <code>string dpv_no_stat = 8;</code>
   *
   * @return The dpvNoStat.
   */
  @java.lang.Override
  public java.lang.String getDpvNoStat() {
    java.lang.Object ref = dpvNoStat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dpvNoStat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Is this a no stat address or an active address?
   * No stat addresses are ones which are not continuously occupied or addresses
   * that the USPS does not service. Returns a single character.
   *
   * * `Y`: The address is not active
   * * `N`: The address is active
   * </pre>
   *
   * <code>string dpv_no_stat = 8;</code>
   *
   * @return The bytes for dpvNoStat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDpvNoStatBytes() {
    java.lang.Object ref = dpvNoStat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dpvNoStat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CARRIER_ROUTE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object carrierRoute_ = "";
  /**
   *
   *
   * <pre>
   * The carrier route code.
   * A four character code consisting of a one letter prefix and a three digit
   * route designator.
   *
   * Prefixes:
   *
   * * `C`: Carrier route (or city route)
   * * `R`: Rural route
   * * `H`: Highway Contract Route
   * * `B`: Post Office Box Section
   * * `G`: General delivery unit
   * </pre>
   *
   * <code>string carrier_route = 9;</code>
   *
   * @return The carrierRoute.
   */
  @java.lang.Override
  public java.lang.String getCarrierRoute() {
    java.lang.Object ref = carrierRoute_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      carrierRoute_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The carrier route code.
   * A four character code consisting of a one letter prefix and a three digit
   * route designator.
   *
   * Prefixes:
   *
   * * `C`: Carrier route (or city route)
   * * `R`: Rural route
   * * `H`: Highway Contract Route
   * * `B`: Post Office Box Section
   * * `G`: General delivery unit
   * </pre>
   *
   * <code>string carrier_route = 9;</code>
   *
   * @return The bytes for carrierRoute.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCarrierRouteBytes() {
    java.lang.Object ref = carrierRoute_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      carrierRoute_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CARRIER_ROUTE_INDICATOR_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object carrierRouteIndicator_ = "";
  /**
   *
   *
   * <pre>
   * Carrier route rate sort indicator.
   * </pre>
   *
   * <code>string carrier_route_indicator = 10;</code>
   *
   * @return The carrierRouteIndicator.
   */
  @java.lang.Override
  public java.lang.String getCarrierRouteIndicator() {
    java.lang.Object ref = carrierRouteIndicator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      carrierRouteIndicator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Carrier route rate sort indicator.
   * </pre>
   *
   * <code>string carrier_route_indicator = 10;</code>
   *
   * @return The bytes for carrierRouteIndicator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCarrierRouteIndicatorBytes() {
    java.lang.Object ref = carrierRouteIndicator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      carrierRouteIndicator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EWS_NO_MATCH_FIELD_NUMBER = 11;
  private boolean ewsNoMatch_ = false;
  /**
   *
   *
   * <pre>
   * The delivery address is matchable, but the EWS file indicates that an exact
   * match will be available soon.
   * </pre>
   *
   * <code>bool ews_no_match = 11;</code>
   *
   * @return The ewsNoMatch.
   */
  @java.lang.Override
  public boolean getEwsNoMatch() {
    return ewsNoMatch_;
  }

  public static final int POST_OFFICE_CITY_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postOfficeCity_ = "";
  /**
   *
   *
   * <pre>
   * Main post office city.
   * </pre>
   *
   * <code>string post_office_city = 12;</code>
   *
   * @return The postOfficeCity.
   */
  @java.lang.Override
  public java.lang.String getPostOfficeCity() {
    java.lang.Object ref = postOfficeCity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postOfficeCity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Main post office city.
   * </pre>
   *
   * <code>string post_office_city = 12;</code>
   *
   * @return The bytes for postOfficeCity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPostOfficeCityBytes() {
    java.lang.Object ref = postOfficeCity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postOfficeCity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POST_OFFICE_STATE_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object postOfficeState_ = "";
  /**
   *
   *
   * <pre>
   * Main post office state.
   * </pre>
   *
   * <code>string post_office_state = 13;</code>
   *
   * @return The postOfficeState.
   */
  @java.lang.Override
  public java.lang.String getPostOfficeState() {
    java.lang.Object ref = postOfficeState_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      postOfficeState_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Main post office state.
   * </pre>
   *
   * <code>string post_office_state = 13;</code>
   *
   * @return The bytes for postOfficeState.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPostOfficeStateBytes() {
    java.lang.Object ref = postOfficeState_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      postOfficeState_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ABBREVIATED_CITY_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object abbreviatedCity_ = "";
  /**
   *
   *
   * <pre>
   * Abbreviated city.
   * </pre>
   *
   * <code>string abbreviated_city = 14;</code>
   *
   * @return The abbreviatedCity.
   */
  @java.lang.Override
  public java.lang.String getAbbreviatedCity() {
    java.lang.Object ref = abbreviatedCity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      abbreviatedCity_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Abbreviated city.
   * </pre>
   *
   * <code>string abbreviated_city = 14;</code>
   *
   * @return The bytes for abbreviatedCity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAbbreviatedCityBytes() {
    java.lang.Object ref = abbreviatedCity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      abbreviatedCity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIPS_COUNTY_CODE_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fipsCountyCode_ = "";
  /**
   *
   *
   * <pre>
   * FIPS county code.
   * </pre>
   *
   * <code>string fips_county_code = 15;</code>
   *
   * @return The fipsCountyCode.
   */
  @java.lang.Override
  public java.lang.String getFipsCountyCode() {
    java.lang.Object ref = fipsCountyCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fipsCountyCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * FIPS county code.
   * </pre>
   *
   * <code>string fips_county_code = 15;</code>
   *
   * @return The bytes for fipsCountyCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFipsCountyCodeBytes() {
    java.lang.Object ref = fipsCountyCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fipsCountyCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COUNTY_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object county_ = "";
  /**
   *
   *
   * <pre>
   * County name.
   * </pre>
   *
   * <code>string county = 16;</code>
   *
   * @return The county.
   */
  @java.lang.Override
  public java.lang.String getCounty() {
    java.lang.Object ref = county_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      county_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * County name.
   * </pre>
   *
   * <code>string county = 16;</code>
   *
   * @return The bytes for county.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCountyBytes() {
    java.lang.Object ref = county_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      county_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ELOT_NUMBER_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object elotNumber_ = "";
  /**
   *
   *
   * <pre>
   * Enhanced Line of Travel (eLOT) number.
   * </pre>
   *
   * <code>string elot_number = 17;</code>
   *
   * @return The elotNumber.
   */
  @java.lang.Override
  public java.lang.String getElotNumber() {
    java.lang.Object ref = elotNumber_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      elotNumber_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Enhanced Line of Travel (eLOT) number.
   * </pre>
   *
   * <code>string elot_number = 17;</code>
   *
   * @return The bytes for elotNumber.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getElotNumberBytes() {
    java.lang.Object ref = elotNumber_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      elotNumber_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ELOT_FLAG_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object elotFlag_ = "";
  /**
   *
   *
   * <pre>
   * eLOT Ascending/Descending Flag (A/D).
   * </pre>
   *
   * <code>string elot_flag = 18;</code>
   *
   * @return The elotFlag.
   */
  @java.lang.Override
  public java.lang.String getElotFlag() {
    java.lang.Object ref = elotFlag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      elotFlag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * eLOT Ascending/Descending Flag (A/D).
   * </pre>
   *
   * <code>string elot_flag = 18;</code>
   *
   * @return The bytes for elotFlag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getElotFlagBytes() {
    java.lang.Object ref = elotFlag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      elotFlag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LACS_LINK_RETURN_CODE_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lacsLinkReturnCode_ = "";
  /**
   *
   *
   * <pre>
   * LACSLink return code.
   * </pre>
   *
   * <code>string lacs_link_return_code = 19;</code>
   *
   * @return The lacsLinkReturnCode.
   */
  @java.lang.Override
  public java.lang.String getLacsLinkReturnCode() {
    java.lang.Object ref = lacsLinkReturnCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lacsLinkReturnCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * LACSLink return code.
   * </pre>
   *
   * <code>string lacs_link_return_code = 19;</code>
   *
   * @return The bytes for lacsLinkReturnCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLacsLinkReturnCodeBytes() {
    java.lang.Object ref = lacsLinkReturnCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lacsLinkReturnCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LACS_LINK_INDICATOR_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lacsLinkIndicator_ = "";
  /**
   *
   *
   * <pre>
   * LACSLink indicator.
   * </pre>
   *
   * <code>string lacs_link_indicator = 20;</code>
   *
   * @return The lacsLinkIndicator.
   */
  @java.lang.Override
  public java.lang.String getLacsLinkIndicator() {
    java.lang.Object ref = lacsLinkIndicator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lacsLinkIndicator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * LACSLink indicator.
   * </pre>
   *
   * <code>string lacs_link_indicator = 20;</code>
   *
   * @return The bytes for lacsLinkIndicator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLacsLinkIndicatorBytes() {
    java.lang.Object ref = lacsLinkIndicator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lacsLinkIndicator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PO_BOX_ONLY_POSTAL_CODE_FIELD_NUMBER = 21;
  private boolean poBoxOnlyPostalCode_ = false;
  /**
   *
   *
   * <pre>
   * PO Box only postal code.
   * </pre>
   *
   * <code>bool po_box_only_postal_code = 21;</code>
   *
   * @return The poBoxOnlyPostalCode.
   */
  @java.lang.Override
  public boolean getPoBoxOnlyPostalCode() {
    return poBoxOnlyPostalCode_;
  }

  public static final int SUITELINK_FOOTNOTE_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object suitelinkFootnote_ = "";
  /**
   *
   *
   * <pre>
   * Footnotes from matching a street or highrise record to suite information.
   * If business name match is found, the secondary number is returned.
   *
   * * `A`: SuiteLink record match, business address improved.
   * * `00`: No match, business address is not improved.
   * </pre>
   *
   * <code>string suitelink_footnote = 22;</code>
   *
   * @return The suitelinkFootnote.
   */
  @java.lang.Override
  public java.lang.String getSuitelinkFootnote() {
    java.lang.Object ref = suitelinkFootnote_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      suitelinkFootnote_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Footnotes from matching a street or highrise record to suite information.
   * If business name match is found, the secondary number is returned.
   *
   * * `A`: SuiteLink record match, business address improved.
   * * `00`: No match, business address is not improved.
   * </pre>
   *
   * <code>string suitelink_footnote = 22;</code>
   *
   * @return The bytes for suitelinkFootnote.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSuitelinkFootnoteBytes() {
    java.lang.Object ref = suitelinkFootnote_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      suitelinkFootnote_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PMB_DESIGNATOR_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pmbDesignator_ = "";
  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) unit designator.
   * </pre>
   *
   * <code>string pmb_designator = 23;</code>
   *
   * @return The pmbDesignator.
   */
  @java.lang.Override
  public java.lang.String getPmbDesignator() {
    java.lang.Object ref = pmbDesignator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pmbDesignator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) unit designator.
   * </pre>
   *
   * <code>string pmb_designator = 23;</code>
   *
   * @return The bytes for pmbDesignator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPmbDesignatorBytes() {
    java.lang.Object ref = pmbDesignator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pmbDesignator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PMB_NUMBER_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pmbNumber_ = "";
  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) number;
   * </pre>
   *
   * <code>string pmb_number = 24;</code>
   *
   * @return The pmbNumber.
   */
  @java.lang.Override
  public java.lang.String getPmbNumber() {
    java.lang.Object ref = pmbNumber_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pmbNumber_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) number;
   * </pre>
   *
   * <code>string pmb_number = 24;</code>
   *
   * @return The bytes for pmbNumber.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPmbNumberBytes() {
    java.lang.Object ref = pmbNumber_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pmbNumber_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDRESS_RECORD_TYPE_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object addressRecordType_ = "";
  /**
   *
   *
   * <pre>
   * Type of the address record that matches the input address.
   *
   * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
   * match available for an address.
   * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
   * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
   * record.
   * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
   * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
   * Route or a Highway Contract record, both of which may have associated Box
   * Number ranges.
   * * `S`: STREET RECORD: This is a match to a Street record containing a valid
   * primary number range.
   * </pre>
   *
   * <code>string address_record_type = 25;</code>
   *
   * @return The addressRecordType.
   */
  @java.lang.Override
  public java.lang.String getAddressRecordType() {
    java.lang.Object ref = addressRecordType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      addressRecordType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of the address record that matches the input address.
   *
   * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
   * match available for an address.
   * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
   * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
   * record.
   * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
   * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
   * Route or a Highway Contract record, both of which may have associated Box
   * Number ranges.
   * * `S`: STREET RECORD: This is a match to a Street record containing a valid
   * primary number range.
   * </pre>
   *
   * <code>string address_record_type = 25;</code>
   *
   * @return The bytes for addressRecordType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAddressRecordTypeBytes() {
    java.lang.Object ref = addressRecordType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      addressRecordType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_ADDRESS_FIELD_NUMBER = 26;
  private boolean defaultAddress_ = false;
  /**
   *
   *
   * <pre>
   * Indicator that a default address was found, but more specific addresses
   * exists.
   * </pre>
   *
   * <code>bool default_address = 26;</code>
   *
   * @return The defaultAddress.
   */
  @java.lang.Override
  public boolean getDefaultAddress() {
    return defaultAddress_;
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * Error message for USPS data retrieval. This is populated when USPS
   * processing is suspended because of the detection of artificially created
   * addresses.
   *
   * The USPS data fields might not be populated when this error is present.
   * </pre>
   *
   * <code>string error_message = 27;</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Error message for USPS data retrieval. This is populated when USPS
   * processing is suspended because of the detection of artificially created
   * addresses.
   *
   * The USPS data fields might not be populated when this error is present.
   * </pre>
   *
   * <code>string error_message = 27;</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CASS_PROCESSED_FIELD_NUMBER = 28;
  private boolean cassProcessed_ = false;
  /**
   *
   *
   * <pre>
   * Indicator that the request has been CASS processed.
   * </pre>
   *
   * <code>bool cass_processed = 28;</code>
   *
   * @return The cassProcessed.
   */
  @java.lang.Override
  public boolean getCassProcessed() {
    return cassProcessed_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (standardizedAddress_ != null) {
      output.writeMessage(1, getStandardizedAddress());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deliveryPointCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deliveryPointCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deliveryPointCheckDigit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, deliveryPointCheckDigit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvConfirmation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, dpvConfirmation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvFootnote_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dpvFootnote_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvCmra_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, dpvCmra_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvVacant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, dpvVacant_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvNoStat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, dpvNoStat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(carrierRoute_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, carrierRoute_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(carrierRouteIndicator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, carrierRouteIndicator_);
    }
    if (ewsNoMatch_ != false) {
      output.writeBool(11, ewsNoMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postOfficeCity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, postOfficeCity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postOfficeState_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, postOfficeState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(abbreviatedCity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, abbreviatedCity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fipsCountyCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, fipsCountyCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(county_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, county_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(elotNumber_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, elotNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(elotFlag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, elotFlag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lacsLinkReturnCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, lacsLinkReturnCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lacsLinkIndicator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, lacsLinkIndicator_);
    }
    if (poBoxOnlyPostalCode_ != false) {
      output.writeBool(21, poBoxOnlyPostalCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suitelinkFootnote_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, suitelinkFootnote_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pmbDesignator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, pmbDesignator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pmbNumber_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 24, pmbNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(addressRecordType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, addressRecordType_);
    }
    if (defaultAddress_ != false) {
      output.writeBool(26, defaultAddress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, errorMessage_);
    }
    if (cassProcessed_ != false) {
      output.writeBool(28, cassProcessed_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (standardizedAddress_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStandardizedAddress());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deliveryPointCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deliveryPointCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deliveryPointCheckDigit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, deliveryPointCheckDigit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvConfirmation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, dpvConfirmation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvFootnote_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, dpvFootnote_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvCmra_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, dpvCmra_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvVacant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, dpvVacant_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dpvNoStat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, dpvNoStat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(carrierRoute_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, carrierRoute_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(carrierRouteIndicator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, carrierRouteIndicator_);
    }
    if (ewsNoMatch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, ewsNoMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postOfficeCity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, postOfficeCity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(postOfficeState_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, postOfficeState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(abbreviatedCity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, abbreviatedCity_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fipsCountyCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, fipsCountyCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(county_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, county_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(elotNumber_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, elotNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(elotFlag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, elotFlag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lacsLinkReturnCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, lacsLinkReturnCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lacsLinkIndicator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, lacsLinkIndicator_);
    }
    if (poBoxOnlyPostalCode_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(21, poBoxOnlyPostalCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suitelinkFootnote_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, suitelinkFootnote_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pmbDesignator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(23, pmbDesignator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pmbNumber_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(24, pmbNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(addressRecordType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, addressRecordType_);
    }
    if (defaultAddress_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(26, defaultAddress_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, errorMessage_);
    }
    if (cassProcessed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(28, cassProcessed_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.UspsData)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.UspsData other =
        (com.google.maps.addressvalidation.v1.UspsData) obj;

    if (hasStandardizedAddress() != other.hasStandardizedAddress()) return false;
    if (hasStandardizedAddress()) {
      if (!getStandardizedAddress().equals(other.getStandardizedAddress())) return false;
    }
    if (!getDeliveryPointCode().equals(other.getDeliveryPointCode())) return false;
    if (!getDeliveryPointCheckDigit().equals(other.getDeliveryPointCheckDigit())) return false;
    if (!getDpvConfirmation().equals(other.getDpvConfirmation())) return false;
    if (!getDpvFootnote().equals(other.getDpvFootnote())) return false;
    if (!getDpvCmra().equals(other.getDpvCmra())) return false;
    if (!getDpvVacant().equals(other.getDpvVacant())) return false;
    if (!getDpvNoStat().equals(other.getDpvNoStat())) return false;
    if (!getCarrierRoute().equals(other.getCarrierRoute())) return false;
    if (!getCarrierRouteIndicator().equals(other.getCarrierRouteIndicator())) return false;
    if (getEwsNoMatch() != other.getEwsNoMatch()) return false;
    if (!getPostOfficeCity().equals(other.getPostOfficeCity())) return false;
    if (!getPostOfficeState().equals(other.getPostOfficeState())) return false;
    if (!getAbbreviatedCity().equals(other.getAbbreviatedCity())) return false;
    if (!getFipsCountyCode().equals(other.getFipsCountyCode())) return false;
    if (!getCounty().equals(other.getCounty())) return false;
    if (!getElotNumber().equals(other.getElotNumber())) return false;
    if (!getElotFlag().equals(other.getElotFlag())) return false;
    if (!getLacsLinkReturnCode().equals(other.getLacsLinkReturnCode())) return false;
    if (!getLacsLinkIndicator().equals(other.getLacsLinkIndicator())) return false;
    if (getPoBoxOnlyPostalCode() != other.getPoBoxOnlyPostalCode()) return false;
    if (!getSuitelinkFootnote().equals(other.getSuitelinkFootnote())) return false;
    if (!getPmbDesignator().equals(other.getPmbDesignator())) return false;
    if (!getPmbNumber().equals(other.getPmbNumber())) return false;
    if (!getAddressRecordType().equals(other.getAddressRecordType())) return false;
    if (getDefaultAddress() != other.getDefaultAddress()) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (getCassProcessed() != other.getCassProcessed()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStandardizedAddress()) {
      hash = (37 * hash) + STANDARDIZED_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getStandardizedAddress().hashCode();
    }
    hash = (37 * hash) + DELIVERY_POINT_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getDeliveryPointCode().hashCode();
    hash = (37 * hash) + DELIVERY_POINT_CHECK_DIGIT_FIELD_NUMBER;
    hash = (53 * hash) + getDeliveryPointCheckDigit().hashCode();
    hash = (37 * hash) + DPV_CONFIRMATION_FIELD_NUMBER;
    hash = (53 * hash) + getDpvConfirmation().hashCode();
    hash = (37 * hash) + DPV_FOOTNOTE_FIELD_NUMBER;
    hash = (53 * hash) + getDpvFootnote().hashCode();
    hash = (37 * hash) + DPV_CMRA_FIELD_NUMBER;
    hash = (53 * hash) + getDpvCmra().hashCode();
    hash = (37 * hash) + DPV_VACANT_FIELD_NUMBER;
    hash = (53 * hash) + getDpvVacant().hashCode();
    hash = (37 * hash) + DPV_NO_STAT_FIELD_NUMBER;
    hash = (53 * hash) + getDpvNoStat().hashCode();
    hash = (37 * hash) + CARRIER_ROUTE_FIELD_NUMBER;
    hash = (53 * hash) + getCarrierRoute().hashCode();
    hash = (37 * hash) + CARRIER_ROUTE_INDICATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCarrierRouteIndicator().hashCode();
    hash = (37 * hash) + EWS_NO_MATCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEwsNoMatch());
    hash = (37 * hash) + POST_OFFICE_CITY_FIELD_NUMBER;
    hash = (53 * hash) + getPostOfficeCity().hashCode();
    hash = (37 * hash) + POST_OFFICE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + getPostOfficeState().hashCode();
    hash = (37 * hash) + ABBREVIATED_CITY_FIELD_NUMBER;
    hash = (53 * hash) + getAbbreviatedCity().hashCode();
    hash = (37 * hash) + FIPS_COUNTY_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getFipsCountyCode().hashCode();
    hash = (37 * hash) + COUNTY_FIELD_NUMBER;
    hash = (53 * hash) + getCounty().hashCode();
    hash = (37 * hash) + ELOT_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getElotNumber().hashCode();
    hash = (37 * hash) + ELOT_FLAG_FIELD_NUMBER;
    hash = (53 * hash) + getElotFlag().hashCode();
    hash = (37 * hash) + LACS_LINK_RETURN_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLacsLinkReturnCode().hashCode();
    hash = (37 * hash) + LACS_LINK_INDICATOR_FIELD_NUMBER;
    hash = (53 * hash) + getLacsLinkIndicator().hashCode();
    hash = (37 * hash) + PO_BOX_ONLY_POSTAL_CODE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPoBoxOnlyPostalCode());
    hash = (37 * hash) + SUITELINK_FOOTNOTE_FIELD_NUMBER;
    hash = (53 * hash) + getSuitelinkFootnote().hashCode();
    hash = (37 * hash) + PMB_DESIGNATOR_FIELD_NUMBER;
    hash = (53 * hash) + getPmbDesignator().hashCode();
    hash = (37 * hash) + PMB_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getPmbNumber().hashCode();
    hash = (37 * hash) + ADDRESS_RECORD_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getAddressRecordType().hashCode();
    hash = (37 * hash) + DEFAULT_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDefaultAddress());
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (37 * hash) + CASS_PROCESSED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCassProcessed());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.UspsData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.addressvalidation.v1.UspsData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The USPS data for the address. `uspsData` is not guaranteed to be fully
   * populated for every US or PR address sent to the Address Validation API. It's
   * recommended to integrate the backup address fields in the response if you
   * utilize uspsData as the primary part of the response.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.UspsData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.UspsData)
      com.google.maps.addressvalidation.v1.UspsDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.UspsDataProto
          .internal_static_google_maps_addressvalidation_v1_UspsData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.UspsDataProto
          .internal_static_google_maps_addressvalidation_v1_UspsData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.UspsData.class,
              com.google.maps.addressvalidation.v1.UspsData.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.UspsData.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      standardizedAddress_ = null;
      if (standardizedAddressBuilder_ != null) {
        standardizedAddressBuilder_.dispose();
        standardizedAddressBuilder_ = null;
      }
      deliveryPointCode_ = "";
      deliveryPointCheckDigit_ = "";
      dpvConfirmation_ = "";
      dpvFootnote_ = "";
      dpvCmra_ = "";
      dpvVacant_ = "";
      dpvNoStat_ = "";
      carrierRoute_ = "";
      carrierRouteIndicator_ = "";
      ewsNoMatch_ = false;
      postOfficeCity_ = "";
      postOfficeState_ = "";
      abbreviatedCity_ = "";
      fipsCountyCode_ = "";
      county_ = "";
      elotNumber_ = "";
      elotFlag_ = "";
      lacsLinkReturnCode_ = "";
      lacsLinkIndicator_ = "";
      poBoxOnlyPostalCode_ = false;
      suitelinkFootnote_ = "";
      pmbDesignator_ = "";
      pmbNumber_ = "";
      addressRecordType_ = "";
      defaultAddress_ = false;
      errorMessage_ = "";
      cassProcessed_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.UspsDataProto
          .internal_static_google_maps_addressvalidation_v1_UspsData_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.UspsData getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.UspsData build() {
      com.google.maps.addressvalidation.v1.UspsData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.UspsData buildPartial() {
      com.google.maps.addressvalidation.v1.UspsData result =
          new com.google.maps.addressvalidation.v1.UspsData(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.UspsData result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.standardizedAddress_ =
            standardizedAddressBuilder_ == null
                ? standardizedAddress_
                : standardizedAddressBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deliveryPointCode_ = deliveryPointCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.deliveryPointCheckDigit_ = deliveryPointCheckDigit_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.dpvConfirmation_ = dpvConfirmation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dpvFootnote_ = dpvFootnote_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dpvCmra_ = dpvCmra_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.dpvVacant_ = dpvVacant_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.dpvNoStat_ = dpvNoStat_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.carrierRoute_ = carrierRoute_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.carrierRouteIndicator_ = carrierRouteIndicator_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ewsNoMatch_ = ewsNoMatch_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.postOfficeCity_ = postOfficeCity_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.postOfficeState_ = postOfficeState_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.abbreviatedCity_ = abbreviatedCity_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.fipsCountyCode_ = fipsCountyCode_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.county_ = county_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.elotNumber_ = elotNumber_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.elotFlag_ = elotFlag_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.lacsLinkReturnCode_ = lacsLinkReturnCode_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.lacsLinkIndicator_ = lacsLinkIndicator_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.poBoxOnlyPostalCode_ = poBoxOnlyPostalCode_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.suitelinkFootnote_ = suitelinkFootnote_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.pmbDesignator_ = pmbDesignator_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.pmbNumber_ = pmbNumber_;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.addressRecordType_ = addressRecordType_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.defaultAddress_ = defaultAddress_;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.cassProcessed_ = cassProcessed_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.UspsData) {
        return mergeFrom((com.google.maps.addressvalidation.v1.UspsData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.UspsData other) {
      if (other == com.google.maps.addressvalidation.v1.UspsData.getDefaultInstance()) return this;
      if (other.hasStandardizedAddress()) {
        mergeStandardizedAddress(other.getStandardizedAddress());
      }
      if (!other.getDeliveryPointCode().isEmpty()) {
        deliveryPointCode_ = other.deliveryPointCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDeliveryPointCheckDigit().isEmpty()) {
        deliveryPointCheckDigit_ = other.deliveryPointCheckDigit_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDpvConfirmation().isEmpty()) {
        dpvConfirmation_ = other.dpvConfirmation_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDpvFootnote().isEmpty()) {
        dpvFootnote_ = other.dpvFootnote_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDpvCmra().isEmpty()) {
        dpvCmra_ = other.dpvCmra_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDpvVacant().isEmpty()) {
        dpvVacant_ = other.dpvVacant_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getDpvNoStat().isEmpty()) {
        dpvNoStat_ = other.dpvNoStat_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getCarrierRoute().isEmpty()) {
        carrierRoute_ = other.carrierRoute_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getCarrierRouteIndicator().isEmpty()) {
        carrierRouteIndicator_ = other.carrierRouteIndicator_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getEwsNoMatch() != false) {
        setEwsNoMatch(other.getEwsNoMatch());
      }
      if (!other.getPostOfficeCity().isEmpty()) {
        postOfficeCity_ = other.postOfficeCity_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getPostOfficeState().isEmpty()) {
        postOfficeState_ = other.postOfficeState_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getAbbreviatedCity().isEmpty()) {
        abbreviatedCity_ = other.abbreviatedCity_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getFipsCountyCode().isEmpty()) {
        fipsCountyCode_ = other.fipsCountyCode_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (!other.getCounty().isEmpty()) {
        county_ = other.county_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.getElotNumber().isEmpty()) {
        elotNumber_ = other.elotNumber_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (!other.getElotFlag().isEmpty()) {
        elotFlag_ = other.elotFlag_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (!other.getLacsLinkReturnCode().isEmpty()) {
        lacsLinkReturnCode_ = other.lacsLinkReturnCode_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (!other.getLacsLinkIndicator().isEmpty()) {
        lacsLinkIndicator_ = other.lacsLinkIndicator_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.getPoBoxOnlyPostalCode() != false) {
        setPoBoxOnlyPostalCode(other.getPoBoxOnlyPostalCode());
      }
      if (!other.getSuitelinkFootnote().isEmpty()) {
        suitelinkFootnote_ = other.suitelinkFootnote_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (!other.getPmbDesignator().isEmpty()) {
        pmbDesignator_ = other.pmbDesignator_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      if (!other.getPmbNumber().isEmpty()) {
        pmbNumber_ = other.pmbNumber_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (!other.getAddressRecordType().isEmpty()) {
        addressRecordType_ = other.addressRecordType_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.getDefaultAddress() != false) {
        setDefaultAddress(other.getDefaultAddress());
      }
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x04000000;
        onChanged();
      }
      if (other.getCassProcessed() != false) {
        setCassProcessed(other.getCassProcessed());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getStandardizedAddressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                deliveryPointCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                deliveryPointCheckDigit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                dpvConfirmation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                dpvFootnote_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                dpvCmra_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                dpvVacant_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                dpvNoStat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                carrierRoute_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                carrierRouteIndicator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                ewsNoMatch_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                postOfficeCity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                postOfficeState_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                abbreviatedCity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                fipsCountyCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                county_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                elotNumber_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 146:
              {
                elotFlag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 154:
              {
                lacsLinkReturnCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 154
            case 162:
              {
                lacsLinkIndicator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 162
            case 168:
              {
                poBoxOnlyPostalCode_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 168
            case 178:
              {
                suitelinkFootnote_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 178
            case 186:
              {
                pmbDesignator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 186
            case 194:
              {
                pmbNumber_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 194
            case 202:
              {
                addressRecordType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 202
            case 208:
              {
                defaultAddress_ = input.readBool();
                bitField0_ |= 0x02000000;
                break;
              } // case 208
            case 218:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x04000000;
                break;
              } // case 218
            case 224:
              {
                cassProcessed_ = input.readBool();
                bitField0_ |= 0x08000000;
                break;
              } // case 224
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.addressvalidation.v1.UspsAddress standardizedAddress_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.UspsAddress,
            com.google.maps.addressvalidation.v1.UspsAddress.Builder,
            com.google.maps.addressvalidation.v1.UspsAddressOrBuilder>
        standardizedAddressBuilder_;
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     *
     * @return Whether the standardizedAddress field is set.
     */
    public boolean hasStandardizedAddress() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     *
     * @return The standardizedAddress.
     */
    public com.google.maps.addressvalidation.v1.UspsAddress getStandardizedAddress() {
      if (standardizedAddressBuilder_ == null) {
        return standardizedAddress_ == null
            ? com.google.maps.addressvalidation.v1.UspsAddress.getDefaultInstance()
            : standardizedAddress_;
      } else {
        return standardizedAddressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    public Builder setStandardizedAddress(com.google.maps.addressvalidation.v1.UspsAddress value) {
      if (standardizedAddressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        standardizedAddress_ = value;
      } else {
        standardizedAddressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    public Builder setStandardizedAddress(
        com.google.maps.addressvalidation.v1.UspsAddress.Builder builderForValue) {
      if (standardizedAddressBuilder_ == null) {
        standardizedAddress_ = builderForValue.build();
      } else {
        standardizedAddressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    public Builder mergeStandardizedAddress(
        com.google.maps.addressvalidation.v1.UspsAddress value) {
      if (standardizedAddressBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && standardizedAddress_ != null
            && standardizedAddress_
                != com.google.maps.addressvalidation.v1.UspsAddress.getDefaultInstance()) {
          getStandardizedAddressBuilder().mergeFrom(value);
        } else {
          standardizedAddress_ = value;
        }
      } else {
        standardizedAddressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    public Builder clearStandardizedAddress() {
      bitField0_ = (bitField0_ & ~0x00000001);
      standardizedAddress_ = null;
      if (standardizedAddressBuilder_ != null) {
        standardizedAddressBuilder_.dispose();
        standardizedAddressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    public com.google.maps.addressvalidation.v1.UspsAddress.Builder
        getStandardizedAddressBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStandardizedAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    public com.google.maps.addressvalidation.v1.UspsAddressOrBuilder
        getStandardizedAddressOrBuilder() {
      if (standardizedAddressBuilder_ != null) {
        return standardizedAddressBuilder_.getMessageOrBuilder();
      } else {
        return standardizedAddress_ == null
            ? com.google.maps.addressvalidation.v1.UspsAddress.getDefaultInstance()
            : standardizedAddress_;
      }
    }
    /**
     *
     *
     * <pre>
     * USPS standardized address.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.addressvalidation.v1.UspsAddress,
            com.google.maps.addressvalidation.v1.UspsAddress.Builder,
            com.google.maps.addressvalidation.v1.UspsAddressOrBuilder>
        getStandardizedAddressFieldBuilder() {
      if (standardizedAddressBuilder_ == null) {
        standardizedAddressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.addressvalidation.v1.UspsAddress,
                com.google.maps.addressvalidation.v1.UspsAddress.Builder,
                com.google.maps.addressvalidation.v1.UspsAddressOrBuilder>(
                getStandardizedAddress(), getParentForChildren(), isClean());
        standardizedAddress_ = null;
      }
      return standardizedAddressBuilder_;
    }

    private java.lang.Object deliveryPointCode_ = "";
    /**
     *
     *
     * <pre>
     * 2 digit delivery point code
     * </pre>
     *
     * <code>string delivery_point_code = 2;</code>
     *
     * @return The deliveryPointCode.
     */
    public java.lang.String getDeliveryPointCode() {
      java.lang.Object ref = deliveryPointCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deliveryPointCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * 2 digit delivery point code
     * </pre>
     *
     * <code>string delivery_point_code = 2;</code>
     *
     * @return The bytes for deliveryPointCode.
     */
    public com.google.protobuf.ByteString getDeliveryPointCodeBytes() {
      java.lang.Object ref = deliveryPointCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deliveryPointCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * 2 digit delivery point code
     * </pre>
     *
     * <code>string delivery_point_code = 2;</code>
     *
     * @param value The deliveryPointCode to set.
     * @return This builder for chaining.
     */
    public Builder setDeliveryPointCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deliveryPointCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * 2 digit delivery point code
     * </pre>
     *
     * <code>string delivery_point_code = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeliveryPointCode() {
      deliveryPointCode_ = getDefaultInstance().getDeliveryPointCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * 2 digit delivery point code
     * </pre>
     *
     * <code>string delivery_point_code = 2;</code>
     *
     * @param value The bytes for deliveryPointCode to set.
     * @return This builder for chaining.
     */
    public Builder setDeliveryPointCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deliveryPointCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object deliveryPointCheckDigit_ = "";
    /**
     *
     *
     * <pre>
     * The delivery point check digit. This number is added to the end of the
     * delivery_point_barcode for mechanically scanned mail. Adding all the
     * digits of the delivery_point_barcode, delivery_point_check_digit, postal
     * code, and ZIP+4 together should yield a number divisible by 10.
     * </pre>
     *
     * <code>string delivery_point_check_digit = 3;</code>
     *
     * @return The deliveryPointCheckDigit.
     */
    public java.lang.String getDeliveryPointCheckDigit() {
      java.lang.Object ref = deliveryPointCheckDigit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deliveryPointCheckDigit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The delivery point check digit. This number is added to the end of the
     * delivery_point_barcode for mechanically scanned mail. Adding all the
     * digits of the delivery_point_barcode, delivery_point_check_digit, postal
     * code, and ZIP+4 together should yield a number divisible by 10.
     * </pre>
     *
     * <code>string delivery_point_check_digit = 3;</code>
     *
     * @return The bytes for deliveryPointCheckDigit.
     */
    public com.google.protobuf.ByteString getDeliveryPointCheckDigitBytes() {
      java.lang.Object ref = deliveryPointCheckDigit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deliveryPointCheckDigit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The delivery point check digit. This number is added to the end of the
     * delivery_point_barcode for mechanically scanned mail. Adding all the
     * digits of the delivery_point_barcode, delivery_point_check_digit, postal
     * code, and ZIP+4 together should yield a number divisible by 10.
     * </pre>
     *
     * <code>string delivery_point_check_digit = 3;</code>
     *
     * @param value The deliveryPointCheckDigit to set.
     * @return This builder for chaining.
     */
    public Builder setDeliveryPointCheckDigit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deliveryPointCheckDigit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The delivery point check digit. This number is added to the end of the
     * delivery_point_barcode for mechanically scanned mail. Adding all the
     * digits of the delivery_point_barcode, delivery_point_check_digit, postal
     * code, and ZIP+4 together should yield a number divisible by 10.
     * </pre>
     *
     * <code>string delivery_point_check_digit = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeliveryPointCheckDigit() {
      deliveryPointCheckDigit_ = getDefaultInstance().getDeliveryPointCheckDigit();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The delivery point check digit. This number is added to the end of the
     * delivery_point_barcode for mechanically scanned mail. Adding all the
     * digits of the delivery_point_barcode, delivery_point_check_digit, postal
     * code, and ZIP+4 together should yield a number divisible by 10.
     * </pre>
     *
     * <code>string delivery_point_check_digit = 3;</code>
     *
     * @param value The bytes for deliveryPointCheckDigit to set.
     * @return This builder for chaining.
     */
    public Builder setDeliveryPointCheckDigitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deliveryPointCheckDigit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object dpvConfirmation_ = "";
    /**
     *
     *
     * <pre>
     * The possible values for DPV confirmation. Returns a single character.
     *
     * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
     * * `N`: Primary and any secondary number information failed to
     * DPV confirm.
     * * `S`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was present by not confirmed.
     * * `D`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was missing.
     * </pre>
     *
     * <code>string dpv_confirmation = 4;</code>
     *
     * @return The dpvConfirmation.
     */
    public java.lang.String getDpvConfirmation() {
      java.lang.Object ref = dpvConfirmation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dpvConfirmation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The possible values for DPV confirmation. Returns a single character.
     *
     * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
     * * `N`: Primary and any secondary number information failed to
     * DPV confirm.
     * * `S`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was present by not confirmed.
     * * `D`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was missing.
     * </pre>
     *
     * <code>string dpv_confirmation = 4;</code>
     *
     * @return The bytes for dpvConfirmation.
     */
    public com.google.protobuf.ByteString getDpvConfirmationBytes() {
      java.lang.Object ref = dpvConfirmation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dpvConfirmation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The possible values for DPV confirmation. Returns a single character.
     *
     * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
     * * `N`: Primary and any secondary number information failed to
     * DPV confirm.
     * * `S`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was present by not confirmed.
     * * `D`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was missing.
     * </pre>
     *
     * <code>string dpv_confirmation = 4;</code>
     *
     * @param value The dpvConfirmation to set.
     * @return This builder for chaining.
     */
    public Builder setDpvConfirmation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dpvConfirmation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The possible values for DPV confirmation. Returns a single character.
     *
     * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
     * * `N`: Primary and any secondary number information failed to
     * DPV confirm.
     * * `S`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was present by not confirmed.
     * * `D`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was missing.
     * </pre>
     *
     * <code>string dpv_confirmation = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDpvConfirmation() {
      dpvConfirmation_ = getDefaultInstance().getDpvConfirmation();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The possible values for DPV confirmation. Returns a single character.
     *
     * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
     * * `N`: Primary and any secondary number information failed to
     * DPV confirm.
     * * `S`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was present by not confirmed.
     * * `D`: Address was DPV confirmed for the primary number only, and the
     * secondary number information was missing.
     * </pre>
     *
     * <code>string dpv_confirmation = 4;</code>
     *
     * @param value The bytes for dpvConfirmation to set.
     * @return This builder for chaining.
     */
    public Builder setDpvConfirmationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dpvConfirmation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object dpvFootnote_ = "";
    /**
     *
     *
     * <pre>
     * The footnotes from delivery point validation.
     * Multiple footnotes may be strung together in the same string.
     *
     * * `AA`: Input address matched to the ZIP+4 file
     * * `A1`: Input address was not matched to the ZIP+4 file
     * * `BB`: Matched to DPV (all components)
     * * `CC`: Secondary number not matched (present but invalid)
     * * `N1`: High-rise address missing secondary number
     * * `M1`: Primary number missing
     * * `M3`: Primary number invalid
     * * `P1`: Input address RR or HC box number missing
     * * `P3`: Input address PO, RR, or HC Box number invalid
     * * `F1`: Input address matched to a military address
     * * `G1`: Input address matched to a general delivery address
     * * `U1`: Input address matched to a unique ZIP code
     * * `PB`: Input address matched to PBSA record
     * * `RR`: DPV confirmed address with PMB information
     * * `R1`: DPV confirmed address without PMB information
     * * `R7`: Carrier Route R777 or R779 record
     * </pre>
     *
     * <code>string dpv_footnote = 5;</code>
     *
     * @return The dpvFootnote.
     */
    public java.lang.String getDpvFootnote() {
      java.lang.Object ref = dpvFootnote_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dpvFootnote_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The footnotes from delivery point validation.
     * Multiple footnotes may be strung together in the same string.
     *
     * * `AA`: Input address matched to the ZIP+4 file
     * * `A1`: Input address was not matched to the ZIP+4 file
     * * `BB`: Matched to DPV (all components)
     * * `CC`: Secondary number not matched (present but invalid)
     * * `N1`: High-rise address missing secondary number
     * * `M1`: Primary number missing
     * * `M3`: Primary number invalid
     * * `P1`: Input address RR or HC box number missing
     * * `P3`: Input address PO, RR, or HC Box number invalid
     * * `F1`: Input address matched to a military address
     * * `G1`: Input address matched to a general delivery address
     * * `U1`: Input address matched to a unique ZIP code
     * * `PB`: Input address matched to PBSA record
     * * `RR`: DPV confirmed address with PMB information
     * * `R1`: DPV confirmed address without PMB information
     * * `R7`: Carrier Route R777 or R779 record
     * </pre>
     *
     * <code>string dpv_footnote = 5;</code>
     *
     * @return The bytes for dpvFootnote.
     */
    public com.google.protobuf.ByteString getDpvFootnoteBytes() {
      java.lang.Object ref = dpvFootnote_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dpvFootnote_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The footnotes from delivery point validation.
     * Multiple footnotes may be strung together in the same string.
     *
     * * `AA`: Input address matched to the ZIP+4 file
     * * `A1`: Input address was not matched to the ZIP+4 file
     * * `BB`: Matched to DPV (all components)
     * * `CC`: Secondary number not matched (present but invalid)
     * * `N1`: High-rise address missing secondary number
     * * `M1`: Primary number missing
     * * `M3`: Primary number invalid
     * * `P1`: Input address RR or HC box number missing
     * * `P3`: Input address PO, RR, or HC Box number invalid
     * * `F1`: Input address matched to a military address
     * * `G1`: Input address matched to a general delivery address
     * * `U1`: Input address matched to a unique ZIP code
     * * `PB`: Input address matched to PBSA record
     * * `RR`: DPV confirmed address with PMB information
     * * `R1`: DPV confirmed address without PMB information
     * * `R7`: Carrier Route R777 or R779 record
     * </pre>
     *
     * <code>string dpv_footnote = 5;</code>
     *
     * @param value The dpvFootnote to set.
     * @return This builder for chaining.
     */
    public Builder setDpvFootnote(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dpvFootnote_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The footnotes from delivery point validation.
     * Multiple footnotes may be strung together in the same string.
     *
     * * `AA`: Input address matched to the ZIP+4 file
     * * `A1`: Input address was not matched to the ZIP+4 file
     * * `BB`: Matched to DPV (all components)
     * * `CC`: Secondary number not matched (present but invalid)
     * * `N1`: High-rise address missing secondary number
     * * `M1`: Primary number missing
     * * `M3`: Primary number invalid
     * * `P1`: Input address RR or HC box number missing
     * * `P3`: Input address PO, RR, or HC Box number invalid
     * * `F1`: Input address matched to a military address
     * * `G1`: Input address matched to a general delivery address
     * * `U1`: Input address matched to a unique ZIP code
     * * `PB`: Input address matched to PBSA record
     * * `RR`: DPV confirmed address with PMB information
     * * `R1`: DPV confirmed address without PMB information
     * * `R7`: Carrier Route R777 or R779 record
     * </pre>
     *
     * <code>string dpv_footnote = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDpvFootnote() {
      dpvFootnote_ = getDefaultInstance().getDpvFootnote();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The footnotes from delivery point validation.
     * Multiple footnotes may be strung together in the same string.
     *
     * * `AA`: Input address matched to the ZIP+4 file
     * * `A1`: Input address was not matched to the ZIP+4 file
     * * `BB`: Matched to DPV (all components)
     * * `CC`: Secondary number not matched (present but invalid)
     * * `N1`: High-rise address missing secondary number
     * * `M1`: Primary number missing
     * * `M3`: Primary number invalid
     * * `P1`: Input address RR or HC box number missing
     * * `P3`: Input address PO, RR, or HC Box number invalid
     * * `F1`: Input address matched to a military address
     * * `G1`: Input address matched to a general delivery address
     * * `U1`: Input address matched to a unique ZIP code
     * * `PB`: Input address matched to PBSA record
     * * `RR`: DPV confirmed address with PMB information
     * * `R1`: DPV confirmed address without PMB information
     * * `R7`: Carrier Route R777 or R779 record
     * </pre>
     *
     * <code>string dpv_footnote = 5;</code>
     *
     * @param value The bytes for dpvFootnote to set.
     * @return This builder for chaining.
     */
    public Builder setDpvFootnoteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dpvFootnote_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object dpvCmra_ = "";
    /**
     *
     *
     * <pre>
     * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
     * private business receiving mail for clients. Returns a single character.
     *
     * * `Y`: The address is a CMRA
     * * `N`: The address is not a CMRA
     * </pre>
     *
     * <code>string dpv_cmra = 6;</code>
     *
     * @return The dpvCmra.
     */
    public java.lang.String getDpvCmra() {
      java.lang.Object ref = dpvCmra_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dpvCmra_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
     * private business receiving mail for clients. Returns a single character.
     *
     * * `Y`: The address is a CMRA
     * * `N`: The address is not a CMRA
     * </pre>
     *
     * <code>string dpv_cmra = 6;</code>
     *
     * @return The bytes for dpvCmra.
     */
    public com.google.protobuf.ByteString getDpvCmraBytes() {
      java.lang.Object ref = dpvCmra_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dpvCmra_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
     * private business receiving mail for clients. Returns a single character.
     *
     * * `Y`: The address is a CMRA
     * * `N`: The address is not a CMRA
     * </pre>
     *
     * <code>string dpv_cmra = 6;</code>
     *
     * @param value The dpvCmra to set.
     * @return This builder for chaining.
     */
    public Builder setDpvCmra(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dpvCmra_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
     * private business receiving mail for clients. Returns a single character.
     *
     * * `Y`: The address is a CMRA
     * * `N`: The address is not a CMRA
     * </pre>
     *
     * <code>string dpv_cmra = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDpvCmra() {
      dpvCmra_ = getDefaultInstance().getDpvCmra();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
     * private business receiving mail for clients. Returns a single character.
     *
     * * `Y`: The address is a CMRA
     * * `N`: The address is not a CMRA
     * </pre>
     *
     * <code>string dpv_cmra = 6;</code>
     *
     * @param value The bytes for dpvCmra to set.
     * @return This builder for chaining.
     */
    public Builder setDpvCmraBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dpvCmra_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object dpvVacant_ = "";
    /**
     *
     *
     * <pre>
     * Is this place vacant?
     * Returns a single character.
     *
     * * `Y`: The address is vacant
     * * `N`: The address is not vacant
     * </pre>
     *
     * <code>string dpv_vacant = 7;</code>
     *
     * @return The dpvVacant.
     */
    public java.lang.String getDpvVacant() {
      java.lang.Object ref = dpvVacant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dpvVacant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Is this place vacant?
     * Returns a single character.
     *
     * * `Y`: The address is vacant
     * * `N`: The address is not vacant
     * </pre>
     *
     * <code>string dpv_vacant = 7;</code>
     *
     * @return The bytes for dpvVacant.
     */
    public com.google.protobuf.ByteString getDpvVacantBytes() {
      java.lang.Object ref = dpvVacant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dpvVacant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Is this place vacant?
     * Returns a single character.
     *
     * * `Y`: The address is vacant
     * * `N`: The address is not vacant
     * </pre>
     *
     * <code>string dpv_vacant = 7;</code>
     *
     * @param value The dpvVacant to set.
     * @return This builder for chaining.
     */
    public Builder setDpvVacant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dpvVacant_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is this place vacant?
     * Returns a single character.
     *
     * * `Y`: The address is vacant
     * * `N`: The address is not vacant
     * </pre>
     *
     * <code>string dpv_vacant = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDpvVacant() {
      dpvVacant_ = getDefaultInstance().getDpvVacant();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is this place vacant?
     * Returns a single character.
     *
     * * `Y`: The address is vacant
     * * `N`: The address is not vacant
     * </pre>
     *
     * <code>string dpv_vacant = 7;</code>
     *
     * @param value The bytes for dpvVacant to set.
     * @return This builder for chaining.
     */
    public Builder setDpvVacantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dpvVacant_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object dpvNoStat_ = "";
    /**
     *
     *
     * <pre>
     * Is this a no stat address or an active address?
     * No stat addresses are ones which are not continuously occupied or addresses
     * that the USPS does not service. Returns a single character.
     *
     * * `Y`: The address is not active
     * * `N`: The address is active
     * </pre>
     *
     * <code>string dpv_no_stat = 8;</code>
     *
     * @return The dpvNoStat.
     */
    public java.lang.String getDpvNoStat() {
      java.lang.Object ref = dpvNoStat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dpvNoStat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Is this a no stat address or an active address?
     * No stat addresses are ones which are not continuously occupied or addresses
     * that the USPS does not service. Returns a single character.
     *
     * * `Y`: The address is not active
     * * `N`: The address is active
     * </pre>
     *
     * <code>string dpv_no_stat = 8;</code>
     *
     * @return The bytes for dpvNoStat.
     */
    public com.google.protobuf.ByteString getDpvNoStatBytes() {
      java.lang.Object ref = dpvNoStat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dpvNoStat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Is this a no stat address or an active address?
     * No stat addresses are ones which are not continuously occupied or addresses
     * that the USPS does not service. Returns a single character.
     *
     * * `Y`: The address is not active
     * * `N`: The address is active
     * </pre>
     *
     * <code>string dpv_no_stat = 8;</code>
     *
     * @param value The dpvNoStat to set.
     * @return This builder for chaining.
     */
    public Builder setDpvNoStat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dpvNoStat_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is this a no stat address or an active address?
     * No stat addresses are ones which are not continuously occupied or addresses
     * that the USPS does not service. Returns a single character.
     *
     * * `Y`: The address is not active
     * * `N`: The address is active
     * </pre>
     *
     * <code>string dpv_no_stat = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDpvNoStat() {
      dpvNoStat_ = getDefaultInstance().getDpvNoStat();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is this a no stat address or an active address?
     * No stat addresses are ones which are not continuously occupied or addresses
     * that the USPS does not service. Returns a single character.
     *
     * * `Y`: The address is not active
     * * `N`: The address is active
     * </pre>
     *
     * <code>string dpv_no_stat = 8;</code>
     *
     * @param value The bytes for dpvNoStat to set.
     * @return This builder for chaining.
     */
    public Builder setDpvNoStatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dpvNoStat_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object carrierRoute_ = "";
    /**
     *
     *
     * <pre>
     * The carrier route code.
     * A four character code consisting of a one letter prefix and a three digit
     * route designator.
     *
     * Prefixes:
     *
     * * `C`: Carrier route (or city route)
     * * `R`: Rural route
     * * `H`: Highway Contract Route
     * * `B`: Post Office Box Section
     * * `G`: General delivery unit
     * </pre>
     *
     * <code>string carrier_route = 9;</code>
     *
     * @return The carrierRoute.
     */
    public java.lang.String getCarrierRoute() {
      java.lang.Object ref = carrierRoute_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        carrierRoute_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The carrier route code.
     * A four character code consisting of a one letter prefix and a three digit
     * route designator.
     *
     * Prefixes:
     *
     * * `C`: Carrier route (or city route)
     * * `R`: Rural route
     * * `H`: Highway Contract Route
     * * `B`: Post Office Box Section
     * * `G`: General delivery unit
     * </pre>
     *
     * <code>string carrier_route = 9;</code>
     *
     * @return The bytes for carrierRoute.
     */
    public com.google.protobuf.ByteString getCarrierRouteBytes() {
      java.lang.Object ref = carrierRoute_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        carrierRoute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The carrier route code.
     * A four character code consisting of a one letter prefix and a three digit
     * route designator.
     *
     * Prefixes:
     *
     * * `C`: Carrier route (or city route)
     * * `R`: Rural route
     * * `H`: Highway Contract Route
     * * `B`: Post Office Box Section
     * * `G`: General delivery unit
     * </pre>
     *
     * <code>string carrier_route = 9;</code>
     *
     * @param value The carrierRoute to set.
     * @return This builder for chaining.
     */
    public Builder setCarrierRoute(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      carrierRoute_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The carrier route code.
     * A four character code consisting of a one letter prefix and a three digit
     * route designator.
     *
     * Prefixes:
     *
     * * `C`: Carrier route (or city route)
     * * `R`: Rural route
     * * `H`: Highway Contract Route
     * * `B`: Post Office Box Section
     * * `G`: General delivery unit
     * </pre>
     *
     * <code>string carrier_route = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCarrierRoute() {
      carrierRoute_ = getDefaultInstance().getCarrierRoute();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The carrier route code.
     * A four character code consisting of a one letter prefix and a three digit
     * route designator.
     *
     * Prefixes:
     *
     * * `C`: Carrier route (or city route)
     * * `R`: Rural route
     * * `H`: Highway Contract Route
     * * `B`: Post Office Box Section
     * * `G`: General delivery unit
     * </pre>
     *
     * <code>string carrier_route = 9;</code>
     *
     * @param value The bytes for carrierRoute to set.
     * @return This builder for chaining.
     */
    public Builder setCarrierRouteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      carrierRoute_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object carrierRouteIndicator_ = "";
    /**
     *
     *
     * <pre>
     * Carrier route rate sort indicator.
     * </pre>
     *
     * <code>string carrier_route_indicator = 10;</code>
     *
     * @return The carrierRouteIndicator.
     */
    public java.lang.String getCarrierRouteIndicator() {
      java.lang.Object ref = carrierRouteIndicator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        carrierRouteIndicator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Carrier route rate sort indicator.
     * </pre>
     *
     * <code>string carrier_route_indicator = 10;</code>
     *
     * @return The bytes for carrierRouteIndicator.
     */
    public com.google.protobuf.ByteString getCarrierRouteIndicatorBytes() {
      java.lang.Object ref = carrierRouteIndicator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        carrierRouteIndicator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Carrier route rate sort indicator.
     * </pre>
     *
     * <code>string carrier_route_indicator = 10;</code>
     *
     * @param value The carrierRouteIndicator to set.
     * @return This builder for chaining.
     */
    public Builder setCarrierRouteIndicator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      carrierRouteIndicator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Carrier route rate sort indicator.
     * </pre>
     *
     * <code>string carrier_route_indicator = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCarrierRouteIndicator() {
      carrierRouteIndicator_ = getDefaultInstance().getCarrierRouteIndicator();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Carrier route rate sort indicator.
     * </pre>
     *
     * <code>string carrier_route_indicator = 10;</code>
     *
     * @param value The bytes for carrierRouteIndicator to set.
     * @return This builder for chaining.
     */
    public Builder setCarrierRouteIndicatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      carrierRouteIndicator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean ewsNoMatch_;
    /**
     *
     *
     * <pre>
     * The delivery address is matchable, but the EWS file indicates that an exact
     * match will be available soon.
     * </pre>
     *
     * <code>bool ews_no_match = 11;</code>
     *
     * @return The ewsNoMatch.
     */
    @java.lang.Override
    public boolean getEwsNoMatch() {
      return ewsNoMatch_;
    }
    /**
     *
     *
     * <pre>
     * The delivery address is matchable, but the EWS file indicates that an exact
     * match will be available soon.
     * </pre>
     *
     * <code>bool ews_no_match = 11;</code>
     *
     * @param value The ewsNoMatch to set.
     * @return This builder for chaining.
     */
    public Builder setEwsNoMatch(boolean value) {

      ewsNoMatch_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The delivery address is matchable, but the EWS file indicates that an exact
     * match will be available soon.
     * </pre>
     *
     * <code>bool ews_no_match = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEwsNoMatch() {
      bitField0_ = (bitField0_ & ~0x00000400);
      ewsNoMatch_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object postOfficeCity_ = "";
    /**
     *
     *
     * <pre>
     * Main post office city.
     * </pre>
     *
     * <code>string post_office_city = 12;</code>
     *
     * @return The postOfficeCity.
     */
    public java.lang.String getPostOfficeCity() {
      java.lang.Object ref = postOfficeCity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postOfficeCity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Main post office city.
     * </pre>
     *
     * <code>string post_office_city = 12;</code>
     *
     * @return The bytes for postOfficeCity.
     */
    public com.google.protobuf.ByteString getPostOfficeCityBytes() {
      java.lang.Object ref = postOfficeCity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postOfficeCity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Main post office city.
     * </pre>
     *
     * <code>string post_office_city = 12;</code>
     *
     * @param value The postOfficeCity to set.
     * @return This builder for chaining.
     */
    public Builder setPostOfficeCity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postOfficeCity_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Main post office city.
     * </pre>
     *
     * <code>string post_office_city = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostOfficeCity() {
      postOfficeCity_ = getDefaultInstance().getPostOfficeCity();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Main post office city.
     * </pre>
     *
     * <code>string post_office_city = 12;</code>
     *
     * @param value The bytes for postOfficeCity to set.
     * @return This builder for chaining.
     */
    public Builder setPostOfficeCityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postOfficeCity_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object postOfficeState_ = "";
    /**
     *
     *
     * <pre>
     * Main post office state.
     * </pre>
     *
     * <code>string post_office_state = 13;</code>
     *
     * @return The postOfficeState.
     */
    public java.lang.String getPostOfficeState() {
      java.lang.Object ref = postOfficeState_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        postOfficeState_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Main post office state.
     * </pre>
     *
     * <code>string post_office_state = 13;</code>
     *
     * @return The bytes for postOfficeState.
     */
    public com.google.protobuf.ByteString getPostOfficeStateBytes() {
      java.lang.Object ref = postOfficeState_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        postOfficeState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Main post office state.
     * </pre>
     *
     * <code>string post_office_state = 13;</code>
     *
     * @param value The postOfficeState to set.
     * @return This builder for chaining.
     */
    public Builder setPostOfficeState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      postOfficeState_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Main post office state.
     * </pre>
     *
     * <code>string post_office_state = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostOfficeState() {
      postOfficeState_ = getDefaultInstance().getPostOfficeState();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Main post office state.
     * </pre>
     *
     * <code>string post_office_state = 13;</code>
     *
     * @param value The bytes for postOfficeState to set.
     * @return This builder for chaining.
     */
    public Builder setPostOfficeStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      postOfficeState_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object abbreviatedCity_ = "";
    /**
     *
     *
     * <pre>
     * Abbreviated city.
     * </pre>
     *
     * <code>string abbreviated_city = 14;</code>
     *
     * @return The abbreviatedCity.
     */
    public java.lang.String getAbbreviatedCity() {
      java.lang.Object ref = abbreviatedCity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        abbreviatedCity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Abbreviated city.
     * </pre>
     *
     * <code>string abbreviated_city = 14;</code>
     *
     * @return The bytes for abbreviatedCity.
     */
    public com.google.protobuf.ByteString getAbbreviatedCityBytes() {
      java.lang.Object ref = abbreviatedCity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        abbreviatedCity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Abbreviated city.
     * </pre>
     *
     * <code>string abbreviated_city = 14;</code>
     *
     * @param value The abbreviatedCity to set.
     * @return This builder for chaining.
     */
    public Builder setAbbreviatedCity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      abbreviatedCity_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Abbreviated city.
     * </pre>
     *
     * <code>string abbreviated_city = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAbbreviatedCity() {
      abbreviatedCity_ = getDefaultInstance().getAbbreviatedCity();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Abbreviated city.
     * </pre>
     *
     * <code>string abbreviated_city = 14;</code>
     *
     * @param value The bytes for abbreviatedCity to set.
     * @return This builder for chaining.
     */
    public Builder setAbbreviatedCityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      abbreviatedCity_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object fipsCountyCode_ = "";
    /**
     *
     *
     * <pre>
     * FIPS county code.
     * </pre>
     *
     * <code>string fips_county_code = 15;</code>
     *
     * @return The fipsCountyCode.
     */
    public java.lang.String getFipsCountyCode() {
      java.lang.Object ref = fipsCountyCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fipsCountyCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * FIPS county code.
     * </pre>
     *
     * <code>string fips_county_code = 15;</code>
     *
     * @return The bytes for fipsCountyCode.
     */
    public com.google.protobuf.ByteString getFipsCountyCodeBytes() {
      java.lang.Object ref = fipsCountyCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fipsCountyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * FIPS county code.
     * </pre>
     *
     * <code>string fips_county_code = 15;</code>
     *
     * @param value The fipsCountyCode to set.
     * @return This builder for chaining.
     */
    public Builder setFipsCountyCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fipsCountyCode_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * FIPS county code.
     * </pre>
     *
     * <code>string fips_county_code = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFipsCountyCode() {
      fipsCountyCode_ = getDefaultInstance().getFipsCountyCode();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * FIPS county code.
     * </pre>
     *
     * <code>string fips_county_code = 15;</code>
     *
     * @param value The bytes for fipsCountyCode to set.
     * @return This builder for chaining.
     */
    public Builder setFipsCountyCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fipsCountyCode_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object county_ = "";
    /**
     *
     *
     * <pre>
     * County name.
     * </pre>
     *
     * <code>string county = 16;</code>
     *
     * @return The county.
     */
    public java.lang.String getCounty() {
      java.lang.Object ref = county_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        county_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * County name.
     * </pre>
     *
     * <code>string county = 16;</code>
     *
     * @return The bytes for county.
     */
    public com.google.protobuf.ByteString getCountyBytes() {
      java.lang.Object ref = county_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        county_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * County name.
     * </pre>
     *
     * <code>string county = 16;</code>
     *
     * @param value The county to set.
     * @return This builder for chaining.
     */
    public Builder setCounty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      county_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * County name.
     * </pre>
     *
     * <code>string county = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCounty() {
      county_ = getDefaultInstance().getCounty();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * County name.
     * </pre>
     *
     * <code>string county = 16;</code>
     *
     * @param value The bytes for county to set.
     * @return This builder for chaining.
     */
    public Builder setCountyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      county_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object elotNumber_ = "";
    /**
     *
     *
     * <pre>
     * Enhanced Line of Travel (eLOT) number.
     * </pre>
     *
     * <code>string elot_number = 17;</code>
     *
     * @return The elotNumber.
     */
    public java.lang.String getElotNumber() {
      java.lang.Object ref = elotNumber_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        elotNumber_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Enhanced Line of Travel (eLOT) number.
     * </pre>
     *
     * <code>string elot_number = 17;</code>
     *
     * @return The bytes for elotNumber.
     */
    public com.google.protobuf.ByteString getElotNumberBytes() {
      java.lang.Object ref = elotNumber_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        elotNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Enhanced Line of Travel (eLOT) number.
     * </pre>
     *
     * <code>string elot_number = 17;</code>
     *
     * @param value The elotNumber to set.
     * @return This builder for chaining.
     */
    public Builder setElotNumber(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      elotNumber_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enhanced Line of Travel (eLOT) number.
     * </pre>
     *
     * <code>string elot_number = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearElotNumber() {
      elotNumber_ = getDefaultInstance().getElotNumber();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enhanced Line of Travel (eLOT) number.
     * </pre>
     *
     * <code>string elot_number = 17;</code>
     *
     * @param value The bytes for elotNumber to set.
     * @return This builder for chaining.
     */
    public Builder setElotNumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      elotNumber_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object elotFlag_ = "";
    /**
     *
     *
     * <pre>
     * eLOT Ascending/Descending Flag (A/D).
     * </pre>
     *
     * <code>string elot_flag = 18;</code>
     *
     * @return The elotFlag.
     */
    public java.lang.String getElotFlag() {
      java.lang.Object ref = elotFlag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        elotFlag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * eLOT Ascending/Descending Flag (A/D).
     * </pre>
     *
     * <code>string elot_flag = 18;</code>
     *
     * @return The bytes for elotFlag.
     */
    public com.google.protobuf.ByteString getElotFlagBytes() {
      java.lang.Object ref = elotFlag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        elotFlag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * eLOT Ascending/Descending Flag (A/D).
     * </pre>
     *
     * <code>string elot_flag = 18;</code>
     *
     * @param value The elotFlag to set.
     * @return This builder for chaining.
     */
    public Builder setElotFlag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      elotFlag_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * eLOT Ascending/Descending Flag (A/D).
     * </pre>
     *
     * <code>string elot_flag = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearElotFlag() {
      elotFlag_ = getDefaultInstance().getElotFlag();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * eLOT Ascending/Descending Flag (A/D).
     * </pre>
     *
     * <code>string elot_flag = 18;</code>
     *
     * @param value The bytes for elotFlag to set.
     * @return This builder for chaining.
     */
    public Builder setElotFlagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      elotFlag_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object lacsLinkReturnCode_ = "";
    /**
     *
     *
     * <pre>
     * LACSLink return code.
     * </pre>
     *
     * <code>string lacs_link_return_code = 19;</code>
     *
     * @return The lacsLinkReturnCode.
     */
    public java.lang.String getLacsLinkReturnCode() {
      java.lang.Object ref = lacsLinkReturnCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lacsLinkReturnCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * LACSLink return code.
     * </pre>
     *
     * <code>string lacs_link_return_code = 19;</code>
     *
     * @return The bytes for lacsLinkReturnCode.
     */
    public com.google.protobuf.ByteString getLacsLinkReturnCodeBytes() {
      java.lang.Object ref = lacsLinkReturnCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lacsLinkReturnCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * LACSLink return code.
     * </pre>
     *
     * <code>string lacs_link_return_code = 19;</code>
     *
     * @param value The lacsLinkReturnCode to set.
     * @return This builder for chaining.
     */
    public Builder setLacsLinkReturnCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lacsLinkReturnCode_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * LACSLink return code.
     * </pre>
     *
     * <code>string lacs_link_return_code = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLacsLinkReturnCode() {
      lacsLinkReturnCode_ = getDefaultInstance().getLacsLinkReturnCode();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * LACSLink return code.
     * </pre>
     *
     * <code>string lacs_link_return_code = 19;</code>
     *
     * @param value The bytes for lacsLinkReturnCode to set.
     * @return This builder for chaining.
     */
    public Builder setLacsLinkReturnCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lacsLinkReturnCode_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object lacsLinkIndicator_ = "";
    /**
     *
     *
     * <pre>
     * LACSLink indicator.
     * </pre>
     *
     * <code>string lacs_link_indicator = 20;</code>
     *
     * @return The lacsLinkIndicator.
     */
    public java.lang.String getLacsLinkIndicator() {
      java.lang.Object ref = lacsLinkIndicator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lacsLinkIndicator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * LACSLink indicator.
     * </pre>
     *
     * <code>string lacs_link_indicator = 20;</code>
     *
     * @return The bytes for lacsLinkIndicator.
     */
    public com.google.protobuf.ByteString getLacsLinkIndicatorBytes() {
      java.lang.Object ref = lacsLinkIndicator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lacsLinkIndicator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * LACSLink indicator.
     * </pre>
     *
     * <code>string lacs_link_indicator = 20;</code>
     *
     * @param value The lacsLinkIndicator to set.
     * @return This builder for chaining.
     */
    public Builder setLacsLinkIndicator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lacsLinkIndicator_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * LACSLink indicator.
     * </pre>
     *
     * <code>string lacs_link_indicator = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLacsLinkIndicator() {
      lacsLinkIndicator_ = getDefaultInstance().getLacsLinkIndicator();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * LACSLink indicator.
     * </pre>
     *
     * <code>string lacs_link_indicator = 20;</code>
     *
     * @param value The bytes for lacsLinkIndicator to set.
     * @return This builder for chaining.
     */
    public Builder setLacsLinkIndicatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lacsLinkIndicator_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private boolean poBoxOnlyPostalCode_;
    /**
     *
     *
     * <pre>
     * PO Box only postal code.
     * </pre>
     *
     * <code>bool po_box_only_postal_code = 21;</code>
     *
     * @return The poBoxOnlyPostalCode.
     */
    @java.lang.Override
    public boolean getPoBoxOnlyPostalCode() {
      return poBoxOnlyPostalCode_;
    }
    /**
     *
     *
     * <pre>
     * PO Box only postal code.
     * </pre>
     *
     * <code>bool po_box_only_postal_code = 21;</code>
     *
     * @param value The poBoxOnlyPostalCode to set.
     * @return This builder for chaining.
     */
    public Builder setPoBoxOnlyPostalCode(boolean value) {

      poBoxOnlyPostalCode_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PO Box only postal code.
     * </pre>
     *
     * <code>bool po_box_only_postal_code = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPoBoxOnlyPostalCode() {
      bitField0_ = (bitField0_ & ~0x00100000);
      poBoxOnlyPostalCode_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object suitelinkFootnote_ = "";
    /**
     *
     *
     * <pre>
     * Footnotes from matching a street or highrise record to suite information.
     * If business name match is found, the secondary number is returned.
     *
     * * `A`: SuiteLink record match, business address improved.
     * * `00`: No match, business address is not improved.
     * </pre>
     *
     * <code>string suitelink_footnote = 22;</code>
     *
     * @return The suitelinkFootnote.
     */
    public java.lang.String getSuitelinkFootnote() {
      java.lang.Object ref = suitelinkFootnote_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suitelinkFootnote_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Footnotes from matching a street or highrise record to suite information.
     * If business name match is found, the secondary number is returned.
     *
     * * `A`: SuiteLink record match, business address improved.
     * * `00`: No match, business address is not improved.
     * </pre>
     *
     * <code>string suitelink_footnote = 22;</code>
     *
     * @return The bytes for suitelinkFootnote.
     */
    public com.google.protobuf.ByteString getSuitelinkFootnoteBytes() {
      java.lang.Object ref = suitelinkFootnote_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suitelinkFootnote_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Footnotes from matching a street or highrise record to suite information.
     * If business name match is found, the secondary number is returned.
     *
     * * `A`: SuiteLink record match, business address improved.
     * * `00`: No match, business address is not improved.
     * </pre>
     *
     * <code>string suitelink_footnote = 22;</code>
     *
     * @param value The suitelinkFootnote to set.
     * @return This builder for chaining.
     */
    public Builder setSuitelinkFootnote(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      suitelinkFootnote_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Footnotes from matching a street or highrise record to suite information.
     * If business name match is found, the secondary number is returned.
     *
     * * `A`: SuiteLink record match, business address improved.
     * * `00`: No match, business address is not improved.
     * </pre>
     *
     * <code>string suitelink_footnote = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuitelinkFootnote() {
      suitelinkFootnote_ = getDefaultInstance().getSuitelinkFootnote();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Footnotes from matching a street or highrise record to suite information.
     * If business name match is found, the secondary number is returned.
     *
     * * `A`: SuiteLink record match, business address improved.
     * * `00`: No match, business address is not improved.
     * </pre>
     *
     * <code>string suitelink_footnote = 22;</code>
     *
     * @param value The bytes for suitelinkFootnote to set.
     * @return This builder for chaining.
     */
    public Builder setSuitelinkFootnoteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      suitelinkFootnote_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object pmbDesignator_ = "";
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) unit designator.
     * </pre>
     *
     * <code>string pmb_designator = 23;</code>
     *
     * @return The pmbDesignator.
     */
    public java.lang.String getPmbDesignator() {
      java.lang.Object ref = pmbDesignator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pmbDesignator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) unit designator.
     * </pre>
     *
     * <code>string pmb_designator = 23;</code>
     *
     * @return The bytes for pmbDesignator.
     */
    public com.google.protobuf.ByteString getPmbDesignatorBytes() {
      java.lang.Object ref = pmbDesignator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pmbDesignator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) unit designator.
     * </pre>
     *
     * <code>string pmb_designator = 23;</code>
     *
     * @param value The pmbDesignator to set.
     * @return This builder for chaining.
     */
    public Builder setPmbDesignator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pmbDesignator_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) unit designator.
     * </pre>
     *
     * <code>string pmb_designator = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPmbDesignator() {
      pmbDesignator_ = getDefaultInstance().getPmbDesignator();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) unit designator.
     * </pre>
     *
     * <code>string pmb_designator = 23;</code>
     *
     * @param value The bytes for pmbDesignator to set.
     * @return This builder for chaining.
     */
    public Builder setPmbDesignatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pmbDesignator_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    private java.lang.Object pmbNumber_ = "";
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) number;
     * </pre>
     *
     * <code>string pmb_number = 24;</code>
     *
     * @return The pmbNumber.
     */
    public java.lang.String getPmbNumber() {
      java.lang.Object ref = pmbNumber_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pmbNumber_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) number;
     * </pre>
     *
     * <code>string pmb_number = 24;</code>
     *
     * @return The bytes for pmbNumber.
     */
    public com.google.protobuf.ByteString getPmbNumberBytes() {
      java.lang.Object ref = pmbNumber_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pmbNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) number;
     * </pre>
     *
     * <code>string pmb_number = 24;</code>
     *
     * @param value The pmbNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPmbNumber(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pmbNumber_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) number;
     * </pre>
     *
     * <code>string pmb_number = 24;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPmbNumber() {
      pmbNumber_ = getDefaultInstance().getPmbNumber();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * PMB (Private Mail Box) number;
     * </pre>
     *
     * <code>string pmb_number = 24;</code>
     *
     * @param value The bytes for pmbNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPmbNumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pmbNumber_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object addressRecordType_ = "";
    /**
     *
     *
     * <pre>
     * Type of the address record that matches the input address.
     *
     * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
     * match available for an address.
     * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
     * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
     * record.
     * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
     * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
     * Route or a Highway Contract record, both of which may have associated Box
     * Number ranges.
     * * `S`: STREET RECORD: This is a match to a Street record containing a valid
     * primary number range.
     * </pre>
     *
     * <code>string address_record_type = 25;</code>
     *
     * @return The addressRecordType.
     */
    public java.lang.String getAddressRecordType() {
      java.lang.Object ref = addressRecordType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        addressRecordType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the address record that matches the input address.
     *
     * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
     * match available for an address.
     * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
     * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
     * record.
     * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
     * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
     * Route or a Highway Contract record, both of which may have associated Box
     * Number ranges.
     * * `S`: STREET RECORD: This is a match to a Street record containing a valid
     * primary number range.
     * </pre>
     *
     * <code>string address_record_type = 25;</code>
     *
     * @return The bytes for addressRecordType.
     */
    public com.google.protobuf.ByteString getAddressRecordTypeBytes() {
      java.lang.Object ref = addressRecordType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        addressRecordType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the address record that matches the input address.
     *
     * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
     * match available for an address.
     * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
     * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
     * record.
     * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
     * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
     * Route or a Highway Contract record, both of which may have associated Box
     * Number ranges.
     * * `S`: STREET RECORD: This is a match to a Street record containing a valid
     * primary number range.
     * </pre>
     *
     * <code>string address_record_type = 25;</code>
     *
     * @param value The addressRecordType to set.
     * @return This builder for chaining.
     */
    public Builder setAddressRecordType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      addressRecordType_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the address record that matches the input address.
     *
     * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
     * match available for an address.
     * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
     * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
     * record.
     * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
     * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
     * Route or a Highway Contract record, both of which may have associated Box
     * Number ranges.
     * * `S`: STREET RECORD: This is a match to a Street record containing a valid
     * primary number range.
     * </pre>
     *
     * <code>string address_record_type = 25;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddressRecordType() {
      addressRecordType_ = getDefaultInstance().getAddressRecordType();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the address record that matches the input address.
     *
     * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
     * match available for an address.
     * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
     * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
     * record.
     * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
     * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
     * Route or a Highway Contract record, both of which may have associated Box
     * Number ranges.
     * * `S`: STREET RECORD: This is a match to a Street record containing a valid
     * primary number range.
     * </pre>
     *
     * <code>string address_record_type = 25;</code>
     *
     * @param value The bytes for addressRecordType to set.
     * @return This builder for chaining.
     */
    public Builder setAddressRecordTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      addressRecordType_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private boolean defaultAddress_;
    /**
     *
     *
     * <pre>
     * Indicator that a default address was found, but more specific addresses
     * exists.
     * </pre>
     *
     * <code>bool default_address = 26;</code>
     *
     * @return The defaultAddress.
     */
    @java.lang.Override
    public boolean getDefaultAddress() {
      return defaultAddress_;
    }
    /**
     *
     *
     * <pre>
     * Indicator that a default address was found, but more specific addresses
     * exists.
     * </pre>
     *
     * <code>bool default_address = 26;</code>
     *
     * @param value The defaultAddress to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultAddress(boolean value) {

      defaultAddress_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicator that a default address was found, but more specific addresses
     * exists.
     * </pre>
     *
     * <code>bool default_address = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultAddress() {
      bitField0_ = (bitField0_ & ~0x02000000);
      defaultAddress_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Error message for USPS data retrieval. This is populated when USPS
     * processing is suspended because of the detection of artificially created
     * addresses.
     *
     * The USPS data fields might not be populated when this error is present.
     * </pre>
     *
     * <code>string error_message = 27;</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Error message for USPS data retrieval. This is populated when USPS
     * processing is suspended because of the detection of artificially created
     * addresses.
     *
     * The USPS data fields might not be populated when this error is present.
     * </pre>
     *
     * <code>string error_message = 27;</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Error message for USPS data retrieval. This is populated when USPS
     * processing is suspended because of the detection of artificially created
     * addresses.
     *
     * The USPS data fields might not be populated when this error is present.
     * </pre>
     *
     * <code>string error_message = 27;</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error message for USPS data retrieval. This is populated when USPS
     * processing is suspended because of the detection of artificially created
     * addresses.
     *
     * The USPS data fields might not be populated when this error is present.
     * </pre>
     *
     * <code>string error_message = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x04000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error message for USPS data retrieval. This is populated when USPS
     * processing is suspended because of the detection of artificially created
     * addresses.
     *
     * The USPS data fields might not be populated when this error is present.
     * </pre>
     *
     * <code>string error_message = 27;</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    private boolean cassProcessed_;
    /**
     *
     *
     * <pre>
     * Indicator that the request has been CASS processed.
     * </pre>
     *
     * <code>bool cass_processed = 28;</code>
     *
     * @return The cassProcessed.
     */
    @java.lang.Override
    public boolean getCassProcessed() {
      return cassProcessed_;
    }
    /**
     *
     *
     * <pre>
     * Indicator that the request has been CASS processed.
     * </pre>
     *
     * <code>bool cass_processed = 28;</code>
     *
     * @param value The cassProcessed to set.
     * @return This builder for chaining.
     */
    public Builder setCassProcessed(boolean value) {

      cassProcessed_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicator that the request has been CASS processed.
     * </pre>
     *
     * <code>bool cass_processed = 28;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCassProcessed() {
      bitField0_ = (bitField0_ & ~0x08000000);
      cassProcessed_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.UspsData)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.UspsData)
  private static final com.google.maps.addressvalidation.v1.UspsData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.UspsData();
  }

  public static com.google.maps.addressvalidation.v1.UspsData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UspsData> PARSER =
      new com.google.protobuf.AbstractParser<UspsData>() {
        @java.lang.Override
        public UspsData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UspsData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UspsData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.UspsData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
