/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/usps_data.proto

package com.google.maps.addressvalidation.v1;

public interface UspsDataOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.maps.addressvalidation.v1.UspsData)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * USPS standardized address.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
   *
   * @return Whether the standardizedAddress field is set.
   */
  boolean hasStandardizedAddress();
  /**
   *
   *
   * <pre>
   * USPS standardized address.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
   *
   * @return The standardizedAddress.
   */
  com.google.maps.addressvalidation.v1.UspsAddress getStandardizedAddress();
  /**
   *
   *
   * <pre>
   * USPS standardized address.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.UspsAddress standardized_address = 1;</code>
   */
  com.google.maps.addressvalidation.v1.UspsAddressOrBuilder getStandardizedAddressOrBuilder();

  /**
   *
   *
   * <pre>
   * 2 digit delivery point code
   * </pre>
   *
   * <code>string delivery_point_code = 2;</code>
   *
   * @return The deliveryPointCode.
   */
  java.lang.String getDeliveryPointCode();
  /**
   *
   *
   * <pre>
   * 2 digit delivery point code
   * </pre>
   *
   * <code>string delivery_point_code = 2;</code>
   *
   * @return The bytes for deliveryPointCode.
   */
  com.google.protobuf.ByteString getDeliveryPointCodeBytes();

  /**
   *
   *
   * <pre>
   * The delivery point check digit. This number is added to the end of the
   * delivery_point_barcode for mechanically scanned mail. Adding all the
   * digits of the delivery_point_barcode, delivery_point_check_digit, postal
   * code, and ZIP+4 together should yield a number divisible by 10.
   * </pre>
   *
   * <code>string delivery_point_check_digit = 3;</code>
   *
   * @return The deliveryPointCheckDigit.
   */
  java.lang.String getDeliveryPointCheckDigit();
  /**
   *
   *
   * <pre>
   * The delivery point check digit. This number is added to the end of the
   * delivery_point_barcode for mechanically scanned mail. Adding all the
   * digits of the delivery_point_barcode, delivery_point_check_digit, postal
   * code, and ZIP+4 together should yield a number divisible by 10.
   * </pre>
   *
   * <code>string delivery_point_check_digit = 3;</code>
   *
   * @return The bytes for deliveryPointCheckDigit.
   */
  com.google.protobuf.ByteString getDeliveryPointCheckDigitBytes();

  /**
   *
   *
   * <pre>
   * The possible values for DPV confirmation. Returns a single character.
   *
   * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
   * * `N`: Primary and any secondary number information failed to
   * DPV confirm.
   * * `S`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was present by not confirmed.
   * * `D`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was missing.
   * </pre>
   *
   * <code>string dpv_confirmation = 4;</code>
   *
   * @return The dpvConfirmation.
   */
  java.lang.String getDpvConfirmation();
  /**
   *
   *
   * <pre>
   * The possible values for DPV confirmation. Returns a single character.
   *
   * * `Y`: Address was DPV confirmed for primary and any secondary numbers.
   * * `N`: Primary and any secondary number information failed to
   * DPV confirm.
   * * `S`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was present by not confirmed.
   * * `D`: Address was DPV confirmed for the primary number only, and the
   * secondary number information was missing.
   * </pre>
   *
   * <code>string dpv_confirmation = 4;</code>
   *
   * @return The bytes for dpvConfirmation.
   */
  com.google.protobuf.ByteString getDpvConfirmationBytes();

  /**
   *
   *
   * <pre>
   * The footnotes from delivery point validation.
   * Multiple footnotes may be strung together in the same string.
   *
   * * `AA`: Input address matched to the ZIP+4 file
   * * `A1`: Input address was not matched to the ZIP+4 file
   * * `BB`: Matched to DPV (all components)
   * * `CC`: Secondary number not matched (present but invalid)
   * * `N1`: High-rise address missing secondary number
   * * `M1`: Primary number missing
   * * `M3`: Primary number invalid
   * * `P1`: Input address RR or HC box number missing
   * * `P3`: Input address PO, RR, or HC Box number invalid
   * * `F1`: Input address matched to a military address
   * * `G1`: Input address matched to a general delivery address
   * * `U1`: Input address matched to a unique ZIP code
   * * `PB`: Input address matched to PBSA record
   * * `RR`: DPV confirmed address with PMB information
   * * `R1`: DPV confirmed address without PMB information
   * * `R7`: Carrier Route R777 or R779 record
   * </pre>
   *
   * <code>string dpv_footnote = 5;</code>
   *
   * @return The dpvFootnote.
   */
  java.lang.String getDpvFootnote();
  /**
   *
   *
   * <pre>
   * The footnotes from delivery point validation.
   * Multiple footnotes may be strung together in the same string.
   *
   * * `AA`: Input address matched to the ZIP+4 file
   * * `A1`: Input address was not matched to the ZIP+4 file
   * * `BB`: Matched to DPV (all components)
   * * `CC`: Secondary number not matched (present but invalid)
   * * `N1`: High-rise address missing secondary number
   * * `M1`: Primary number missing
   * * `M3`: Primary number invalid
   * * `P1`: Input address RR or HC box number missing
   * * `P3`: Input address PO, RR, or HC Box number invalid
   * * `F1`: Input address matched to a military address
   * * `G1`: Input address matched to a general delivery address
   * * `U1`: Input address matched to a unique ZIP code
   * * `PB`: Input address matched to PBSA record
   * * `RR`: DPV confirmed address with PMB information
   * * `R1`: DPV confirmed address without PMB information
   * * `R7`: Carrier Route R777 or R779 record
   * </pre>
   *
   * <code>string dpv_footnote = 5;</code>
   *
   * @return The bytes for dpvFootnote.
   */
  com.google.protobuf.ByteString getDpvFootnoteBytes();

  /**
   *
   *
   * <pre>
   * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
   * private business receiving mail for clients. Returns a single character.
   *
   * * `Y`: The address is a CMRA
   * * `N`: The address is not a CMRA
   * </pre>
   *
   * <code>string dpv_cmra = 6;</code>
   *
   * @return The dpvCmra.
   */
  java.lang.String getDpvCmra();
  /**
   *
   *
   * <pre>
   * Indicates if the address is a CMRA (Commercial Mail Receiving Agency)--a
   * private business receiving mail for clients. Returns a single character.
   *
   * * `Y`: The address is a CMRA
   * * `N`: The address is not a CMRA
   * </pre>
   *
   * <code>string dpv_cmra = 6;</code>
   *
   * @return The bytes for dpvCmra.
   */
  com.google.protobuf.ByteString getDpvCmraBytes();

  /**
   *
   *
   * <pre>
   * Is this place vacant?
   * Returns a single character.
   *
   * * `Y`: The address is vacant
   * * `N`: The address is not vacant
   * </pre>
   *
   * <code>string dpv_vacant = 7;</code>
   *
   * @return The dpvVacant.
   */
  java.lang.String getDpvVacant();
  /**
   *
   *
   * <pre>
   * Is this place vacant?
   * Returns a single character.
   *
   * * `Y`: The address is vacant
   * * `N`: The address is not vacant
   * </pre>
   *
   * <code>string dpv_vacant = 7;</code>
   *
   * @return The bytes for dpvVacant.
   */
  com.google.protobuf.ByteString getDpvVacantBytes();

  /**
   *
   *
   * <pre>
   * Is this a no stat address or an active address?
   * No stat addresses are ones which are not continuously occupied or addresses
   * that the USPS does not service. Returns a single character.
   *
   * * `Y`: The address is not active
   * * `N`: The address is active
   * </pre>
   *
   * <code>string dpv_no_stat = 8;</code>
   *
   * @return The dpvNoStat.
   */
  java.lang.String getDpvNoStat();
  /**
   *
   *
   * <pre>
   * Is this a no stat address or an active address?
   * No stat addresses are ones which are not continuously occupied or addresses
   * that the USPS does not service. Returns a single character.
   *
   * * `Y`: The address is not active
   * * `N`: The address is active
   * </pre>
   *
   * <code>string dpv_no_stat = 8;</code>
   *
   * @return The bytes for dpvNoStat.
   */
  com.google.protobuf.ByteString getDpvNoStatBytes();

  /**
   *
   *
   * <pre>
   * The carrier route code.
   * A four character code consisting of a one letter prefix and a three digit
   * route designator.
   *
   * Prefixes:
   *
   * * `C`: Carrier route (or city route)
   * * `R`: Rural route
   * * `H`: Highway Contract Route
   * * `B`: Post Office Box Section
   * * `G`: General delivery unit
   * </pre>
   *
   * <code>string carrier_route = 9;</code>
   *
   * @return The carrierRoute.
   */
  java.lang.String getCarrierRoute();
  /**
   *
   *
   * <pre>
   * The carrier route code.
   * A four character code consisting of a one letter prefix and a three digit
   * route designator.
   *
   * Prefixes:
   *
   * * `C`: Carrier route (or city route)
   * * `R`: Rural route
   * * `H`: Highway Contract Route
   * * `B`: Post Office Box Section
   * * `G`: General delivery unit
   * </pre>
   *
   * <code>string carrier_route = 9;</code>
   *
   * @return The bytes for carrierRoute.
   */
  com.google.protobuf.ByteString getCarrierRouteBytes();

  /**
   *
   *
   * <pre>
   * Carrier route rate sort indicator.
   * </pre>
   *
   * <code>string carrier_route_indicator = 10;</code>
   *
   * @return The carrierRouteIndicator.
   */
  java.lang.String getCarrierRouteIndicator();
  /**
   *
   *
   * <pre>
   * Carrier route rate sort indicator.
   * </pre>
   *
   * <code>string carrier_route_indicator = 10;</code>
   *
   * @return The bytes for carrierRouteIndicator.
   */
  com.google.protobuf.ByteString getCarrierRouteIndicatorBytes();

  /**
   *
   *
   * <pre>
   * The delivery address is matchable, but the EWS file indicates that an exact
   * match will be available soon.
   * </pre>
   *
   * <code>bool ews_no_match = 11;</code>
   *
   * @return The ewsNoMatch.
   */
  boolean getEwsNoMatch();

  /**
   *
   *
   * <pre>
   * Main post office city.
   * </pre>
   *
   * <code>string post_office_city = 12;</code>
   *
   * @return The postOfficeCity.
   */
  java.lang.String getPostOfficeCity();
  /**
   *
   *
   * <pre>
   * Main post office city.
   * </pre>
   *
   * <code>string post_office_city = 12;</code>
   *
   * @return The bytes for postOfficeCity.
   */
  com.google.protobuf.ByteString getPostOfficeCityBytes();

  /**
   *
   *
   * <pre>
   * Main post office state.
   * </pre>
   *
   * <code>string post_office_state = 13;</code>
   *
   * @return The postOfficeState.
   */
  java.lang.String getPostOfficeState();
  /**
   *
   *
   * <pre>
   * Main post office state.
   * </pre>
   *
   * <code>string post_office_state = 13;</code>
   *
   * @return The bytes for postOfficeState.
   */
  com.google.protobuf.ByteString getPostOfficeStateBytes();

  /**
   *
   *
   * <pre>
   * Abbreviated city.
   * </pre>
   *
   * <code>string abbreviated_city = 14;</code>
   *
   * @return The abbreviatedCity.
   */
  java.lang.String getAbbreviatedCity();
  /**
   *
   *
   * <pre>
   * Abbreviated city.
   * </pre>
   *
   * <code>string abbreviated_city = 14;</code>
   *
   * @return The bytes for abbreviatedCity.
   */
  com.google.protobuf.ByteString getAbbreviatedCityBytes();

  /**
   *
   *
   * <pre>
   * FIPS county code.
   * </pre>
   *
   * <code>string fips_county_code = 15;</code>
   *
   * @return The fipsCountyCode.
   */
  java.lang.String getFipsCountyCode();
  /**
   *
   *
   * <pre>
   * FIPS county code.
   * </pre>
   *
   * <code>string fips_county_code = 15;</code>
   *
   * @return The bytes for fipsCountyCode.
   */
  com.google.protobuf.ByteString getFipsCountyCodeBytes();

  /**
   *
   *
   * <pre>
   * County name.
   * </pre>
   *
   * <code>string county = 16;</code>
   *
   * @return The county.
   */
  java.lang.String getCounty();
  /**
   *
   *
   * <pre>
   * County name.
   * </pre>
   *
   * <code>string county = 16;</code>
   *
   * @return The bytes for county.
   */
  com.google.protobuf.ByteString getCountyBytes();

  /**
   *
   *
   * <pre>
   * Enhanced Line of Travel (eLOT) number.
   * </pre>
   *
   * <code>string elot_number = 17;</code>
   *
   * @return The elotNumber.
   */
  java.lang.String getElotNumber();
  /**
   *
   *
   * <pre>
   * Enhanced Line of Travel (eLOT) number.
   * </pre>
   *
   * <code>string elot_number = 17;</code>
   *
   * @return The bytes for elotNumber.
   */
  com.google.protobuf.ByteString getElotNumberBytes();

  /**
   *
   *
   * <pre>
   * eLOT Ascending/Descending Flag (A/D).
   * </pre>
   *
   * <code>string elot_flag = 18;</code>
   *
   * @return The elotFlag.
   */
  java.lang.String getElotFlag();
  /**
   *
   *
   * <pre>
   * eLOT Ascending/Descending Flag (A/D).
   * </pre>
   *
   * <code>string elot_flag = 18;</code>
   *
   * @return The bytes for elotFlag.
   */
  com.google.protobuf.ByteString getElotFlagBytes();

  /**
   *
   *
   * <pre>
   * LACSLink return code.
   * </pre>
   *
   * <code>string lacs_link_return_code = 19;</code>
   *
   * @return The lacsLinkReturnCode.
   */
  java.lang.String getLacsLinkReturnCode();
  /**
   *
   *
   * <pre>
   * LACSLink return code.
   * </pre>
   *
   * <code>string lacs_link_return_code = 19;</code>
   *
   * @return The bytes for lacsLinkReturnCode.
   */
  com.google.protobuf.ByteString getLacsLinkReturnCodeBytes();

  /**
   *
   *
   * <pre>
   * LACSLink indicator.
   * </pre>
   *
   * <code>string lacs_link_indicator = 20;</code>
   *
   * @return The lacsLinkIndicator.
   */
  java.lang.String getLacsLinkIndicator();
  /**
   *
   *
   * <pre>
   * LACSLink indicator.
   * </pre>
   *
   * <code>string lacs_link_indicator = 20;</code>
   *
   * @return The bytes for lacsLinkIndicator.
   */
  com.google.protobuf.ByteString getLacsLinkIndicatorBytes();

  /**
   *
   *
   * <pre>
   * PO Box only postal code.
   * </pre>
   *
   * <code>bool po_box_only_postal_code = 21;</code>
   *
   * @return The poBoxOnlyPostalCode.
   */
  boolean getPoBoxOnlyPostalCode();

  /**
   *
   *
   * <pre>
   * Footnotes from matching a street or highrise record to suite information.
   * If business name match is found, the secondary number is returned.
   *
   * * `A`: SuiteLink record match, business address improved.
   * * `00`: No match, business address is not improved.
   * </pre>
   *
   * <code>string suitelink_footnote = 22;</code>
   *
   * @return The suitelinkFootnote.
   */
  java.lang.String getSuitelinkFootnote();
  /**
   *
   *
   * <pre>
   * Footnotes from matching a street or highrise record to suite information.
   * If business name match is found, the secondary number is returned.
   *
   * * `A`: SuiteLink record match, business address improved.
   * * `00`: No match, business address is not improved.
   * </pre>
   *
   * <code>string suitelink_footnote = 22;</code>
   *
   * @return The bytes for suitelinkFootnote.
   */
  com.google.protobuf.ByteString getSuitelinkFootnoteBytes();

  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) unit designator.
   * </pre>
   *
   * <code>string pmb_designator = 23;</code>
   *
   * @return The pmbDesignator.
   */
  java.lang.String getPmbDesignator();
  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) unit designator.
   * </pre>
   *
   * <code>string pmb_designator = 23;</code>
   *
   * @return The bytes for pmbDesignator.
   */
  com.google.protobuf.ByteString getPmbDesignatorBytes();

  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) number;
   * </pre>
   *
   * <code>string pmb_number = 24;</code>
   *
   * @return The pmbNumber.
   */
  java.lang.String getPmbNumber();
  /**
   *
   *
   * <pre>
   * PMB (Private Mail Box) number;
   * </pre>
   *
   * <code>string pmb_number = 24;</code>
   *
   * @return The bytes for pmbNumber.
   */
  com.google.protobuf.ByteString getPmbNumberBytes();

  /**
   *
   *
   * <pre>
   * Type of the address record that matches the input address.
   *
   * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
   * match available for an address.
   * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
   * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
   * record.
   * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
   * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
   * Route or a Highway Contract record, both of which may have associated Box
   * Number ranges.
   * * `S`: STREET RECORD: This is a match to a Street record containing a valid
   * primary number range.
   * </pre>
   *
   * <code>string address_record_type = 25;</code>
   *
   * @return The addressRecordType.
   */
  java.lang.String getAddressRecordType();
  /**
   *
   *
   * <pre>
   * Type of the address record that matches the input address.
   *
   * * `F`: FIRM. This is a match to a Firm Record, which is the finest level of
   * match available for an address.
   * * `G`: GENERAL DELIVERY. This is a match to a General Delivery record.
   * * `H`: BUILDING / APARTMENT. This is a match to a Building or Apartment
   * record.
   * * `P`: POST OFFICE BOX. This is a match to a Post Office Box.
   * * `R`: RURAL ROUTE or HIGHWAY CONTRACT: This is a match to either a Rural
   * Route or a Highway Contract record, both of which may have associated Box
   * Number ranges.
   * * `S`: STREET RECORD: This is a match to a Street record containing a valid
   * primary number range.
   * </pre>
   *
   * <code>string address_record_type = 25;</code>
   *
   * @return The bytes for addressRecordType.
   */
  com.google.protobuf.ByteString getAddressRecordTypeBytes();

  /**
   *
   *
   * <pre>
   * Indicator that a default address was found, but more specific addresses
   * exists.
   * </pre>
   *
   * <code>bool default_address = 26;</code>
   *
   * @return The defaultAddress.
   */
  boolean getDefaultAddress();

  /**
   *
   *
   * <pre>
   * Error message for USPS data retrieval. This is populated when USPS
   * processing is suspended because of the detection of artificially created
   * addresses.
   *
   * The USPS data fields might not be populated when this error is present.
   * </pre>
   *
   * <code>string error_message = 27;</code>
   *
   * @return The errorMessage.
   */
  java.lang.String getErrorMessage();
  /**
   *
   *
   * <pre>
   * Error message for USPS data retrieval. This is populated when USPS
   * processing is suspended because of the detection of artificially created
   * addresses.
   *
   * The USPS data fields might not be populated when this error is present.
   * </pre>
   *
   * <code>string error_message = 27;</code>
   *
   * @return The bytes for errorMessage.
   */
  com.google.protobuf.ByteString getErrorMessageBytes();

  /**
   *
   *
   * <pre>
   * Indicator that the request has been CASS processed.
   * </pre>
   *
   * <code>bool cass_processed = 28;</code>
   *
   * @return The cassProcessed.
   */
  boolean getCassProcessed();
}
