/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address_validation_service.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * The request for validating an address.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.ValidateAddressRequest}
 */
public final class ValidateAddressRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.ValidateAddressRequest)
    ValidateAddressRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ValidateAddressRequest.newBuilder() to construct.
  private ValidateAddressRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ValidateAddressRequest() {
    previousResponseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ValidateAddressRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
        .internal_static_google_maps_addressvalidation_v1_ValidateAddressRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
        .internal_static_google_maps_addressvalidation_v1_ValidateAddressRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.ValidateAddressRequest.class,
            com.google.maps.addressvalidation.v1.ValidateAddressRequest.Builder.class);
  }

  public static final int ADDRESS_FIELD_NUMBER = 1;
  private com.google.type.PostalAddress address_;
  /**
   *
   *
   * <pre>
   * Required. The address being validated. Unformatted addresses should be
   * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
   *
   * The total length of the fields in this input must not exceed 280
   * characters.
   *
   * Supported regions can be found in the
   * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
   *
   * The [language_code][google.type.PostalAddress.language_code] value in the
   * input address is reserved for future uses and is ignored today. The
   * validated address result will be populated based on the preferred language
   * for the given address, as identified by the system.
   *
   * The Address Validation API ignores the values in
   * [recipients][google.type.PostalAddress.recipients] and
   * [organization][google.type.PostalAddress.organization]. Any values in those
   * fields will be discarded and not returned. Please do not set them.
   * </pre>
   *
   * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the address field is set.
   */
  @java.lang.Override
  public boolean hasAddress() {
    return address_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The address being validated. Unformatted addresses should be
   * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
   *
   * The total length of the fields in this input must not exceed 280
   * characters.
   *
   * Supported regions can be found in the
   * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
   *
   * The [language_code][google.type.PostalAddress.language_code] value in the
   * input address is reserved for future uses and is ignored today. The
   * validated address result will be populated based on the preferred language
   * for the given address, as identified by the system.
   *
   * The Address Validation API ignores the values in
   * [recipients][google.type.PostalAddress.recipients] and
   * [organization][google.type.PostalAddress.organization]. Any values in those
   * fields will be discarded and not returned. Please do not set them.
   * </pre>
   *
   * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The address.
   */
  @java.lang.Override
  public com.google.type.PostalAddress getAddress() {
    return address_ == null ? com.google.type.PostalAddress.getDefaultInstance() : address_;
  }
  /**
   *
   *
   * <pre>
   * Required. The address being validated. Unformatted addresses should be
   * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
   *
   * The total length of the fields in this input must not exceed 280
   * characters.
   *
   * Supported regions can be found in the
   * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
   *
   * The [language_code][google.type.PostalAddress.language_code] value in the
   * input address is reserved for future uses and is ignored today. The
   * validated address result will be populated based on the preferred language
   * for the given address, as identified by the system.
   *
   * The Address Validation API ignores the values in
   * [recipients][google.type.PostalAddress.recipients] and
   * [organization][google.type.PostalAddress.organization]. Any values in those
   * fields will be discarded and not returned. Please do not set them.
   * </pre>
   *
   * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.type.PostalAddressOrBuilder getAddressOrBuilder() {
    return address_ == null ? com.google.type.PostalAddress.getDefaultInstance() : address_;
  }

  public static final int PREVIOUS_RESPONSE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object previousResponseId_ = "";
  /**
   *
   *
   * <pre>
   * This field must be empty for the first address validation request. If
   * more requests are necessary to fully validate a single address (for
   * example if the changes the user makes after the initial validation need to
   * be re-validated), then each followup request must populate this field with
   * the
   * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
   * from the very first response in the validation sequence.
   * </pre>
   *
   * <code>string previous_response_id = 2;</code>
   *
   * @return The previousResponseId.
   */
  @java.lang.Override
  public java.lang.String getPreviousResponseId() {
    java.lang.Object ref = previousResponseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      previousResponseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field must be empty for the first address validation request. If
   * more requests are necessary to fully validate a single address (for
   * example if the changes the user makes after the initial validation need to
   * be re-validated), then each followup request must populate this field with
   * the
   * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
   * from the very first response in the validation sequence.
   * </pre>
   *
   * <code>string previous_response_id = 2;</code>
   *
   * @return The bytes for previousResponseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPreviousResponseIdBytes() {
    java.lang.Object ref = previousResponseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      previousResponseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_USPS_CASS_FIELD_NUMBER = 3;
  private boolean enableUspsCass_ = false;
  /**
   *
   *
   * <pre>
   * Enables USPS CASS compatible mode. This affects _only_ the
   * [google.maps.addressvalidation.v1.ValidationResult.usps_data] field of
   * [google.maps.addressvalidation.v1.ValidationResult]. Note: for USPS CASS
   * enabled requests for addresses in Puerto Rico, a
   * [google.type.PostalAddress.region_code] of the `address` must be provided
   * as "PR", or an [google.type.PostalAddress.administrative_area] of the
   * `address` must be provided as "Puerto Rico" (case-insensitive) or "PR".
   *
   * It's recommended to use a componentized `address`, or alternatively specify
   * at least two [google.type.PostalAddress.address_lines] where the first line
   * contains the street number and name and the second line contains the city,
   * state, and zip code.
   * </pre>
   *
   * <code>bool enable_usps_cass = 3;</code>
   *
   * @return The enableUspsCass.
   */
  @java.lang.Override
  public boolean getEnableUspsCass() {
    return enableUspsCass_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (address_ != null) {
      output.writeMessage(1, getAddress());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(previousResponseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, previousResponseId_);
    }
    if (enableUspsCass_ != false) {
      output.writeBool(3, enableUspsCass_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (address_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAddress());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(previousResponseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, previousResponseId_);
    }
    if (enableUspsCass_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableUspsCass_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.ValidateAddressRequest)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.ValidateAddressRequest other =
        (com.google.maps.addressvalidation.v1.ValidateAddressRequest) obj;

    if (hasAddress() != other.hasAddress()) return false;
    if (hasAddress()) {
      if (!getAddress().equals(other.getAddress())) return false;
    }
    if (!getPreviousResponseId().equals(other.getPreviousResponseId())) return false;
    if (getEnableUspsCass() != other.getEnableUspsCass()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAddress()) {
      hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getAddress().hashCode();
    }
    hash = (37 * hash) + PREVIOUS_RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPreviousResponseId().hashCode();
    hash = (37 * hash) + ENABLE_USPS_CASS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableUspsCass());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.maps.addressvalidation.v1.ValidateAddressRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for validating an address.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.ValidateAddressRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.ValidateAddressRequest)
      com.google.maps.addressvalidation.v1.ValidateAddressRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_ValidateAddressRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_ValidateAddressRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.ValidateAddressRequest.class,
              com.google.maps.addressvalidation.v1.ValidateAddressRequest.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.ValidateAddressRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      address_ = null;
      if (addressBuilder_ != null) {
        addressBuilder_.dispose();
        addressBuilder_ = null;
      }
      previousResponseId_ = "";
      enableUspsCass_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_ValidateAddressRequest_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.ValidateAddressRequest getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.ValidateAddressRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.ValidateAddressRequest build() {
      com.google.maps.addressvalidation.v1.ValidateAddressRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.ValidateAddressRequest buildPartial() {
      com.google.maps.addressvalidation.v1.ValidateAddressRequest result =
          new com.google.maps.addressvalidation.v1.ValidateAddressRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.ValidateAddressRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.address_ = addressBuilder_ == null ? address_ : addressBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.previousResponseId_ = previousResponseId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.enableUspsCass_ = enableUspsCass_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.ValidateAddressRequest) {
        return mergeFrom((com.google.maps.addressvalidation.v1.ValidateAddressRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.ValidateAddressRequest other) {
      if (other == com.google.maps.addressvalidation.v1.ValidateAddressRequest.getDefaultInstance())
        return this;
      if (other.hasAddress()) {
        mergeAddress(other.getAddress());
      }
      if (!other.getPreviousResponseId().isEmpty()) {
        previousResponseId_ = other.previousResponseId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getEnableUspsCass() != false) {
        setEnableUspsCass(other.getEnableUspsCass());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAddressFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                previousResponseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                enableUspsCass_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.type.PostalAddress address_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PostalAddress,
            com.google.type.PostalAddress.Builder,
            com.google.type.PostalAddressOrBuilder>
        addressBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the address field is set.
     */
    public boolean hasAddress() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The address.
     */
    public com.google.type.PostalAddress getAddress() {
      if (addressBuilder_ == null) {
        return address_ == null ? com.google.type.PostalAddress.getDefaultInstance() : address_;
      } else {
        return addressBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAddress(com.google.type.PostalAddress value) {
      if (addressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        address_ = value;
      } else {
        addressBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAddress(com.google.type.PostalAddress.Builder builderForValue) {
      if (addressBuilder_ == null) {
        address_ = builderForValue.build();
      } else {
        addressBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAddress(com.google.type.PostalAddress value) {
      if (addressBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && address_ != null
            && address_ != com.google.type.PostalAddress.getDefaultInstance()) {
          getAddressBuilder().mergeFrom(value);
        } else {
          address_ = value;
        }
      } else {
        addressBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAddress() {
      bitField0_ = (bitField0_ & ~0x00000001);
      address_ = null;
      if (addressBuilder_ != null) {
        addressBuilder_.dispose();
        addressBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.PostalAddress.Builder getAddressBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAddressFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.PostalAddressOrBuilder getAddressOrBuilder() {
      if (addressBuilder_ != null) {
        return addressBuilder_.getMessageOrBuilder();
      } else {
        return address_ == null ? com.google.type.PostalAddress.getDefaultInstance() : address_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The address being validated. Unformatted addresses should be
     * submitted via [`address_lines`][google.type.PostalAddress.address_lines].
     *
     * The total length of the fields in this input must not exceed 280
     * characters.
     *
     * Supported regions can be found in the
     * [FAQ](https://developers.google.com/maps/documentation/address-validation/faq#which_regions_are_currently_supported).
     *
     * The [language_code][google.type.PostalAddress.language_code] value in the
     * input address is reserved for future uses and is ignored today. The
     * validated address result will be populated based on the preferred language
     * for the given address, as identified by the system.
     *
     * The Address Validation API ignores the values in
     * [recipients][google.type.PostalAddress.recipients] and
     * [organization][google.type.PostalAddress.organization]. Any values in those
     * fields will be discarded and not returned. Please do not set them.
     * </pre>
     *
     * <code>.google.type.PostalAddress address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.PostalAddress,
            com.google.type.PostalAddress.Builder,
            com.google.type.PostalAddressOrBuilder>
        getAddressFieldBuilder() {
      if (addressBuilder_ == null) {
        addressBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.PostalAddress,
                com.google.type.PostalAddress.Builder,
                com.google.type.PostalAddressOrBuilder>(
                getAddress(), getParentForChildren(), isClean());
        address_ = null;
      }
      return addressBuilder_;
    }

    private java.lang.Object previousResponseId_ = "";
    /**
     *
     *
     * <pre>
     * This field must be empty for the first address validation request. If
     * more requests are necessary to fully validate a single address (for
     * example if the changes the user makes after the initial validation need to
     * be re-validated), then each followup request must populate this field with
     * the
     * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
     * from the very first response in the validation sequence.
     * </pre>
     *
     * <code>string previous_response_id = 2;</code>
     *
     * @return The previousResponseId.
     */
    public java.lang.String getPreviousResponseId() {
      java.lang.Object ref = previousResponseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        previousResponseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field must be empty for the first address validation request. If
     * more requests are necessary to fully validate a single address (for
     * example if the changes the user makes after the initial validation need to
     * be re-validated), then each followup request must populate this field with
     * the
     * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
     * from the very first response in the validation sequence.
     * </pre>
     *
     * <code>string previous_response_id = 2;</code>
     *
     * @return The bytes for previousResponseId.
     */
    public com.google.protobuf.ByteString getPreviousResponseIdBytes() {
      java.lang.Object ref = previousResponseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        previousResponseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field must be empty for the first address validation request. If
     * more requests are necessary to fully validate a single address (for
     * example if the changes the user makes after the initial validation need to
     * be re-validated), then each followup request must populate this field with
     * the
     * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
     * from the very first response in the validation sequence.
     * </pre>
     *
     * <code>string previous_response_id = 2;</code>
     *
     * @param value The previousResponseId to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      previousResponseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field must be empty for the first address validation request. If
     * more requests are necessary to fully validate a single address (for
     * example if the changes the user makes after the initial validation need to
     * be re-validated), then each followup request must populate this field with
     * the
     * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
     * from the very first response in the validation sequence.
     * </pre>
     *
     * <code>string previous_response_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreviousResponseId() {
      previousResponseId_ = getDefaultInstance().getPreviousResponseId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field must be empty for the first address validation request. If
     * more requests are necessary to fully validate a single address (for
     * example if the changes the user makes after the initial validation need to
     * be re-validated), then each followup request must populate this field with
     * the
     * [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
     * from the very first response in the validation sequence.
     * </pre>
     *
     * <code>string previous_response_id = 2;</code>
     *
     * @param value The bytes for previousResponseId to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      previousResponseId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean enableUspsCass_;
    /**
     *
     *
     * <pre>
     * Enables USPS CASS compatible mode. This affects _only_ the
     * [google.maps.addressvalidation.v1.ValidationResult.usps_data] field of
     * [google.maps.addressvalidation.v1.ValidationResult]. Note: for USPS CASS
     * enabled requests for addresses in Puerto Rico, a
     * [google.type.PostalAddress.region_code] of the `address` must be provided
     * as "PR", or an [google.type.PostalAddress.administrative_area] of the
     * `address` must be provided as "Puerto Rico" (case-insensitive) or "PR".
     *
     * It's recommended to use a componentized `address`, or alternatively specify
     * at least two [google.type.PostalAddress.address_lines] where the first line
     * contains the street number and name and the second line contains the city,
     * state, and zip code.
     * </pre>
     *
     * <code>bool enable_usps_cass = 3;</code>
     *
     * @return The enableUspsCass.
     */
    @java.lang.Override
    public boolean getEnableUspsCass() {
      return enableUspsCass_;
    }
    /**
     *
     *
     * <pre>
     * Enables USPS CASS compatible mode. This affects _only_ the
     * [google.maps.addressvalidation.v1.ValidationResult.usps_data] field of
     * [google.maps.addressvalidation.v1.ValidationResult]. Note: for USPS CASS
     * enabled requests for addresses in Puerto Rico, a
     * [google.type.PostalAddress.region_code] of the `address` must be provided
     * as "PR", or an [google.type.PostalAddress.administrative_area] of the
     * `address` must be provided as "Puerto Rico" (case-insensitive) or "PR".
     *
     * It's recommended to use a componentized `address`, or alternatively specify
     * at least two [google.type.PostalAddress.address_lines] where the first line
     * contains the street number and name and the second line contains the city,
     * state, and zip code.
     * </pre>
     *
     * <code>bool enable_usps_cass = 3;</code>
     *
     * @param value The enableUspsCass to set.
     * @return This builder for chaining.
     */
    public Builder setEnableUspsCass(boolean value) {

      enableUspsCass_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables USPS CASS compatible mode. This affects _only_ the
     * [google.maps.addressvalidation.v1.ValidationResult.usps_data] field of
     * [google.maps.addressvalidation.v1.ValidationResult]. Note: for USPS CASS
     * enabled requests for addresses in Puerto Rico, a
     * [google.type.PostalAddress.region_code] of the `address` must be provided
     * as "PR", or an [google.type.PostalAddress.administrative_area] of the
     * `address` must be provided as "Puerto Rico" (case-insensitive) or "PR".
     *
     * It's recommended to use a componentized `address`, or alternatively specify
     * at least two [google.type.PostalAddress.address_lines] where the first line
     * contains the street number and name and the second line contains the city,
     * state, and zip code.
     * </pre>
     *
     * <code>bool enable_usps_cass = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableUspsCass() {
      bitField0_ = (bitField0_ & ~0x00000004);
      enableUspsCass_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.ValidateAddressRequest)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.ValidateAddressRequest)
  private static final com.google.maps.addressvalidation.v1.ValidateAddressRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.ValidateAddressRequest();
  }

  public static com.google.maps.addressvalidation.v1.ValidateAddressRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ValidateAddressRequest> PARSER =
      new com.google.protobuf.AbstractParser<ValidateAddressRequest>() {
        @java.lang.Override
        public ValidateAddressRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ValidateAddressRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ValidateAddressRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.ValidateAddressRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
