/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address_validation_service.proto

package com.google.maps.addressvalidation.v1;

/**
 *
 *
 * <pre>
 * High level overview of the address validation result and geocode.
 * </pre>
 *
 * Protobuf type {@code google.maps.addressvalidation.v1.Verdict}
 */
public final class Verdict extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.addressvalidation.v1.Verdict)
    VerdictOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Verdict.newBuilder() to construct.
  private Verdict(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Verdict() {
    inputGranularity_ = 0;
    validationGranularity_ = 0;
    geocodeGranularity_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Verdict();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
        .internal_static_google_maps_addressvalidation_v1_Verdict_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
        .internal_static_google_maps_addressvalidation_v1_Verdict_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.addressvalidation.v1.Verdict.class,
            com.google.maps.addressvalidation.v1.Verdict.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The various granularities that an address or a geocode can have.
   * When used to indicate granularity for an *address*, these values indicate
   * with how fine a granularity the address identifies a mailing destination.
   * For example, an address such as "123 Main Street, Redwood City, CA, 94061"
   * identifies a `PREMISE` while something like "Redwood City, CA, 94061"
   * identifies a `LOCALITY`. However, if we are unable to find a geocode for
   * "123 Main Street" in Redwood City, the geocode returned might be of
   * `LOCALITY` granularity even though the address is more granular.
   * </pre>
   *
   * Protobuf enum {@code google.maps.addressvalidation.v1.Verdict.Granularity}
   */
  public enum Granularity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>GRANULARITY_UNSPECIFIED = 0;</code>
     */
    GRANULARITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Below-building level result, such as an apartment.
     * </pre>
     *
     * <code>SUB_PREMISE = 1;</code>
     */
    SUB_PREMISE(1),
    /**
     *
     *
     * <pre>
     * Building-level result.
     * </pre>
     *
     * <code>PREMISE = 2;</code>
     */
    PREMISE(2),
    /**
     *
     *
     * <pre>
     * A geocode that should be very close to the building-level location of
     * the address.
     * </pre>
     *
     * <code>PREMISE_PROXIMITY = 3;</code>
     */
    PREMISE_PROXIMITY(3),
    /**
     *
     *
     * <pre>
     * The address or geocode indicates a block. Only used in regions which
     * have block-level addressing, such as Japan.
     * </pre>
     *
     * <code>BLOCK = 4;</code>
     */
    BLOCK(4),
    /**
     *
     *
     * <pre>
     * The geocode or address is granular to route, such as a street, road, or
     * highway.
     * </pre>
     *
     * <code>ROUTE = 5;</code>
     */
    ROUTE(5),
    /**
     *
     *
     * <pre>
     * All other granularities, which are bucketed together since they are not
     * deliverable.
     * </pre>
     *
     * <code>OTHER = 6;</code>
     */
    OTHER(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>GRANULARITY_UNSPECIFIED = 0;</code>
     */
    public static final int GRANULARITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Below-building level result, such as an apartment.
     * </pre>
     *
     * <code>SUB_PREMISE = 1;</code>
     */
    public static final int SUB_PREMISE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Building-level result.
     * </pre>
     *
     * <code>PREMISE = 2;</code>
     */
    public static final int PREMISE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * A geocode that should be very close to the building-level location of
     * the address.
     * </pre>
     *
     * <code>PREMISE_PROXIMITY = 3;</code>
     */
    public static final int PREMISE_PROXIMITY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The address or geocode indicates a block. Only used in regions which
     * have block-level addressing, such as Japan.
     * </pre>
     *
     * <code>BLOCK = 4;</code>
     */
    public static final int BLOCK_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The geocode or address is granular to route, such as a street, road, or
     * highway.
     * </pre>
     *
     * <code>ROUTE = 5;</code>
     */
    public static final int ROUTE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * All other granularities, which are bucketed together since they are not
     * deliverable.
     * </pre>
     *
     * <code>OTHER = 6;</code>
     */
    public static final int OTHER_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Granularity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Granularity forNumber(int value) {
      switch (value) {
        case 0:
          return GRANULARITY_UNSPECIFIED;
        case 1:
          return SUB_PREMISE;
        case 2:
          return PREMISE;
        case 3:
          return PREMISE_PROXIMITY;
        case 4:
          return BLOCK;
        case 5:
          return ROUTE;
        case 6:
          return OTHER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Granularity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Granularity> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Granularity>() {
          public Granularity findValueByNumber(int number) {
            return Granularity.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.Verdict.getDescriptor().getEnumTypes().get(0);
    }

    private static final Granularity[] VALUES = values();

    public static Granularity valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Granularity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.addressvalidation.v1.Verdict.Granularity)
  }

  public static final int INPUT_GRANULARITY_FIELD_NUMBER = 1;
  private int inputGranularity_ = 0;
  /**
   *
   *
   * <pre>
   * The granularity of the **input** address. This is the result of parsing the
   * input address and does not give any validation signals. For validation
   * signals, refer to `validation_granularity` below.
   *
   * For example, if the input address includes a specific apartment number,
   * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
   * the apartment number in the databases or the apartment number is invalid,
   * the `validation_granularity` will likely be `PREMISE` or below.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
   *
   * @return The enum numeric value on the wire for inputGranularity.
   */
  @java.lang.Override
  public int getInputGranularityValue() {
    return inputGranularity_;
  }
  /**
   *
   *
   * <pre>
   * The granularity of the **input** address. This is the result of parsing the
   * input address and does not give any validation signals. For validation
   * signals, refer to `validation_granularity` below.
   *
   * For example, if the input address includes a specific apartment number,
   * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
   * the apartment number in the databases or the apartment number is invalid,
   * the `validation_granularity` will likely be `PREMISE` or below.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
   *
   * @return The inputGranularity.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Verdict.Granularity getInputGranularity() {
    com.google.maps.addressvalidation.v1.Verdict.Granularity result =
        com.google.maps.addressvalidation.v1.Verdict.Granularity.forNumber(inputGranularity_);
    return result == null
        ? com.google.maps.addressvalidation.v1.Verdict.Granularity.UNRECOGNIZED
        : result;
  }

  public static final int VALIDATION_GRANULARITY_FIELD_NUMBER = 2;
  private int validationGranularity_ = 0;
  /**
   *
   *
   * <pre>
   * The granularity level that the API can fully **validate** the address to.
   * For example, an `validation_granularity` of `PREMISE` indicates all address
   * components at the level of `PREMISE` or more coarse can be validated.
   *
   * Per address component validation result can be found in
   * [google.maps.addressvalidation.v1.Address.address_components].
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;</code>
   *
   * @return The enum numeric value on the wire for validationGranularity.
   */
  @java.lang.Override
  public int getValidationGranularityValue() {
    return validationGranularity_;
  }
  /**
   *
   *
   * <pre>
   * The granularity level that the API can fully **validate** the address to.
   * For example, an `validation_granularity` of `PREMISE` indicates all address
   * components at the level of `PREMISE` or more coarse can be validated.
   *
   * Per address component validation result can be found in
   * [google.maps.addressvalidation.v1.Address.address_components].
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;</code>
   *
   * @return The validationGranularity.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Verdict.Granularity getValidationGranularity() {
    com.google.maps.addressvalidation.v1.Verdict.Granularity result =
        com.google.maps.addressvalidation.v1.Verdict.Granularity.forNumber(validationGranularity_);
    return result == null
        ? com.google.maps.addressvalidation.v1.Verdict.Granularity.UNRECOGNIZED
        : result;
  }

  public static final int GEOCODE_GRANULARITY_FIELD_NUMBER = 3;
  private int geocodeGranularity_ = 0;
  /**
   *
   *
   * <pre>
   * Information about the granularity of the
   * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
   * This can be understood as the semantic meaning of how coarse or fine the
   * geocoded location is.
   *
   * This can differ from the `validation_granularity` above occasionally. For
   * example, our database might record the existence of an apartment number but
   * do not have a precise location for the apartment within a big apartment
   * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
   * but the `geocode_granularity` will be `PREMISE`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
   *
   * @return The enum numeric value on the wire for geocodeGranularity.
   */
  @java.lang.Override
  public int getGeocodeGranularityValue() {
    return geocodeGranularity_;
  }
  /**
   *
   *
   * <pre>
   * Information about the granularity of the
   * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
   * This can be understood as the semantic meaning of how coarse or fine the
   * geocoded location is.
   *
   * This can differ from the `validation_granularity` above occasionally. For
   * example, our database might record the existence of an apartment number but
   * do not have a precise location for the apartment within a big apartment
   * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
   * but the `geocode_granularity` will be `PREMISE`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
   *
   * @return The geocodeGranularity.
   */
  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Verdict.Granularity getGeocodeGranularity() {
    com.google.maps.addressvalidation.v1.Verdict.Granularity result =
        com.google.maps.addressvalidation.v1.Verdict.Granularity.forNumber(geocodeGranularity_);
    return result == null
        ? com.google.maps.addressvalidation.v1.Verdict.Granularity.UNRECOGNIZED
        : result;
  }

  public static final int ADDRESS_COMPLETE_FIELD_NUMBER = 4;
  private boolean addressComplete_ = false;
  /**
   *
   *
   * <pre>
   * The address is considered complete if there are no unresolved tokens, no
   * unexpected or missing address components. See
   * [`missing_component_types`][google.maps.addressvalidation.v1.Address.missing_component_types],
   * [`unresolved_tokens`][google.maps.addressvalidation.v1.Address.unresolved_tokens]
   * or
   * [`unexpected`][google.maps.addressvalidation.v1.AddressComponent.unexpected]
   * fields for more details.
   * </pre>
   *
   * <code>bool address_complete = 4;</code>
   *
   * @return The addressComplete.
   */
  @java.lang.Override
  public boolean getAddressComplete() {
    return addressComplete_;
  }

  public static final int HAS_UNCONFIRMED_COMPONENTS_FIELD_NUMBER = 5;
  private boolean hasUnconfirmedComponents_ = false;
  /**
   *
   *
   * <pre>
   * At least one address component cannot be categorized or validated, see
   * [google.maps.addressvalidation.v1.Address.address_components] for
   * details.
   * </pre>
   *
   * <code>bool has_unconfirmed_components = 5;</code>
   *
   * @return The hasUnconfirmedComponents.
   */
  @java.lang.Override
  public boolean getHasUnconfirmedComponents() {
    return hasUnconfirmedComponents_;
  }

  public static final int HAS_INFERRED_COMPONENTS_FIELD_NUMBER = 6;
  private boolean hasInferredComponents_ = false;
  /**
   *
   *
   * <pre>
   * At least one address component was inferred (added) that wasn't in the
   * input, see
   * [google.maps.addressvalidation.v1.Address.address_components] for
   * details.
   * </pre>
   *
   * <code>bool has_inferred_components = 6;</code>
   *
   * @return The hasInferredComponents.
   */
  @java.lang.Override
  public boolean getHasInferredComponents() {
    return hasInferredComponents_;
  }

  public static final int HAS_REPLACED_COMPONENTS_FIELD_NUMBER = 7;
  private boolean hasReplacedComponents_ = false;
  /**
   *
   *
   * <pre>
   * At least one address component was replaced, see
   * [google.maps.addressvalidation.v1.Address.address_components] for
   * details.
   * </pre>
   *
   * <code>bool has_replaced_components = 7;</code>
   *
   * @return The hasReplacedComponents.
   */
  @java.lang.Override
  public boolean getHasReplacedComponents() {
    return hasReplacedComponents_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputGranularity_
        != com.google.maps.addressvalidation.v1.Verdict.Granularity.GRANULARITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, inputGranularity_);
    }
    if (validationGranularity_
        != com.google.maps.addressvalidation.v1.Verdict.Granularity.GRANULARITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, validationGranularity_);
    }
    if (geocodeGranularity_
        != com.google.maps.addressvalidation.v1.Verdict.Granularity.GRANULARITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, geocodeGranularity_);
    }
    if (addressComplete_ != false) {
      output.writeBool(4, addressComplete_);
    }
    if (hasUnconfirmedComponents_ != false) {
      output.writeBool(5, hasUnconfirmedComponents_);
    }
    if (hasInferredComponents_ != false) {
      output.writeBool(6, hasInferredComponents_);
    }
    if (hasReplacedComponents_ != false) {
      output.writeBool(7, hasReplacedComponents_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputGranularity_
        != com.google.maps.addressvalidation.v1.Verdict.Granularity.GRANULARITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, inputGranularity_);
    }
    if (validationGranularity_
        != com.google.maps.addressvalidation.v1.Verdict.Granularity.GRANULARITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, validationGranularity_);
    }
    if (geocodeGranularity_
        != com.google.maps.addressvalidation.v1.Verdict.Granularity.GRANULARITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, geocodeGranularity_);
    }
    if (addressComplete_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, addressComplete_);
    }
    if (hasUnconfirmedComponents_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, hasUnconfirmedComponents_);
    }
    if (hasInferredComponents_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, hasInferredComponents_);
    }
    if (hasReplacedComponents_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, hasReplacedComponents_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.addressvalidation.v1.Verdict)) {
      return super.equals(obj);
    }
    com.google.maps.addressvalidation.v1.Verdict other =
        (com.google.maps.addressvalidation.v1.Verdict) obj;

    if (inputGranularity_ != other.inputGranularity_) return false;
    if (validationGranularity_ != other.validationGranularity_) return false;
    if (geocodeGranularity_ != other.geocodeGranularity_) return false;
    if (getAddressComplete() != other.getAddressComplete()) return false;
    if (getHasUnconfirmedComponents() != other.getHasUnconfirmedComponents()) return false;
    if (getHasInferredComponents() != other.getHasInferredComponents()) return false;
    if (getHasReplacedComponents() != other.getHasReplacedComponents()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INPUT_GRANULARITY_FIELD_NUMBER;
    hash = (53 * hash) + inputGranularity_;
    hash = (37 * hash) + VALIDATION_GRANULARITY_FIELD_NUMBER;
    hash = (53 * hash) + validationGranularity_;
    hash = (37 * hash) + GEOCODE_GRANULARITY_FIELD_NUMBER;
    hash = (53 * hash) + geocodeGranularity_;
    hash = (37 * hash) + ADDRESS_COMPLETE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAddressComplete());
    hash = (37 * hash) + HAS_UNCONFIRMED_COMPONENTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasUnconfirmedComponents());
    hash = (37 * hash) + HAS_INFERRED_COMPONENTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasInferredComponents());
    hash = (37 * hash) + HAS_REPLACED_COMPONENTS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHasReplacedComponents());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.addressvalidation.v1.Verdict parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.addressvalidation.v1.Verdict prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * High level overview of the address validation result and geocode.
   * </pre>
   *
   * Protobuf type {@code google.maps.addressvalidation.v1.Verdict}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.addressvalidation.v1.Verdict)
      com.google.maps.addressvalidation.v1.VerdictOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_Verdict_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_Verdict_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.addressvalidation.v1.Verdict.class,
              com.google.maps.addressvalidation.v1.Verdict.Builder.class);
    }

    // Construct using com.google.maps.addressvalidation.v1.Verdict.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inputGranularity_ = 0;
      validationGranularity_ = 0;
      geocodeGranularity_ = 0;
      addressComplete_ = false;
      hasUnconfirmedComponents_ = false;
      hasInferredComponents_ = false;
      hasReplacedComponents_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.addressvalidation.v1.AddressValidationServiceProto
          .internal_static_google_maps_addressvalidation_v1_Verdict_descriptor;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Verdict getDefaultInstanceForType() {
      return com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Verdict build() {
      com.google.maps.addressvalidation.v1.Verdict result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Verdict buildPartial() {
      com.google.maps.addressvalidation.v1.Verdict result =
          new com.google.maps.addressvalidation.v1.Verdict(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.addressvalidation.v1.Verdict result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inputGranularity_ = inputGranularity_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.validationGranularity_ = validationGranularity_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.geocodeGranularity_ = geocodeGranularity_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.addressComplete_ = addressComplete_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.hasUnconfirmedComponents_ = hasUnconfirmedComponents_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.hasInferredComponents_ = hasInferredComponents_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.hasReplacedComponents_ = hasReplacedComponents_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.addressvalidation.v1.Verdict) {
        return mergeFrom((com.google.maps.addressvalidation.v1.Verdict) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.addressvalidation.v1.Verdict other) {
      if (other == com.google.maps.addressvalidation.v1.Verdict.getDefaultInstance()) return this;
      if (other.inputGranularity_ != 0) {
        setInputGranularityValue(other.getInputGranularityValue());
      }
      if (other.validationGranularity_ != 0) {
        setValidationGranularityValue(other.getValidationGranularityValue());
      }
      if (other.geocodeGranularity_ != 0) {
        setGeocodeGranularityValue(other.getGeocodeGranularityValue());
      }
      if (other.getAddressComplete() != false) {
        setAddressComplete(other.getAddressComplete());
      }
      if (other.getHasUnconfirmedComponents() != false) {
        setHasUnconfirmedComponents(other.getHasUnconfirmedComponents());
      }
      if (other.getHasInferredComponents() != false) {
        setHasInferredComponents(other.getHasInferredComponents());
      }
      if (other.getHasReplacedComponents() != false) {
        setHasReplacedComponents(other.getHasReplacedComponents());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                inputGranularity_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                validationGranularity_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                geocodeGranularity_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                addressComplete_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                hasUnconfirmedComponents_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                hasInferredComponents_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                hasReplacedComponents_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int inputGranularity_ = 0;
    /**
     *
     *
     * <pre>
     * The granularity of the **input** address. This is the result of parsing the
     * input address and does not give any validation signals. For validation
     * signals, refer to `validation_granularity` below.
     *
     * For example, if the input address includes a specific apartment number,
     * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
     * the apartment number in the databases or the apartment number is invalid,
     * the `validation_granularity` will likely be `PREMISE` or below.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
     *
     * @return The enum numeric value on the wire for inputGranularity.
     */
    @java.lang.Override
    public int getInputGranularityValue() {
      return inputGranularity_;
    }
    /**
     *
     *
     * <pre>
     * The granularity of the **input** address. This is the result of parsing the
     * input address and does not give any validation signals. For validation
     * signals, refer to `validation_granularity` below.
     *
     * For example, if the input address includes a specific apartment number,
     * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
     * the apartment number in the databases or the apartment number is invalid,
     * the `validation_granularity` will likely be `PREMISE` or below.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
     *
     * @param value The enum numeric value on the wire for inputGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setInputGranularityValue(int value) {
      inputGranularity_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The granularity of the **input** address. This is the result of parsing the
     * input address and does not give any validation signals. For validation
     * signals, refer to `validation_granularity` below.
     *
     * For example, if the input address includes a specific apartment number,
     * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
     * the apartment number in the databases or the apartment number is invalid,
     * the `validation_granularity` will likely be `PREMISE` or below.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
     *
     * @return The inputGranularity.
     */
    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Verdict.Granularity getInputGranularity() {
      com.google.maps.addressvalidation.v1.Verdict.Granularity result =
          com.google.maps.addressvalidation.v1.Verdict.Granularity.forNumber(inputGranularity_);
      return result == null
          ? com.google.maps.addressvalidation.v1.Verdict.Granularity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The granularity of the **input** address. This is the result of parsing the
     * input address and does not give any validation signals. For validation
     * signals, refer to `validation_granularity` below.
     *
     * For example, if the input address includes a specific apartment number,
     * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
     * the apartment number in the databases or the apartment number is invalid,
     * the `validation_granularity` will likely be `PREMISE` or below.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
     *
     * @param value The inputGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setInputGranularity(
        com.google.maps.addressvalidation.v1.Verdict.Granularity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      inputGranularity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The granularity of the **input** address. This is the result of parsing the
     * input address and does not give any validation signals. For validation
     * signals, refer to `validation_granularity` below.
     *
     * For example, if the input address includes a specific apartment number,
     * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
     * the apartment number in the databases or the apartment number is invalid,
     * the `validation_granularity` will likely be `PREMISE` or below.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputGranularity() {
      bitField0_ = (bitField0_ & ~0x00000001);
      inputGranularity_ = 0;
      onChanged();
      return this;
    }

    private int validationGranularity_ = 0;
    /**
     *
     *
     * <pre>
     * The granularity level that the API can fully **validate** the address to.
     * For example, an `validation_granularity` of `PREMISE` indicates all address
     * components at the level of `PREMISE` or more coarse can be validated.
     *
     * Per address component validation result can be found in
     * [google.maps.addressvalidation.v1.Address.address_components].
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for validationGranularity.
     */
    @java.lang.Override
    public int getValidationGranularityValue() {
      return validationGranularity_;
    }
    /**
     *
     *
     * <pre>
     * The granularity level that the API can fully **validate** the address to.
     * For example, an `validation_granularity` of `PREMISE` indicates all address
     * components at the level of `PREMISE` or more coarse can be validated.
     *
     * Per address component validation result can be found in
     * [google.maps.addressvalidation.v1.Address.address_components].
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for validationGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setValidationGranularityValue(int value) {
      validationGranularity_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The granularity level that the API can fully **validate** the address to.
     * For example, an `validation_granularity` of `PREMISE` indicates all address
     * components at the level of `PREMISE` or more coarse can be validated.
     *
     * Per address component validation result can be found in
     * [google.maps.addressvalidation.v1.Address.address_components].
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;
     * </code>
     *
     * @return The validationGranularity.
     */
    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Verdict.Granularity getValidationGranularity() {
      com.google.maps.addressvalidation.v1.Verdict.Granularity result =
          com.google.maps.addressvalidation.v1.Verdict.Granularity.forNumber(
              validationGranularity_);
      return result == null
          ? com.google.maps.addressvalidation.v1.Verdict.Granularity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The granularity level that the API can fully **validate** the address to.
     * For example, an `validation_granularity` of `PREMISE` indicates all address
     * components at the level of `PREMISE` or more coarse can be validated.
     *
     * Per address component validation result can be found in
     * [google.maps.addressvalidation.v1.Address.address_components].
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;
     * </code>
     *
     * @param value The validationGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setValidationGranularity(
        com.google.maps.addressvalidation.v1.Verdict.Granularity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      validationGranularity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The granularity level that the API can fully **validate** the address to.
     * For example, an `validation_granularity` of `PREMISE` indicates all address
     * components at the level of `PREMISE` or more coarse can be validated.
     *
     * Per address component validation result can be found in
     * [google.maps.addressvalidation.v1.Address.address_components].
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationGranularity() {
      bitField0_ = (bitField0_ & ~0x00000002);
      validationGranularity_ = 0;
      onChanged();
      return this;
    }

    private int geocodeGranularity_ = 0;
    /**
     *
     *
     * <pre>
     * Information about the granularity of the
     * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
     * This can be understood as the semantic meaning of how coarse or fine the
     * geocoded location is.
     *
     * This can differ from the `validation_granularity` above occasionally. For
     * example, our database might record the existence of an apartment number but
     * do not have a precise location for the apartment within a big apartment
     * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
     * but the `geocode_granularity` will be `PREMISE`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
     *
     * @return The enum numeric value on the wire for geocodeGranularity.
     */
    @java.lang.Override
    public int getGeocodeGranularityValue() {
      return geocodeGranularity_;
    }
    /**
     *
     *
     * <pre>
     * Information about the granularity of the
     * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
     * This can be understood as the semantic meaning of how coarse or fine the
     * geocoded location is.
     *
     * This can differ from the `validation_granularity` above occasionally. For
     * example, our database might record the existence of an apartment number but
     * do not have a precise location for the apartment within a big apartment
     * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
     * but the `geocode_granularity` will be `PREMISE`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
     *
     * @param value The enum numeric value on the wire for geocodeGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setGeocodeGranularityValue(int value) {
      geocodeGranularity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the granularity of the
     * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
     * This can be understood as the semantic meaning of how coarse or fine the
     * geocoded location is.
     *
     * This can differ from the `validation_granularity` above occasionally. For
     * example, our database might record the existence of an apartment number but
     * do not have a precise location for the apartment within a big apartment
     * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
     * but the `geocode_granularity` will be `PREMISE`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
     *
     * @return The geocodeGranularity.
     */
    @java.lang.Override
    public com.google.maps.addressvalidation.v1.Verdict.Granularity getGeocodeGranularity() {
      com.google.maps.addressvalidation.v1.Verdict.Granularity result =
          com.google.maps.addressvalidation.v1.Verdict.Granularity.forNumber(geocodeGranularity_);
      return result == null
          ? com.google.maps.addressvalidation.v1.Verdict.Granularity.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Information about the granularity of the
     * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
     * This can be understood as the semantic meaning of how coarse or fine the
     * geocoded location is.
     *
     * This can differ from the `validation_granularity` above occasionally. For
     * example, our database might record the existence of an apartment number but
     * do not have a precise location for the apartment within a big apartment
     * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
     * but the `geocode_granularity` will be `PREMISE`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
     *
     * @param value The geocodeGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setGeocodeGranularity(
        com.google.maps.addressvalidation.v1.Verdict.Granularity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      geocodeGranularity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the granularity of the
     * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
     * This can be understood as the semantic meaning of how coarse or fine the
     * geocoded location is.
     *
     * This can differ from the `validation_granularity` above occasionally. For
     * example, our database might record the existence of an apartment number but
     * do not have a precise location for the apartment within a big apartment
     * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
     * but the `geocode_granularity` will be `PREMISE`.
     * </pre>
     *
     * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeocodeGranularity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      geocodeGranularity_ = 0;
      onChanged();
      return this;
    }

    private boolean addressComplete_;
    /**
     *
     *
     * <pre>
     * The address is considered complete if there are no unresolved tokens, no
     * unexpected or missing address components. See
     * [`missing_component_types`][google.maps.addressvalidation.v1.Address.missing_component_types],
     * [`unresolved_tokens`][google.maps.addressvalidation.v1.Address.unresolved_tokens]
     * or
     * [`unexpected`][google.maps.addressvalidation.v1.AddressComponent.unexpected]
     * fields for more details.
     * </pre>
     *
     * <code>bool address_complete = 4;</code>
     *
     * @return The addressComplete.
     */
    @java.lang.Override
    public boolean getAddressComplete() {
      return addressComplete_;
    }
    /**
     *
     *
     * <pre>
     * The address is considered complete if there are no unresolved tokens, no
     * unexpected or missing address components. See
     * [`missing_component_types`][google.maps.addressvalidation.v1.Address.missing_component_types],
     * [`unresolved_tokens`][google.maps.addressvalidation.v1.Address.unresolved_tokens]
     * or
     * [`unexpected`][google.maps.addressvalidation.v1.AddressComponent.unexpected]
     * fields for more details.
     * </pre>
     *
     * <code>bool address_complete = 4;</code>
     *
     * @param value The addressComplete to set.
     * @return This builder for chaining.
     */
    public Builder setAddressComplete(boolean value) {

      addressComplete_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address is considered complete if there are no unresolved tokens, no
     * unexpected or missing address components. See
     * [`missing_component_types`][google.maps.addressvalidation.v1.Address.missing_component_types],
     * [`unresolved_tokens`][google.maps.addressvalidation.v1.Address.unresolved_tokens]
     * or
     * [`unexpected`][google.maps.addressvalidation.v1.AddressComponent.unexpected]
     * fields for more details.
     * </pre>
     *
     * <code>bool address_complete = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddressComplete() {
      bitField0_ = (bitField0_ & ~0x00000008);
      addressComplete_ = false;
      onChanged();
      return this;
    }

    private boolean hasUnconfirmedComponents_;
    /**
     *
     *
     * <pre>
     * At least one address component cannot be categorized or validated, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_unconfirmed_components = 5;</code>
     *
     * @return The hasUnconfirmedComponents.
     */
    @java.lang.Override
    public boolean getHasUnconfirmedComponents() {
      return hasUnconfirmedComponents_;
    }
    /**
     *
     *
     * <pre>
     * At least one address component cannot be categorized or validated, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_unconfirmed_components = 5;</code>
     *
     * @param value The hasUnconfirmedComponents to set.
     * @return This builder for chaining.
     */
    public Builder setHasUnconfirmedComponents(boolean value) {

      hasUnconfirmedComponents_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one address component cannot be categorized or validated, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_unconfirmed_components = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasUnconfirmedComponents() {
      bitField0_ = (bitField0_ & ~0x00000010);
      hasUnconfirmedComponents_ = false;
      onChanged();
      return this;
    }

    private boolean hasInferredComponents_;
    /**
     *
     *
     * <pre>
     * At least one address component was inferred (added) that wasn't in the
     * input, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_inferred_components = 6;</code>
     *
     * @return The hasInferredComponents.
     */
    @java.lang.Override
    public boolean getHasInferredComponents() {
      return hasInferredComponents_;
    }
    /**
     *
     *
     * <pre>
     * At least one address component was inferred (added) that wasn't in the
     * input, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_inferred_components = 6;</code>
     *
     * @param value The hasInferredComponents to set.
     * @return This builder for chaining.
     */
    public Builder setHasInferredComponents(boolean value) {

      hasInferredComponents_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one address component was inferred (added) that wasn't in the
     * input, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_inferred_components = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasInferredComponents() {
      bitField0_ = (bitField0_ & ~0x00000020);
      hasInferredComponents_ = false;
      onChanged();
      return this;
    }

    private boolean hasReplacedComponents_;
    /**
     *
     *
     * <pre>
     * At least one address component was replaced, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_replaced_components = 7;</code>
     *
     * @return The hasReplacedComponents.
     */
    @java.lang.Override
    public boolean getHasReplacedComponents() {
      return hasReplacedComponents_;
    }
    /**
     *
     *
     * <pre>
     * At least one address component was replaced, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_replaced_components = 7;</code>
     *
     * @param value The hasReplacedComponents to set.
     * @return This builder for chaining.
     */
    public Builder setHasReplacedComponents(boolean value) {

      hasReplacedComponents_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * At least one address component was replaced, see
     * [google.maps.addressvalidation.v1.Address.address_components] for
     * details.
     * </pre>
     *
     * <code>bool has_replaced_components = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHasReplacedComponents() {
      bitField0_ = (bitField0_ & ~0x00000040);
      hasReplacedComponents_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.addressvalidation.v1.Verdict)
  }

  // @@protoc_insertion_point(class_scope:google.maps.addressvalidation.v1.Verdict)
  private static final com.google.maps.addressvalidation.v1.Verdict DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.addressvalidation.v1.Verdict();
  }

  public static com.google.maps.addressvalidation.v1.Verdict getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Verdict> PARSER =
      new com.google.protobuf.AbstractParser<Verdict>() {
        @java.lang.Override
        public Verdict parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Verdict> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Verdict> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.addressvalidation.v1.Verdict getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
