/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/addressvalidation/v1/address_validation_service.proto

package com.google.maps.addressvalidation.v1;

public interface VerdictOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.maps.addressvalidation.v1.Verdict)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The granularity of the **input** address. This is the result of parsing the
   * input address and does not give any validation signals. For validation
   * signals, refer to `validation_granularity` below.
   *
   * For example, if the input address includes a specific apartment number,
   * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
   * the apartment number in the databases or the apartment number is invalid,
   * the `validation_granularity` will likely be `PREMISE` or below.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
   *
   * @return The enum numeric value on the wire for inputGranularity.
   */
  int getInputGranularityValue();
  /**
   *
   *
   * <pre>
   * The granularity of the **input** address. This is the result of parsing the
   * input address and does not give any validation signals. For validation
   * signals, refer to `validation_granularity` below.
   *
   * For example, if the input address includes a specific apartment number,
   * then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
   * the apartment number in the databases or the apartment number is invalid,
   * the `validation_granularity` will likely be `PREMISE` or below.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity input_granularity = 1;</code>
   *
   * @return The inputGranularity.
   */
  com.google.maps.addressvalidation.v1.Verdict.Granularity getInputGranularity();

  /**
   *
   *
   * <pre>
   * The granularity level that the API can fully **validate** the address to.
   * For example, an `validation_granularity` of `PREMISE` indicates all address
   * components at the level of `PREMISE` or more coarse can be validated.
   *
   * Per address component validation result can be found in
   * [google.maps.addressvalidation.v1.Address.address_components].
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;</code>
   *
   * @return The enum numeric value on the wire for validationGranularity.
   */
  int getValidationGranularityValue();
  /**
   *
   *
   * <pre>
   * The granularity level that the API can fully **validate** the address to.
   * For example, an `validation_granularity` of `PREMISE` indicates all address
   * components at the level of `PREMISE` or more coarse can be validated.
   *
   * Per address component validation result can be found in
   * [google.maps.addressvalidation.v1.Address.address_components].
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity validation_granularity = 2;</code>
   *
   * @return The validationGranularity.
   */
  com.google.maps.addressvalidation.v1.Verdict.Granularity getValidationGranularity();

  /**
   *
   *
   * <pre>
   * Information about the granularity of the
   * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
   * This can be understood as the semantic meaning of how coarse or fine the
   * geocoded location is.
   *
   * This can differ from the `validation_granularity` above occasionally. For
   * example, our database might record the existence of an apartment number but
   * do not have a precise location for the apartment within a big apartment
   * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
   * but the `geocode_granularity` will be `PREMISE`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
   *
   * @return The enum numeric value on the wire for geocodeGranularity.
   */
  int getGeocodeGranularityValue();
  /**
   *
   *
   * <pre>
   * Information about the granularity of the
   * [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
   * This can be understood as the semantic meaning of how coarse or fine the
   * geocoded location is.
   *
   * This can differ from the `validation_granularity` above occasionally. For
   * example, our database might record the existence of an apartment number but
   * do not have a precise location for the apartment within a big apartment
   * complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
   * but the `geocode_granularity` will be `PREMISE`.
   * </pre>
   *
   * <code>.google.maps.addressvalidation.v1.Verdict.Granularity geocode_granularity = 3;</code>
   *
   * @return The geocodeGranularity.
   */
  com.google.maps.addressvalidation.v1.Verdict.Granularity getGeocodeGranularity();

  /**
   *
   *
   * <pre>
   * The address is considered complete if there are no unresolved tokens, no
   * unexpected or missing address components. See
   * [`missing_component_types`][google.maps.addressvalidation.v1.Address.missing_component_types],
   * [`unresolved_tokens`][google.maps.addressvalidation.v1.Address.unresolved_tokens]
   * or
   * [`unexpected`][google.maps.addressvalidation.v1.AddressComponent.unexpected]
   * fields for more details.
   * </pre>
   *
   * <code>bool address_complete = 4;</code>
   *
   * @return The addressComplete.
   */
  boolean getAddressComplete();

  /**
   *
   *
   * <pre>
   * At least one address component cannot be categorized or validated, see
   * [google.maps.addressvalidation.v1.Address.address_components] for
   * details.
   * </pre>
   *
   * <code>bool has_unconfirmed_components = 5;</code>
   *
   * @return The hasUnconfirmedComponents.
   */
  boolean getHasUnconfirmedComponents();

  /**
   *
   *
   * <pre>
   * At least one address component was inferred (added) that wasn't in the
   * input, see
   * [google.maps.addressvalidation.v1.Address.address_components] for
   * details.
   * </pre>
   *
   * <code>bool has_inferred_components = 6;</code>
   *
   * @return The hasInferredComponents.
   */
  boolean getHasInferredComponents();

  /**
   *
   *
   * <pre>
   * At least one address component was replaced, see
   * [google.maps.addressvalidation.v1.Address.address_components] for
   * details.
   * </pre>
   *
   * <code>bool has_replaced_components = 7;</code>
   *
   * @return The hasReplacedComponents.
   */
  boolean getHasReplacedComponents();
}
