/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DeliveryVehicleName
implements ResourceName {
    private static final PathTemplate PROVIDER_VEHICLE = PathTemplate.createWithoutUrlEncoding((String)"providers/{provider}/deliveryVehicles/{vehicle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String provider;
    private final String vehicle;

    @Deprecated
    protected DeliveryVehicleName() {
        this.provider = null;
        this.vehicle = null;
    }

    private DeliveryVehicleName(Builder builder) {
        this.provider = (String)Preconditions.checkNotNull((Object)builder.getProvider());
        this.vehicle = (String)Preconditions.checkNotNull((Object)builder.getVehicle());
    }

    public String getProvider() {
        return this.provider;
    }

    public String getVehicle() {
        return this.vehicle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeliveryVehicleName of(String provider, String vehicle) {
        return DeliveryVehicleName.newBuilder().setProvider(provider).setVehicle(vehicle).build();
    }

    public static String format(String provider, String vehicle) {
        return DeliveryVehicleName.newBuilder().setProvider(provider).setVehicle(vehicle).build().toString();
    }

    public static DeliveryVehicleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROVIDER_VEHICLE.validatedMatch(formattedString, "DeliveryVehicleName.parse: formattedString not in valid format");
        return DeliveryVehicleName.of((String)matchMap.get("provider"), (String)matchMap.get("vehicle"));
    }

    public static List<DeliveryVehicleName> parseList(List<String> formattedStrings) {
        ArrayList<DeliveryVehicleName> list = new ArrayList<DeliveryVehicleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DeliveryVehicleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DeliveryVehicleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DeliveryVehicleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROVIDER_VEHICLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DeliveryVehicleName deliveryVehicleName = this;
            synchronized (deliveryVehicleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.provider != null) {
                        fieldMapBuilder.put((Object)"provider", (Object)this.provider);
                    }
                    if (this.vehicle != null) {
                        fieldMapBuilder.put((Object)"vehicle", (Object)this.vehicle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROVIDER_VEHICLE.instantiate(new String[]{"provider", this.provider, "vehicle", this.vehicle});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DeliveryVehicleName that = (DeliveryVehicleName)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.vehicle, that.vehicle);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.provider);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vehicle);
    }

    public static class Builder {
        private String provider;
        private String vehicle;

        protected Builder() {
        }

        public String getProvider() {
            return this.provider;
        }

        public String getVehicle() {
            return this.vehicle;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder setVehicle(String vehicle) {
            this.vehicle = vehicle;
            return this;
        }

        private Builder(DeliveryVehicleName deliveryVehicleName) {
            this.provider = deliveryVehicleName.provider;
            this.vehicle = deliveryVehicleName.vehicle;
        }

        public DeliveryVehicleName build() {
            return new DeliveryVehicleName(this);
        }
    }
}

