/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProviderName
implements ResourceName {
    private static final PathTemplate PROVIDER = PathTemplate.createWithoutUrlEncoding((String)"providers/{provider}");
    private volatile Map<String, String> fieldValuesMap;
    private final String provider;

    @Deprecated
    protected ProviderName() {
        this.provider = null;
    }

    private ProviderName(Builder builder) {
        this.provider = (String)Preconditions.checkNotNull((Object)builder.getProvider());
    }

    public String getProvider() {
        return this.provider;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProviderName of(String provider) {
        return ProviderName.newBuilder().setProvider(provider).build();
    }

    public static String format(String provider) {
        return ProviderName.newBuilder().setProvider(provider).build().toString();
    }

    public static ProviderName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROVIDER.validatedMatch(formattedString, "ProviderName.parse: formattedString not in valid format");
        return ProviderName.of((String)matchMap.get("provider"));
    }

    public static List<ProviderName> parseList(List<String> formattedStrings) {
        ArrayList<ProviderName> list = new ArrayList<ProviderName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProviderName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProviderName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProviderName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROVIDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProviderName providerName = this;
            synchronized (providerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.provider != null) {
                        fieldMapBuilder.put((Object)"provider", (Object)this.provider);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROVIDER.instantiate(new String[]{"provider", this.provider});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProviderName that = (ProviderName)o;
            return Objects.equals(this.provider, that.provider);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.provider);
    }

    public static class Builder {
        private String provider;

        protected Builder() {
        }

        public String getProvider() {
            return this.provider;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        private Builder(ProviderName providerName) {
            this.provider = providerName.provider;
        }

        public ProviderName build() {
            return new ProviderName(this);
        }
    }
}

