/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.fleetengine.delivery.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskTrackingInfoName
implements ResourceName {
    private static final PathTemplate PROVIDER_TRACKING = PathTemplate.createWithoutUrlEncoding((String)"providers/{provider}/taskTrackingInfo/{tracking}");
    private volatile Map<String, String> fieldValuesMap;
    private final String provider;
    private final String tracking;

    @Deprecated
    protected TaskTrackingInfoName() {
        this.provider = null;
        this.tracking = null;
    }

    private TaskTrackingInfoName(Builder builder) {
        this.provider = (String)Preconditions.checkNotNull((Object)builder.getProvider());
        this.tracking = (String)Preconditions.checkNotNull((Object)builder.getTracking());
    }

    public String getProvider() {
        return this.provider;
    }

    public String getTracking() {
        return this.tracking;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TaskTrackingInfoName of(String provider, String tracking) {
        return TaskTrackingInfoName.newBuilder().setProvider(provider).setTracking(tracking).build();
    }

    public static String format(String provider, String tracking) {
        return TaskTrackingInfoName.newBuilder().setProvider(provider).setTracking(tracking).build().toString();
    }

    public static TaskTrackingInfoName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROVIDER_TRACKING.validatedMatch(formattedString, "TaskTrackingInfoName.parse: formattedString not in valid format");
        return TaskTrackingInfoName.of((String)matchMap.get("provider"), (String)matchMap.get("tracking"));
    }

    public static List<TaskTrackingInfoName> parseList(List<String> formattedStrings) {
        ArrayList<TaskTrackingInfoName> list = new ArrayList<TaskTrackingInfoName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaskTrackingInfoName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaskTrackingInfoName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaskTrackingInfoName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROVIDER_TRACKING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaskTrackingInfoName taskTrackingInfoName = this;
            synchronized (taskTrackingInfoName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.provider != null) {
                        fieldMapBuilder.put((Object)"provider", (Object)this.provider);
                    }
                    if (this.tracking != null) {
                        fieldMapBuilder.put((Object)"tracking", (Object)this.tracking);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROVIDER_TRACKING.instantiate(new String[]{"provider", this.provider, "tracking", this.tracking});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TaskTrackingInfoName that = (TaskTrackingInfoName)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.tracking, that.tracking);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.provider);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tracking);
    }

    public static class Builder {
        private String provider;
        private String tracking;

        protected Builder() {
        }

        public String getProvider() {
            return this.provider;
        }

        public String getTracking() {
            return this.tracking;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder setTracking(String tracking) {
            this.tracking = tracking;
            return this;
        }

        private Builder(TaskTrackingInfoName taskTrackingInfoName) {
            this.provider = taskTrackingInfoName.provider;
            this.tracking = taskTrackingInfoName.tracking;
        }

        public TaskTrackingInfoName build() {
            return new TaskTrackingInfoName(this);
        }
    }
}

