/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/routes_service.proto

package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * ComputeRouteMatrix request message
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.ComputeRouteMatrixRequest}
 */
public final class ComputeRouteMatrixRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.ComputeRouteMatrixRequest)
    ComputeRouteMatrixRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ComputeRouteMatrixRequest.newBuilder() to construct.
  private ComputeRouteMatrixRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeRouteMatrixRequest() {
    origins_ = java.util.Collections.emptyList();
    destinations_ = java.util.Collections.emptyList();
    travelMode_ = 0;
    routingPreference_ = 0;
    languageCode_ = "";
    regionCode_ = "";
    extraComputations_ = java.util.Collections.emptyList();
    trafficModel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeRouteMatrixRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RoutesServiceProto
        .internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RoutesServiceProto
        .internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.ComputeRouteMatrixRequest.class,
            com.google.maps.routing.v2.ComputeRouteMatrixRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Extra computations to perform while completing the request.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation}
   */
  public enum ExtraComputation implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used. Requests containing this value will fail.
     * </pre>
     *
     * <code>EXTRA_COMPUTATION_UNSPECIFIED = 0;</code>
     */
    EXTRA_COMPUTATION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Toll information for the matrix element(s).
     * </pre>
     *
     * <code>TOLLS = 1;</code>
     */
    TOLLS(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used. Requests containing this value will fail.
     * </pre>
     *
     * <code>EXTRA_COMPUTATION_UNSPECIFIED = 0;</code>
     */
    public static final int EXTRA_COMPUTATION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Toll information for the matrix element(s).
     * </pre>
     *
     * <code>TOLLS = 1;</code>
     */
    public static final int TOLLS_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExtraComputation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExtraComputation forNumber(int value) {
      switch (value) {
        case 0:
          return EXTRA_COMPUTATION_UNSPECIFIED;
        case 1:
          return TOLLS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExtraComputation> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExtraComputation>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ExtraComputation>() {
              public ExtraComputation findValueByNumber(int number) {
                return ExtraComputation.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.ComputeRouteMatrixRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ExtraComputation[] VALUES = values();

    public static ExtraComputation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExtraComputation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation)
  }

  public static final int ORIGINS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.RouteMatrixOrigin> origins_;
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The number of elements (origins × destinations) must be no greater than
   * 625 in any case.
   * * The number of elements (origins × destinations) must be no greater than
   * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The number of waypoints (origins + destinations) specified as `place_id`
   * must be no greater than 50.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.RouteMatrixOrigin> getOriginsList() {
    return origins_;
  }
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The number of elements (origins × destinations) must be no greater than
   * 625 in any case.
   * * The number of elements (origins × destinations) must be no greater than
   * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The number of waypoints (origins + destinations) specified as `place_id`
   * must be no greater than 50.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.RouteMatrixOriginOrBuilder>
      getOriginsOrBuilderList() {
    return origins_;
  }
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The number of elements (origins × destinations) must be no greater than
   * 625 in any case.
   * * The number of elements (origins × destinations) must be no greater than
   * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The number of waypoints (origins + destinations) specified as `place_id`
   * must be no greater than 50.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getOriginsCount() {
    return origins_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The number of elements (origins × destinations) must be no greater than
   * 625 in any case.
   * * The number of elements (origins × destinations) must be no greater than
   * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The number of waypoints (origins + destinations) specified as `place_id`
   * must be no greater than 50.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteMatrixOrigin getOrigins(int index) {
    return origins_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The number of elements (origins × destinations) must be no greater than
   * 625 in any case.
   * * The number of elements (origins × destinations) must be no greater than
   * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The number of waypoints (origins + destinations) specified as `place_id`
   * must be no greater than 50.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteMatrixOriginOrBuilder getOriginsOrBuilder(int index) {
    return origins_.get(index);
  }

  public static final int DESTINATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.RouteMatrixDestination> destinations_;
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.RouteMatrixDestination> getDestinationsList() {
    return destinations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder>
      getDestinationsOrBuilderList() {
    return destinations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getDestinationsCount() {
    return destinations_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteMatrixDestination getDestinations(int index) {
    return destinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder getDestinationsOrBuilder(
      int index) {
    return destinations_.get(index);
  }

  public static final int TRAVEL_MODE_FIELD_NUMBER = 3;
  private int travelMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Specifies the mode of transportation.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for travelMode.
   */
  @java.lang.Override
  public int getTravelModeValue() {
    return travelMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the mode of transportation.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The travelMode.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteTravelMode getTravelMode() {
    com.google.maps.routing.v2.RouteTravelMode result =
        com.google.maps.routing.v2.RouteTravelMode.forNumber(travelMode_);
    return result == null ? com.google.maps.routing.v2.RouteTravelMode.UNRECOGNIZED : result;
  }

  public static final int ROUTING_PREFERENCE_FIELD_NUMBER = 4;
  private int routingPreference_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to compute the route. The server attempts to use
   * the selected routing preference to compute the route. If the routing
   * preference results in an error or an extra long latency, an error is
   * returned. You can specify this option only when the `travel_mode` is
   * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for routingPreference.
   */
  @java.lang.Override
  public int getRoutingPreferenceValue() {
    return routingPreference_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to compute the route. The server attempts to use
   * the selected routing preference to compute the route. If the routing
   * preference results in an error or an extra long latency, an error is
   * returned. You can specify this option only when the `travel_mode` is
   * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The routingPreference.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RoutingPreference getRoutingPreference() {
    com.google.maps.routing.v2.RoutingPreference result =
        com.google.maps.routing.v2.RoutingPreference.forNumber(routingPreference_);
    return result == null ? com.google.maps.routing.v2.RoutingPreference.UNRECOGNIZED : result;
  }

  public static final int DEPARTURE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp departureTime_;
  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the departureTime field is set.
   */
  @java.lang.Override
  public boolean hasDepartureTime() {
    return departureTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The departureTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDepartureTime() {
    return departureTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : departureTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder() {
    return departureTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : departureTime_;
  }

  public static final int ARRIVAL_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp arrivalTime_;
  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either departure_time or arrival_time, but not
   * both.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the arrivalTime field is set.
   */
  @java.lang.Override
  public boolean hasArrivalTime() {
    return arrivalTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either departure_time or arrival_time, but not
   * both.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The arrivalTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getArrivalTime() {
    return arrivalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : arrivalTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either departure_time or arrival_time, but not
   * both.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder() {
    return arrivalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : arrivalTime_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see
   * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
   * [Language Support](https://developers.google.com/maps/faq#languagesupport)
   * for the list of supported languages. When you don't provide this value, the
   * display language is inferred from the location of the first origin.
   * </pre>
   *
   * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see
   * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
   * [Language Support](https://developers.google.com/maps/faq#languagesupport)
   * for the list of supported languages. When you don't provide this value, the
   * display language is inferred from the location of the first origin.
   * </pre>
   *
   * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_CODE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object regionCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The region code, specified as a ccTLD ("top-level domain")
   * two-character value. For more information see
   * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
   * </pre>
   *
   * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The regionCode.
   */
  @java.lang.Override
  public java.lang.String getRegionCode() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regionCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The region code, specified as a ccTLD ("top-level domain")
   * two-character value. For more information see
   * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
   * </pre>
   *
   * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for regionCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionCodeBytes() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      regionCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTRA_COMPUTATIONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> extraComputations_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>
      extraComputations_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>() {
            public com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation convert(
                java.lang.Integer from) {
              com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation result =
                  com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation.forNumber(
                      from);
              return result == null
                  ? com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the extraComputations.
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>
      getExtraComputationsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>(
        extraComputations_, extraComputations_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of extraComputations.
   */
  @java.lang.Override
  public int getExtraComputationsCount() {
    return extraComputations_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The extraComputations at the given index.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation getExtraComputations(
      int index) {
    return extraComputations_converter_.convert(extraComputations_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for extraComputations.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getExtraComputationsValueList() {
    return extraComputations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of extraComputations at the given index.
   */
  @java.lang.Override
  public int getExtraComputationsValue(int index) {
    return extraComputations_.get(index);
  }

  private int extraComputationsMemoizedSerializedSize;

  public static final int TRAFFIC_MODEL_FIELD_NUMBER = 10;
  private int trafficModel_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Specifies the assumptions to use when calculating time in
   * traffic. This setting affects the value returned in the duration field in
   * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
   * contains the predicted time in traffic based on historical averages.
   * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
   * `TRAFFIC_AWARE_OPTIMAL` and
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
   * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
   * specified.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for trafficModel.
   */
  @java.lang.Override
  public int getTrafficModelValue() {
    return trafficModel_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies the assumptions to use when calculating time in
   * traffic. This setting affects the value returned in the duration field in
   * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
   * contains the predicted time in traffic based on historical averages.
   * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
   * `TRAFFIC_AWARE_OPTIMAL` and
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
   * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
   * specified.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The trafficModel.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TrafficModel getTrafficModel() {
    com.google.maps.routing.v2.TrafficModel result =
        com.google.maps.routing.v2.TrafficModel.forNumber(trafficModel_);
    return result == null ? com.google.maps.routing.v2.TrafficModel.UNRECOGNIZED : result;
  }

  public static final int TRANSIT_PREFERENCES_FIELD_NUMBER = 12;
  private com.google.maps.routing.v2.TransitPreferences transitPreferences_;
  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the transitPreferences field is set.
   */
  @java.lang.Override
  public boolean hasTransitPreferences() {
    return transitPreferences_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transitPreferences.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferences getTransitPreferences() {
    return transitPreferences_ == null
        ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
        : transitPreferences_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
    return transitPreferences_ == null
        ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
        : transitPreferences_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < origins_.size(); i++) {
      output.writeMessage(1, origins_.get(i));
    }
    for (int i = 0; i < destinations_.size(); i++) {
      output.writeMessage(2, destinations_.get(i));
    }
    if (travelMode_
        != com.google.maps.routing.v2.RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, travelMode_);
    }
    if (routingPreference_
        != com.google.maps.routing.v2.RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, routingPreference_);
    }
    if (departureTime_ != null) {
      output.writeMessage(5, getDepartureTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, languageCode_);
    }
    if (getExtraComputationsList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(extraComputationsMemoizedSerializedSize);
    }
    for (int i = 0; i < extraComputations_.size(); i++) {
      output.writeEnumNoTag(extraComputations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, regionCode_);
    }
    if (trafficModel_
        != com.google.maps.routing.v2.TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, trafficModel_);
    }
    if (arrivalTime_ != null) {
      output.writeMessage(11, getArrivalTime());
    }
    if (transitPreferences_ != null) {
      output.writeMessage(12, getTransitPreferences());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < origins_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, origins_.get(i));
    }
    for (int i = 0; i < destinations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, destinations_.get(i));
    }
    if (travelMode_
        != com.google.maps.routing.v2.RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, travelMode_);
    }
    if (routingPreference_
        != com.google.maps.routing.v2.RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, routingPreference_);
    }
    if (departureTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDepartureTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, languageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < extraComputations_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(extraComputations_.get(i));
      }
      size += dataSize;
      if (!getExtraComputationsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      extraComputationsMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, regionCode_);
    }
    if (trafficModel_
        != com.google.maps.routing.v2.TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, trafficModel_);
    }
    if (arrivalTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getArrivalTime());
    }
    if (transitPreferences_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getTransitPreferences());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.ComputeRouteMatrixRequest)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.ComputeRouteMatrixRequest other =
        (com.google.maps.routing.v2.ComputeRouteMatrixRequest) obj;

    if (!getOriginsList().equals(other.getOriginsList())) return false;
    if (!getDestinationsList().equals(other.getDestinationsList())) return false;
    if (travelMode_ != other.travelMode_) return false;
    if (routingPreference_ != other.routingPreference_) return false;
    if (hasDepartureTime() != other.hasDepartureTime()) return false;
    if (hasDepartureTime()) {
      if (!getDepartureTime().equals(other.getDepartureTime())) return false;
    }
    if (hasArrivalTime() != other.hasArrivalTime()) return false;
    if (hasArrivalTime()) {
      if (!getArrivalTime().equals(other.getArrivalTime())) return false;
    }
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getRegionCode().equals(other.getRegionCode())) return false;
    if (!extraComputations_.equals(other.extraComputations_)) return false;
    if (trafficModel_ != other.trafficModel_) return false;
    if (hasTransitPreferences() != other.hasTransitPreferences()) return false;
    if (hasTransitPreferences()) {
      if (!getTransitPreferences().equals(other.getTransitPreferences())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getOriginsCount() > 0) {
      hash = (37 * hash) + ORIGINS_FIELD_NUMBER;
      hash = (53 * hash) + getOriginsList().hashCode();
    }
    if (getDestinationsCount() > 0) {
      hash = (37 * hash) + DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationsList().hashCode();
    }
    hash = (37 * hash) + TRAVEL_MODE_FIELD_NUMBER;
    hash = (53 * hash) + travelMode_;
    hash = (37 * hash) + ROUTING_PREFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + routingPreference_;
    if (hasDepartureTime()) {
      hash = (37 * hash) + DEPARTURE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDepartureTime().hashCode();
    }
    if (hasArrivalTime()) {
      hash = (37 * hash) + ARRIVAL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getArrivalTime().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getRegionCode().hashCode();
    if (getExtraComputationsCount() > 0) {
      hash = (37 * hash) + EXTRA_COMPUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + extraComputations_.hashCode();
    }
    hash = (37 * hash) + TRAFFIC_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + trafficModel_;
    if (hasTransitPreferences()) {
      hash = (37 * hash) + TRANSIT_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getTransitPreferences().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.ComputeRouteMatrixRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * ComputeRouteMatrix request message
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.ComputeRouteMatrixRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.ComputeRouteMatrixRequest)
      com.google.maps.routing.v2.ComputeRouteMatrixRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.ComputeRouteMatrixRequest.class,
              com.google.maps.routing.v2.ComputeRouteMatrixRequest.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.ComputeRouteMatrixRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (originsBuilder_ == null) {
        origins_ = java.util.Collections.emptyList();
      } else {
        origins_ = null;
        originsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (destinationsBuilder_ == null) {
        destinations_ = java.util.Collections.emptyList();
      } else {
        destinations_ = null;
        destinationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      travelMode_ = 0;
      routingPreference_ = 0;
      departureTime_ = null;
      if (departureTimeBuilder_ != null) {
        departureTimeBuilder_.dispose();
        departureTimeBuilder_ = null;
      }
      arrivalTime_ = null;
      if (arrivalTimeBuilder_ != null) {
        arrivalTimeBuilder_.dispose();
        arrivalTimeBuilder_ = null;
      }
      languageCode_ = "";
      regionCode_ = "";
      extraComputations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      trafficModel_ = 0;
      transitPreferences_ = null;
      if (transitPreferencesBuilder_ != null) {
        transitPreferencesBuilder_.dispose();
        transitPreferencesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRouteMatrixRequest_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRouteMatrixRequest getDefaultInstanceForType() {
      return com.google.maps.routing.v2.ComputeRouteMatrixRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRouteMatrixRequest build() {
      com.google.maps.routing.v2.ComputeRouteMatrixRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRouteMatrixRequest buildPartial() {
      com.google.maps.routing.v2.ComputeRouteMatrixRequest result =
          new com.google.maps.routing.v2.ComputeRouteMatrixRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.maps.routing.v2.ComputeRouteMatrixRequest result) {
      if (originsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          origins_ = java.util.Collections.unmodifiableList(origins_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.origins_ = origins_;
      } else {
        result.origins_ = originsBuilder_.build();
      }
      if (destinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          destinations_ = java.util.Collections.unmodifiableList(destinations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.destinations_ = destinations_;
      } else {
        result.destinations_ = destinationsBuilder_.build();
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        extraComputations_ = java.util.Collections.unmodifiableList(extraComputations_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.extraComputations_ = extraComputations_;
    }

    private void buildPartial0(com.google.maps.routing.v2.ComputeRouteMatrixRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.travelMode_ = travelMode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.routingPreference_ = routingPreference_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.departureTime_ =
            departureTimeBuilder_ == null ? departureTime_ : departureTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.arrivalTime_ =
            arrivalTimeBuilder_ == null ? arrivalTime_ : arrivalTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.regionCode_ = regionCode_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.trafficModel_ = trafficModel_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.transitPreferences_ =
            transitPreferencesBuilder_ == null
                ? transitPreferences_
                : transitPreferencesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.ComputeRouteMatrixRequest) {
        return mergeFrom((com.google.maps.routing.v2.ComputeRouteMatrixRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.ComputeRouteMatrixRequest other) {
      if (other == com.google.maps.routing.v2.ComputeRouteMatrixRequest.getDefaultInstance())
        return this;
      if (originsBuilder_ == null) {
        if (!other.origins_.isEmpty()) {
          if (origins_.isEmpty()) {
            origins_ = other.origins_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureOriginsIsMutable();
            origins_.addAll(other.origins_);
          }
          onChanged();
        }
      } else {
        if (!other.origins_.isEmpty()) {
          if (originsBuilder_.isEmpty()) {
            originsBuilder_.dispose();
            originsBuilder_ = null;
            origins_ = other.origins_;
            bitField0_ = (bitField0_ & ~0x00000001);
            originsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOriginsFieldBuilder()
                    : null;
          } else {
            originsBuilder_.addAllMessages(other.origins_);
          }
        }
      }
      if (destinationsBuilder_ == null) {
        if (!other.destinations_.isEmpty()) {
          if (destinations_.isEmpty()) {
            destinations_ = other.destinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDestinationsIsMutable();
            destinations_.addAll(other.destinations_);
          }
          onChanged();
        }
      } else {
        if (!other.destinations_.isEmpty()) {
          if (destinationsBuilder_.isEmpty()) {
            destinationsBuilder_.dispose();
            destinationsBuilder_ = null;
            destinations_ = other.destinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            destinationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDestinationsFieldBuilder()
                    : null;
          } else {
            destinationsBuilder_.addAllMessages(other.destinations_);
          }
        }
      }
      if (other.travelMode_ != 0) {
        setTravelModeValue(other.getTravelModeValue());
      }
      if (other.routingPreference_ != 0) {
        setRoutingPreferenceValue(other.getRoutingPreferenceValue());
      }
      if (other.hasDepartureTime()) {
        mergeDepartureTime(other.getDepartureTime());
      }
      if (other.hasArrivalTime()) {
        mergeArrivalTime(other.getArrivalTime());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getRegionCode().isEmpty()) {
        regionCode_ = other.regionCode_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.extraComputations_.isEmpty()) {
        if (extraComputations_.isEmpty()) {
          extraComputations_ = other.extraComputations_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureExtraComputationsIsMutable();
          extraComputations_.addAll(other.extraComputations_);
        }
        onChanged();
      }
      if (other.trafficModel_ != 0) {
        setTrafficModelValue(other.getTrafficModelValue());
      }
      if (other.hasTransitPreferences()) {
        mergeTransitPreferences(other.getTransitPreferences());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.maps.routing.v2.RouteMatrixOrigin m =
                    input.readMessage(
                        com.google.maps.routing.v2.RouteMatrixOrigin.parser(), extensionRegistry);
                if (originsBuilder_ == null) {
                  ensureOriginsIsMutable();
                  origins_.add(m);
                } else {
                  originsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.maps.routing.v2.RouteMatrixDestination m =
                    input.readMessage(
                        com.google.maps.routing.v2.RouteMatrixDestination.parser(),
                        extensionRegistry);
                if (destinationsBuilder_ == null) {
                  ensureDestinationsIsMutable();
                  destinations_.add(m);
                } else {
                  destinationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                travelMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                routingPreference_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureExtraComputationsIsMutable();
                extraComputations_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureExtraComputationsIsMutable();
                  extraComputations_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 74:
              {
                regionCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 80:
              {
                trafficModel_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getTransitPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.maps.routing.v2.RouteMatrixOrigin> origins_ =
        java.util.Collections.emptyList();

    private void ensureOriginsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        origins_ = new java.util.ArrayList<com.google.maps.routing.v2.RouteMatrixOrigin>(origins_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.RouteMatrixOrigin,
            com.google.maps.routing.v2.RouteMatrixOrigin.Builder,
            com.google.maps.routing.v2.RouteMatrixOriginOrBuilder>
        originsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.RouteMatrixOrigin> getOriginsList() {
      if (originsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(origins_);
      } else {
        return originsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getOriginsCount() {
      if (originsBuilder_ == null) {
        return origins_.size();
      } else {
        return originsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixOrigin getOrigins(int index) {
      if (originsBuilder_ == null) {
        return origins_.get(index);
      } else {
        return originsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOrigins(int index, com.google.maps.routing.v2.RouteMatrixOrigin value) {
      if (originsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginsIsMutable();
        origins_.set(index, value);
        onChanged();
      } else {
        originsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOrigins(
        int index, com.google.maps.routing.v2.RouteMatrixOrigin.Builder builderForValue) {
      if (originsBuilder_ == null) {
        ensureOriginsIsMutable();
        origins_.set(index, builderForValue.build());
        onChanged();
      } else {
        originsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOrigins(com.google.maps.routing.v2.RouteMatrixOrigin value) {
      if (originsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginsIsMutable();
        origins_.add(value);
        onChanged();
      } else {
        originsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOrigins(int index, com.google.maps.routing.v2.RouteMatrixOrigin value) {
      if (originsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOriginsIsMutable();
        origins_.add(index, value);
        onChanged();
      } else {
        originsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOrigins(
        com.google.maps.routing.v2.RouteMatrixOrigin.Builder builderForValue) {
      if (originsBuilder_ == null) {
        ensureOriginsIsMutable();
        origins_.add(builderForValue.build());
        onChanged();
      } else {
        originsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addOrigins(
        int index, com.google.maps.routing.v2.RouteMatrixOrigin.Builder builderForValue) {
      if (originsBuilder_ == null) {
        ensureOriginsIsMutable();
        origins_.add(index, builderForValue.build());
        onChanged();
      } else {
        originsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllOrigins(
        java.lang.Iterable<? extends com.google.maps.routing.v2.RouteMatrixOrigin> values) {
      if (originsBuilder_ == null) {
        ensureOriginsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, origins_);
        onChanged();
      } else {
        originsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOrigins() {
      if (originsBuilder_ == null) {
        origins_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        originsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeOrigins(int index) {
      if (originsBuilder_ == null) {
        ensureOriginsIsMutable();
        origins_.remove(index);
        onChanged();
      } else {
        originsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixOrigin.Builder getOriginsBuilder(int index) {
      return getOriginsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixOriginOrBuilder getOriginsOrBuilder(int index) {
      if (originsBuilder_ == null) {
        return origins_.get(index);
      } else {
        return originsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.RouteMatrixOriginOrBuilder>
        getOriginsOrBuilderList() {
      if (originsBuilder_ != null) {
        return originsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(origins_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixOrigin.Builder addOriginsBuilder() {
      return getOriginsFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.RouteMatrixOrigin.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixOrigin.Builder addOriginsBuilder(int index) {
      return getOriginsFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.RouteMatrixOrigin.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Array of origins, which determines the rows of the response
     * matrix. Several size restrictions apply to the cardinality of origins and
     * destinations:
     *
     * * The number of elements (origins × destinations) must be no greater than
     * 625 in any case.
     * * The number of elements (origins × destinations) must be no greater than
     * 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
     * * The number of waypoints (origins + destinations) specified as `place_id`
     * must be no greater than 50.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.RouteMatrixOrigin.Builder>
        getOriginsBuilderList() {
      return getOriginsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.RouteMatrixOrigin,
            com.google.maps.routing.v2.RouteMatrixOrigin.Builder,
            com.google.maps.routing.v2.RouteMatrixOriginOrBuilder>
        getOriginsFieldBuilder() {
      if (originsBuilder_ == null) {
        originsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.RouteMatrixOrigin,
                com.google.maps.routing.v2.RouteMatrixOrigin.Builder,
                com.google.maps.routing.v2.RouteMatrixOriginOrBuilder>(
                origins_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        origins_ = null;
      }
      return originsBuilder_;
    }

    private java.util.List<com.google.maps.routing.v2.RouteMatrixDestination> destinations_ =
        java.util.Collections.emptyList();

    private void ensureDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        destinations_ =
            new java.util.ArrayList<com.google.maps.routing.v2.RouteMatrixDestination>(
                destinations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.RouteMatrixDestination,
            com.google.maps.routing.v2.RouteMatrixDestination.Builder,
            com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder>
        destinationsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.RouteMatrixDestination> getDestinationsList() {
      if (destinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(destinations_);
      } else {
        return destinationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getDestinationsCount() {
      if (destinationsBuilder_ == null) {
        return destinations_.size();
      } else {
        return destinationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixDestination getDestinations(int index) {
      if (destinationsBuilder_ == null) {
        return destinations_.get(index);
      } else {
        return destinationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestinations(
        int index, com.google.maps.routing.v2.RouteMatrixDestination value) {
      if (destinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDestinationsIsMutable();
        destinations_.set(index, value);
        onChanged();
      } else {
        destinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestinations(
        int index, com.google.maps.routing.v2.RouteMatrixDestination.Builder builderForValue) {
      if (destinationsBuilder_ == null) {
        ensureDestinationsIsMutable();
        destinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        destinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDestinations(com.google.maps.routing.v2.RouteMatrixDestination value) {
      if (destinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDestinationsIsMutable();
        destinations_.add(value);
        onChanged();
      } else {
        destinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDestinations(
        int index, com.google.maps.routing.v2.RouteMatrixDestination value) {
      if (destinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDestinationsIsMutable();
        destinations_.add(index, value);
        onChanged();
      } else {
        destinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDestinations(
        com.google.maps.routing.v2.RouteMatrixDestination.Builder builderForValue) {
      if (destinationsBuilder_ == null) {
        ensureDestinationsIsMutable();
        destinations_.add(builderForValue.build());
        onChanged();
      } else {
        destinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDestinations(
        int index, com.google.maps.routing.v2.RouteMatrixDestination.Builder builderForValue) {
      if (destinationsBuilder_ == null) {
        ensureDestinationsIsMutable();
        destinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        destinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllDestinations(
        java.lang.Iterable<? extends com.google.maps.routing.v2.RouteMatrixDestination> values) {
      if (destinationsBuilder_ == null) {
        ensureDestinationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destinations_);
        onChanged();
      } else {
        destinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestinations() {
      if (destinationsBuilder_ == null) {
        destinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        destinationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeDestinations(int index) {
      if (destinationsBuilder_ == null) {
        ensureDestinationsIsMutable();
        destinations_.remove(index);
        onChanged();
      } else {
        destinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixDestination.Builder getDestinationsBuilder(
        int index) {
      return getDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder getDestinationsOrBuilder(
        int index) {
      if (destinationsBuilder_ == null) {
        return destinations_.get(index);
      } else {
        return destinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder>
        getDestinationsOrBuilderList() {
      if (destinationsBuilder_ != null) {
        return destinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(destinations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixDestination.Builder addDestinationsBuilder() {
      return getDestinationsFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.RouteMatrixDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.RouteMatrixDestination.Builder addDestinationsBuilder(
        int index) {
      return getDestinationsFieldBuilder()
          .addBuilder(
              index, com.google.maps.routing.v2.RouteMatrixDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Array of destinations, which determines the columns of the
     * response matrix.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.RouteMatrixDestination.Builder>
        getDestinationsBuilderList() {
      return getDestinationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.RouteMatrixDestination,
            com.google.maps.routing.v2.RouteMatrixDestination.Builder,
            com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder>
        getDestinationsFieldBuilder() {
      if (destinationsBuilder_ == null) {
        destinationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.RouteMatrixDestination,
                com.google.maps.routing.v2.RouteMatrixDestination.Builder,
                com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder>(
                destinations_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        destinations_ = null;
      }
      return destinationsBuilder_;
    }

    private int travelMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for travelMode.
     */
    @java.lang.Override
    public int getTravelModeValue() {
      return travelMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelModeValue(int value) {
      travelMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The travelMode.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.RouteTravelMode getTravelMode() {
      com.google.maps.routing.v2.RouteTravelMode result =
          com.google.maps.routing.v2.RouteTravelMode.forNumber(travelMode_);
      return result == null ? com.google.maps.routing.v2.RouteTravelMode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelMode(com.google.maps.routing.v2.RouteTravelMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      travelMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTravelMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      travelMode_ = 0;
      onChanged();
      return this;
    }

    private int routingPreference_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server attempts to use
     * the selected routing preference to compute the route. If the routing
     * preference results in an error or an extra long latency, an error is
     * returned. You can specify this option only when the `travel_mode` is
     * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for routingPreference.
     */
    @java.lang.Override
    public int getRoutingPreferenceValue() {
      return routingPreference_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server attempts to use
     * the selected routing preference to compute the route. If the routing
     * preference results in an error or an extra long latency, an error is
     * returned. You can specify this option only when the `travel_mode` is
     * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for routingPreference to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingPreferenceValue(int value) {
      routingPreference_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server attempts to use
     * the selected routing preference to compute the route. If the routing
     * preference results in an error or an extra long latency, an error is
     * returned. You can specify this option only when the `travel_mode` is
     * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The routingPreference.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.RoutingPreference getRoutingPreference() {
      com.google.maps.routing.v2.RoutingPreference result =
          com.google.maps.routing.v2.RoutingPreference.forNumber(routingPreference_);
      return result == null ? com.google.maps.routing.v2.RoutingPreference.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server attempts to use
     * the selected routing preference to compute the route. If the routing
     * preference results in an error or an extra long latency, an error is
     * returned. You can specify this option only when the `travel_mode` is
     * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The routingPreference to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingPreference(com.google.maps.routing.v2.RoutingPreference value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      routingPreference_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server attempts to use
     * the selected routing preference to compute the route. If the routing
     * preference results in an error or an extra long latency, an error is
     * returned. You can specify this option only when the `travel_mode` is
     * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutingPreference() {
      bitField0_ = (bitField0_ & ~0x00000008);
      routingPreference_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp departureTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        departureTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the departureTime field is set.
     */
    public boolean hasDepartureTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The departureTime.
     */
    public com.google.protobuf.Timestamp getDepartureTime() {
      if (departureTimeBuilder_ == null) {
        return departureTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : departureTime_;
      } else {
        return departureTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDepartureTime(com.google.protobuf.Timestamp value) {
      if (departureTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        departureTime_ = value;
      } else {
        departureTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDepartureTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (departureTimeBuilder_ == null) {
        departureTime_ = builderForValue.build();
      } else {
        departureTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDepartureTime(com.google.protobuf.Timestamp value) {
      if (departureTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && departureTime_ != null
            && departureTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDepartureTimeBuilder().mergeFrom(value);
        } else {
          departureTime_ = value;
        }
      } else {
        departureTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDepartureTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      departureTime_ = null;
      if (departureTimeBuilder_ != null) {
        departureTimeBuilder_.dispose();
        departureTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDepartureTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDepartureTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder() {
      if (departureTimeBuilder_ != null) {
        return departureTimeBuilder_.getMessageOrBuilder();
      } else {
        return departureTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : departureTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDepartureTimeFieldBuilder() {
      if (departureTimeBuilder_ == null) {
        departureTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDepartureTime(), getParentForChildren(), isClean());
        departureTime_ = null;
      }
      return departureTimeBuilder_;
    }

    private com.google.protobuf.Timestamp arrivalTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        arrivalTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the arrivalTime field is set.
     */
    public boolean hasArrivalTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The arrivalTime.
     */
    public com.google.protobuf.Timestamp getArrivalTime() {
      if (arrivalTimeBuilder_ == null) {
        return arrivalTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : arrivalTime_;
      } else {
        return arrivalTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setArrivalTime(com.google.protobuf.Timestamp value) {
      if (arrivalTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        arrivalTime_ = value;
      } else {
        arrivalTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setArrivalTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (arrivalTimeBuilder_ == null) {
        arrivalTime_ = builderForValue.build();
      } else {
        arrivalTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeArrivalTime(com.google.protobuf.Timestamp value) {
      if (arrivalTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && arrivalTime_ != null
            && arrivalTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getArrivalTimeBuilder().mergeFrom(value);
        } else {
          arrivalTime_ = value;
        }
      } else {
        arrivalTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearArrivalTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      arrivalTime_ = null;
      if (arrivalTimeBuilder_ != null) {
        arrivalTimeBuilder_.dispose();
        arrivalTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getArrivalTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getArrivalTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder() {
      if (arrivalTimeBuilder_ != null) {
        return arrivalTimeBuilder_.getMessageOrBuilder();
      } else {
        return arrivalTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : arrivalTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either departure_time or arrival_time, but not
     * both.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getArrivalTimeFieldBuilder() {
      if (arrivalTimeBuilder_ == null) {
        arrivalTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getArrivalTime(), getParentForChildren(), isClean());
        arrivalTime_ = null;
      }
      return arrivalTimeBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
     * [Language Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the first origin.
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
     * [Language Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the first origin.
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
     * [Language Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the first origin.
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
     * [Language Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the first origin.
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see
     * http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
     * [Language Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the first origin.
     * </pre>
     *
     * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object regionCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see
     * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
     * </pre>
     *
     * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The regionCode.
     */
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see
     * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
     * </pre>
     *
     * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for regionCode.
     */
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see
     * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
     * </pre>
     *
     * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      regionCode_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see
     * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
     * </pre>
     *
     * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegionCode() {
      regionCode_ = getDefaultInstance().getRegionCode();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see
     * https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains
     * </pre>
     *
     * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      regionCode_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> extraComputations_ =
        java.util.Collections.emptyList();

    private void ensureExtraComputationsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        extraComputations_ = new java.util.ArrayList<java.lang.Integer>(extraComputations_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the extraComputations.
     */
    public java.util.List<com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>
        getExtraComputationsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>(
          extraComputations_, extraComputations_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of extraComputations.
     */
    public int getExtraComputationsCount() {
      return extraComputations_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The extraComputations at the given index.
     */
    public com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation
        getExtraComputations(int index) {
      return extraComputations_converter_.convert(extraComputations_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The extraComputations to set.
     * @return This builder for chaining.
     */
    public Builder setExtraComputations(
        int index, com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraComputationsIsMutable();
      extraComputations_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addExtraComputations(
        com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraComputationsIsMutable();
      extraComputations_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraComputations(
        java.lang.Iterable<
                ? extends com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>
            values) {
      ensureExtraComputationsIsMutable();
      for (com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation value : values) {
        extraComputations_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExtraComputations() {
      extraComputations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for extraComputations.
     */
    public java.util.List<java.lang.Integer> getExtraComputationsValueList() {
      return java.util.Collections.unmodifiableList(extraComputations_);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of extraComputations at the given index.
     */
    public int getExtraComputationsValue(int index) {
      return extraComputations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for extraComputations to set.
     * @return This builder for chaining.
     */
    public Builder setExtraComputationsValue(int index, int value) {
      ensureExtraComputationsIsMutable();
      extraComputations_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addExtraComputationsValue(int value) {
      ensureExtraComputationsIsMutable();
      extraComputations_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraComputationsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureExtraComputationsIsMutable();
      for (int value : values) {
        extraComputations_.add(value);
      }
      onChanged();
      return this;
    }

    private int trafficModel_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
     * contains the predicted time in traffic based on historical averages.
     * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for trafficModel.
     */
    @java.lang.Override
    public int getTrafficModelValue() {
      return trafficModel_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
     * contains the predicted time in traffic based on historical averages.
     * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for trafficModel to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficModelValue(int value) {
      trafficModel_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
     * contains the predicted time in traffic based on historical averages.
     * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The trafficModel.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TrafficModel getTrafficModel() {
      com.google.maps.routing.v2.TrafficModel result =
          com.google.maps.routing.v2.TrafficModel.forNumber(trafficModel_);
      return result == null ? com.google.maps.routing.v2.TrafficModel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
     * contains the predicted time in traffic based on historical averages.
     * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The trafficModel to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficModel(com.google.maps.routing.v2.TrafficModel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      trafficModel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
     * contains the predicted time in traffic based on historical averages.
     * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrafficModel() {
      bitField0_ = (bitField0_ & ~0x00000200);
      trafficModel_ = 0;
      onChanged();
      return this;
    }

    private com.google.maps.routing.v2.TransitPreferences transitPreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitPreferences,
            com.google.maps.routing.v2.TransitPreferences.Builder,
            com.google.maps.routing.v2.TransitPreferencesOrBuilder>
        transitPreferencesBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the transitPreferences field is set.
     */
    public boolean hasTransitPreferences() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transitPreferences.
     */
    public com.google.maps.routing.v2.TransitPreferences getTransitPreferences() {
      if (transitPreferencesBuilder_ == null) {
        return transitPreferences_ == null
            ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
            : transitPreferences_;
      } else {
        return transitPreferencesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransitPreferences(com.google.maps.routing.v2.TransitPreferences value) {
      if (transitPreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transitPreferences_ = value;
      } else {
        transitPreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransitPreferences(
        com.google.maps.routing.v2.TransitPreferences.Builder builderForValue) {
      if (transitPreferencesBuilder_ == null) {
        transitPreferences_ = builderForValue.build();
      } else {
        transitPreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTransitPreferences(com.google.maps.routing.v2.TransitPreferences value) {
      if (transitPreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && transitPreferences_ != null
            && transitPreferences_
                != com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()) {
          getTransitPreferencesBuilder().mergeFrom(value);
        } else {
          transitPreferences_ = value;
        }
      } else {
        transitPreferencesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTransitPreferences() {
      bitField0_ = (bitField0_ & ~0x00000400);
      transitPreferences_ = null;
      if (transitPreferencesBuilder_ != null) {
        transitPreferencesBuilder_.dispose();
        transitPreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.TransitPreferences.Builder getTransitPreferencesBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getTransitPreferencesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
      if (transitPreferencesBuilder_ != null) {
        return transitPreferencesBuilder_.getMessageOrBuilder();
      } else {
        return transitPreferences_ == null
            ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
            : transitPreferences_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitPreferences,
            com.google.maps.routing.v2.TransitPreferences.Builder,
            com.google.maps.routing.v2.TransitPreferencesOrBuilder>
        getTransitPreferencesFieldBuilder() {
      if (transitPreferencesBuilder_ == null) {
        transitPreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.TransitPreferences,
                com.google.maps.routing.v2.TransitPreferences.Builder,
                com.google.maps.routing.v2.TransitPreferencesOrBuilder>(
                getTransitPreferences(), getParentForChildren(), isClean());
        transitPreferences_ = null;
      }
      return transitPreferencesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.ComputeRouteMatrixRequest)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.ComputeRouteMatrixRequest)
  private static final com.google.maps.routing.v2.ComputeRouteMatrixRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.ComputeRouteMatrixRequest();
  }

  public static com.google.maps.routing.v2.ComputeRouteMatrixRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeRouteMatrixRequest> PARSER =
      new com.google.protobuf.AbstractParser<ComputeRouteMatrixRequest>() {
        @java.lang.Override
        public ComputeRouteMatrixRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeRouteMatrixRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeRouteMatrixRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.ComputeRouteMatrixRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
