/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/polyline.proto

package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * A set of values that specify the quality of the polyline.
 * </pre>
 *
 * Protobuf enum {@code google.maps.routing.v2.PolylineQuality}
 */
public enum PolylineQuality implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * No polyline quality preference specified. Defaults to `OVERVIEW`.
   * </pre>
   *
   * <code>POLYLINE_QUALITY_UNSPECIFIED = 0;</code>
   */
  POLYLINE_QUALITY_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Specifies a high-quality polyline - which is composed using more points
   * than `OVERVIEW`, at the cost of increased response size. Use this value
   * when you need more precision.
   * </pre>
   *
   * <code>HIGH_QUALITY = 1;</code>
   */
  HIGH_QUALITY(1),
  /**
   *
   *
   * <pre>
   * Specifies an overview polyline - which is composed using a small number of
   * points. Use this value when displaying an overview of the route. Using this
   * option has a lower request latency compared to using the
   * `HIGH_QUALITY` option.
   * </pre>
   *
   * <code>OVERVIEW = 2;</code>
   */
  OVERVIEW(2),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * No polyline quality preference specified. Defaults to `OVERVIEW`.
   * </pre>
   *
   * <code>POLYLINE_QUALITY_UNSPECIFIED = 0;</code>
   */
  public static final int POLYLINE_QUALITY_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Specifies a high-quality polyline - which is composed using more points
   * than `OVERVIEW`, at the cost of increased response size. Use this value
   * when you need more precision.
   * </pre>
   *
   * <code>HIGH_QUALITY = 1;</code>
   */
  public static final int HIGH_QUALITY_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Specifies an overview polyline - which is composed using a small number of
   * points. Use this value when displaying an overview of the route. Using this
   * option has a lower request latency compared to using the
   * `HIGH_QUALITY` option.
   * </pre>
   *
   * <code>OVERVIEW = 2;</code>
   */
  public static final int OVERVIEW_VALUE = 2;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static PolylineQuality valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static PolylineQuality forNumber(int value) {
    switch (value) {
      case 0:
        return POLYLINE_QUALITY_UNSPECIFIED;
      case 1:
        return HIGH_QUALITY;
      case 2:
        return OVERVIEW;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<PolylineQuality> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<PolylineQuality> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<PolylineQuality>() {
        public PolylineQuality findValueByNumber(int number) {
          return PolylineQuality.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.maps.routing.v2.PolylineProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final PolylineQuality[] VALUES = values();

  public static PolylineQuality valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private PolylineQuality(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.PolylineQuality)
}
