/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/route.proto

package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Contains a route, which consists of a series of connected road segments
 * that join beginning, ending, and intermediate waypoints.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.Route}
 */
public final class Route extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.Route)
    RouteOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Route.newBuilder() to construct.
  private Route(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Route() {
    routeLabels_ = java.util.Collections.emptyList();
    legs_ = java.util.Collections.emptyList();
    description_ = "";
    warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
    optimizedIntermediateWaypointIndex_ = emptyIntList();
    routeToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Route();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_Route_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_Route_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.Route.class, com.google.maps.routing.v2.Route.Builder.class);
  }

  public interface RouteLocalizedValuesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.Route.RouteLocalizedValues)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return Whether the distance field is set.
     */
    boolean hasDistance();
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return The distance.
     */
    com.google.type.LocalizedText getDistance();
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     */
    com.google.type.LocalizedTextOrBuilder getDistanceOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration taking traffic conditions into consideration, represented in
     * text form. Note: If you did not request traffic information, this value
     * will be the same value as static_duration.
     * </pre>
     *
     * <code>.google.type.LocalizedText duration = 2;</code>
     *
     * @return Whether the duration field is set.
     */
    boolean hasDuration();
    /**
     *
     *
     * <pre>
     * Duration taking traffic conditions into consideration, represented in
     * text form. Note: If you did not request traffic information, this value
     * will be the same value as static_duration.
     * </pre>
     *
     * <code>.google.type.LocalizedText duration = 2;</code>
     *
     * @return The duration.
     */
    com.google.type.LocalizedText getDuration();
    /**
     *
     *
     * <pre>
     * Duration taking traffic conditions into consideration, represented in
     * text form. Note: If you did not request traffic information, this value
     * will be the same value as static_duration.
     * </pre>
     *
     * <code>.google.type.LocalizedText duration = 2;</code>
     */
    com.google.type.LocalizedTextOrBuilder getDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return Whether the staticDuration field is set.
     */
    boolean hasStaticDuration();
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return The staticDuration.
     */
    com.google.type.LocalizedText getStaticDuration();
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     */
    com.google.type.LocalizedTextOrBuilder getStaticDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Transit fare represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText transit_fare = 4;</code>
     *
     * @return Whether the transitFare field is set.
     */
    boolean hasTransitFare();
    /**
     *
     *
     * <pre>
     * Transit fare represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText transit_fare = 4;</code>
     *
     * @return The transitFare.
     */
    com.google.type.LocalizedText getTransitFare();
    /**
     *
     *
     * <pre>
     * Transit fare represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText transit_fare = 4;</code>
     */
    com.google.type.LocalizedTextOrBuilder getTransitFareOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Text representations of certain properties.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.Route.RouteLocalizedValues}
   */
  public static final class RouteLocalizedValues extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.Route.RouteLocalizedValues)
      RouteLocalizedValuesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RouteLocalizedValues.newBuilder() to construct.
    private RouteLocalizedValues(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RouteLocalizedValues() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RouteLocalizedValues();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.Route.RouteLocalizedValues.class,
              com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder.class);
    }

    public static final int DISTANCE_FIELD_NUMBER = 1;
    private com.google.type.LocalizedText distance_;
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return Whether the distance field is set.
     */
    @java.lang.Override
    public boolean hasDistance() {
      return distance_ != null;
    }
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return The distance.
     */
    @java.lang.Override
    public com.google.type.LocalizedText getDistance() {
      return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
    }
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     */
    @java.lang.Override
    public com.google.type.LocalizedTextOrBuilder getDistanceOrBuilder() {
      return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
    }

    public static final int DURATION_FIELD_NUMBER = 2;
    private com.google.type.LocalizedText duration_;
    /**
     *
     *
     * <pre>
     * Duration taking traffic conditions into consideration, represented in
     * text form. Note: If you did not request traffic information, this value
     * will be the same value as static_duration.
     * </pre>
     *
     * <code>.google.type.LocalizedText duration = 2;</code>
     *
     * @return Whether the duration field is set.
     */
    @java.lang.Override
    public boolean hasDuration() {
      return duration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration taking traffic conditions into consideration, represented in
     * text form. Note: If you did not request traffic information, this value
     * will be the same value as static_duration.
     * </pre>
     *
     * <code>.google.type.LocalizedText duration = 2;</code>
     *
     * @return The duration.
     */
    @java.lang.Override
    public com.google.type.LocalizedText getDuration() {
      return duration_ == null ? com.google.type.LocalizedText.getDefaultInstance() : duration_;
    }
    /**
     *
     *
     * <pre>
     * Duration taking traffic conditions into consideration, represented in
     * text form. Note: If you did not request traffic information, this value
     * will be the same value as static_duration.
     * </pre>
     *
     * <code>.google.type.LocalizedText duration = 2;</code>
     */
    @java.lang.Override
    public com.google.type.LocalizedTextOrBuilder getDurationOrBuilder() {
      return duration_ == null ? com.google.type.LocalizedText.getDefaultInstance() : duration_;
    }

    public static final int STATIC_DURATION_FIELD_NUMBER = 3;
    private com.google.type.LocalizedText staticDuration_;
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return Whether the staticDuration field is set.
     */
    @java.lang.Override
    public boolean hasStaticDuration() {
      return staticDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return The staticDuration.
     */
    @java.lang.Override
    public com.google.type.LocalizedText getStaticDuration() {
      return staticDuration_ == null
          ? com.google.type.LocalizedText.getDefaultInstance()
          : staticDuration_;
    }
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     */
    @java.lang.Override
    public com.google.type.LocalizedTextOrBuilder getStaticDurationOrBuilder() {
      return staticDuration_ == null
          ? com.google.type.LocalizedText.getDefaultInstance()
          : staticDuration_;
    }

    public static final int TRANSIT_FARE_FIELD_NUMBER = 4;
    private com.google.type.LocalizedText transitFare_;
    /**
     *
     *
     * <pre>
     * Transit fare represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText transit_fare = 4;</code>
     *
     * @return Whether the transitFare field is set.
     */
    @java.lang.Override
    public boolean hasTransitFare() {
      return transitFare_ != null;
    }
    /**
     *
     *
     * <pre>
     * Transit fare represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText transit_fare = 4;</code>
     *
     * @return The transitFare.
     */
    @java.lang.Override
    public com.google.type.LocalizedText getTransitFare() {
      return transitFare_ == null
          ? com.google.type.LocalizedText.getDefaultInstance()
          : transitFare_;
    }
    /**
     *
     *
     * <pre>
     * Transit fare represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText transit_fare = 4;</code>
     */
    @java.lang.Override
    public com.google.type.LocalizedTextOrBuilder getTransitFareOrBuilder() {
      return transitFare_ == null
          ? com.google.type.LocalizedText.getDefaultInstance()
          : transitFare_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (distance_ != null) {
        output.writeMessage(1, getDistance());
      }
      if (duration_ != null) {
        output.writeMessage(2, getDuration());
      }
      if (staticDuration_ != null) {
        output.writeMessage(3, getStaticDuration());
      }
      if (transitFare_ != null) {
        output.writeMessage(4, getTransitFare());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (distance_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDistance());
      }
      if (duration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDuration());
      }
      if (staticDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStaticDuration());
      }
      if (transitFare_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTransitFare());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.maps.routing.v2.Route.RouteLocalizedValues)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.Route.RouteLocalizedValues other =
          (com.google.maps.routing.v2.Route.RouteLocalizedValues) obj;

      if (hasDistance() != other.hasDistance()) return false;
      if (hasDistance()) {
        if (!getDistance().equals(other.getDistance())) return false;
      }
      if (hasDuration() != other.hasDuration()) return false;
      if (hasDuration()) {
        if (!getDuration().equals(other.getDuration())) return false;
      }
      if (hasStaticDuration() != other.hasStaticDuration()) return false;
      if (hasStaticDuration()) {
        if (!getStaticDuration().equals(other.getStaticDuration())) return false;
      }
      if (hasTransitFare() != other.hasTransitFare()) return false;
      if (hasTransitFare()) {
        if (!getTransitFare().equals(other.getTransitFare())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDistance()) {
        hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getDistance().hashCode();
      }
      if (hasDuration()) {
        hash = (37 * hash) + DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getDuration().hashCode();
      }
      if (hasStaticDuration()) {
        hash = (37 * hash) + STATIC_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getStaticDuration().hashCode();
      }
      if (hasTransitFare()) {
        hash = (37 * hash) + TRANSIT_FARE_FIELD_NUMBER;
        hash = (53 * hash) + getTransitFare().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.Route.RouteLocalizedValues prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Text representations of certain properties.
     * </pre>
     *
     * Protobuf type {@code google.maps.routing.v2.Route.RouteLocalizedValues}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.Route.RouteLocalizedValues)
        com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.Route.RouteLocalizedValues.class,
                com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder.class);
      }

      // Construct using com.google.maps.routing.v2.Route.RouteLocalizedValues.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        distance_ = null;
        if (distanceBuilder_ != null) {
          distanceBuilder_.dispose();
          distanceBuilder_ = null;
        }
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        staticDuration_ = null;
        if (staticDurationBuilder_ != null) {
          staticDurationBuilder_.dispose();
          staticDurationBuilder_ = null;
        }
        transitFare_ = null;
        if (transitFareBuilder_ != null) {
          transitFareBuilder_.dispose();
          transitFareBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_Route_RouteLocalizedValues_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.Route.RouteLocalizedValues getDefaultInstanceForType() {
        return com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.Route.RouteLocalizedValues build() {
        com.google.maps.routing.v2.Route.RouteLocalizedValues result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.Route.RouteLocalizedValues buildPartial() {
        com.google.maps.routing.v2.Route.RouteLocalizedValues result =
            new com.google.maps.routing.v2.Route.RouteLocalizedValues(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.maps.routing.v2.Route.RouteLocalizedValues result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.distance_ = distanceBuilder_ == null ? distance_ : distanceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.staticDuration_ =
              staticDurationBuilder_ == null ? staticDuration_ : staticDurationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.transitFare_ =
              transitFareBuilder_ == null ? transitFare_ : transitFareBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.maps.routing.v2.Route.RouteLocalizedValues) {
          return mergeFrom((com.google.maps.routing.v2.Route.RouteLocalizedValues) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.maps.routing.v2.Route.RouteLocalizedValues other) {
        if (other == com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance())
          return this;
        if (other.hasDistance()) {
          mergeDistance(other.getDistance());
        }
        if (other.hasDuration()) {
          mergeDuration(other.getDuration());
        }
        if (other.hasStaticDuration()) {
          mergeStaticDuration(other.getStaticDuration());
        }
        if (other.hasTransitFare()) {
          mergeTransitFare(other.getTransitFare());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDistanceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getStaticDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getTransitFareFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.type.LocalizedText distance_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          distanceBuilder_;
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       *
       * @return Whether the distance field is set.
       */
      public boolean hasDistance() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       *
       * @return The distance.
       */
      public com.google.type.LocalizedText getDistance() {
        if (distanceBuilder_ == null) {
          return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
        } else {
          return distanceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder setDistance(com.google.type.LocalizedText value) {
        if (distanceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          distance_ = value;
        } else {
          distanceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder setDistance(com.google.type.LocalizedText.Builder builderForValue) {
        if (distanceBuilder_ == null) {
          distance_ = builderForValue.build();
        } else {
          distanceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder mergeDistance(com.google.type.LocalizedText value) {
        if (distanceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && distance_ != null
              && distance_ != com.google.type.LocalizedText.getDefaultInstance()) {
            getDistanceBuilder().mergeFrom(value);
          } else {
            distance_ = value;
          }
        } else {
          distanceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000001);
        distance_ = null;
        if (distanceBuilder_ != null) {
          distanceBuilder_.dispose();
          distanceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public com.google.type.LocalizedText.Builder getDistanceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDistanceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public com.google.type.LocalizedTextOrBuilder getDistanceOrBuilder() {
        if (distanceBuilder_ != null) {
          return distanceBuilder_.getMessageOrBuilder();
        } else {
          return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
        }
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          getDistanceFieldBuilder() {
        if (distanceBuilder_ == null) {
          distanceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LocalizedText,
                  com.google.type.LocalizedText.Builder,
                  com.google.type.LocalizedTextOrBuilder>(
                  getDistance(), getParentForChildren(), isClean());
          distance_ = null;
        }
        return distanceBuilder_;
      }

      private com.google.type.LocalizedText duration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          durationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       *
       * @return Whether the duration field is set.
       */
      public boolean hasDuration() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       *
       * @return The duration.
       */
      public com.google.type.LocalizedText getDuration() {
        if (durationBuilder_ == null) {
          return duration_ == null ? com.google.type.LocalizedText.getDefaultInstance() : duration_;
        } else {
          return durationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      public Builder setDuration(com.google.type.LocalizedText value) {
        if (durationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          duration_ = value;
        } else {
          durationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      public Builder setDuration(com.google.type.LocalizedText.Builder builderForValue) {
        if (durationBuilder_ == null) {
          duration_ = builderForValue.build();
        } else {
          durationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      public Builder mergeDuration(com.google.type.LocalizedText value) {
        if (durationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && duration_ != null
              && duration_ != com.google.type.LocalizedText.getDefaultInstance()) {
            getDurationBuilder().mergeFrom(value);
          } else {
            duration_ = value;
          }
        } else {
          durationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      public Builder clearDuration() {
        bitField0_ = (bitField0_ & ~0x00000002);
        duration_ = null;
        if (durationBuilder_ != null) {
          durationBuilder_.dispose();
          durationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      public com.google.type.LocalizedText.Builder getDurationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      public com.google.type.LocalizedTextOrBuilder getDurationOrBuilder() {
        if (durationBuilder_ != null) {
          return durationBuilder_.getMessageOrBuilder();
        } else {
          return duration_ == null ? com.google.type.LocalizedText.getDefaultInstance() : duration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration taking traffic conditions into consideration, represented in
       * text form. Note: If you did not request traffic information, this value
       * will be the same value as static_duration.
       * </pre>
       *
       * <code>.google.type.LocalizedText duration = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          getDurationFieldBuilder() {
        if (durationBuilder_ == null) {
          durationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LocalizedText,
                  com.google.type.LocalizedText.Builder,
                  com.google.type.LocalizedTextOrBuilder>(
                  getDuration(), getParentForChildren(), isClean());
          duration_ = null;
        }
        return durationBuilder_;
      }

      private com.google.type.LocalizedText staticDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          staticDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       *
       * @return Whether the staticDuration field is set.
       */
      public boolean hasStaticDuration() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       *
       * @return The staticDuration.
       */
      public com.google.type.LocalizedText getStaticDuration() {
        if (staticDurationBuilder_ == null) {
          return staticDuration_ == null
              ? com.google.type.LocalizedText.getDefaultInstance()
              : staticDuration_;
        } else {
          return staticDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder setStaticDuration(com.google.type.LocalizedText value) {
        if (staticDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          staticDuration_ = value;
        } else {
          staticDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder setStaticDuration(com.google.type.LocalizedText.Builder builderForValue) {
        if (staticDurationBuilder_ == null) {
          staticDuration_ = builderForValue.build();
        } else {
          staticDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder mergeStaticDuration(com.google.type.LocalizedText value) {
        if (staticDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && staticDuration_ != null
              && staticDuration_ != com.google.type.LocalizedText.getDefaultInstance()) {
            getStaticDurationBuilder().mergeFrom(value);
          } else {
            staticDuration_ = value;
          }
        } else {
          staticDurationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder clearStaticDuration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        staticDuration_ = null;
        if (staticDurationBuilder_ != null) {
          staticDurationBuilder_.dispose();
          staticDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public com.google.type.LocalizedText.Builder getStaticDurationBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStaticDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public com.google.type.LocalizedTextOrBuilder getStaticDurationOrBuilder() {
        if (staticDurationBuilder_ != null) {
          return staticDurationBuilder_.getMessageOrBuilder();
        } else {
          return staticDuration_ == null
              ? com.google.type.LocalizedText.getDefaultInstance()
              : staticDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          getStaticDurationFieldBuilder() {
        if (staticDurationBuilder_ == null) {
          staticDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LocalizedText,
                  com.google.type.LocalizedText.Builder,
                  com.google.type.LocalizedTextOrBuilder>(
                  getStaticDuration(), getParentForChildren(), isClean());
          staticDuration_ = null;
        }
        return staticDurationBuilder_;
      }

      private com.google.type.LocalizedText transitFare_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          transitFareBuilder_;
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       *
       * @return Whether the transitFare field is set.
       */
      public boolean hasTransitFare() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       *
       * @return The transitFare.
       */
      public com.google.type.LocalizedText getTransitFare() {
        if (transitFareBuilder_ == null) {
          return transitFare_ == null
              ? com.google.type.LocalizedText.getDefaultInstance()
              : transitFare_;
        } else {
          return transitFareBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      public Builder setTransitFare(com.google.type.LocalizedText value) {
        if (transitFareBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transitFare_ = value;
        } else {
          transitFareBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      public Builder setTransitFare(com.google.type.LocalizedText.Builder builderForValue) {
        if (transitFareBuilder_ == null) {
          transitFare_ = builderForValue.build();
        } else {
          transitFareBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      public Builder mergeTransitFare(com.google.type.LocalizedText value) {
        if (transitFareBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && transitFare_ != null
              && transitFare_ != com.google.type.LocalizedText.getDefaultInstance()) {
            getTransitFareBuilder().mergeFrom(value);
          } else {
            transitFare_ = value;
          }
        } else {
          transitFareBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      public Builder clearTransitFare() {
        bitField0_ = (bitField0_ & ~0x00000008);
        transitFare_ = null;
        if (transitFareBuilder_ != null) {
          transitFareBuilder_.dispose();
          transitFareBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      public com.google.type.LocalizedText.Builder getTransitFareBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTransitFareFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      public com.google.type.LocalizedTextOrBuilder getTransitFareOrBuilder() {
        if (transitFareBuilder_ != null) {
          return transitFareBuilder_.getMessageOrBuilder();
        } else {
          return transitFare_ == null
              ? com.google.type.LocalizedText.getDefaultInstance()
              : transitFare_;
        }
      }
      /**
       *
       *
       * <pre>
       * Transit fare represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText transit_fare = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          getTransitFareFieldBuilder() {
        if (transitFareBuilder_ == null) {
          transitFareBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LocalizedText,
                  com.google.type.LocalizedText.Builder,
                  com.google.type.LocalizedTextOrBuilder>(
                  getTransitFare(), getParentForChildren(), isClean());
          transitFare_ = null;
        }
        return transitFareBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.Route.RouteLocalizedValues)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.Route.RouteLocalizedValues)
    private static final com.google.maps.routing.v2.Route.RouteLocalizedValues DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.maps.routing.v2.Route.RouteLocalizedValues();
    }

    public static com.google.maps.routing.v2.Route.RouteLocalizedValues getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RouteLocalizedValues> PARSER =
        new com.google.protobuf.AbstractParser<RouteLocalizedValues>() {
          @java.lang.Override
          public RouteLocalizedValues parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RouteLocalizedValues> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RouteLocalizedValues> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.Route.RouteLocalizedValues getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ROUTE_LABELS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> routeLabels_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.maps.routing.v2.RouteLabel>
      routeLabels_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.maps.routing.v2.RouteLabel>() {
            public com.google.maps.routing.v2.RouteLabel convert(java.lang.Integer from) {
              com.google.maps.routing.v2.RouteLabel result =
                  com.google.maps.routing.v2.RouteLabel.forNumber(from);
              return result == null ? com.google.maps.routing.v2.RouteLabel.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @return A list containing the routeLabels.
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.RouteLabel> getRouteLabelsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.maps.routing.v2.RouteLabel>(
        routeLabels_, routeLabels_converter_);
  }
  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @return The count of routeLabels.
   */
  @java.lang.Override
  public int getRouteLabelsCount() {
    return routeLabels_.size();
  }
  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The routeLabels at the given index.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLabel getRouteLabels(int index) {
    return routeLabels_converter_.convert(routeLabels_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @return A list containing the enum numeric values on the wire for routeLabels.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getRouteLabelsValueList() {
    return routeLabels_;
  }
  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of routeLabels at the given index.
   */
  @java.lang.Override
  public int getRouteLabelsValue(int index) {
    return routeLabels_.get(index);
  }

  private int routeLabelsMemoizedSerializedSize;

  public static final int LEGS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.RouteLeg> legs_;
  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
   * intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.RouteLeg> getLegsList() {
    return legs_;
  }
  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
   * intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.RouteLegOrBuilder>
      getLegsOrBuilderList() {
    return legs_;
  }
  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
   * intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  @java.lang.Override
  public int getLegsCount() {
    return legs_.size();
  }
  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
   * intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLeg getLegs(int index) {
    return legs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
   * intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegOrBuilder getLegsOrBuilder(int index) {
    return legs_.get(index);
  }

  public static final int DISTANCE_METERS_FIELD_NUMBER = 2;
  private int distanceMeters_ = 0;
  /**
   *
   *
   * <pre>
   * The travel distance of the route, in meters.
   * </pre>
   *
   * <code>int32 distance_meters = 2;</code>
   *
   * @return The distanceMeters.
   */
  @java.lang.Override
  public int getDistanceMeters() {
    return distanceMeters_;
  }

  public static final int DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration duration_;
  /**
   *
   *
   * <pre>
   * The length of time needed to navigate the route. If you set the
   * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
   * `static_duration`. If you set the `routing_preference` to either
   * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
   * taking traffic conditions into account.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 3;</code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return duration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The length of time needed to navigate the route. If you set the
   * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
   * `static_duration`. If you set the `routing_preference` to either
   * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
   * taking traffic conditions into account.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 3;</code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDuration() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }
  /**
   *
   *
   * <pre>
   * The length of time needed to navigate the route. If you set the
   * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
   * `static_duration`. If you set the `routing_preference` to either
   * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
   * taking traffic conditions into account.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }

  public static final int STATIC_DURATION_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration staticDuration_;
  /**
   *
   *
   * <pre>
   * The duration of travel through the route without taking traffic
   * conditions into consideration.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 4;</code>
   *
   * @return Whether the staticDuration field is set.
   */
  @java.lang.Override
  public boolean hasStaticDuration() {
    return staticDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The duration of travel through the route without taking traffic
   * conditions into consideration.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 4;</code>
   *
   * @return The staticDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getStaticDuration() {
    return staticDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : staticDuration_;
  }
  /**
   *
   *
   * <pre>
   * The duration of travel through the route without taking traffic
   * conditions into consideration.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getStaticDurationOrBuilder() {
    return staticDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : staticDuration_;
  }

  public static final int POLYLINE_FIELD_NUMBER = 5;
  private com.google.maps.routing.v2.Polyline polyline_;
  /**
   *
   *
   * <pre>
   * The overall route polyline. This polyline is the combined polyline of
   * all `legs`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
   *
   * @return Whether the polyline field is set.
   */
  @java.lang.Override
  public boolean hasPolyline() {
    return polyline_ != null;
  }
  /**
   *
   *
   * <pre>
   * The overall route polyline. This polyline is the combined polyline of
   * all `legs`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
   *
   * @return The polyline.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Polyline getPolyline() {
    return polyline_ == null ? com.google.maps.routing.v2.Polyline.getDefaultInstance() : polyline_;
  }
  /**
   *
   *
   * <pre>
   * The overall route polyline. This polyline is the combined polyline of
   * all `legs`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineOrBuilder getPolylineOrBuilder() {
    return polyline_ == null ? com.google.maps.routing.v2.Polyline.getDefaultInstance() : polyline_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A description of the route.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of the route.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WARNINGS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList warnings_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @return A list containing the warnings.
   */
  public com.google.protobuf.ProtocolStringList getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @return The count of warnings.
   */
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  public java.lang.String getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  public com.google.protobuf.ByteString getWarningsBytes(int index) {
    return warnings_.getByteString(index);
  }

  public static final int VIEWPORT_FIELD_NUMBER = 8;
  private com.google.geo.type.Viewport viewport_;
  /**
   *
   *
   * <pre>
   * The viewport bounding box of the polyline.
   * </pre>
   *
   * <code>.google.geo.type.Viewport viewport = 8;</code>
   *
   * @return Whether the viewport field is set.
   */
  @java.lang.Override
  public boolean hasViewport() {
    return viewport_ != null;
  }
  /**
   *
   *
   * <pre>
   * The viewport bounding box of the polyline.
   * </pre>
   *
   * <code>.google.geo.type.Viewport viewport = 8;</code>
   *
   * @return The viewport.
   */
  @java.lang.Override
  public com.google.geo.type.Viewport getViewport() {
    return viewport_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : viewport_;
  }
  /**
   *
   *
   * <pre>
   * The viewport bounding box of the polyline.
   * </pre>
   *
   * <code>.google.geo.type.Viewport viewport = 8;</code>
   */
  @java.lang.Override
  public com.google.geo.type.ViewportOrBuilder getViewportOrBuilder() {
    return viewport_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : viewport_;
  }

  public static final int TRAVEL_ADVISORY_FIELD_NUMBER = 9;
  private com.google.maps.routing.v2.RouteTravelAdvisory travelAdvisory_;
  /**
   *
   *
   * <pre>
   * Additional information about the route.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
   *
   * @return Whether the travelAdvisory field is set.
   */
  @java.lang.Override
  public boolean hasTravelAdvisory() {
    return travelAdvisory_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional information about the route.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
   *
   * @return The travelAdvisory.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteTravelAdvisory getTravelAdvisory() {
    return travelAdvisory_ == null
        ? com.google.maps.routing.v2.RouteTravelAdvisory.getDefaultInstance()
        : travelAdvisory_;
  }
  /**
   *
   *
   * <pre>
   * Additional information about the route.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder getTravelAdvisoryOrBuilder() {
    return travelAdvisory_ == null
        ? com.google.maps.routing.v2.RouteTravelAdvisory.getDefaultInstance()
        : travelAdvisory_;
  }

  public static final int OPTIMIZED_INTERMEDIATE_WAYPOINT_INDEX_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.IntList optimizedIntermediateWaypointIndex_;
  /**
   *
   *
   * <pre>
   * If you set
   * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
   * to true, this field contains the optimized ordering of intermediate
   * waypoints. Otherwise, this field is empty.
   * For example, if you give an input of Origin: LA; Intermediate waypoints:
   * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
   * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
   * contains the values [2, 0, 1]. The index starts with 0 for the first
   * intermediate waypoint provided in the input.
   * </pre>
   *
   * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
   *
   * @return A list containing the optimizedIntermediateWaypointIndex.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getOptimizedIntermediateWaypointIndexList() {
    return optimizedIntermediateWaypointIndex_;
  }
  /**
   *
   *
   * <pre>
   * If you set
   * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
   * to true, this field contains the optimized ordering of intermediate
   * waypoints. Otherwise, this field is empty.
   * For example, if you give an input of Origin: LA; Intermediate waypoints:
   * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
   * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
   * contains the values [2, 0, 1]. The index starts with 0 for the first
   * intermediate waypoint provided in the input.
   * </pre>
   *
   * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
   *
   * @return The count of optimizedIntermediateWaypointIndex.
   */
  public int getOptimizedIntermediateWaypointIndexCount() {
    return optimizedIntermediateWaypointIndex_.size();
  }
  /**
   *
   *
   * <pre>
   * If you set
   * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
   * to true, this field contains the optimized ordering of intermediate
   * waypoints. Otherwise, this field is empty.
   * For example, if you give an input of Origin: LA; Intermediate waypoints:
   * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
   * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
   * contains the values [2, 0, 1]. The index starts with 0 for the first
   * intermediate waypoint provided in the input.
   * </pre>
   *
   * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The optimizedIntermediateWaypointIndex at the given index.
   */
  public int getOptimizedIntermediateWaypointIndex(int index) {
    return optimizedIntermediateWaypointIndex_.getInt(index);
  }

  private int optimizedIntermediateWaypointIndexMemoizedSerializedSize = -1;

  public static final int LOCALIZED_VALUES_FIELD_NUMBER = 11;
  private com.google.maps.routing.v2.Route.RouteLocalizedValues localizedValues_;
  /**
   *
   *
   * <pre>
   * Text representations of properties of the `Route`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
   *
   * @return Whether the localizedValues field is set.
   */
  @java.lang.Override
  public boolean hasLocalizedValues() {
    return localizedValues_ != null;
  }
  /**
   *
   *
   * <pre>
   * Text representations of properties of the `Route`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
   *
   * @return The localizedValues.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Route.RouteLocalizedValues getLocalizedValues() {
    return localizedValues_ == null
        ? com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance()
        : localizedValues_;
  }
  /**
   *
   *
   * <pre>
   * Text representations of properties of the `Route`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder
      getLocalizedValuesOrBuilder() {
    return localizedValues_ == null
        ? com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance()
        : localizedValues_;
  }

  public static final int ROUTE_TOKEN_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object routeToken_ = "";
  /**
   *
   *
   * <pre>
   * A web-safe, base64-encoded route token that can be passed to the Navigation
   * SDK, that allows the Navigation SDK to reconstruct the route during
   * navigation, and, in the event of rerouting, honor the original intention
   * when you created the route by calling ComputeRoutes. Customers should treat
   * this token as an opaque blob. It is not meant for reading or mutating.
   * NOTE: `Route.route_token` is only available for requests that have set
   * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
   * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
   * that have Via waypoints.
   * </pre>
   *
   * <code>string route_token = 12;</code>
   *
   * @return The routeToken.
   */
  @java.lang.Override
  public java.lang.String getRouteToken() {
    java.lang.Object ref = routeToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      routeToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A web-safe, base64-encoded route token that can be passed to the Navigation
   * SDK, that allows the Navigation SDK to reconstruct the route during
   * navigation, and, in the event of rerouting, honor the original intention
   * when you created the route by calling ComputeRoutes. Customers should treat
   * this token as an opaque blob. It is not meant for reading or mutating.
   * NOTE: `Route.route_token` is only available for requests that have set
   * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
   * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
   * that have Via waypoints.
   * </pre>
   *
   * <code>string route_token = 12;</code>
   *
   * @return The bytes for routeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRouteTokenBytes() {
    java.lang.Object ref = routeToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      routeToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < legs_.size(); i++) {
      output.writeMessage(1, legs_.get(i));
    }
    if (distanceMeters_ != 0) {
      output.writeInt32(2, distanceMeters_);
    }
    if (duration_ != null) {
      output.writeMessage(3, getDuration());
    }
    if (staticDuration_ != null) {
      output.writeMessage(4, getStaticDuration());
    }
    if (polyline_ != null) {
      output.writeMessage(5, getPolyline());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, warnings_.getRaw(i));
    }
    if (viewport_ != null) {
      output.writeMessage(8, getViewport());
    }
    if (travelAdvisory_ != null) {
      output.writeMessage(9, getTravelAdvisory());
    }
    if (getOptimizedIntermediateWaypointIndexList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(optimizedIntermediateWaypointIndexMemoizedSerializedSize);
    }
    for (int i = 0; i < optimizedIntermediateWaypointIndex_.size(); i++) {
      output.writeInt32NoTag(optimizedIntermediateWaypointIndex_.getInt(i));
    }
    if (localizedValues_ != null) {
      output.writeMessage(11, getLocalizedValues());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routeToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, routeToken_);
    }
    if (getRouteLabelsList().size() > 0) {
      output.writeUInt32NoTag(106);
      output.writeUInt32NoTag(routeLabelsMemoizedSerializedSize);
    }
    for (int i = 0; i < routeLabels_.size(); i++) {
      output.writeEnumNoTag(routeLabels_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < legs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, legs_.get(i));
    }
    if (distanceMeters_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, distanceMeters_);
    }
    if (duration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDuration());
    }
    if (staticDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStaticDuration());
    }
    if (polyline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPolyline());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < warnings_.size(); i++) {
        dataSize += computeStringSizeNoTag(warnings_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWarningsList().size();
    }
    if (viewport_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getViewport());
    }
    if (travelAdvisory_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTravelAdvisory());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < optimizedIntermediateWaypointIndex_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                optimizedIntermediateWaypointIndex_.getInt(i));
      }
      size += dataSize;
      if (!getOptimizedIntermediateWaypointIndexList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      optimizedIntermediateWaypointIndexMemoizedSerializedSize = dataSize;
    }
    if (localizedValues_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getLocalizedValues());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(routeToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, routeToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < routeLabels_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(routeLabels_.get(i));
      }
      size += dataSize;
      if (!getRouteLabelsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      routeLabelsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.Route)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.Route other = (com.google.maps.routing.v2.Route) obj;

    if (!routeLabels_.equals(other.routeLabels_)) return false;
    if (!getLegsList().equals(other.getLegsList())) return false;
    if (getDistanceMeters() != other.getDistanceMeters()) return false;
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (hasStaticDuration() != other.hasStaticDuration()) return false;
    if (hasStaticDuration()) {
      if (!getStaticDuration().equals(other.getStaticDuration())) return false;
    }
    if (hasPolyline() != other.hasPolyline()) return false;
    if (hasPolyline()) {
      if (!getPolyline().equals(other.getPolyline())) return false;
    }
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (hasViewport() != other.hasViewport()) return false;
    if (hasViewport()) {
      if (!getViewport().equals(other.getViewport())) return false;
    }
    if (hasTravelAdvisory() != other.hasTravelAdvisory()) return false;
    if (hasTravelAdvisory()) {
      if (!getTravelAdvisory().equals(other.getTravelAdvisory())) return false;
    }
    if (!getOptimizedIntermediateWaypointIndexList()
        .equals(other.getOptimizedIntermediateWaypointIndexList())) return false;
    if (hasLocalizedValues() != other.hasLocalizedValues()) return false;
    if (hasLocalizedValues()) {
      if (!getLocalizedValues().equals(other.getLocalizedValues())) return false;
    }
    if (!getRouteToken().equals(other.getRouteToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRouteLabelsCount() > 0) {
      hash = (37 * hash) + ROUTE_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + routeLabels_.hashCode();
    }
    if (getLegsCount() > 0) {
      hash = (37 * hash) + LEGS_FIELD_NUMBER;
      hash = (53 * hash) + getLegsList().hashCode();
    }
    hash = (37 * hash) + DISTANCE_METERS_FIELD_NUMBER;
    hash = (53 * hash) + getDistanceMeters();
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    if (hasStaticDuration()) {
      hash = (37 * hash) + STATIC_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getStaticDuration().hashCode();
    }
    if (hasPolyline()) {
      hash = (37 * hash) + POLYLINE_FIELD_NUMBER;
      hash = (53 * hash) + getPolyline().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    if (hasViewport()) {
      hash = (37 * hash) + VIEWPORT_FIELD_NUMBER;
      hash = (53 * hash) + getViewport().hashCode();
    }
    if (hasTravelAdvisory()) {
      hash = (37 * hash) + TRAVEL_ADVISORY_FIELD_NUMBER;
      hash = (53 * hash) + getTravelAdvisory().hashCode();
    }
    if (getOptimizedIntermediateWaypointIndexCount() > 0) {
      hash = (37 * hash) + OPTIMIZED_INTERMEDIATE_WAYPOINT_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getOptimizedIntermediateWaypointIndexList().hashCode();
    }
    if (hasLocalizedValues()) {
      hash = (37 * hash) + LOCALIZED_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getLocalizedValues().hashCode();
    }
    hash = (37 * hash) + ROUTE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getRouteToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.Route parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.Route parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.Route parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.Route parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.Route parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.Route parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.Route parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.Route parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.Route parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.Route parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.Route parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.Route parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.Route prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains a route, which consists of a series of connected road segments
   * that join beginning, ending, and intermediate waypoints.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.Route}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.Route)
      com.google.maps.routing.v2.RouteOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_Route_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_Route_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.Route.class,
              com.google.maps.routing.v2.Route.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.Route.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      routeLabels_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      if (legsBuilder_ == null) {
        legs_ = java.util.Collections.emptyList();
      } else {
        legs_ = null;
        legsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      distanceMeters_ = 0;
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      staticDuration_ = null;
      if (staticDurationBuilder_ != null) {
        staticDurationBuilder_.dispose();
        staticDurationBuilder_ = null;
      }
      polyline_ = null;
      if (polylineBuilder_ != null) {
        polylineBuilder_.dispose();
        polylineBuilder_ = null;
      }
      description_ = "";
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      viewport_ = null;
      if (viewportBuilder_ != null) {
        viewportBuilder_.dispose();
        viewportBuilder_ = null;
      }
      travelAdvisory_ = null;
      if (travelAdvisoryBuilder_ != null) {
        travelAdvisoryBuilder_.dispose();
        travelAdvisoryBuilder_ = null;
      }
      optimizedIntermediateWaypointIndex_ = emptyIntList();
      localizedValues_ = null;
      if (localizedValuesBuilder_ != null) {
        localizedValuesBuilder_.dispose();
        localizedValuesBuilder_ = null;
      }
      routeToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_Route_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.Route getDefaultInstanceForType() {
      return com.google.maps.routing.v2.Route.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.Route build() {
      com.google.maps.routing.v2.Route result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.Route buildPartial() {
      com.google.maps.routing.v2.Route result = new com.google.maps.routing.v2.Route(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.Route result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        routeLabels_ = java.util.Collections.unmodifiableList(routeLabels_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.routeLabels_ = routeLabels_;
      if (legsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          legs_ = java.util.Collections.unmodifiableList(legs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.legs_ = legs_;
      } else {
        result.legs_ = legsBuilder_.build();
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        optimizedIntermediateWaypointIndex_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.optimizedIntermediateWaypointIndex_ = optimizedIntermediateWaypointIndex_;
    }

    private void buildPartial0(com.google.maps.routing.v2.Route result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.distanceMeters_ = distanceMeters_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.staticDuration_ =
            staticDurationBuilder_ == null ? staticDuration_ : staticDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.polyline_ = polylineBuilder_ == null ? polyline_ : polylineBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        warnings_.makeImmutable();
        result.warnings_ = warnings_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.viewport_ = viewportBuilder_ == null ? viewport_ : viewportBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.travelAdvisory_ =
            travelAdvisoryBuilder_ == null ? travelAdvisory_ : travelAdvisoryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.localizedValues_ =
            localizedValuesBuilder_ == null ? localizedValues_ : localizedValuesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.routeToken_ = routeToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.Route) {
        return mergeFrom((com.google.maps.routing.v2.Route) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.Route other) {
      if (other == com.google.maps.routing.v2.Route.getDefaultInstance()) return this;
      if (!other.routeLabels_.isEmpty()) {
        if (routeLabels_.isEmpty()) {
          routeLabels_ = other.routeLabels_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRouteLabelsIsMutable();
          routeLabels_.addAll(other.routeLabels_);
        }
        onChanged();
      }
      if (legsBuilder_ == null) {
        if (!other.legs_.isEmpty()) {
          if (legs_.isEmpty()) {
            legs_ = other.legs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLegsIsMutable();
            legs_.addAll(other.legs_);
          }
          onChanged();
        }
      } else {
        if (!other.legs_.isEmpty()) {
          if (legsBuilder_.isEmpty()) {
            legsBuilder_.dispose();
            legsBuilder_ = null;
            legs_ = other.legs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            legsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLegsFieldBuilder()
                    : null;
          } else {
            legsBuilder_.addAllMessages(other.legs_);
          }
        }
      }
      if (other.getDistanceMeters() != 0) {
        setDistanceMeters(other.getDistanceMeters());
      }
      if (other.hasDuration()) {
        mergeDuration(other.getDuration());
      }
      if (other.hasStaticDuration()) {
        mergeStaticDuration(other.getStaticDuration());
      }
      if (other.hasPolyline()) {
        mergePolyline(other.getPolyline());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.warnings_.isEmpty()) {
        if (warnings_.isEmpty()) {
          warnings_ = other.warnings_;
          bitField0_ |= 0x00000080;
        } else {
          ensureWarningsIsMutable();
          warnings_.addAll(other.warnings_);
        }
        onChanged();
      }
      if (other.hasViewport()) {
        mergeViewport(other.getViewport());
      }
      if (other.hasTravelAdvisory()) {
        mergeTravelAdvisory(other.getTravelAdvisory());
      }
      if (!other.optimizedIntermediateWaypointIndex_.isEmpty()) {
        if (optimizedIntermediateWaypointIndex_.isEmpty()) {
          optimizedIntermediateWaypointIndex_ = other.optimizedIntermediateWaypointIndex_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureOptimizedIntermediateWaypointIndexIsMutable();
          optimizedIntermediateWaypointIndex_.addAll(other.optimizedIntermediateWaypointIndex_);
        }
        onChanged();
      }
      if (other.hasLocalizedValues()) {
        mergeLocalizedValues(other.getLocalizedValues());
      }
      if (!other.getRouteToken().isEmpty()) {
        routeToken_ = other.routeToken_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.maps.routing.v2.RouteLeg m =
                    input.readMessage(
                        com.google.maps.routing.v2.RouteLeg.parser(), extensionRegistry);
                if (legsBuilder_ == null) {
                  ensureLegsIsMutable();
                  legs_.add(m);
                } else {
                  legsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                distanceMeters_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStaticDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPolylineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWarningsIsMutable();
                warnings_.add(s);
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getViewportFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTravelAdvisoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 80:
              {
                int v = input.readInt32();
                ensureOptimizedIntermediateWaypointIndexIsMutable();
                optimizedIntermediateWaypointIndex_.addInt(v);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureOptimizedIntermediateWaypointIndexIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  optimizedIntermediateWaypointIndex_.addInt(input.readInt32());
                }
                input.popLimit(limit);
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getLocalizedValuesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                routeToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 104:
              {
                int tmpRaw = input.readEnum();
                ensureRouteLabelsIsMutable();
                routeLabels_.add(tmpRaw);
                break;
              } // case 104
            case 106:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureRouteLabelsIsMutable();
                  routeLabels_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> routeLabels_ = java.util.Collections.emptyList();

    private void ensureRouteLabelsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        routeLabels_ = new java.util.ArrayList<java.lang.Integer>(routeLabels_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @return A list containing the routeLabels.
     */
    public java.util.List<com.google.maps.routing.v2.RouteLabel> getRouteLabelsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.maps.routing.v2.RouteLabel>(
          routeLabels_, routeLabels_converter_);
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @return The count of routeLabels.
     */
    public int getRouteLabelsCount() {
      return routeLabels_.size();
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The routeLabels at the given index.
     */
    public com.google.maps.routing.v2.RouteLabel getRouteLabels(int index) {
      return routeLabels_converter_.convert(routeLabels_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The routeLabels to set.
     * @return This builder for chaining.
     */
    public Builder setRouteLabels(int index, com.google.maps.routing.v2.RouteLabel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRouteLabelsIsMutable();
      routeLabels_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param value The routeLabels to add.
     * @return This builder for chaining.
     */
    public Builder addRouteLabels(com.google.maps.routing.v2.RouteLabel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRouteLabelsIsMutable();
      routeLabels_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param values The routeLabels to add.
     * @return This builder for chaining.
     */
    public Builder addAllRouteLabels(
        java.lang.Iterable<? extends com.google.maps.routing.v2.RouteLabel> values) {
      ensureRouteLabelsIsMutable();
      for (com.google.maps.routing.v2.RouteLabel value : values) {
        routeLabels_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteLabels() {
      routeLabels_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @return A list containing the enum numeric values on the wire for routeLabels.
     */
    public java.util.List<java.lang.Integer> getRouteLabelsValueList() {
      return java.util.Collections.unmodifiableList(routeLabels_);
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of routeLabels at the given index.
     */
    public int getRouteLabelsValue(int index) {
      return routeLabels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for routeLabels to set.
     * @return This builder for chaining.
     */
    public Builder setRouteLabelsValue(int index, int value) {
      ensureRouteLabelsIsMutable();
      routeLabels_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param value The enum numeric value on the wire for routeLabels to add.
     * @return This builder for chaining.
     */
    public Builder addRouteLabelsValue(int value) {
      ensureRouteLabelsIsMutable();
      routeLabels_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for the `Route` that are useful to identify specific properties
     * of the route to compare against others.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
     *
     * @param values The enum numeric values on the wire for routeLabels to add.
     * @return This builder for chaining.
     */
    public Builder addAllRouteLabelsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureRouteLabelsIsMutable();
      for (int value : values) {
        routeLabels_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<com.google.maps.routing.v2.RouteLeg> legs_ =
        java.util.Collections.emptyList();

    private void ensureLegsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        legs_ = new java.util.ArrayList<com.google.maps.routing.v2.RouteLeg>(legs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.RouteLeg,
            com.google.maps.routing.v2.RouteLeg.Builder,
            com.google.maps.routing.v2.RouteLegOrBuilder>
        legsBuilder_;

    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public java.util.List<com.google.maps.routing.v2.RouteLeg> getLegsList() {
      if (legsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(legs_);
      } else {
        return legsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public int getLegsCount() {
      if (legsBuilder_ == null) {
        return legs_.size();
      } else {
        return legsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public com.google.maps.routing.v2.RouteLeg getLegs(int index) {
      if (legsBuilder_ == null) {
        return legs_.get(index);
      } else {
        return legsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder setLegs(int index, com.google.maps.routing.v2.RouteLeg value) {
      if (legsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLegsIsMutable();
        legs_.set(index, value);
        onChanged();
      } else {
        legsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder setLegs(int index, com.google.maps.routing.v2.RouteLeg.Builder builderForValue) {
      if (legsBuilder_ == null) {
        ensureLegsIsMutable();
        legs_.set(index, builderForValue.build());
        onChanged();
      } else {
        legsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder addLegs(com.google.maps.routing.v2.RouteLeg value) {
      if (legsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLegsIsMutable();
        legs_.add(value);
        onChanged();
      } else {
        legsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder addLegs(int index, com.google.maps.routing.v2.RouteLeg value) {
      if (legsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLegsIsMutable();
        legs_.add(index, value);
        onChanged();
      } else {
        legsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder addLegs(com.google.maps.routing.v2.RouteLeg.Builder builderForValue) {
      if (legsBuilder_ == null) {
        ensureLegsIsMutable();
        legs_.add(builderForValue.build());
        onChanged();
      } else {
        legsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder addLegs(int index, com.google.maps.routing.v2.RouteLeg.Builder builderForValue) {
      if (legsBuilder_ == null) {
        ensureLegsIsMutable();
        legs_.add(index, builderForValue.build());
        onChanged();
      } else {
        legsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder addAllLegs(
        java.lang.Iterable<? extends com.google.maps.routing.v2.RouteLeg> values) {
      if (legsBuilder_ == null) {
        ensureLegsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, legs_);
        onChanged();
      } else {
        legsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder clearLegs() {
      if (legsBuilder_ == null) {
        legs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        legsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public Builder removeLegs(int index) {
      if (legsBuilder_ == null) {
        ensureLegsIsMutable();
        legs_.remove(index);
        onChanged();
      } else {
        legsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public com.google.maps.routing.v2.RouteLeg.Builder getLegsBuilder(int index) {
      return getLegsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public com.google.maps.routing.v2.RouteLegOrBuilder getLegsOrBuilder(int index) {
      if (legsBuilder_ == null) {
        return legs_.get(index);
      } else {
        return legsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.RouteLegOrBuilder>
        getLegsOrBuilderList() {
      if (legsBuilder_ != null) {
        return legsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(legs_);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public com.google.maps.routing.v2.RouteLeg.Builder addLegsBuilder() {
      return getLegsFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.RouteLeg.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public com.google.maps.routing.v2.RouteLeg.Builder addLegsBuilder(int index) {
      return getLegsFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.RouteLeg.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of legs (path segments between waypoints) that make up the
     * route. Each leg corresponds to the trip between two non-`via`
     * [Waypoints][google.maps.routing.v2.Waypoint]. For example, a route with no
     * intermediate waypoints has only one leg. A route that includes one
     * non-`via` intermediate waypoint has two legs. A route that includes one
     * `via` intermediate waypoint has one leg. The order of the legs matches the
     * order of waypoints from `origin` to `intermediates` to `destination`.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
     */
    public java.util.List<com.google.maps.routing.v2.RouteLeg.Builder> getLegsBuilderList() {
      return getLegsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.RouteLeg,
            com.google.maps.routing.v2.RouteLeg.Builder,
            com.google.maps.routing.v2.RouteLegOrBuilder>
        getLegsFieldBuilder() {
      if (legsBuilder_ == null) {
        legsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.RouteLeg,
                com.google.maps.routing.v2.RouteLeg.Builder,
                com.google.maps.routing.v2.RouteLegOrBuilder>(
                legs_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        legs_ = null;
      }
      return legsBuilder_;
    }

    private int distanceMeters_;
    /**
     *
     *
     * <pre>
     * The travel distance of the route, in meters.
     * </pre>
     *
     * <code>int32 distance_meters = 2;</code>
     *
     * @return The distanceMeters.
     */
    @java.lang.Override
    public int getDistanceMeters() {
      return distanceMeters_;
    }
    /**
     *
     *
     * <pre>
     * The travel distance of the route, in meters.
     * </pre>
     *
     * <code>int32 distance_meters = 2;</code>
     *
     * @param value The distanceMeters to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceMeters(int value) {

      distanceMeters_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The travel distance of the route, in meters.
     * </pre>
     *
     * <code>int32 distance_meters = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistanceMeters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      distanceMeters_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration duration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        durationBuilder_;
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     *
     * @return The duration.
     */
    public com.google.protobuf.Duration getDuration() {
      if (durationBuilder_ == null) {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      } else {
        return durationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    public Builder setDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        duration_ = value;
      } else {
        durationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (durationBuilder_ == null) {
        duration_ = builderForValue.build();
      } else {
        durationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    public Builder mergeDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && duration_ != null
            && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDurationBuilder().mergeFrom(value);
        } else {
          duration_ = value;
        }
      } else {
        durationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    public Builder clearDuration() {
      bitField0_ = (bitField0_ & ~0x00000008);
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getDurationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      if (durationBuilder_ != null) {
        return durationBuilder_.getMessageOrBuilder();
      } else {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The length of time needed to navigate the route. If you set the
     * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
     * `static_duration`. If you set the `routing_preference` to either
     * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
     * taking traffic conditions into account.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDurationFieldBuilder() {
      if (durationBuilder_ == null) {
        durationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDuration(), getParentForChildren(), isClean());
        duration_ = null;
      }
      return durationBuilder_;
    }

    private com.google.protobuf.Duration staticDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        staticDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     *
     * @return Whether the staticDuration field is set.
     */
    public boolean hasStaticDuration() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     *
     * @return The staticDuration.
     */
    public com.google.protobuf.Duration getStaticDuration() {
      if (staticDurationBuilder_ == null) {
        return staticDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : staticDuration_;
      } else {
        return staticDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    public Builder setStaticDuration(com.google.protobuf.Duration value) {
      if (staticDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        staticDuration_ = value;
      } else {
        staticDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    public Builder setStaticDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (staticDurationBuilder_ == null) {
        staticDuration_ = builderForValue.build();
      } else {
        staticDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    public Builder mergeStaticDuration(com.google.protobuf.Duration value) {
      if (staticDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && staticDuration_ != null
            && staticDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getStaticDurationBuilder().mergeFrom(value);
        } else {
          staticDuration_ = value;
        }
      } else {
        staticDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    public Builder clearStaticDuration() {
      bitField0_ = (bitField0_ & ~0x00000010);
      staticDuration_ = null;
      if (staticDurationBuilder_ != null) {
        staticDurationBuilder_.dispose();
        staticDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getStaticDurationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getStaticDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getStaticDurationOrBuilder() {
      if (staticDurationBuilder_ != null) {
        return staticDurationBuilder_.getMessageOrBuilder();
      } else {
        return staticDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : staticDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through the route without taking traffic
     * conditions into consideration.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getStaticDurationFieldBuilder() {
      if (staticDurationBuilder_ == null) {
        staticDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getStaticDuration(), getParentForChildren(), isClean());
        staticDuration_ = null;
      }
      return staticDurationBuilder_;
    }

    private com.google.maps.routing.v2.Polyline polyline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Polyline,
            com.google.maps.routing.v2.Polyline.Builder,
            com.google.maps.routing.v2.PolylineOrBuilder>
        polylineBuilder_;
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     *
     * @return Whether the polyline field is set.
     */
    public boolean hasPolyline() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     *
     * @return The polyline.
     */
    public com.google.maps.routing.v2.Polyline getPolyline() {
      if (polylineBuilder_ == null) {
        return polyline_ == null
            ? com.google.maps.routing.v2.Polyline.getDefaultInstance()
            : polyline_;
      } else {
        return polylineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    public Builder setPolyline(com.google.maps.routing.v2.Polyline value) {
      if (polylineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        polyline_ = value;
      } else {
        polylineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    public Builder setPolyline(com.google.maps.routing.v2.Polyline.Builder builderForValue) {
      if (polylineBuilder_ == null) {
        polyline_ = builderForValue.build();
      } else {
        polylineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    public Builder mergePolyline(com.google.maps.routing.v2.Polyline value) {
      if (polylineBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && polyline_ != null
            && polyline_ != com.google.maps.routing.v2.Polyline.getDefaultInstance()) {
          getPolylineBuilder().mergeFrom(value);
        } else {
          polyline_ = value;
        }
      } else {
        polylineBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    public Builder clearPolyline() {
      bitField0_ = (bitField0_ & ~0x00000020);
      polyline_ = null;
      if (polylineBuilder_ != null) {
        polylineBuilder_.dispose();
        polylineBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    public com.google.maps.routing.v2.Polyline.Builder getPolylineBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPolylineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    public com.google.maps.routing.v2.PolylineOrBuilder getPolylineOrBuilder() {
      if (polylineBuilder_ != null) {
        return polylineBuilder_.getMessageOrBuilder();
      } else {
        return polyline_ == null
            ? com.google.maps.routing.v2.Polyline.getDefaultInstance()
            : polyline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The overall route polyline. This polyline is the combined polyline of
     * all `legs`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Polyline,
            com.google.maps.routing.v2.Polyline.Builder,
            com.google.maps.routing.v2.PolylineOrBuilder>
        getPolylineFieldBuilder() {
      if (polylineBuilder_ == null) {
        polylineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Polyline,
                com.google.maps.routing.v2.Polyline.Builder,
                com.google.maps.routing.v2.PolylineOrBuilder>(
                getPolyline(), getParentForChildren(), isClean());
        polyline_ = null;
      }
      return polylineBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of the route.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the route.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the route.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the route.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the route.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList warnings_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWarningsIsMutable() {
      if (!warnings_.isModifiable()) {
        warnings_ = new com.google.protobuf.LazyStringArrayList(warnings_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @return A list containing the warnings.
     */
    public com.google.protobuf.ProtocolStringList getWarningsList() {
      warnings_.makeImmutable();
      return warnings_;
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @return The count of warnings.
     */
    public int getWarningsCount() {
      return warnings_.size();
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    public java.lang.String getWarnings(int index) {
      return warnings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    public com.google.protobuf.ByteString getWarningsBytes(int index) {
      return warnings_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The warnings to set.
     * @return This builder for chaining.
     */
    public Builder setWarnings(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @param value The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarnings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @param values The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addAllWarnings(java.lang.Iterable<java.lang.String> values) {
      ensureWarningsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWarnings() {
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of warnings to show when displaying the route.
     * </pre>
     *
     * <code>repeated string warnings = 7;</code>
     *
     * @param value The bytes of the warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarningsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWarningsIsMutable();
      warnings_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.geo.type.Viewport viewport_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.geo.type.Viewport,
            com.google.geo.type.Viewport.Builder,
            com.google.geo.type.ViewportOrBuilder>
        viewportBuilder_;
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     *
     * @return Whether the viewport field is set.
     */
    public boolean hasViewport() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     *
     * @return The viewport.
     */
    public com.google.geo.type.Viewport getViewport() {
      if (viewportBuilder_ == null) {
        return viewport_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : viewport_;
      } else {
        return viewportBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    public Builder setViewport(com.google.geo.type.Viewport value) {
      if (viewportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        viewport_ = value;
      } else {
        viewportBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    public Builder setViewport(com.google.geo.type.Viewport.Builder builderForValue) {
      if (viewportBuilder_ == null) {
        viewport_ = builderForValue.build();
      } else {
        viewportBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    public Builder mergeViewport(com.google.geo.type.Viewport value) {
      if (viewportBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && viewport_ != null
            && viewport_ != com.google.geo.type.Viewport.getDefaultInstance()) {
          getViewportBuilder().mergeFrom(value);
        } else {
          viewport_ = value;
        }
      } else {
        viewportBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    public Builder clearViewport() {
      bitField0_ = (bitField0_ & ~0x00000100);
      viewport_ = null;
      if (viewportBuilder_ != null) {
        viewportBuilder_.dispose();
        viewportBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    public com.google.geo.type.Viewport.Builder getViewportBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getViewportFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    public com.google.geo.type.ViewportOrBuilder getViewportOrBuilder() {
      if (viewportBuilder_ != null) {
        return viewportBuilder_.getMessageOrBuilder();
      } else {
        return viewport_ == null ? com.google.geo.type.Viewport.getDefaultInstance() : viewport_;
      }
    }
    /**
     *
     *
     * <pre>
     * The viewport bounding box of the polyline.
     * </pre>
     *
     * <code>.google.geo.type.Viewport viewport = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.geo.type.Viewport,
            com.google.geo.type.Viewport.Builder,
            com.google.geo.type.ViewportOrBuilder>
        getViewportFieldBuilder() {
      if (viewportBuilder_ == null) {
        viewportBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.geo.type.Viewport,
                com.google.geo.type.Viewport.Builder,
                com.google.geo.type.ViewportOrBuilder>(
                getViewport(), getParentForChildren(), isClean());
        viewport_ = null;
      }
      return viewportBuilder_;
    }

    private com.google.maps.routing.v2.RouteTravelAdvisory travelAdvisory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteTravelAdvisory,
            com.google.maps.routing.v2.RouteTravelAdvisory.Builder,
            com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder>
        travelAdvisoryBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     *
     * @return Whether the travelAdvisory field is set.
     */
    public boolean hasTravelAdvisory() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     *
     * @return The travelAdvisory.
     */
    public com.google.maps.routing.v2.RouteTravelAdvisory getTravelAdvisory() {
      if (travelAdvisoryBuilder_ == null) {
        return travelAdvisory_ == null
            ? com.google.maps.routing.v2.RouteTravelAdvisory.getDefaultInstance()
            : travelAdvisory_;
      } else {
        return travelAdvisoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    public Builder setTravelAdvisory(com.google.maps.routing.v2.RouteTravelAdvisory value) {
      if (travelAdvisoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        travelAdvisory_ = value;
      } else {
        travelAdvisoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    public Builder setTravelAdvisory(
        com.google.maps.routing.v2.RouteTravelAdvisory.Builder builderForValue) {
      if (travelAdvisoryBuilder_ == null) {
        travelAdvisory_ = builderForValue.build();
      } else {
        travelAdvisoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    public Builder mergeTravelAdvisory(com.google.maps.routing.v2.RouteTravelAdvisory value) {
      if (travelAdvisoryBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && travelAdvisory_ != null
            && travelAdvisory_
                != com.google.maps.routing.v2.RouteTravelAdvisory.getDefaultInstance()) {
          getTravelAdvisoryBuilder().mergeFrom(value);
        } else {
          travelAdvisory_ = value;
        }
      } else {
        travelAdvisoryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    public Builder clearTravelAdvisory() {
      bitField0_ = (bitField0_ & ~0x00000200);
      travelAdvisory_ = null;
      if (travelAdvisoryBuilder_ != null) {
        travelAdvisoryBuilder_.dispose();
        travelAdvisoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    public com.google.maps.routing.v2.RouteTravelAdvisory.Builder getTravelAdvisoryBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getTravelAdvisoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    public com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder getTravelAdvisoryOrBuilder() {
      if (travelAdvisoryBuilder_ != null) {
        return travelAdvisoryBuilder_.getMessageOrBuilder();
      } else {
        return travelAdvisory_ == null
            ? com.google.maps.routing.v2.RouteTravelAdvisory.getDefaultInstance()
            : travelAdvisory_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information about the route.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteTravelAdvisory,
            com.google.maps.routing.v2.RouteTravelAdvisory.Builder,
            com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder>
        getTravelAdvisoryFieldBuilder() {
      if (travelAdvisoryBuilder_ == null) {
        travelAdvisoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteTravelAdvisory,
                com.google.maps.routing.v2.RouteTravelAdvisory.Builder,
                com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder>(
                getTravelAdvisory(), getParentForChildren(), isClean());
        travelAdvisory_ = null;
      }
      return travelAdvisoryBuilder_;
    }

    private com.google.protobuf.Internal.IntList optimizedIntermediateWaypointIndex_ =
        emptyIntList();

    private void ensureOptimizedIntermediateWaypointIndexIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        optimizedIntermediateWaypointIndex_ = mutableCopy(optimizedIntermediateWaypointIndex_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @return A list containing the optimizedIntermediateWaypointIndex.
     */
    public java.util.List<java.lang.Integer> getOptimizedIntermediateWaypointIndexList() {
      return ((bitField0_ & 0x00000400) != 0)
          ? java.util.Collections.unmodifiableList(optimizedIntermediateWaypointIndex_)
          : optimizedIntermediateWaypointIndex_;
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @return The count of optimizedIntermediateWaypointIndex.
     */
    public int getOptimizedIntermediateWaypointIndexCount() {
      return optimizedIntermediateWaypointIndex_.size();
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The optimizedIntermediateWaypointIndex at the given index.
     */
    public int getOptimizedIntermediateWaypointIndex(int index) {
      return optimizedIntermediateWaypointIndex_.getInt(index);
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The optimizedIntermediateWaypointIndex to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizedIntermediateWaypointIndex(int index, int value) {

      ensureOptimizedIntermediateWaypointIndexIsMutable();
      optimizedIntermediateWaypointIndex_.setInt(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @param value The optimizedIntermediateWaypointIndex to add.
     * @return This builder for chaining.
     */
    public Builder addOptimizedIntermediateWaypointIndex(int value) {

      ensureOptimizedIntermediateWaypointIndexIsMutable();
      optimizedIntermediateWaypointIndex_.addInt(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @param values The optimizedIntermediateWaypointIndex to add.
     * @return This builder for chaining.
     */
    public Builder addAllOptimizedIntermediateWaypointIndex(
        java.lang.Iterable<? extends java.lang.Integer> values) {
      ensureOptimizedIntermediateWaypointIndexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, optimizedIntermediateWaypointIndex_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If you set
     * [optimize_waypoint_order][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
     * to true, this field contains the optimized ordering of intermediate
     * waypoints. Otherwise, this field is empty.
     * For example, if you give an input of Origin: LA; Intermediate waypoints:
     * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
     * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
     * contains the values [2, 0, 1]. The index starts with 0 for the first
     * intermediate waypoint provided in the input.
     * </pre>
     *
     * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptimizedIntermediateWaypointIndex() {
      optimizedIntermediateWaypointIndex_ = emptyIntList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    private com.google.maps.routing.v2.Route.RouteLocalizedValues localizedValues_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Route.RouteLocalizedValues,
            com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder,
            com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder>
        localizedValuesBuilder_;
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     *
     * @return Whether the localizedValues field is set.
     */
    public boolean hasLocalizedValues() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     *
     * @return The localizedValues.
     */
    public com.google.maps.routing.v2.Route.RouteLocalizedValues getLocalizedValues() {
      if (localizedValuesBuilder_ == null) {
        return localizedValues_ == null
            ? com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance()
            : localizedValues_;
      } else {
        return localizedValuesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    public Builder setLocalizedValues(com.google.maps.routing.v2.Route.RouteLocalizedValues value) {
      if (localizedValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        localizedValues_ = value;
      } else {
        localizedValuesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    public Builder setLocalizedValues(
        com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder builderForValue) {
      if (localizedValuesBuilder_ == null) {
        localizedValues_ = builderForValue.build();
      } else {
        localizedValuesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    public Builder mergeLocalizedValues(
        com.google.maps.routing.v2.Route.RouteLocalizedValues value) {
      if (localizedValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && localizedValues_ != null
            && localizedValues_
                != com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance()) {
          getLocalizedValuesBuilder().mergeFrom(value);
        } else {
          localizedValues_ = value;
        }
      } else {
        localizedValuesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    public Builder clearLocalizedValues() {
      bitField0_ = (bitField0_ & ~0x00000800);
      localizedValues_ = null;
      if (localizedValuesBuilder_ != null) {
        localizedValuesBuilder_.dispose();
        localizedValuesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    public com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder
        getLocalizedValuesBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getLocalizedValuesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    public com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder
        getLocalizedValuesOrBuilder() {
      if (localizedValuesBuilder_ != null) {
        return localizedValuesBuilder_.getMessageOrBuilder();
      } else {
        return localizedValues_ == null
            ? com.google.maps.routing.v2.Route.RouteLocalizedValues.getDefaultInstance()
            : localizedValues_;
      }
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `Route`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Route.RouteLocalizedValues,
            com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder,
            com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder>
        getLocalizedValuesFieldBuilder() {
      if (localizedValuesBuilder_ == null) {
        localizedValuesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Route.RouteLocalizedValues,
                com.google.maps.routing.v2.Route.RouteLocalizedValues.Builder,
                com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder>(
                getLocalizedValues(), getParentForChildren(), isClean());
        localizedValues_ = null;
      }
      return localizedValuesBuilder_;
    }

    private java.lang.Object routeToken_ = "";
    /**
     *
     *
     * <pre>
     * A web-safe, base64-encoded route token that can be passed to the Navigation
     * SDK, that allows the Navigation SDK to reconstruct the route during
     * navigation, and, in the event of rerouting, honor the original intention
     * when you created the route by calling ComputeRoutes. Customers should treat
     * this token as an opaque blob. It is not meant for reading or mutating.
     * NOTE: `Route.route_token` is only available for requests that have set
     * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
     * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
     * that have Via waypoints.
     * </pre>
     *
     * <code>string route_token = 12;</code>
     *
     * @return The routeToken.
     */
    public java.lang.String getRouteToken() {
      java.lang.Object ref = routeToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        routeToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A web-safe, base64-encoded route token that can be passed to the Navigation
     * SDK, that allows the Navigation SDK to reconstruct the route during
     * navigation, and, in the event of rerouting, honor the original intention
     * when you created the route by calling ComputeRoutes. Customers should treat
     * this token as an opaque blob. It is not meant for reading or mutating.
     * NOTE: `Route.route_token` is only available for requests that have set
     * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
     * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
     * that have Via waypoints.
     * </pre>
     *
     * <code>string route_token = 12;</code>
     *
     * @return The bytes for routeToken.
     */
    public com.google.protobuf.ByteString getRouteTokenBytes() {
      java.lang.Object ref = routeToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        routeToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A web-safe, base64-encoded route token that can be passed to the Navigation
     * SDK, that allows the Navigation SDK to reconstruct the route during
     * navigation, and, in the event of rerouting, honor the original intention
     * when you created the route by calling ComputeRoutes. Customers should treat
     * this token as an opaque blob. It is not meant for reading or mutating.
     * NOTE: `Route.route_token` is only available for requests that have set
     * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
     * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
     * that have Via waypoints.
     * </pre>
     *
     * <code>string route_token = 12;</code>
     *
     * @param value The routeToken to set.
     * @return This builder for chaining.
     */
    public Builder setRouteToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      routeToken_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A web-safe, base64-encoded route token that can be passed to the Navigation
     * SDK, that allows the Navigation SDK to reconstruct the route during
     * navigation, and, in the event of rerouting, honor the original intention
     * when you created the route by calling ComputeRoutes. Customers should treat
     * this token as an opaque blob. It is not meant for reading or mutating.
     * NOTE: `Route.route_token` is only available for requests that have set
     * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
     * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
     * that have Via waypoints.
     * </pre>
     *
     * <code>string route_token = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRouteToken() {
      routeToken_ = getDefaultInstance().getRouteToken();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A web-safe, base64-encoded route token that can be passed to the Navigation
     * SDK, that allows the Navigation SDK to reconstruct the route during
     * navigation, and, in the event of rerouting, honor the original intention
     * when you created the route by calling ComputeRoutes. Customers should treat
     * this token as an opaque blob. It is not meant for reading or mutating.
     * NOTE: `Route.route_token` is only available for requests that have set
     * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
     * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
     * that have Via waypoints.
     * </pre>
     *
     * <code>string route_token = 12;</code>
     *
     * @param value The bytes for routeToken to set.
     * @return This builder for chaining.
     */
    public Builder setRouteTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      routeToken_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.Route)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.Route)
  private static final com.google.maps.routing.v2.Route DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.Route();
  }

  public static com.google.maps.routing.v2.Route getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Route> PARSER =
      new com.google.protobuf.AbstractParser<Route>() {
        @java.lang.Override
        public Route parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Route> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Route> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.Route getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
