/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/speed_reading_interval.proto

package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Traffic density indicator on a contiguous segment of a polyline or path.
 * Given a path with points P_0, P_1, ... , P_N (zero-based index), the
 * SpeedReadingInterval defines an interval and describes its traffic using the
 * following categories.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.SpeedReadingInterval}
 */
public final class SpeedReadingInterval extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.SpeedReadingInterval)
    SpeedReadingIntervalOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpeedReadingInterval.newBuilder() to construct.
  private SpeedReadingInterval(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpeedReadingInterval() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpeedReadingInterval();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.SpeedReadingIntervalProto
        .internal_static_google_maps_routing_v2_SpeedReadingInterval_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.SpeedReadingIntervalProto
        .internal_static_google_maps_routing_v2_SpeedReadingInterval_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.SpeedReadingInterval.class,
            com.google.maps.routing.v2.SpeedReadingInterval.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The classification of polyline speed based on traffic data.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.SpeedReadingInterval.Speed}
   */
  public enum Speed implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>SPEED_UNSPECIFIED = 0;</code>
     */
    SPEED_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Normal speed, no slowdown is detected.
     * </pre>
     *
     * <code>NORMAL = 1;</code>
     */
    NORMAL(1),
    /**
     *
     *
     * <pre>
     * Slowdown detected, but no traffic jam formed.
     * </pre>
     *
     * <code>SLOW = 2;</code>
     */
    SLOW(2),
    /**
     *
     *
     * <pre>
     * Traffic jam detected.
     * </pre>
     *
     * <code>TRAFFIC_JAM = 3;</code>
     */
    TRAFFIC_JAM(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>SPEED_UNSPECIFIED = 0;</code>
     */
    public static final int SPEED_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Normal speed, no slowdown is detected.
     * </pre>
     *
     * <code>NORMAL = 1;</code>
     */
    public static final int NORMAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Slowdown detected, but no traffic jam formed.
     * </pre>
     *
     * <code>SLOW = 2;</code>
     */
    public static final int SLOW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Traffic jam detected.
     * </pre>
     *
     * <code>TRAFFIC_JAM = 3;</code>
     */
    public static final int TRAFFIC_JAM_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Speed valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Speed forNumber(int value) {
      switch (value) {
        case 0:
          return SPEED_UNSPECIFIED;
        case 1:
          return NORMAL;
        case 2:
          return SLOW;
        case 3:
          return TRAFFIC_JAM;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Speed> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Speed> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Speed>() {
          public Speed findValueByNumber(int number) {
            return Speed.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.SpeedReadingInterval.getDescriptor().getEnumTypes().get(0);
    }

    private static final Speed[] VALUES = values();

    public static Speed valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Speed(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.SpeedReadingInterval.Speed)
  }

  private int bitField0_;
  private int speedTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object speedType_;

  public enum SpeedTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SPEED(3),
    SPEEDTYPE_NOT_SET(0);
    private final int value;

    private SpeedTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpeedTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpeedTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return SPEED;
        case 0:
          return SPEEDTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SpeedTypeCase getSpeedTypeCase() {
    return SpeedTypeCase.forNumber(speedTypeCase_);
  }

  public static final int START_POLYLINE_POINT_INDEX_FIELD_NUMBER = 1;
  private int startPolylinePointIndex_ = 0;
  /**
   *
   *
   * <pre>
   * The starting index of this interval in the polyline.
   * </pre>
   *
   * <code>optional int32 start_polyline_point_index = 1;</code>
   *
   * @return Whether the startPolylinePointIndex field is set.
   */
  @java.lang.Override
  public boolean hasStartPolylinePointIndex() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The starting index of this interval in the polyline.
   * </pre>
   *
   * <code>optional int32 start_polyline_point_index = 1;</code>
   *
   * @return The startPolylinePointIndex.
   */
  @java.lang.Override
  public int getStartPolylinePointIndex() {
    return startPolylinePointIndex_;
  }

  public static final int END_POLYLINE_POINT_INDEX_FIELD_NUMBER = 2;
  private int endPolylinePointIndex_ = 0;
  /**
   *
   *
   * <pre>
   * The ending index of this interval in the polyline.
   * </pre>
   *
   * <code>optional int32 end_polyline_point_index = 2;</code>
   *
   * @return Whether the endPolylinePointIndex field is set.
   */
  @java.lang.Override
  public boolean hasEndPolylinePointIndex() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The ending index of this interval in the polyline.
   * </pre>
   *
   * <code>optional int32 end_polyline_point_index = 2;</code>
   *
   * @return The endPolylinePointIndex.
   */
  @java.lang.Override
  public int getEndPolylinePointIndex() {
    return endPolylinePointIndex_;
  }

  public static final int SPEED_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Traffic speed in this interval.
   * </pre>
   *
   * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
   *
   * @return Whether the speed field is set.
   */
  public boolean hasSpeed() {
    return speedTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Traffic speed in this interval.
   * </pre>
   *
   * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
   *
   * @return The enum numeric value on the wire for speed.
   */
  public int getSpeedValue() {
    if (speedTypeCase_ == 3) {
      return (java.lang.Integer) speedType_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Traffic speed in this interval.
   * </pre>
   *
   * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
   *
   * @return The speed.
   */
  public com.google.maps.routing.v2.SpeedReadingInterval.Speed getSpeed() {
    if (speedTypeCase_ == 3) {
      com.google.maps.routing.v2.SpeedReadingInterval.Speed result =
          com.google.maps.routing.v2.SpeedReadingInterval.Speed.forNumber(
              (java.lang.Integer) speedType_);
      return result == null
          ? com.google.maps.routing.v2.SpeedReadingInterval.Speed.UNRECOGNIZED
          : result;
    }
    return com.google.maps.routing.v2.SpeedReadingInterval.Speed.SPEED_UNSPECIFIED;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(1, startPolylinePointIndex_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(2, endPolylinePointIndex_);
    }
    if (speedTypeCase_ == 3) {
      output.writeEnum(3, ((java.lang.Integer) speedType_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, startPolylinePointIndex_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, endPolylinePointIndex_);
    }
    if (speedTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              3, ((java.lang.Integer) speedType_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.SpeedReadingInterval)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.SpeedReadingInterval other =
        (com.google.maps.routing.v2.SpeedReadingInterval) obj;

    if (hasStartPolylinePointIndex() != other.hasStartPolylinePointIndex()) return false;
    if (hasStartPolylinePointIndex()) {
      if (getStartPolylinePointIndex() != other.getStartPolylinePointIndex()) return false;
    }
    if (hasEndPolylinePointIndex() != other.hasEndPolylinePointIndex()) return false;
    if (hasEndPolylinePointIndex()) {
      if (getEndPolylinePointIndex() != other.getEndPolylinePointIndex()) return false;
    }
    if (!getSpeedTypeCase().equals(other.getSpeedTypeCase())) return false;
    switch (speedTypeCase_) {
      case 3:
        if (getSpeedValue() != other.getSpeedValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartPolylinePointIndex()) {
      hash = (37 * hash) + START_POLYLINE_POINT_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getStartPolylinePointIndex();
    }
    if (hasEndPolylinePointIndex()) {
      hash = (37 * hash) + END_POLYLINE_POINT_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getEndPolylinePointIndex();
    }
    switch (speedTypeCase_) {
      case 3:
        hash = (37 * hash) + SPEED_FIELD_NUMBER;
        hash = (53 * hash) + getSpeedValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.SpeedReadingInterval prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Traffic density indicator on a contiguous segment of a polyline or path.
   * Given a path with points P_0, P_1, ... , P_N (zero-based index), the
   * SpeedReadingInterval defines an interval and describes its traffic using the
   * following categories.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.SpeedReadingInterval}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.SpeedReadingInterval)
      com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.SpeedReadingIntervalProto
          .internal_static_google_maps_routing_v2_SpeedReadingInterval_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.SpeedReadingIntervalProto
          .internal_static_google_maps_routing_v2_SpeedReadingInterval_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.SpeedReadingInterval.class,
              com.google.maps.routing.v2.SpeedReadingInterval.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.SpeedReadingInterval.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startPolylinePointIndex_ = 0;
      endPolylinePointIndex_ = 0;
      speedTypeCase_ = 0;
      speedType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.SpeedReadingIntervalProto
          .internal_static_google_maps_routing_v2_SpeedReadingInterval_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.SpeedReadingInterval getDefaultInstanceForType() {
      return com.google.maps.routing.v2.SpeedReadingInterval.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.SpeedReadingInterval build() {
      com.google.maps.routing.v2.SpeedReadingInterval result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.SpeedReadingInterval buildPartial() {
      com.google.maps.routing.v2.SpeedReadingInterval result =
          new com.google.maps.routing.v2.SpeedReadingInterval(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.routing.v2.SpeedReadingInterval result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startPolylinePointIndex_ = startPolylinePointIndex_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endPolylinePointIndex_ = endPolylinePointIndex_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.maps.routing.v2.SpeedReadingInterval result) {
      result.speedTypeCase_ = speedTypeCase_;
      result.speedType_ = this.speedType_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.SpeedReadingInterval) {
        return mergeFrom((com.google.maps.routing.v2.SpeedReadingInterval) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.SpeedReadingInterval other) {
      if (other == com.google.maps.routing.v2.SpeedReadingInterval.getDefaultInstance())
        return this;
      if (other.hasStartPolylinePointIndex()) {
        setStartPolylinePointIndex(other.getStartPolylinePointIndex());
      }
      if (other.hasEndPolylinePointIndex()) {
        setEndPolylinePointIndex(other.getEndPolylinePointIndex());
      }
      switch (other.getSpeedTypeCase()) {
        case SPEED:
          {
            setSpeedValue(other.getSpeedValue());
            break;
          }
        case SPEEDTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                startPolylinePointIndex_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                endPolylinePointIndex_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                int rawValue = input.readEnum();
                speedTypeCase_ = 3;
                speedType_ = rawValue;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int speedTypeCase_ = 0;
    private java.lang.Object speedType_;

    public SpeedTypeCase getSpeedTypeCase() {
      return SpeedTypeCase.forNumber(speedTypeCase_);
    }

    public Builder clearSpeedType() {
      speedTypeCase_ = 0;
      speedType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int startPolylinePointIndex_;
    /**
     *
     *
     * <pre>
     * The starting index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 start_polyline_point_index = 1;</code>
     *
     * @return Whether the startPolylinePointIndex field is set.
     */
    @java.lang.Override
    public boolean hasStartPolylinePointIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The starting index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 start_polyline_point_index = 1;</code>
     *
     * @return The startPolylinePointIndex.
     */
    @java.lang.Override
    public int getStartPolylinePointIndex() {
      return startPolylinePointIndex_;
    }
    /**
     *
     *
     * <pre>
     * The starting index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 start_polyline_point_index = 1;</code>
     *
     * @param value The startPolylinePointIndex to set.
     * @return This builder for chaining.
     */
    public Builder setStartPolylinePointIndex(int value) {

      startPolylinePointIndex_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The starting index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 start_polyline_point_index = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartPolylinePointIndex() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startPolylinePointIndex_ = 0;
      onChanged();
      return this;
    }

    private int endPolylinePointIndex_;
    /**
     *
     *
     * <pre>
     * The ending index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 end_polyline_point_index = 2;</code>
     *
     * @return Whether the endPolylinePointIndex field is set.
     */
    @java.lang.Override
    public boolean hasEndPolylinePointIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The ending index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 end_polyline_point_index = 2;</code>
     *
     * @return The endPolylinePointIndex.
     */
    @java.lang.Override
    public int getEndPolylinePointIndex() {
      return endPolylinePointIndex_;
    }
    /**
     *
     *
     * <pre>
     * The ending index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 end_polyline_point_index = 2;</code>
     *
     * @param value The endPolylinePointIndex to set.
     * @return This builder for chaining.
     */
    public Builder setEndPolylinePointIndex(int value) {

      endPolylinePointIndex_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ending index of this interval in the polyline.
     * </pre>
     *
     * <code>optional int32 end_polyline_point_index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndPolylinePointIndex() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endPolylinePointIndex_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Traffic speed in this interval.
     * </pre>
     *
     * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
     *
     * @return Whether the speed field is set.
     */
    @java.lang.Override
    public boolean hasSpeed() {
      return speedTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Traffic speed in this interval.
     * </pre>
     *
     * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
     *
     * @return The enum numeric value on the wire for speed.
     */
    @java.lang.Override
    public int getSpeedValue() {
      if (speedTypeCase_ == 3) {
        return ((java.lang.Integer) speedType_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Traffic speed in this interval.
     * </pre>
     *
     * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
     *
     * @param value The enum numeric value on the wire for speed to set.
     * @return This builder for chaining.
     */
    public Builder setSpeedValue(int value) {
      speedTypeCase_ = 3;
      speedType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Traffic speed in this interval.
     * </pre>
     *
     * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
     *
     * @return The speed.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.SpeedReadingInterval.Speed getSpeed() {
      if (speedTypeCase_ == 3) {
        com.google.maps.routing.v2.SpeedReadingInterval.Speed result =
            com.google.maps.routing.v2.SpeedReadingInterval.Speed.forNumber(
                (java.lang.Integer) speedType_);
        return result == null
            ? com.google.maps.routing.v2.SpeedReadingInterval.Speed.UNRECOGNIZED
            : result;
      }
      return com.google.maps.routing.v2.SpeedReadingInterval.Speed.SPEED_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Traffic speed in this interval.
     * </pre>
     *
     * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
     *
     * @param value The speed to set.
     * @return This builder for chaining.
     */
    public Builder setSpeed(com.google.maps.routing.v2.SpeedReadingInterval.Speed value) {
      if (value == null) {
        throw new NullPointerException();
      }
      speedTypeCase_ = 3;
      speedType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Traffic speed in this interval.
     * </pre>
     *
     * <code>.google.maps.routing.v2.SpeedReadingInterval.Speed speed = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeed() {
      if (speedTypeCase_ == 3) {
        speedTypeCase_ = 0;
        speedType_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.SpeedReadingInterval)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.SpeedReadingInterval)
  private static final com.google.maps.routing.v2.SpeedReadingInterval DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.SpeedReadingInterval();
  }

  public static com.google.maps.routing.v2.SpeedReadingInterval getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpeedReadingInterval> PARSER =
      new com.google.protobuf.AbstractParser<SpeedReadingInterval>() {
        @java.lang.Override
        public SpeedReadingInterval parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpeedReadingInterval> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpeedReadingInterval> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.SpeedReadingInterval getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
