/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/routes_service.proto

// Protobuf Java Version: 3.25.3
package com.google.maps.routing.v2;

public interface ComputeRouteMatrixRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.ComputeRouteMatrixRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The sum of the number of origins + the number of destinations specified
   * as either `place_id` or `address` must be no greater than 50.
   * * The product of number of origins × number of destinations must be no
   * greater than 625 in any case.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if travel_mode is set to `TRANSIT`.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.maps.routing.v2.RouteMatrixOrigin> getOriginsList();
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The sum of the number of origins + the number of destinations specified
   * as either `place_id` or `address` must be no greater than 50.
   * * The product of number of origins × number of destinations must be no
   * greater than 625 in any case.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if travel_mode is set to `TRANSIT`.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.maps.routing.v2.RouteMatrixOrigin getOrigins(int index);
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The sum of the number of origins + the number of destinations specified
   * as either `place_id` or `address` must be no greater than 50.
   * * The product of number of origins × number of destinations must be no
   * greater than 625 in any case.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if travel_mode is set to `TRANSIT`.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getOriginsCount();
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The sum of the number of origins + the number of destinations specified
   * as either `place_id` or `address` must be no greater than 50.
   * * The product of number of origins × number of destinations must be no
   * greater than 625 in any case.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if travel_mode is set to `TRANSIT`.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.maps.routing.v2.RouteMatrixOriginOrBuilder>
      getOriginsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. Array of origins, which determines the rows of the response
   * matrix. Several size restrictions apply to the cardinality of origins and
   * destinations:
   *
   * * The sum of the number of origins + the number of destinations specified
   * as either `place_id` or `address` must be no greater than 50.
   * * The product of number of origins × number of destinations must be no
   * greater than 625 in any case.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if routing_preference is set to `TRAFFIC_AWARE_OPTIMAL`.
   * * The product of the number of origins × number of destinations must be no
   * greater than 100 if travel_mode is set to `TRANSIT`.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixOrigin origins = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.maps.routing.v2.RouteMatrixOriginOrBuilder getOriginsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.maps.routing.v2.RouteMatrixDestination> getDestinationsList();
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.maps.routing.v2.RouteMatrixDestination getDestinations(int index);
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getDestinationsCount();
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder>
      getDestinationsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. Array of destinations, which determines the columns of the
   * response matrix.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.RouteMatrixDestination destinations = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.maps.routing.v2.RouteMatrixDestinationOrBuilder getDestinationsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Optional. Specifies the mode of transportation.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for travelMode.
   */
  int getTravelModeValue();
  /**
   *
   *
   * <pre>
   * Optional. Specifies the mode of transportation.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteTravelMode travel_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The travelMode.
   */
  com.google.maps.routing.v2.RouteTravelMode getTravelMode();

  /**
   *
   *
   * <pre>
   * Optional. Specifies how to compute the route. The server attempts to use
   * the selected routing preference to compute the route. If the routing
   * preference results in an error or an extra long latency, an error is
   * returned. You can specify this option only when the `travel_mode` is
   * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for routingPreference.
   */
  int getRoutingPreferenceValue();
  /**
   *
   *
   * <pre>
   * Optional. Specifies how to compute the route. The server attempts to use
   * the selected routing preference to compute the route. If the routing
   * preference results in an error or an extra long latency, an error is
   * returned. You can specify this option only when the `travel_mode` is
   * `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RoutingPreference routing_preference = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The routingPreference.
   */
  com.google.maps.routing.v2.RoutingPreference getRoutingPreference();

  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the departureTime field is set.
   */
  boolean hasDepartureTime();
  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The departureTime.
   */
  com.google.protobuf.Timestamp getDepartureTime();
  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
   * not both.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the arrivalTime field is set.
   */
  boolean hasArrivalTime();
  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
   * not both.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The arrivalTime.
   */
  com.google.protobuf.Timestamp getArrivalTime();
  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
   * not both.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see [Unicode Locale
   * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
   * See [Language
   * Support](https://developers.google.com/maps/faq#languagesupport)
   * for the list of supported languages. When you don't provide this value, the
   * display language is inferred from the location of the first origin.
   * </pre>
   *
   * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see [Unicode Locale
   * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
   * See [Language
   * Support](https://developers.google.com/maps/faq#languagesupport)
   * for the list of supported languages. When you don't provide this value, the
   * display language is inferred from the location of the first origin.
   * </pre>
   *
   * <code>string language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * Optional. The region code, specified as a ccTLD ("top-level domain")
   * two-character value. For more information see [Country code top-level
   * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
   * </pre>
   *
   * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The regionCode.
   */
  java.lang.String getRegionCode();
  /**
   *
   *
   * <pre>
   * Optional. The region code, specified as a ccTLD ("top-level domain")
   * two-character value. For more information see [Country code top-level
   * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
   * </pre>
   *
   * <code>string region_code = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for regionCode.
   */
  com.google.protobuf.ByteString getRegionCodeBytes();

  /**
   *
   *
   * <pre>
   * Optional. Specifies the units of measure for the display fields.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Units units = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enum numeric value on the wire for units.
   */
  int getUnitsValue();
  /**
   *
   *
   * <pre>
   * Optional. Specifies the units of measure for the display fields.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Units units = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The units.
   */
  com.google.maps.routing.v2.Units getUnits();

  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the extraComputations.
   */
  java.util.List<com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation>
      getExtraComputationsList();
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of extraComputations.
   */
  int getExtraComputationsCount();
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The extraComputations at the given index.
   */
  com.google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation getExtraComputations(
      int index);
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for extraComputations.
   */
  java.util.List<java.lang.Integer> getExtraComputationsValueList();
  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRouteMatrixRequest.ExtraComputation extra_computations = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of extraComputations at the given index.
   */
  int getExtraComputationsValue(int index);

  /**
   *
   *
   * <pre>
   * Optional. Specifies the assumptions to use when calculating time in
   * traffic. This setting affects the value returned in the duration field in
   * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
   * contains the predicted time in traffic based on historical averages.
   * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
   * `TRAFFIC_AWARE_OPTIMAL` and
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
   * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
   * specified.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for trafficModel.
   */
  int getTrafficModelValue();
  /**
   *
   *
   * <pre>
   * Optional. Specifies the assumptions to use when calculating time in
   * traffic. This setting affects the value returned in the duration field in
   * the [RouteMatrixElement][google.maps.routing.v2.RouteMatrixElement] which
   * contains the predicted time in traffic based on historical averages.
   * [RoutingPreference][google.maps.routing.v2.RoutingPreference] to
   * `TRAFFIC_AWARE_OPTIMAL` and
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
   * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
   * specified.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TrafficModel traffic_model = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The trafficModel.
   */
  com.google.maps.routing.v2.TrafficModel getTrafficModel();

  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the transitPreferences field is set.
   */
  boolean hasTransitPreferences();
  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transitPreferences.
   */
  com.google.maps.routing.v2.TransitPreferences getTransitPreferences();
  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.maps.routing.v2.TransitPreferencesOrBuilder getTransitPreferencesOrBuilder();
}
