/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/route.proto

// Protobuf Java Version: 3.25.3
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Contains a segment of a [`RouteLeg`][google.maps.routing.v2.RouteLeg]. A
 * step corresponds to a single navigation instruction. Route legs are made up
 * of steps.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.RouteLegStep}
 */
public final class RouteLegStep extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteLegStep)
    RouteLegStepOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RouteLegStep.newBuilder() to construct.
  private RouteLegStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouteLegStep() {
    travelMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouteLegStep();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_RouteLegStep_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_RouteLegStep_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.RouteLegStep.class,
            com.google.maps.routing.v2.RouteLegStep.Builder.class);
  }

  public interface RouteLegStepLocalizedValuesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return Whether the distance field is set.
     */
    boolean hasDistance();
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return The distance.
     */
    com.google.type.LocalizedText getDistance();
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     */
    com.google.type.LocalizedTextOrBuilder getDistanceOrBuilder();

    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return Whether the staticDuration field is set.
     */
    boolean hasStaticDuration();
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return The staticDuration.
     */
    com.google.type.LocalizedText getStaticDuration();
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     */
    com.google.type.LocalizedTextOrBuilder getStaticDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Text representations of certain properties.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues}
   */
  public static final class RouteLegStepLocalizedValues
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues)
      RouteLegStepLocalizedValuesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RouteLegStepLocalizedValues.newBuilder() to construct.
    private RouteLegStepLocalizedValues(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RouteLegStepLocalizedValues() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RouteLegStepLocalizedValues();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStep_RouteLegStepLocalizedValues_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStep_RouteLegStepLocalizedValues_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.class,
              com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder.class);
    }

    private int bitField0_;
    public static final int DISTANCE_FIELD_NUMBER = 1;
    private com.google.type.LocalizedText distance_;
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return Whether the distance field is set.
     */
    @java.lang.Override
    public boolean hasDistance() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     *
     * @return The distance.
     */
    @java.lang.Override
    public com.google.type.LocalizedText getDistance() {
      return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
    }
    /**
     *
     *
     * <pre>
     * Travel distance represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText distance = 1;</code>
     */
    @java.lang.Override
    public com.google.type.LocalizedTextOrBuilder getDistanceOrBuilder() {
      return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
    }

    public static final int STATIC_DURATION_FIELD_NUMBER = 3;
    private com.google.type.LocalizedText staticDuration_;
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return Whether the staticDuration field is set.
     */
    @java.lang.Override
    public boolean hasStaticDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     *
     * @return The staticDuration.
     */
    @java.lang.Override
    public com.google.type.LocalizedText getStaticDuration() {
      return staticDuration_ == null
          ? com.google.type.LocalizedText.getDefaultInstance()
          : staticDuration_;
    }
    /**
     *
     *
     * <pre>
     * Duration without taking traffic conditions into
     * consideration, represented in text form.
     * </pre>
     *
     * <code>.google.type.LocalizedText static_duration = 3;</code>
     */
    @java.lang.Override
    public com.google.type.LocalizedTextOrBuilder getStaticDurationOrBuilder() {
      return staticDuration_ == null
          ? com.google.type.LocalizedText.getDefaultInstance()
          : staticDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getDistance());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getStaticDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDistance());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStaticDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues other =
          (com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues) obj;

      if (hasDistance() != other.hasDistance()) return false;
      if (hasDistance()) {
        if (!getDistance().equals(other.getDistance())) return false;
      }
      if (hasStaticDuration() != other.hasStaticDuration()) return false;
      if (hasStaticDuration()) {
        if (!getStaticDuration().equals(other.getStaticDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDistance()) {
        hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
        hash = (53 * hash) + getDistance().hashCode();
      }
      if (hasStaticDuration()) {
        hash = (37 * hash) + STATIC_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getStaticDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Text representations of certain properties.
     * </pre>
     *
     * Protobuf type {@code google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues)
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValuesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStep_RouteLegStepLocalizedValues_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStep_RouteLegStepLocalizedValues_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.class,
                com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder.class);
      }

      // Construct using
      // com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDistanceFieldBuilder();
          getStaticDurationFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        distance_ = null;
        if (distanceBuilder_ != null) {
          distanceBuilder_.dispose();
          distanceBuilder_ = null;
        }
        staticDuration_ = null;
        if (staticDurationBuilder_ != null) {
          staticDurationBuilder_.dispose();
          staticDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStep_RouteLegStepLocalizedValues_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
          getDefaultInstanceForType() {
        return com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues build() {
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues buildPartial() {
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues result =
            new com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.distance_ = distanceBuilder_ == null ? distance_ : distanceBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.staticDuration_ =
              staticDurationBuilder_ == null ? staticDuration_ : staticDurationBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues) {
          return mergeFrom(
              (com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues other) {
        if (other
            == com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
                .getDefaultInstance()) return this;
        if (other.hasDistance()) {
          mergeDistance(other.getDistance());
        }
        if (other.hasStaticDuration()) {
          mergeStaticDuration(other.getStaticDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDistanceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      getStaticDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.type.LocalizedText distance_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          distanceBuilder_;
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       *
       * @return Whether the distance field is set.
       */
      public boolean hasDistance() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       *
       * @return The distance.
       */
      public com.google.type.LocalizedText getDistance() {
        if (distanceBuilder_ == null) {
          return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
        } else {
          return distanceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder setDistance(com.google.type.LocalizedText value) {
        if (distanceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          distance_ = value;
        } else {
          distanceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder setDistance(com.google.type.LocalizedText.Builder builderForValue) {
        if (distanceBuilder_ == null) {
          distance_ = builderForValue.build();
        } else {
          distanceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder mergeDistance(com.google.type.LocalizedText value) {
        if (distanceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && distance_ != null
              && distance_ != com.google.type.LocalizedText.getDefaultInstance()) {
            getDistanceBuilder().mergeFrom(value);
          } else {
            distance_ = value;
          }
        } else {
          distanceBuilder_.mergeFrom(value);
        }
        if (distance_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000001);
        distance_ = null;
        if (distanceBuilder_ != null) {
          distanceBuilder_.dispose();
          distanceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public com.google.type.LocalizedText.Builder getDistanceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDistanceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      public com.google.type.LocalizedTextOrBuilder getDistanceOrBuilder() {
        if (distanceBuilder_ != null) {
          return distanceBuilder_.getMessageOrBuilder();
        } else {
          return distance_ == null ? com.google.type.LocalizedText.getDefaultInstance() : distance_;
        }
      }
      /**
       *
       *
       * <pre>
       * Travel distance represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText distance = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          getDistanceFieldBuilder() {
        if (distanceBuilder_ == null) {
          distanceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LocalizedText,
                  com.google.type.LocalizedText.Builder,
                  com.google.type.LocalizedTextOrBuilder>(
                  getDistance(), getParentForChildren(), isClean());
          distance_ = null;
        }
        return distanceBuilder_;
      }

      private com.google.type.LocalizedText staticDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          staticDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       *
       * @return Whether the staticDuration field is set.
       */
      public boolean hasStaticDuration() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       *
       * @return The staticDuration.
       */
      public com.google.type.LocalizedText getStaticDuration() {
        if (staticDurationBuilder_ == null) {
          return staticDuration_ == null
              ? com.google.type.LocalizedText.getDefaultInstance()
              : staticDuration_;
        } else {
          return staticDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder setStaticDuration(com.google.type.LocalizedText value) {
        if (staticDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          staticDuration_ = value;
        } else {
          staticDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder setStaticDuration(com.google.type.LocalizedText.Builder builderForValue) {
        if (staticDurationBuilder_ == null) {
          staticDuration_ = builderForValue.build();
        } else {
          staticDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder mergeStaticDuration(com.google.type.LocalizedText value) {
        if (staticDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && staticDuration_ != null
              && staticDuration_ != com.google.type.LocalizedText.getDefaultInstance()) {
            getStaticDurationBuilder().mergeFrom(value);
          } else {
            staticDuration_ = value;
          }
        } else {
          staticDurationBuilder_.mergeFrom(value);
        }
        if (staticDuration_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public Builder clearStaticDuration() {
        bitField0_ = (bitField0_ & ~0x00000002);
        staticDuration_ = null;
        if (staticDurationBuilder_ != null) {
          staticDurationBuilder_.dispose();
          staticDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public com.google.type.LocalizedText.Builder getStaticDurationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStaticDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      public com.google.type.LocalizedTextOrBuilder getStaticDurationOrBuilder() {
        if (staticDurationBuilder_ != null) {
          return staticDurationBuilder_.getMessageOrBuilder();
        } else {
          return staticDuration_ == null
              ? com.google.type.LocalizedText.getDefaultInstance()
              : staticDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * Duration without taking traffic conditions into
       * consideration, represented in text form.
       * </pre>
       *
       * <code>.google.type.LocalizedText static_duration = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.LocalizedText,
              com.google.type.LocalizedText.Builder,
              com.google.type.LocalizedTextOrBuilder>
          getStaticDurationFieldBuilder() {
        if (staticDurationBuilder_ == null) {
          staticDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.LocalizedText,
                  com.google.type.LocalizedText.Builder,
                  com.google.type.LocalizedTextOrBuilder>(
                  getStaticDuration(), getParentForChildren(), isClean());
          staticDuration_ = null;
        }
        return staticDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues)
    private static final com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues();
    }

    public static com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RouteLegStepLocalizedValues> PARSER =
        new com.google.protobuf.AbstractParser<RouteLegStepLocalizedValues>() {
          @java.lang.Override
          public RouteLegStepLocalizedValues parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RouteLegStepLocalizedValues> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RouteLegStepLocalizedValues> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int DISTANCE_METERS_FIELD_NUMBER = 1;
  private int distanceMeters_ = 0;
  /**
   *
   *
   * <pre>
   * The travel distance of this step, in meters. In some circumstances, this
   * field might not have a value.
   * </pre>
   *
   * <code>int32 distance_meters = 1;</code>
   *
   * @return The distanceMeters.
   */
  @java.lang.Override
  public int getDistanceMeters() {
    return distanceMeters_;
  }

  public static final int STATIC_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration staticDuration_;
  /**
   *
   *
   * <pre>
   * The duration of travel through this step without taking traffic conditions
   * into consideration. In some circumstances, this field might not have a
   * value.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 2;</code>
   *
   * @return Whether the staticDuration field is set.
   */
  @java.lang.Override
  public boolean hasStaticDuration() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The duration of travel through this step without taking traffic conditions
   * into consideration. In some circumstances, this field might not have a
   * value.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 2;</code>
   *
   * @return The staticDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getStaticDuration() {
    return staticDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : staticDuration_;
  }
  /**
   *
   *
   * <pre>
   * The duration of travel through this step without taking traffic conditions
   * into consideration. In some circumstances, this field might not have a
   * value.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getStaticDurationOrBuilder() {
    return staticDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : staticDuration_;
  }

  public static final int POLYLINE_FIELD_NUMBER = 3;
  private com.google.maps.routing.v2.Polyline polyline_;
  /**
   *
   *
   * <pre>
   * The polyline associated with this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
   *
   * @return Whether the polyline field is set.
   */
  @java.lang.Override
  public boolean hasPolyline() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The polyline associated with this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
   *
   * @return The polyline.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Polyline getPolyline() {
    return polyline_ == null ? com.google.maps.routing.v2.Polyline.getDefaultInstance() : polyline_;
  }
  /**
   *
   *
   * <pre>
   * The polyline associated with this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineOrBuilder getPolylineOrBuilder() {
    return polyline_ == null ? com.google.maps.routing.v2.Polyline.getDefaultInstance() : polyline_;
  }

  public static final int START_LOCATION_FIELD_NUMBER = 4;
  private com.google.maps.routing.v2.Location startLocation_;
  /**
   *
   *
   * <pre>
   * The start location of this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Location start_location = 4;</code>
   *
   * @return Whether the startLocation field is set.
   */
  @java.lang.Override
  public boolean hasStartLocation() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The start location of this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Location start_location = 4;</code>
   *
   * @return The startLocation.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Location getStartLocation() {
    return startLocation_ == null
        ? com.google.maps.routing.v2.Location.getDefaultInstance()
        : startLocation_;
  }
  /**
   *
   *
   * <pre>
   * The start location of this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Location start_location = 4;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.LocationOrBuilder getStartLocationOrBuilder() {
    return startLocation_ == null
        ? com.google.maps.routing.v2.Location.getDefaultInstance()
        : startLocation_;
  }

  public static final int END_LOCATION_FIELD_NUMBER = 5;
  private com.google.maps.routing.v2.Location endLocation_;
  /**
   *
   *
   * <pre>
   * The end location of this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Location end_location = 5;</code>
   *
   * @return Whether the endLocation field is set.
   */
  @java.lang.Override
  public boolean hasEndLocation() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The end location of this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Location end_location = 5;</code>
   *
   * @return The endLocation.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Location getEndLocation() {
    return endLocation_ == null
        ? com.google.maps.routing.v2.Location.getDefaultInstance()
        : endLocation_;
  }
  /**
   *
   *
   * <pre>
   * The end location of this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Location end_location = 5;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.LocationOrBuilder getEndLocationOrBuilder() {
    return endLocation_ == null
        ? com.google.maps.routing.v2.Location.getDefaultInstance()
        : endLocation_;
  }

  public static final int NAVIGATION_INSTRUCTION_FIELD_NUMBER = 6;
  private com.google.maps.routing.v2.NavigationInstruction navigationInstruction_;
  /**
   *
   *
   * <pre>
   * Navigation instructions.
   * </pre>
   *
   * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
   *
   * @return Whether the navigationInstruction field is set.
   */
  @java.lang.Override
  public boolean hasNavigationInstruction() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Navigation instructions.
   * </pre>
   *
   * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
   *
   * @return The navigationInstruction.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.NavigationInstruction getNavigationInstruction() {
    return navigationInstruction_ == null
        ? com.google.maps.routing.v2.NavigationInstruction.getDefaultInstance()
        : navigationInstruction_;
  }
  /**
   *
   *
   * <pre>
   * Navigation instructions.
   * </pre>
   *
   * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.NavigationInstructionOrBuilder
      getNavigationInstructionOrBuilder() {
    return navigationInstruction_ == null
        ? com.google.maps.routing.v2.NavigationInstruction.getDefaultInstance()
        : navigationInstruction_;
  }

  public static final int TRAVEL_ADVISORY_FIELD_NUMBER = 7;
  private com.google.maps.routing.v2.RouteLegStepTravelAdvisory travelAdvisory_;
  /**
   *
   *
   * <pre>
   * Contains the additional information that the user should be informed
   * about, such as possible traffic zone restrictions, on a leg step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
   *
   * @return Whether the travelAdvisory field is set.
   */
  @java.lang.Override
  public boolean hasTravelAdvisory() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Contains the additional information that the user should be informed
   * about, such as possible traffic zone restrictions, on a leg step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
   *
   * @return The travelAdvisory.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTravelAdvisory getTravelAdvisory() {
    return travelAdvisory_ == null
        ? com.google.maps.routing.v2.RouteLegStepTravelAdvisory.getDefaultInstance()
        : travelAdvisory_;
  }
  /**
   *
   *
   * <pre>
   * Contains the additional information that the user should be informed
   * about, such as possible traffic zone restrictions, on a leg step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTravelAdvisoryOrBuilder
      getTravelAdvisoryOrBuilder() {
    return travelAdvisory_ == null
        ? com.google.maps.routing.v2.RouteLegStepTravelAdvisory.getDefaultInstance()
        : travelAdvisory_;
  }

  public static final int LOCALIZED_VALUES_FIELD_NUMBER = 8;
  private com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localizedValues_;
  /**
   *
   *
   * <pre>
   * Text representations of properties of the `RouteLegStep`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
   * </code>
   *
   * @return Whether the localizedValues field is set.
   */
  @java.lang.Override
  public boolean hasLocalizedValues() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Text representations of properties of the `RouteLegStep`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
   * </code>
   *
   * @return The localizedValues.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues getLocalizedValues() {
    return localizedValues_ == null
        ? com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.getDefaultInstance()
        : localizedValues_;
  }
  /**
   *
   *
   * <pre>
   * Text representations of properties of the `RouteLegStep`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValuesOrBuilder
      getLocalizedValuesOrBuilder() {
    return localizedValues_ == null
        ? com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.getDefaultInstance()
        : localizedValues_;
  }

  public static final int TRANSIT_DETAILS_FIELD_NUMBER = 9;
  private com.google.maps.routing.v2.RouteLegStepTransitDetails transitDetails_;
  /**
   *
   *
   * <pre>
   * Details pertaining to this step if the travel mode is `TRANSIT`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
   *
   * @return Whether the transitDetails field is set.
   */
  @java.lang.Override
  public boolean hasTransitDetails() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Details pertaining to this step if the travel mode is `TRANSIT`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
   *
   * @return The transitDetails.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetails getTransitDetails() {
    return transitDetails_ == null
        ? com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance()
        : transitDetails_;
  }
  /**
   *
   *
   * <pre>
   * Details pertaining to this step if the travel mode is `TRANSIT`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetailsOrBuilder
      getTransitDetailsOrBuilder() {
    return transitDetails_ == null
        ? com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance()
        : transitDetails_;
  }

  public static final int TRAVEL_MODE_FIELD_NUMBER = 10;
  private int travelMode_ = 0;
  /**
   *
   *
   * <pre>
   * The travel mode used for this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
   *
   * @return The enum numeric value on the wire for travelMode.
   */
  @java.lang.Override
  public int getTravelModeValue() {
    return travelMode_;
  }
  /**
   *
   *
   * <pre>
   * The travel mode used for this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
   *
   * @return The travelMode.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteTravelMode getTravelMode() {
    com.google.maps.routing.v2.RouteTravelMode result =
        com.google.maps.routing.v2.RouteTravelMode.forNumber(travelMode_);
    return result == null ? com.google.maps.routing.v2.RouteTravelMode.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (distanceMeters_ != 0) {
      output.writeInt32(1, distanceMeters_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getStaticDuration());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getPolyline());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getStartLocation());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getEndLocation());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(6, getNavigationInstruction());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(7, getTravelAdvisory());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(8, getLocalizedValues());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(9, getTransitDetails());
    }
    if (travelMode_
        != com.google.maps.routing.v2.RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, travelMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (distanceMeters_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, distanceMeters_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStaticDuration());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPolyline());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartLocation());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndLocation());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getNavigationInstruction());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTravelAdvisory());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLocalizedValues());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTransitDetails());
    }
    if (travelMode_
        != com.google.maps.routing.v2.RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, travelMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.RouteLegStep)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.RouteLegStep other = (com.google.maps.routing.v2.RouteLegStep) obj;

    if (getDistanceMeters() != other.getDistanceMeters()) return false;
    if (hasStaticDuration() != other.hasStaticDuration()) return false;
    if (hasStaticDuration()) {
      if (!getStaticDuration().equals(other.getStaticDuration())) return false;
    }
    if (hasPolyline() != other.hasPolyline()) return false;
    if (hasPolyline()) {
      if (!getPolyline().equals(other.getPolyline())) return false;
    }
    if (hasStartLocation() != other.hasStartLocation()) return false;
    if (hasStartLocation()) {
      if (!getStartLocation().equals(other.getStartLocation())) return false;
    }
    if (hasEndLocation() != other.hasEndLocation()) return false;
    if (hasEndLocation()) {
      if (!getEndLocation().equals(other.getEndLocation())) return false;
    }
    if (hasNavigationInstruction() != other.hasNavigationInstruction()) return false;
    if (hasNavigationInstruction()) {
      if (!getNavigationInstruction().equals(other.getNavigationInstruction())) return false;
    }
    if (hasTravelAdvisory() != other.hasTravelAdvisory()) return false;
    if (hasTravelAdvisory()) {
      if (!getTravelAdvisory().equals(other.getTravelAdvisory())) return false;
    }
    if (hasLocalizedValues() != other.hasLocalizedValues()) return false;
    if (hasLocalizedValues()) {
      if (!getLocalizedValues().equals(other.getLocalizedValues())) return false;
    }
    if (hasTransitDetails() != other.hasTransitDetails()) return false;
    if (hasTransitDetails()) {
      if (!getTransitDetails().equals(other.getTransitDetails())) return false;
    }
    if (travelMode_ != other.travelMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISTANCE_METERS_FIELD_NUMBER;
    hash = (53 * hash) + getDistanceMeters();
    if (hasStaticDuration()) {
      hash = (37 * hash) + STATIC_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getStaticDuration().hashCode();
    }
    if (hasPolyline()) {
      hash = (37 * hash) + POLYLINE_FIELD_NUMBER;
      hash = (53 * hash) + getPolyline().hashCode();
    }
    if (hasStartLocation()) {
      hash = (37 * hash) + START_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getStartLocation().hashCode();
    }
    if (hasEndLocation()) {
      hash = (37 * hash) + END_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getEndLocation().hashCode();
    }
    if (hasNavigationInstruction()) {
      hash = (37 * hash) + NAVIGATION_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getNavigationInstruction().hashCode();
    }
    if (hasTravelAdvisory()) {
      hash = (37 * hash) + TRAVEL_ADVISORY_FIELD_NUMBER;
      hash = (53 * hash) + getTravelAdvisory().hashCode();
    }
    if (hasLocalizedValues()) {
      hash = (37 * hash) + LOCALIZED_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getLocalizedValues().hashCode();
    }
    if (hasTransitDetails()) {
      hash = (37 * hash) + TRANSIT_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getTransitDetails().hashCode();
    }
    hash = (37 * hash) + TRAVEL_MODE_FIELD_NUMBER;
    hash = (53 * hash) + travelMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegStep parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.RouteLegStep prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains a segment of a [`RouteLeg`][google.maps.routing.v2.RouteLeg]. A
   * step corresponds to a single navigation instruction. Route legs are made up
   * of steps.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.RouteLegStep}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteLegStep)
      com.google.maps.routing.v2.RouteLegStepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteLegStep.class,
              com.google.maps.routing.v2.RouteLegStep.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.RouteLegStep.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStaticDurationFieldBuilder();
        getPolylineFieldBuilder();
        getStartLocationFieldBuilder();
        getEndLocationFieldBuilder();
        getNavigationInstructionFieldBuilder();
        getTravelAdvisoryFieldBuilder();
        getLocalizedValuesFieldBuilder();
        getTransitDetailsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      distanceMeters_ = 0;
      staticDuration_ = null;
      if (staticDurationBuilder_ != null) {
        staticDurationBuilder_.dispose();
        staticDurationBuilder_ = null;
      }
      polyline_ = null;
      if (polylineBuilder_ != null) {
        polylineBuilder_.dispose();
        polylineBuilder_ = null;
      }
      startLocation_ = null;
      if (startLocationBuilder_ != null) {
        startLocationBuilder_.dispose();
        startLocationBuilder_ = null;
      }
      endLocation_ = null;
      if (endLocationBuilder_ != null) {
        endLocationBuilder_.dispose();
        endLocationBuilder_ = null;
      }
      navigationInstruction_ = null;
      if (navigationInstructionBuilder_ != null) {
        navigationInstructionBuilder_.dispose();
        navigationInstructionBuilder_ = null;
      }
      travelAdvisory_ = null;
      if (travelAdvisoryBuilder_ != null) {
        travelAdvisoryBuilder_.dispose();
        travelAdvisoryBuilder_ = null;
      }
      localizedValues_ = null;
      if (localizedValuesBuilder_ != null) {
        localizedValuesBuilder_.dispose();
        localizedValuesBuilder_ = null;
      }
      transitDetails_ = null;
      if (transitDetailsBuilder_ != null) {
        transitDetailsBuilder_.dispose();
        transitDetailsBuilder_ = null;
      }
      travelMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStep_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStep getDefaultInstanceForType() {
      return com.google.maps.routing.v2.RouteLegStep.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStep build() {
      com.google.maps.routing.v2.RouteLegStep result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStep buildPartial() {
      com.google.maps.routing.v2.RouteLegStep result =
          new com.google.maps.routing.v2.RouteLegStep(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.routing.v2.RouteLegStep result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.distanceMeters_ = distanceMeters_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.staticDuration_ =
            staticDurationBuilder_ == null ? staticDuration_ : staticDurationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.polyline_ = polylineBuilder_ == null ? polyline_ : polylineBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.startLocation_ =
            startLocationBuilder_ == null ? startLocation_ : startLocationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.endLocation_ =
            endLocationBuilder_ == null ? endLocation_ : endLocationBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.navigationInstruction_ =
            navigationInstructionBuilder_ == null
                ? navigationInstruction_
                : navigationInstructionBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.travelAdvisory_ =
            travelAdvisoryBuilder_ == null ? travelAdvisory_ : travelAdvisoryBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.localizedValues_ =
            localizedValuesBuilder_ == null ? localizedValues_ : localizedValuesBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.transitDetails_ =
            transitDetailsBuilder_ == null ? transitDetails_ : transitDetailsBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.travelMode_ = travelMode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.RouteLegStep) {
        return mergeFrom((com.google.maps.routing.v2.RouteLegStep) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.RouteLegStep other) {
      if (other == com.google.maps.routing.v2.RouteLegStep.getDefaultInstance()) return this;
      if (other.getDistanceMeters() != 0) {
        setDistanceMeters(other.getDistanceMeters());
      }
      if (other.hasStaticDuration()) {
        mergeStaticDuration(other.getStaticDuration());
      }
      if (other.hasPolyline()) {
        mergePolyline(other.getPolyline());
      }
      if (other.hasStartLocation()) {
        mergeStartLocation(other.getStartLocation());
      }
      if (other.hasEndLocation()) {
        mergeEndLocation(other.getEndLocation());
      }
      if (other.hasNavigationInstruction()) {
        mergeNavigationInstruction(other.getNavigationInstruction());
      }
      if (other.hasTravelAdvisory()) {
        mergeTravelAdvisory(other.getTravelAdvisory());
      }
      if (other.hasLocalizedValues()) {
        mergeLocalizedValues(other.getLocalizedValues());
      }
      if (other.hasTransitDetails()) {
        mergeTransitDetails(other.getTransitDetails());
      }
      if (other.travelMode_ != 0) {
        setTravelModeValue(other.getTravelModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                distanceMeters_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getStaticDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPolylineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStartLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEndLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getNavigationInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTravelAdvisoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getLocalizedValuesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTransitDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                travelMode_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int distanceMeters_;
    /**
     *
     *
     * <pre>
     * The travel distance of this step, in meters. In some circumstances, this
     * field might not have a value.
     * </pre>
     *
     * <code>int32 distance_meters = 1;</code>
     *
     * @return The distanceMeters.
     */
    @java.lang.Override
    public int getDistanceMeters() {
      return distanceMeters_;
    }
    /**
     *
     *
     * <pre>
     * The travel distance of this step, in meters. In some circumstances, this
     * field might not have a value.
     * </pre>
     *
     * <code>int32 distance_meters = 1;</code>
     *
     * @param value The distanceMeters to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceMeters(int value) {

      distanceMeters_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The travel distance of this step, in meters. In some circumstances, this
     * field might not have a value.
     * </pre>
     *
     * <code>int32 distance_meters = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistanceMeters() {
      bitField0_ = (bitField0_ & ~0x00000001);
      distanceMeters_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration staticDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        staticDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     *
     * @return Whether the staticDuration field is set.
     */
    public boolean hasStaticDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     *
     * @return The staticDuration.
     */
    public com.google.protobuf.Duration getStaticDuration() {
      if (staticDurationBuilder_ == null) {
        return staticDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : staticDuration_;
      } else {
        return staticDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    public Builder setStaticDuration(com.google.protobuf.Duration value) {
      if (staticDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        staticDuration_ = value;
      } else {
        staticDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    public Builder setStaticDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (staticDurationBuilder_ == null) {
        staticDuration_ = builderForValue.build();
      } else {
        staticDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    public Builder mergeStaticDuration(com.google.protobuf.Duration value) {
      if (staticDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && staticDuration_ != null
            && staticDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getStaticDurationBuilder().mergeFrom(value);
        } else {
          staticDuration_ = value;
        }
      } else {
        staticDurationBuilder_.mergeFrom(value);
      }
      if (staticDuration_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    public Builder clearStaticDuration() {
      bitField0_ = (bitField0_ & ~0x00000002);
      staticDuration_ = null;
      if (staticDurationBuilder_ != null) {
        staticDurationBuilder_.dispose();
        staticDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getStaticDurationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStaticDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getStaticDurationOrBuilder() {
      if (staticDurationBuilder_ != null) {
        return staticDurationBuilder_.getMessageOrBuilder();
      } else {
        return staticDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : staticDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The duration of travel through this step without taking traffic conditions
     * into consideration. In some circumstances, this field might not have a
     * value.
     * </pre>
     *
     * <code>.google.protobuf.Duration static_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getStaticDurationFieldBuilder() {
      if (staticDurationBuilder_ == null) {
        staticDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getStaticDuration(), getParentForChildren(), isClean());
        staticDuration_ = null;
      }
      return staticDurationBuilder_;
    }

    private com.google.maps.routing.v2.Polyline polyline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Polyline,
            com.google.maps.routing.v2.Polyline.Builder,
            com.google.maps.routing.v2.PolylineOrBuilder>
        polylineBuilder_;
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     *
     * @return Whether the polyline field is set.
     */
    public boolean hasPolyline() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     *
     * @return The polyline.
     */
    public com.google.maps.routing.v2.Polyline getPolyline() {
      if (polylineBuilder_ == null) {
        return polyline_ == null
            ? com.google.maps.routing.v2.Polyline.getDefaultInstance()
            : polyline_;
      } else {
        return polylineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    public Builder setPolyline(com.google.maps.routing.v2.Polyline value) {
      if (polylineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        polyline_ = value;
      } else {
        polylineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    public Builder setPolyline(com.google.maps.routing.v2.Polyline.Builder builderForValue) {
      if (polylineBuilder_ == null) {
        polyline_ = builderForValue.build();
      } else {
        polylineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    public Builder mergePolyline(com.google.maps.routing.v2.Polyline value) {
      if (polylineBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && polyline_ != null
            && polyline_ != com.google.maps.routing.v2.Polyline.getDefaultInstance()) {
          getPolylineBuilder().mergeFrom(value);
        } else {
          polyline_ = value;
        }
      } else {
        polylineBuilder_.mergeFrom(value);
      }
      if (polyline_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    public Builder clearPolyline() {
      bitField0_ = (bitField0_ & ~0x00000004);
      polyline_ = null;
      if (polylineBuilder_ != null) {
        polylineBuilder_.dispose();
        polylineBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    public com.google.maps.routing.v2.Polyline.Builder getPolylineBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPolylineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    public com.google.maps.routing.v2.PolylineOrBuilder getPolylineOrBuilder() {
      if (polylineBuilder_ != null) {
        return polylineBuilder_.getMessageOrBuilder();
      } else {
        return polyline_ == null
            ? com.google.maps.routing.v2.Polyline.getDefaultInstance()
            : polyline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The polyline associated with this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Polyline polyline = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Polyline,
            com.google.maps.routing.v2.Polyline.Builder,
            com.google.maps.routing.v2.PolylineOrBuilder>
        getPolylineFieldBuilder() {
      if (polylineBuilder_ == null) {
        polylineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Polyline,
                com.google.maps.routing.v2.Polyline.Builder,
                com.google.maps.routing.v2.PolylineOrBuilder>(
                getPolyline(), getParentForChildren(), isClean());
        polyline_ = null;
      }
      return polylineBuilder_;
    }

    private com.google.maps.routing.v2.Location startLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Location,
            com.google.maps.routing.v2.Location.Builder,
            com.google.maps.routing.v2.LocationOrBuilder>
        startLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     *
     * @return Whether the startLocation field is set.
     */
    public boolean hasStartLocation() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     *
     * @return The startLocation.
     */
    public com.google.maps.routing.v2.Location getStartLocation() {
      if (startLocationBuilder_ == null) {
        return startLocation_ == null
            ? com.google.maps.routing.v2.Location.getDefaultInstance()
            : startLocation_;
      } else {
        return startLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    public Builder setStartLocation(com.google.maps.routing.v2.Location value) {
      if (startLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startLocation_ = value;
      } else {
        startLocationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    public Builder setStartLocation(com.google.maps.routing.v2.Location.Builder builderForValue) {
      if (startLocationBuilder_ == null) {
        startLocation_ = builderForValue.build();
      } else {
        startLocationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    public Builder mergeStartLocation(com.google.maps.routing.v2.Location value) {
      if (startLocationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && startLocation_ != null
            && startLocation_ != com.google.maps.routing.v2.Location.getDefaultInstance()) {
          getStartLocationBuilder().mergeFrom(value);
        } else {
          startLocation_ = value;
        }
      } else {
        startLocationBuilder_.mergeFrom(value);
      }
      if (startLocation_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    public Builder clearStartLocation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      startLocation_ = null;
      if (startLocationBuilder_ != null) {
        startLocationBuilder_.dispose();
        startLocationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    public com.google.maps.routing.v2.Location.Builder getStartLocationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getStartLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    public com.google.maps.routing.v2.LocationOrBuilder getStartLocationOrBuilder() {
      if (startLocationBuilder_ != null) {
        return startLocationBuilder_.getMessageOrBuilder();
      } else {
        return startLocation_ == null
            ? com.google.maps.routing.v2.Location.getDefaultInstance()
            : startLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The start location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location start_location = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Location,
            com.google.maps.routing.v2.Location.Builder,
            com.google.maps.routing.v2.LocationOrBuilder>
        getStartLocationFieldBuilder() {
      if (startLocationBuilder_ == null) {
        startLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Location,
                com.google.maps.routing.v2.Location.Builder,
                com.google.maps.routing.v2.LocationOrBuilder>(
                getStartLocation(), getParentForChildren(), isClean());
        startLocation_ = null;
      }
      return startLocationBuilder_;
    }

    private com.google.maps.routing.v2.Location endLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Location,
            com.google.maps.routing.v2.Location.Builder,
            com.google.maps.routing.v2.LocationOrBuilder>
        endLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     *
     * @return Whether the endLocation field is set.
     */
    public boolean hasEndLocation() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     *
     * @return The endLocation.
     */
    public com.google.maps.routing.v2.Location getEndLocation() {
      if (endLocationBuilder_ == null) {
        return endLocation_ == null
            ? com.google.maps.routing.v2.Location.getDefaultInstance()
            : endLocation_;
      } else {
        return endLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    public Builder setEndLocation(com.google.maps.routing.v2.Location value) {
      if (endLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endLocation_ = value;
      } else {
        endLocationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    public Builder setEndLocation(com.google.maps.routing.v2.Location.Builder builderForValue) {
      if (endLocationBuilder_ == null) {
        endLocation_ = builderForValue.build();
      } else {
        endLocationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    public Builder mergeEndLocation(com.google.maps.routing.v2.Location value) {
      if (endLocationBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && endLocation_ != null
            && endLocation_ != com.google.maps.routing.v2.Location.getDefaultInstance()) {
          getEndLocationBuilder().mergeFrom(value);
        } else {
          endLocation_ = value;
        }
      } else {
        endLocationBuilder_.mergeFrom(value);
      }
      if (endLocation_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    public Builder clearEndLocation() {
      bitField0_ = (bitField0_ & ~0x00000010);
      endLocation_ = null;
      if (endLocationBuilder_ != null) {
        endLocationBuilder_.dispose();
        endLocationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    public com.google.maps.routing.v2.Location.Builder getEndLocationBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEndLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    public com.google.maps.routing.v2.LocationOrBuilder getEndLocationOrBuilder() {
      if (endLocationBuilder_ != null) {
        return endLocationBuilder_.getMessageOrBuilder();
      } else {
        return endLocation_ == null
            ? com.google.maps.routing.v2.Location.getDefaultInstance()
            : endLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end location of this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Location end_location = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Location,
            com.google.maps.routing.v2.Location.Builder,
            com.google.maps.routing.v2.LocationOrBuilder>
        getEndLocationFieldBuilder() {
      if (endLocationBuilder_ == null) {
        endLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Location,
                com.google.maps.routing.v2.Location.Builder,
                com.google.maps.routing.v2.LocationOrBuilder>(
                getEndLocation(), getParentForChildren(), isClean());
        endLocation_ = null;
      }
      return endLocationBuilder_;
    }

    private com.google.maps.routing.v2.NavigationInstruction navigationInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.NavigationInstruction,
            com.google.maps.routing.v2.NavigationInstruction.Builder,
            com.google.maps.routing.v2.NavigationInstructionOrBuilder>
        navigationInstructionBuilder_;
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     *
     * @return Whether the navigationInstruction field is set.
     */
    public boolean hasNavigationInstruction() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     *
     * @return The navigationInstruction.
     */
    public com.google.maps.routing.v2.NavigationInstruction getNavigationInstruction() {
      if (navigationInstructionBuilder_ == null) {
        return navigationInstruction_ == null
            ? com.google.maps.routing.v2.NavigationInstruction.getDefaultInstance()
            : navigationInstruction_;
      } else {
        return navigationInstructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    public Builder setNavigationInstruction(
        com.google.maps.routing.v2.NavigationInstruction value) {
      if (navigationInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        navigationInstruction_ = value;
      } else {
        navigationInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    public Builder setNavigationInstruction(
        com.google.maps.routing.v2.NavigationInstruction.Builder builderForValue) {
      if (navigationInstructionBuilder_ == null) {
        navigationInstruction_ = builderForValue.build();
      } else {
        navigationInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    public Builder mergeNavigationInstruction(
        com.google.maps.routing.v2.NavigationInstruction value) {
      if (navigationInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && navigationInstruction_ != null
            && navigationInstruction_
                != com.google.maps.routing.v2.NavigationInstruction.getDefaultInstance()) {
          getNavigationInstructionBuilder().mergeFrom(value);
        } else {
          navigationInstruction_ = value;
        }
      } else {
        navigationInstructionBuilder_.mergeFrom(value);
      }
      if (navigationInstruction_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    public Builder clearNavigationInstruction() {
      bitField0_ = (bitField0_ & ~0x00000020);
      navigationInstruction_ = null;
      if (navigationInstructionBuilder_ != null) {
        navigationInstructionBuilder_.dispose();
        navigationInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    public com.google.maps.routing.v2.NavigationInstruction.Builder
        getNavigationInstructionBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getNavigationInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    public com.google.maps.routing.v2.NavigationInstructionOrBuilder
        getNavigationInstructionOrBuilder() {
      if (navigationInstructionBuilder_ != null) {
        return navigationInstructionBuilder_.getMessageOrBuilder();
      } else {
        return navigationInstruction_ == null
            ? com.google.maps.routing.v2.NavigationInstruction.getDefaultInstance()
            : navigationInstruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Navigation instructions.
     * </pre>
     *
     * <code>.google.maps.routing.v2.NavigationInstruction navigation_instruction = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.NavigationInstruction,
            com.google.maps.routing.v2.NavigationInstruction.Builder,
            com.google.maps.routing.v2.NavigationInstructionOrBuilder>
        getNavigationInstructionFieldBuilder() {
      if (navigationInstructionBuilder_ == null) {
        navigationInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.NavigationInstruction,
                com.google.maps.routing.v2.NavigationInstruction.Builder,
                com.google.maps.routing.v2.NavigationInstructionOrBuilder>(
                getNavigationInstruction(), getParentForChildren(), isClean());
        navigationInstruction_ = null;
      }
      return navigationInstructionBuilder_;
    }

    private com.google.maps.routing.v2.RouteLegStepTravelAdvisory travelAdvisory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTravelAdvisory,
            com.google.maps.routing.v2.RouteLegStepTravelAdvisory.Builder,
            com.google.maps.routing.v2.RouteLegStepTravelAdvisoryOrBuilder>
        travelAdvisoryBuilder_;
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     *
     * @return Whether the travelAdvisory field is set.
     */
    public boolean hasTravelAdvisory() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     *
     * @return The travelAdvisory.
     */
    public com.google.maps.routing.v2.RouteLegStepTravelAdvisory getTravelAdvisory() {
      if (travelAdvisoryBuilder_ == null) {
        return travelAdvisory_ == null
            ? com.google.maps.routing.v2.RouteLegStepTravelAdvisory.getDefaultInstance()
            : travelAdvisory_;
      } else {
        return travelAdvisoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    public Builder setTravelAdvisory(com.google.maps.routing.v2.RouteLegStepTravelAdvisory value) {
      if (travelAdvisoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        travelAdvisory_ = value;
      } else {
        travelAdvisoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    public Builder setTravelAdvisory(
        com.google.maps.routing.v2.RouteLegStepTravelAdvisory.Builder builderForValue) {
      if (travelAdvisoryBuilder_ == null) {
        travelAdvisory_ = builderForValue.build();
      } else {
        travelAdvisoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    public Builder mergeTravelAdvisory(
        com.google.maps.routing.v2.RouteLegStepTravelAdvisory value) {
      if (travelAdvisoryBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && travelAdvisory_ != null
            && travelAdvisory_
                != com.google.maps.routing.v2.RouteLegStepTravelAdvisory.getDefaultInstance()) {
          getTravelAdvisoryBuilder().mergeFrom(value);
        } else {
          travelAdvisory_ = value;
        }
      } else {
        travelAdvisoryBuilder_.mergeFrom(value);
      }
      if (travelAdvisory_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    public Builder clearTravelAdvisory() {
      bitField0_ = (bitField0_ & ~0x00000040);
      travelAdvisory_ = null;
      if (travelAdvisoryBuilder_ != null) {
        travelAdvisoryBuilder_.dispose();
        travelAdvisoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    public com.google.maps.routing.v2.RouteLegStepTravelAdvisory.Builder
        getTravelAdvisoryBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTravelAdvisoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    public com.google.maps.routing.v2.RouteLegStepTravelAdvisoryOrBuilder
        getTravelAdvisoryOrBuilder() {
      if (travelAdvisoryBuilder_ != null) {
        return travelAdvisoryBuilder_.getMessageOrBuilder();
      } else {
        return travelAdvisory_ == null
            ? com.google.maps.routing.v2.RouteLegStepTravelAdvisory.getDefaultInstance()
            : travelAdvisory_;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the additional information that the user should be informed
     * about, such as possible traffic zone restrictions, on a leg step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTravelAdvisory travel_advisory = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTravelAdvisory,
            com.google.maps.routing.v2.RouteLegStepTravelAdvisory.Builder,
            com.google.maps.routing.v2.RouteLegStepTravelAdvisoryOrBuilder>
        getTravelAdvisoryFieldBuilder() {
      if (travelAdvisoryBuilder_ == null) {
        travelAdvisoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteLegStepTravelAdvisory,
                com.google.maps.routing.v2.RouteLegStepTravelAdvisory.Builder,
                com.google.maps.routing.v2.RouteLegStepTravelAdvisoryOrBuilder>(
                getTravelAdvisory(), getParentForChildren(), isClean());
        travelAdvisory_ = null;
      }
      return travelAdvisoryBuilder_;
    }

    private com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localizedValues_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues,
            com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder,
            com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValuesOrBuilder>
        localizedValuesBuilder_;
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     *
     * @return Whether the localizedValues field is set.
     */
    public boolean hasLocalizedValues() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     *
     * @return The localizedValues.
     */
    public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
        getLocalizedValues() {
      if (localizedValuesBuilder_ == null) {
        return localizedValues_ == null
            ? com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
                .getDefaultInstance()
            : localizedValues_;
      } else {
        return localizedValuesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    public Builder setLocalizedValues(
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues value) {
      if (localizedValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        localizedValues_ = value;
      } else {
        localizedValuesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    public Builder setLocalizedValues(
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder
            builderForValue) {
      if (localizedValuesBuilder_ == null) {
        localizedValues_ = builderForValue.build();
      } else {
        localizedValuesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    public Builder mergeLocalizedValues(
        com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues value) {
      if (localizedValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && localizedValues_ != null
            && localizedValues_
                != com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
                    .getDefaultInstance()) {
          getLocalizedValuesBuilder().mergeFrom(value);
        } else {
          localizedValues_ = value;
        }
      } else {
        localizedValuesBuilder_.mergeFrom(value);
      }
      if (localizedValues_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    public Builder clearLocalizedValues() {
      bitField0_ = (bitField0_ & ~0x00000080);
      localizedValues_ = null;
      if (localizedValuesBuilder_ != null) {
        localizedValuesBuilder_.dispose();
        localizedValuesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder
        getLocalizedValuesBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLocalizedValuesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    public com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValuesOrBuilder
        getLocalizedValuesOrBuilder() {
      if (localizedValuesBuilder_ != null) {
        return localizedValuesBuilder_.getMessageOrBuilder();
      } else {
        return localizedValues_ == null
            ? com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues
                .getDefaultInstance()
            : localizedValues_;
      }
    }
    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStep`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues localized_values = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues,
            com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder,
            com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValuesOrBuilder>
        getLocalizedValuesFieldBuilder() {
      if (localizedValuesBuilder_ == null) {
        localizedValuesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues,
                com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValues.Builder,
                com.google.maps.routing.v2.RouteLegStep.RouteLegStepLocalizedValuesOrBuilder>(
                getLocalizedValues(), getParentForChildren(), isClean());
        localizedValues_ = null;
      }
      return localizedValuesBuilder_;
    }

    private com.google.maps.routing.v2.RouteLegStepTransitDetails transitDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTransitDetails,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder,
            com.google.maps.routing.v2.RouteLegStepTransitDetailsOrBuilder>
        transitDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     *
     * @return Whether the transitDetails field is set.
     */
    public boolean hasTransitDetails() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     *
     * @return The transitDetails.
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails getTransitDetails() {
      if (transitDetailsBuilder_ == null) {
        return transitDetails_ == null
            ? com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance()
            : transitDetails_;
      } else {
        return transitDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    public Builder setTransitDetails(com.google.maps.routing.v2.RouteLegStepTransitDetails value) {
      if (transitDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transitDetails_ = value;
      } else {
        transitDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    public Builder setTransitDetails(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder builderForValue) {
      if (transitDetailsBuilder_ == null) {
        transitDetails_ = builderForValue.build();
      } else {
        transitDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    public Builder mergeTransitDetails(
        com.google.maps.routing.v2.RouteLegStepTransitDetails value) {
      if (transitDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && transitDetails_ != null
            && transitDetails_
                != com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance()) {
          getTransitDetailsBuilder().mergeFrom(value);
        } else {
          transitDetails_ = value;
        }
      } else {
        transitDetailsBuilder_.mergeFrom(value);
      }
      if (transitDetails_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    public Builder clearTransitDetails() {
      bitField0_ = (bitField0_ & ~0x00000100);
      transitDetails_ = null;
      if (transitDetailsBuilder_ != null) {
        transitDetailsBuilder_.dispose();
        transitDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder
        getTransitDetailsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getTransitDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetailsOrBuilder
        getTransitDetailsOrBuilder() {
      if (transitDetailsBuilder_ != null) {
        return transitDetailsBuilder_.getMessageOrBuilder();
      } else {
        return transitDetails_ == null
            ? com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance()
            : transitDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Details pertaining to this step if the travel mode is `TRANSIT`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails transit_details = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTransitDetails,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder,
            com.google.maps.routing.v2.RouteLegStepTransitDetailsOrBuilder>
        getTransitDetailsFieldBuilder() {
      if (transitDetailsBuilder_ == null) {
        transitDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteLegStepTransitDetails,
                com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder,
                com.google.maps.routing.v2.RouteLegStepTransitDetailsOrBuilder>(
                getTransitDetails(), getParentForChildren(), isClean());
        transitDetails_ = null;
      }
      return transitDetailsBuilder_;
    }

    private int travelMode_ = 0;
    /**
     *
     *
     * <pre>
     * The travel mode used for this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
     *
     * @return The enum numeric value on the wire for travelMode.
     */
    @java.lang.Override
    public int getTravelModeValue() {
      return travelMode_;
    }
    /**
     *
     *
     * <pre>
     * The travel mode used for this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
     *
     * @param value The enum numeric value on the wire for travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelModeValue(int value) {
      travelMode_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The travel mode used for this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
     *
     * @return The travelMode.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.RouteTravelMode getTravelMode() {
      com.google.maps.routing.v2.RouteTravelMode result =
          com.google.maps.routing.v2.RouteTravelMode.forNumber(travelMode_);
      return result == null ? com.google.maps.routing.v2.RouteTravelMode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The travel mode used for this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
     *
     * @param value The travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelMode(com.google.maps.routing.v2.RouteTravelMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      travelMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The travel mode used for this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteTravelMode travel_mode = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTravelMode() {
      bitField0_ = (bitField0_ & ~0x00000200);
      travelMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteLegStep)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteLegStep)
  private static final com.google.maps.routing.v2.RouteLegStep DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.RouteLegStep();
  }

  public static com.google.maps.routing.v2.RouteLegStep getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouteLegStep> PARSER =
      new com.google.protobuf.AbstractParser<RouteLegStep>() {
        @java.lang.Override
        public RouteLegStep parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouteLegStep> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouteLegStep> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStep getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
