/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/traffic_model.proto

// Protobuf Java Version: 3.25.3
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Specifies the assumptions to use when calculating time in traffic. This
 * setting affects the value returned in the `duration` field in the
 * response, which contains the predicted time in traffic based on historical
 * averages.
 * </pre>
 *
 * Protobuf enum {@code google.maps.routing.v2.TrafficModel}
 */
public enum TrafficModel implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Unused. If specified, will default to `BEST_GUESS`.
   * </pre>
   *
   * <code>TRAFFIC_MODEL_UNSPECIFIED = 0;</code>
   */
  TRAFFIC_MODEL_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Indicates that the returned `duration` should be the best
   * estimate of travel time given what is known about both historical traffic
   * conditions and live traffic. Live traffic becomes more important the closer
   * the `departure_time` is to now.
   * </pre>
   *
   * <code>BEST_GUESS = 1;</code>
   */
  BEST_GUESS(1),
  /**
   *
   *
   * <pre>
   * Indicates that the returned duration should be longer than the
   * actual travel time on most days, though occasional days with particularly
   * bad traffic conditions may exceed this value.
   * </pre>
   *
   * <code>PESSIMISTIC = 2;</code>
   */
  PESSIMISTIC(2),
  /**
   *
   *
   * <pre>
   * Indicates that the returned duration should be shorter than the actual
   * travel time on most days, though occasional days with particularly good
   * traffic conditions may be faster than this value.
   * </pre>
   *
   * <code>OPTIMISTIC = 3;</code>
   */
  OPTIMISTIC(3),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Unused. If specified, will default to `BEST_GUESS`.
   * </pre>
   *
   * <code>TRAFFIC_MODEL_UNSPECIFIED = 0;</code>
   */
  public static final int TRAFFIC_MODEL_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Indicates that the returned `duration` should be the best
   * estimate of travel time given what is known about both historical traffic
   * conditions and live traffic. Live traffic becomes more important the closer
   * the `departure_time` is to now.
   * </pre>
   *
   * <code>BEST_GUESS = 1;</code>
   */
  public static final int BEST_GUESS_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Indicates that the returned duration should be longer than the
   * actual travel time on most days, though occasional days with particularly
   * bad traffic conditions may exceed this value.
   * </pre>
   *
   * <code>PESSIMISTIC = 2;</code>
   */
  public static final int PESSIMISTIC_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Indicates that the returned duration should be shorter than the actual
   * travel time on most days, though occasional days with particularly good
   * traffic conditions may be faster than this value.
   * </pre>
   *
   * <code>OPTIMISTIC = 3;</code>
   */
  public static final int OPTIMISTIC_VALUE = 3;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static TrafficModel valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static TrafficModel forNumber(int value) {
    switch (value) {
      case 0:
        return TRAFFIC_MODEL_UNSPECIFIED;
      case 1:
        return BEST_GUESS;
      case 2:
        return PESSIMISTIC;
      case 3:
        return OPTIMISTIC;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<TrafficModel> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<TrafficModel> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<TrafficModel>() {
        public TrafficModel findValueByNumber(int number) {
          return TrafficModel.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.maps.routing.v2.TrafficModelProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final TrafficModel[] VALUES = values();

  public static TrafficModel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private TrafficModel(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.TrafficModel)
}
