/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/transit.proto

// Protobuf Java Version: 3.25.3
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Contains information about the transit line used in this step.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.TransitLine}
 */
public final class TransitLine extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.TransitLine)
    TransitLineOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransitLine.newBuilder() to construct.
  private TransitLine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitLine() {
    agencies_ = java.util.Collections.emptyList();
    name_ = "";
    uri_ = "";
    color_ = "";
    iconUri_ = "";
    nameShort_ = "";
    textColor_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitLine();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.TransitProto
        .internal_static_google_maps_routing_v2_TransitLine_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.TransitProto
        .internal_static_google_maps_routing_v2_TransitLine_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.TransitLine.class,
            com.google.maps.routing.v2.TransitLine.Builder.class);
  }

  private int bitField0_;
  public static final int AGENCIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.TransitAgency> agencies_;
  /**
   *
   *
   * <pre>
   * The transit agency (or agencies) that operates this transit line.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.TransitAgency> getAgenciesList() {
    return agencies_;
  }
  /**
   *
   *
   * <pre>
   * The transit agency (or agencies) that operates this transit line.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.TransitAgencyOrBuilder>
      getAgenciesOrBuilderList() {
    return agencies_;
  }
  /**
   *
   *
   * <pre>
   * The transit agency (or agencies) that operates this transit line.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
   */
  @java.lang.Override
  public int getAgenciesCount() {
    return agencies_.size();
  }
  /**
   *
   *
   * <pre>
   * The transit agency (or agencies) that operates this transit line.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitAgency getAgencies(int index) {
    return agencies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The transit agency (or agencies) that operates this transit line.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitAgencyOrBuilder getAgenciesOrBuilder(int index) {
    return agencies_.get(index);
  }

  public static final int NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full name of this transit line, For example, "8 Avenue Local".
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of this transit line, For example, "8 Avenue Local".
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * the URI for this transit line as provided by the transit agency.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * the URI for this transit line as provided by the transit agency.
   * </pre>
   *
   * <code>string uri = 3;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLOR_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object color_ = "";
  /**
   *
   *
   * <pre>
   * The color commonly used in signage for this line. Represented in
   * hexadecimal.
   * </pre>
   *
   * <code>string color = 4;</code>
   *
   * @return The color.
   */
  @java.lang.Override
  public java.lang.String getColor() {
    java.lang.Object ref = color_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      color_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The color commonly used in signage for this line. Represented in
   * hexadecimal.
   * </pre>
   *
   * <code>string color = 4;</code>
   *
   * @return The bytes for color.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getColorBytes() {
    java.lang.Object ref = color_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      color_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ICON_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object iconUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI for the icon associated with this line.
   * </pre>
   *
   * <code>string icon_uri = 5;</code>
   *
   * @return The iconUri.
   */
  @java.lang.Override
  public java.lang.String getIconUri() {
    java.lang.Object ref = iconUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      iconUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI for the icon associated with this line.
   * </pre>
   *
   * <code>string icon_uri = 5;</code>
   *
   * @return The bytes for iconUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIconUriBytes() {
    java.lang.Object ref = iconUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      iconUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_SHORT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nameShort_ = "";
  /**
   *
   *
   * <pre>
   * The short name of this transit line. This name will normally be a line
   * number, such as "M7" or "355".
   * </pre>
   *
   * <code>string name_short = 6;</code>
   *
   * @return The nameShort.
   */
  @java.lang.Override
  public java.lang.String getNameShort() {
    java.lang.Object ref = nameShort_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nameShort_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The short name of this transit line. This name will normally be a line
   * number, such as "M7" or "355".
   * </pre>
   *
   * <code>string name_short = 6;</code>
   *
   * @return The bytes for nameShort.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameShortBytes() {
    java.lang.Object ref = nameShort_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nameShort_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_COLOR_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object textColor_ = "";
  /**
   *
   *
   * <pre>
   * The color commonly used in text on signage for this line. Represented in
   * hexadecimal.
   * </pre>
   *
   * <code>string text_color = 7;</code>
   *
   * @return The textColor.
   */
  @java.lang.Override
  public java.lang.String getTextColor() {
    java.lang.Object ref = textColor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      textColor_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The color commonly used in text on signage for this line. Represented in
   * hexadecimal.
   * </pre>
   *
   * <code>string text_color = 7;</code>
   *
   * @return The bytes for textColor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTextColorBytes() {
    java.lang.Object ref = textColor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      textColor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VEHICLE_FIELD_NUMBER = 8;
  private com.google.maps.routing.v2.TransitVehicle vehicle_;
  /**
   *
   *
   * <pre>
   * The type of vehicle that operates on this transit line.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
   *
   * @return Whether the vehicle field is set.
   */
  @java.lang.Override
  public boolean hasVehicle() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type of vehicle that operates on this transit line.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
   *
   * @return The vehicle.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitVehicle getVehicle() {
    return vehicle_ == null
        ? com.google.maps.routing.v2.TransitVehicle.getDefaultInstance()
        : vehicle_;
  }
  /**
   *
   *
   * <pre>
   * The type of vehicle that operates on this transit line.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitVehicleOrBuilder getVehicleOrBuilder() {
    return vehicle_ == null
        ? com.google.maps.routing.v2.TransitVehicle.getDefaultInstance()
        : vehicle_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < agencies_.size(); i++) {
      output.writeMessage(1, agencies_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(color_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, color_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(iconUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, iconUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nameShort_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, nameShort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textColor_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, textColor_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getVehicle());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < agencies_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, agencies_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(color_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, color_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(iconUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, iconUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nameShort_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, nameShort_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textColor_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, textColor_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getVehicle());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.TransitLine)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.TransitLine other = (com.google.maps.routing.v2.TransitLine) obj;

    if (!getAgenciesList().equals(other.getAgenciesList())) return false;
    if (!getName().equals(other.getName())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getColor().equals(other.getColor())) return false;
    if (!getIconUri().equals(other.getIconUri())) return false;
    if (!getNameShort().equals(other.getNameShort())) return false;
    if (!getTextColor().equals(other.getTextColor())) return false;
    if (hasVehicle() != other.hasVehicle()) return false;
    if (hasVehicle()) {
      if (!getVehicle().equals(other.getVehicle())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAgenciesCount() > 0) {
      hash = (37 * hash) + AGENCIES_FIELD_NUMBER;
      hash = (53 * hash) + getAgenciesList().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + COLOR_FIELD_NUMBER;
    hash = (53 * hash) + getColor().hashCode();
    hash = (37 * hash) + ICON_URI_FIELD_NUMBER;
    hash = (53 * hash) + getIconUri().hashCode();
    hash = (37 * hash) + NAME_SHORT_FIELD_NUMBER;
    hash = (53 * hash) + getNameShort().hashCode();
    hash = (37 * hash) + TEXT_COLOR_FIELD_NUMBER;
    hash = (53 * hash) + getTextColor().hashCode();
    if (hasVehicle()) {
      hash = (37 * hash) + VEHICLE_FIELD_NUMBER;
      hash = (53 * hash) + getVehicle().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitLine parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitLine parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitLine parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.TransitLine prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains information about the transit line used in this step.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.TransitLine}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.TransitLine)
      com.google.maps.routing.v2.TransitLineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.TransitProto
          .internal_static_google_maps_routing_v2_TransitLine_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.TransitProto
          .internal_static_google_maps_routing_v2_TransitLine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.TransitLine.class,
              com.google.maps.routing.v2.TransitLine.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.TransitLine.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAgenciesFieldBuilder();
        getVehicleFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (agenciesBuilder_ == null) {
        agencies_ = java.util.Collections.emptyList();
      } else {
        agencies_ = null;
        agenciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      name_ = "";
      uri_ = "";
      color_ = "";
      iconUri_ = "";
      nameShort_ = "";
      textColor_ = "";
      vehicle_ = null;
      if (vehicleBuilder_ != null) {
        vehicleBuilder_.dispose();
        vehicleBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.TransitProto
          .internal_static_google_maps_routing_v2_TransitLine_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitLine getDefaultInstanceForType() {
      return com.google.maps.routing.v2.TransitLine.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitLine build() {
      com.google.maps.routing.v2.TransitLine result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitLine buildPartial() {
      com.google.maps.routing.v2.TransitLine result =
          new com.google.maps.routing.v2.TransitLine(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.TransitLine result) {
      if (agenciesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          agencies_ = java.util.Collections.unmodifiableList(agencies_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.agencies_ = agencies_;
      } else {
        result.agencies_ = agenciesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.routing.v2.TransitLine result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.color_ = color_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.iconUri_ = iconUri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.nameShort_ = nameShort_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.textColor_ = textColor_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.vehicle_ = vehicleBuilder_ == null ? vehicle_ : vehicleBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.TransitLine) {
        return mergeFrom((com.google.maps.routing.v2.TransitLine) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.TransitLine other) {
      if (other == com.google.maps.routing.v2.TransitLine.getDefaultInstance()) return this;
      if (agenciesBuilder_ == null) {
        if (!other.agencies_.isEmpty()) {
          if (agencies_.isEmpty()) {
            agencies_ = other.agencies_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAgenciesIsMutable();
            agencies_.addAll(other.agencies_);
          }
          onChanged();
        }
      } else {
        if (!other.agencies_.isEmpty()) {
          if (agenciesBuilder_.isEmpty()) {
            agenciesBuilder_.dispose();
            agenciesBuilder_ = null;
            agencies_ = other.agencies_;
            bitField0_ = (bitField0_ & ~0x00000001);
            agenciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAgenciesFieldBuilder()
                    : null;
          } else {
            agenciesBuilder_.addAllMessages(other.agencies_);
          }
        }
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getColor().isEmpty()) {
        color_ = other.color_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getIconUri().isEmpty()) {
        iconUri_ = other.iconUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getNameShort().isEmpty()) {
        nameShort_ = other.nameShort_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getTextColor().isEmpty()) {
        textColor_ = other.textColor_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasVehicle()) {
        mergeVehicle(other.getVehicle());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.maps.routing.v2.TransitAgency m =
                    input.readMessage(
                        com.google.maps.routing.v2.TransitAgency.parser(), extensionRegistry);
                if (agenciesBuilder_ == null) {
                  ensureAgenciesIsMutable();
                  agencies_.add(m);
                } else {
                  agenciesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                color_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                iconUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                nameShort_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                textColor_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getVehicleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.maps.routing.v2.TransitAgency> agencies_ =
        java.util.Collections.emptyList();

    private void ensureAgenciesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        agencies_ = new java.util.ArrayList<com.google.maps.routing.v2.TransitAgency>(agencies_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.TransitAgency,
            com.google.maps.routing.v2.TransitAgency.Builder,
            com.google.maps.routing.v2.TransitAgencyOrBuilder>
        agenciesBuilder_;

    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public java.util.List<com.google.maps.routing.v2.TransitAgency> getAgenciesList() {
      if (agenciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(agencies_);
      } else {
        return agenciesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public int getAgenciesCount() {
      if (agenciesBuilder_ == null) {
        return agencies_.size();
      } else {
        return agenciesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public com.google.maps.routing.v2.TransitAgency getAgencies(int index) {
      if (agenciesBuilder_ == null) {
        return agencies_.get(index);
      } else {
        return agenciesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder setAgencies(int index, com.google.maps.routing.v2.TransitAgency value) {
      if (agenciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAgenciesIsMutable();
        agencies_.set(index, value);
        onChanged();
      } else {
        agenciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder setAgencies(
        int index, com.google.maps.routing.v2.TransitAgency.Builder builderForValue) {
      if (agenciesBuilder_ == null) {
        ensureAgenciesIsMutable();
        agencies_.set(index, builderForValue.build());
        onChanged();
      } else {
        agenciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder addAgencies(com.google.maps.routing.v2.TransitAgency value) {
      if (agenciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAgenciesIsMutable();
        agencies_.add(value);
        onChanged();
      } else {
        agenciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder addAgencies(int index, com.google.maps.routing.v2.TransitAgency value) {
      if (agenciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAgenciesIsMutable();
        agencies_.add(index, value);
        onChanged();
      } else {
        agenciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder addAgencies(com.google.maps.routing.v2.TransitAgency.Builder builderForValue) {
      if (agenciesBuilder_ == null) {
        ensureAgenciesIsMutable();
        agencies_.add(builderForValue.build());
        onChanged();
      } else {
        agenciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder addAgencies(
        int index, com.google.maps.routing.v2.TransitAgency.Builder builderForValue) {
      if (agenciesBuilder_ == null) {
        ensureAgenciesIsMutable();
        agencies_.add(index, builderForValue.build());
        onChanged();
      } else {
        agenciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder addAllAgencies(
        java.lang.Iterable<? extends com.google.maps.routing.v2.TransitAgency> values) {
      if (agenciesBuilder_ == null) {
        ensureAgenciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, agencies_);
        onChanged();
      } else {
        agenciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder clearAgencies() {
      if (agenciesBuilder_ == null) {
        agencies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        agenciesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public Builder removeAgencies(int index) {
      if (agenciesBuilder_ == null) {
        ensureAgenciesIsMutable();
        agencies_.remove(index);
        onChanged();
      } else {
        agenciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public com.google.maps.routing.v2.TransitAgency.Builder getAgenciesBuilder(int index) {
      return getAgenciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public com.google.maps.routing.v2.TransitAgencyOrBuilder getAgenciesOrBuilder(int index) {
      if (agenciesBuilder_ == null) {
        return agencies_.get(index);
      } else {
        return agenciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.TransitAgencyOrBuilder>
        getAgenciesOrBuilderList() {
      if (agenciesBuilder_ != null) {
        return agenciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(agencies_);
      }
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public com.google.maps.routing.v2.TransitAgency.Builder addAgenciesBuilder() {
      return getAgenciesFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.TransitAgency.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public com.google.maps.routing.v2.TransitAgency.Builder addAgenciesBuilder(int index) {
      return getAgenciesFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.TransitAgency.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The transit agency (or agencies) that operates this transit line.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TransitAgency agencies = 1;</code>
     */
    public java.util.List<com.google.maps.routing.v2.TransitAgency.Builder>
        getAgenciesBuilderList() {
      return getAgenciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.TransitAgency,
            com.google.maps.routing.v2.TransitAgency.Builder,
            com.google.maps.routing.v2.TransitAgencyOrBuilder>
        getAgenciesFieldBuilder() {
      if (agenciesBuilder_ == null) {
        agenciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.TransitAgency,
                com.google.maps.routing.v2.TransitAgency.Builder,
                com.google.maps.routing.v2.TransitAgencyOrBuilder>(
                agencies_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        agencies_ = null;
      }
      return agenciesBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full name of this transit line, For example, "8 Avenue Local".
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of this transit line, For example, "8 Avenue Local".
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of this transit line, For example, "8 Avenue Local".
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of this transit line, For example, "8 Avenue Local".
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of this transit line, For example, "8 Avenue Local".
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * the URI for this transit line as provided by the transit agency.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * the URI for this transit line as provided by the transit agency.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * the URI for this transit line as provided by the transit agency.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * the URI for this transit line as provided by the transit agency.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * the URI for this transit line as provided by the transit agency.
     * </pre>
     *
     * <code>string uri = 3;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object color_ = "";
    /**
     *
     *
     * <pre>
     * The color commonly used in signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string color = 4;</code>
     *
     * @return The color.
     */
    public java.lang.String getColor() {
      java.lang.Object ref = color_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        color_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string color = 4;</code>
     *
     * @return The bytes for color.
     */
    public com.google.protobuf.ByteString getColorBytes() {
      java.lang.Object ref = color_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        color_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string color = 4;</code>
     *
     * @param value The color to set.
     * @return This builder for chaining.
     */
    public Builder setColor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      color_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string color = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColor() {
      color_ = getDefaultInstance().getColor();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string color = 4;</code>
     *
     * @param value The bytes for color to set.
     * @return This builder for chaining.
     */
    public Builder setColorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      color_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object iconUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this line.
     * </pre>
     *
     * <code>string icon_uri = 5;</code>
     *
     * @return The iconUri.
     */
    public java.lang.String getIconUri() {
      java.lang.Object ref = iconUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        iconUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this line.
     * </pre>
     *
     * <code>string icon_uri = 5;</code>
     *
     * @return The bytes for iconUri.
     */
    public com.google.protobuf.ByteString getIconUriBytes() {
      java.lang.Object ref = iconUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        iconUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this line.
     * </pre>
     *
     * <code>string icon_uri = 5;</code>
     *
     * @param value The iconUri to set.
     * @return This builder for chaining.
     */
    public Builder setIconUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iconUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this line.
     * </pre>
     *
     * <code>string icon_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIconUri() {
      iconUri_ = getDefaultInstance().getIconUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this line.
     * </pre>
     *
     * <code>string icon_uri = 5;</code>
     *
     * @param value The bytes for iconUri to set.
     * @return This builder for chaining.
     */
    public Builder setIconUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iconUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object nameShort_ = "";
    /**
     *
     *
     * <pre>
     * The short name of this transit line. This name will normally be a line
     * number, such as "M7" or "355".
     * </pre>
     *
     * <code>string name_short = 6;</code>
     *
     * @return The nameShort.
     */
    public java.lang.String getNameShort() {
      java.lang.Object ref = nameShort_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nameShort_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short name of this transit line. This name will normally be a line
     * number, such as "M7" or "355".
     * </pre>
     *
     * <code>string name_short = 6;</code>
     *
     * @return The bytes for nameShort.
     */
    public com.google.protobuf.ByteString getNameShortBytes() {
      java.lang.Object ref = nameShort_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nameShort_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short name of this transit line. This name will normally be a line
     * number, such as "M7" or "355".
     * </pre>
     *
     * <code>string name_short = 6;</code>
     *
     * @param value The nameShort to set.
     * @return This builder for chaining.
     */
    public Builder setNameShort(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nameShort_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short name of this transit line. This name will normally be a line
     * number, such as "M7" or "355".
     * </pre>
     *
     * <code>string name_short = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNameShort() {
      nameShort_ = getDefaultInstance().getNameShort();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short name of this transit line. This name will normally be a line
     * number, such as "M7" or "355".
     * </pre>
     *
     * <code>string name_short = 6;</code>
     *
     * @param value The bytes for nameShort to set.
     * @return This builder for chaining.
     */
    public Builder setNameShortBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nameShort_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object textColor_ = "";
    /**
     *
     *
     * <pre>
     * The color commonly used in text on signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string text_color = 7;</code>
     *
     * @return The textColor.
     */
    public java.lang.String getTextColor() {
      java.lang.Object ref = textColor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        textColor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in text on signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string text_color = 7;</code>
     *
     * @return The bytes for textColor.
     */
    public com.google.protobuf.ByteString getTextColorBytes() {
      java.lang.Object ref = textColor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        textColor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in text on signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string text_color = 7;</code>
     *
     * @param value The textColor to set.
     * @return This builder for chaining.
     */
    public Builder setTextColor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      textColor_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in text on signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string text_color = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTextColor() {
      textColor_ = getDefaultInstance().getTextColor();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The color commonly used in text on signage for this line. Represented in
     * hexadecimal.
     * </pre>
     *
     * <code>string text_color = 7;</code>
     *
     * @param value The bytes for textColor to set.
     * @return This builder for chaining.
     */
    public Builder setTextColorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      textColor_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.maps.routing.v2.TransitVehicle vehicle_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitVehicle,
            com.google.maps.routing.v2.TransitVehicle.Builder,
            com.google.maps.routing.v2.TransitVehicleOrBuilder>
        vehicleBuilder_;
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     *
     * @return Whether the vehicle field is set.
     */
    public boolean hasVehicle() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     *
     * @return The vehicle.
     */
    public com.google.maps.routing.v2.TransitVehicle getVehicle() {
      if (vehicleBuilder_ == null) {
        return vehicle_ == null
            ? com.google.maps.routing.v2.TransitVehicle.getDefaultInstance()
            : vehicle_;
      } else {
        return vehicleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    public Builder setVehicle(com.google.maps.routing.v2.TransitVehicle value) {
      if (vehicleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vehicle_ = value;
      } else {
        vehicleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    public Builder setVehicle(com.google.maps.routing.v2.TransitVehicle.Builder builderForValue) {
      if (vehicleBuilder_ == null) {
        vehicle_ = builderForValue.build();
      } else {
        vehicleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    public Builder mergeVehicle(com.google.maps.routing.v2.TransitVehicle value) {
      if (vehicleBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && vehicle_ != null
            && vehicle_ != com.google.maps.routing.v2.TransitVehicle.getDefaultInstance()) {
          getVehicleBuilder().mergeFrom(value);
        } else {
          vehicle_ = value;
        }
      } else {
        vehicleBuilder_.mergeFrom(value);
      }
      if (vehicle_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    public Builder clearVehicle() {
      bitField0_ = (bitField0_ & ~0x00000080);
      vehicle_ = null;
      if (vehicleBuilder_ != null) {
        vehicleBuilder_.dispose();
        vehicleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    public com.google.maps.routing.v2.TransitVehicle.Builder getVehicleBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getVehicleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    public com.google.maps.routing.v2.TransitVehicleOrBuilder getVehicleOrBuilder() {
      if (vehicleBuilder_ != null) {
        return vehicleBuilder_.getMessageOrBuilder();
      } else {
        return vehicle_ == null
            ? com.google.maps.routing.v2.TransitVehicle.getDefaultInstance()
            : vehicle_;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of vehicle that operates on this transit line.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle vehicle = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitVehicle,
            com.google.maps.routing.v2.TransitVehicle.Builder,
            com.google.maps.routing.v2.TransitVehicleOrBuilder>
        getVehicleFieldBuilder() {
      if (vehicleBuilder_ == null) {
        vehicleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.TransitVehicle,
                com.google.maps.routing.v2.TransitVehicle.Builder,
                com.google.maps.routing.v2.TransitVehicleOrBuilder>(
                getVehicle(), getParentForChildren(), isClean());
        vehicle_ = null;
      }
      return vehicleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.TransitLine)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.TransitLine)
  private static final com.google.maps.routing.v2.TransitLine DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.TransitLine();
  }

  public static com.google.maps.routing.v2.TransitLine getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitLine> PARSER =
      new com.google.protobuf.AbstractParser<TransitLine>() {
        @java.lang.Override
        public TransitLine parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitLine> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitLine> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.TransitLine getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
