/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/vehicle_emission_type.proto

// Protobuf Java Version: 3.25.3
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * A set of values describing the vehicle's emission type.
 * Applies only to the `DRIVE`
 * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
 * </pre>
 *
 * Protobuf enum {@code google.maps.routing.v2.VehicleEmissionType}
 */
public enum VehicleEmissionType implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * No emission type specified. Default to `GASOLINE`.
   * </pre>
   *
   * <code>VEHICLE_EMISSION_TYPE_UNSPECIFIED = 0;</code>
   */
  VEHICLE_EMISSION_TYPE_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * Gasoline/petrol fueled vehicle.
   * </pre>
   *
   * <code>GASOLINE = 1;</code>
   */
  GASOLINE(1),
  /**
   *
   *
   * <pre>
   * Electricity powered vehicle.
   * </pre>
   *
   * <code>ELECTRIC = 2;</code>
   */
  ELECTRIC(2),
  /**
   *
   *
   * <pre>
   * Hybrid fuel (such as gasoline + electric) vehicle.
   * </pre>
   *
   * <code>HYBRID = 3;</code>
   */
  HYBRID(3),
  /**
   *
   *
   * <pre>
   * Diesel fueled vehicle.
   * </pre>
   *
   * <code>DIESEL = 4;</code>
   */
  DIESEL(4),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * No emission type specified. Default to `GASOLINE`.
   * </pre>
   *
   * <code>VEHICLE_EMISSION_TYPE_UNSPECIFIED = 0;</code>
   */
  public static final int VEHICLE_EMISSION_TYPE_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * Gasoline/petrol fueled vehicle.
   * </pre>
   *
   * <code>GASOLINE = 1;</code>
   */
  public static final int GASOLINE_VALUE = 1;
  /**
   *
   *
   * <pre>
   * Electricity powered vehicle.
   * </pre>
   *
   * <code>ELECTRIC = 2;</code>
   */
  public static final int ELECTRIC_VALUE = 2;
  /**
   *
   *
   * <pre>
   * Hybrid fuel (such as gasoline + electric) vehicle.
   * </pre>
   *
   * <code>HYBRID = 3;</code>
   */
  public static final int HYBRID_VALUE = 3;
  /**
   *
   *
   * <pre>
   * Diesel fueled vehicle.
   * </pre>
   *
   * <code>DIESEL = 4;</code>
   */
  public static final int DIESEL_VALUE = 4;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static VehicleEmissionType valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static VehicleEmissionType forNumber(int value) {
    switch (value) {
      case 0:
        return VEHICLE_EMISSION_TYPE_UNSPECIFIED;
      case 1:
        return GASOLINE;
      case 2:
        return ELECTRIC;
      case 3:
        return HYBRID;
      case 4:
        return DIESEL;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<VehicleEmissionType>
      internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<VehicleEmissionType>
      internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<VehicleEmissionType>() {
            public VehicleEmissionType findValueByNumber(int number) {
              return VehicleEmissionType.forNumber(number);
            }
          };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.maps.routing.v2.VehicleEmissionTypeProto.getDescriptor()
        .getEnumTypes()
        .get(0);
  }

  private static final VehicleEmissionType[] VALUES = values();

  public static VehicleEmissionType valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private VehicleEmissionType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.VehicleEmissionType)
}
