/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/geocoding_results.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Contains [`GeocodedWaypoints`][google.maps.routing.v2.GeocodedWaypoint] for
 * origin, destination and intermediate waypoints. Only populated for address
 * waypoints.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.GeocodingResults}
 */
public final class GeocodingResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.GeocodingResults)
    GeocodingResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GeocodingResults.newBuilder() to construct.
  private GeocodingResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GeocodingResults() {
    intermediates_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GeocodingResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.GeocodingResultsProto
        .internal_static_google_maps_routing_v2_GeocodingResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.GeocodingResultsProto
        .internal_static_google_maps_routing_v2_GeocodingResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.GeocodingResults.class,
            com.google.maps.routing.v2.GeocodingResults.Builder.class);
  }

  private int bitField0_;
  public static final int ORIGIN_FIELD_NUMBER = 1;
  private com.google.maps.routing.v2.GeocodedWaypoint origin_;
  /**
   *
   *
   * <pre>
   * Origin geocoded waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
   *
   * @return Whether the origin field is set.
   */
  @java.lang.Override
  public boolean hasOrigin() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Origin geocoded waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
   *
   * @return The origin.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypoint getOrigin() {
    return origin_ == null
        ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
        : origin_;
  }
  /**
   *
   *
   * <pre>
   * Origin geocoded waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypointOrBuilder getOriginOrBuilder() {
    return origin_ == null
        ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
        : origin_;
  }

  public static final int DESTINATION_FIELD_NUMBER = 2;
  private com.google.maps.routing.v2.GeocodedWaypoint destination_;
  /**
   *
   *
   * <pre>
   * Destination geocoded waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Destination geocoded waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypoint getDestination() {
    return destination_ == null
        ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
        : destination_;
  }
  /**
   *
   *
   * <pre>
   * Destination geocoded waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypointOrBuilder getDestinationOrBuilder() {
    return destination_ == null
        ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
        : destination_;
  }

  public static final int INTERMEDIATES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.GeocodedWaypoint> intermediates_;
  /**
   *
   *
   * <pre>
   * A list of intermediate geocoded waypoints each containing an index field
   * that corresponds to the zero-based position of the waypoint in the order
   * they were specified in the request.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.GeocodedWaypoint> getIntermediatesList() {
    return intermediates_;
  }
  /**
   *
   *
   * <pre>
   * A list of intermediate geocoded waypoints each containing an index field
   * that corresponds to the zero-based position of the waypoint in the order
   * they were specified in the request.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
      getIntermediatesOrBuilderList() {
    return intermediates_;
  }
  /**
   *
   *
   * <pre>
   * A list of intermediate geocoded waypoints each containing an index field
   * that corresponds to the zero-based position of the waypoint in the order
   * they were specified in the request.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
   */
  @java.lang.Override
  public int getIntermediatesCount() {
    return intermediates_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of intermediate geocoded waypoints each containing an index field
   * that corresponds to the zero-based position of the waypoint in the order
   * they were specified in the request.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypoint getIntermediates(int index) {
    return intermediates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of intermediate geocoded waypoints each containing an index field
   * that corresponds to the zero-based position of the waypoint in the order
   * they were specified in the request.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypointOrBuilder getIntermediatesOrBuilder(int index) {
    return intermediates_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getOrigin());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getDestination());
    }
    for (int i = 0; i < intermediates_.size(); i++) {
      output.writeMessage(3, intermediates_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOrigin());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDestination());
    }
    for (int i = 0; i < intermediates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, intermediates_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.GeocodingResults)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.GeocodingResults other =
        (com.google.maps.routing.v2.GeocodingResults) obj;

    if (hasOrigin() != other.hasOrigin()) return false;
    if (hasOrigin()) {
      if (!getOrigin().equals(other.getOrigin())) return false;
    }
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (!getIntermediatesList().equals(other.getIntermediatesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOrigin()) {
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
    }
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (getIntermediatesCount() > 0) {
      hash = (37 * hash) + INTERMEDIATES_FIELD_NUMBER;
      hash = (53 * hash) + getIntermediatesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.GeocodingResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.GeocodingResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains [`GeocodedWaypoints`][google.maps.routing.v2.GeocodedWaypoint] for
   * origin, destination and intermediate waypoints. Only populated for address
   * waypoints.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.GeocodingResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.GeocodingResults)
      com.google.maps.routing.v2.GeocodingResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.GeocodingResultsProto
          .internal_static_google_maps_routing_v2_GeocodingResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.GeocodingResultsProto
          .internal_static_google_maps_routing_v2_GeocodingResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.GeocodingResults.class,
              com.google.maps.routing.v2.GeocodingResults.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.GeocodingResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOriginFieldBuilder();
        getDestinationFieldBuilder();
        getIntermediatesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      origin_ = null;
      if (originBuilder_ != null) {
        originBuilder_.dispose();
        originBuilder_ = null;
      }
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      if (intermediatesBuilder_ == null) {
        intermediates_ = java.util.Collections.emptyList();
      } else {
        intermediates_ = null;
        intermediatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.GeocodingResultsProto
          .internal_static_google_maps_routing_v2_GeocodingResults_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.GeocodingResults getDefaultInstanceForType() {
      return com.google.maps.routing.v2.GeocodingResults.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.GeocodingResults build() {
      com.google.maps.routing.v2.GeocodingResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.GeocodingResults buildPartial() {
      com.google.maps.routing.v2.GeocodingResults result =
          new com.google.maps.routing.v2.GeocodingResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.GeocodingResults result) {
      if (intermediatesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          intermediates_ = java.util.Collections.unmodifiableList(intermediates_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.intermediates_ = intermediates_;
      } else {
        result.intermediates_ = intermediatesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.routing.v2.GeocodingResults result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.origin_ = originBuilder_ == null ? origin_ : originBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destination_ =
            destinationBuilder_ == null ? destination_ : destinationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.GeocodingResults) {
        return mergeFrom((com.google.maps.routing.v2.GeocodingResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.GeocodingResults other) {
      if (other == com.google.maps.routing.v2.GeocodingResults.getDefaultInstance()) return this;
      if (other.hasOrigin()) {
        mergeOrigin(other.getOrigin());
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (intermediatesBuilder_ == null) {
        if (!other.intermediates_.isEmpty()) {
          if (intermediates_.isEmpty()) {
            intermediates_ = other.intermediates_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureIntermediatesIsMutable();
            intermediates_.addAll(other.intermediates_);
          }
          onChanged();
        }
      } else {
        if (!other.intermediates_.isEmpty()) {
          if (intermediatesBuilder_.isEmpty()) {
            intermediatesBuilder_.dispose();
            intermediatesBuilder_ = null;
            intermediates_ = other.intermediates_;
            bitField0_ = (bitField0_ & ~0x00000004);
            intermediatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIntermediatesFieldBuilder()
                    : null;
          } else {
            intermediatesBuilder_.addAllMessages(other.intermediates_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOriginFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.maps.routing.v2.GeocodedWaypoint m =
                    input.readMessage(
                        com.google.maps.routing.v2.GeocodedWaypoint.parser(), extensionRegistry);
                if (intermediatesBuilder_ == null) {
                  ensureIntermediatesIsMutable();
                  intermediates_.add(m);
                } else {
                  intermediatesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.routing.v2.GeocodedWaypoint origin_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.GeocodedWaypoint,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder,
            com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        originBuilder_;
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     *
     * @return Whether the origin field is set.
     */
    public boolean hasOrigin() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     *
     * @return The origin.
     */
    public com.google.maps.routing.v2.GeocodedWaypoint getOrigin() {
      if (originBuilder_ == null) {
        return origin_ == null
            ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
            : origin_;
      } else {
        return originBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    public Builder setOrigin(com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (originBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        origin_ = value;
      } else {
        originBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    public Builder setOrigin(com.google.maps.routing.v2.GeocodedWaypoint.Builder builderForValue) {
      if (originBuilder_ == null) {
        origin_ = builderForValue.build();
      } else {
        originBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    public Builder mergeOrigin(com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (originBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && origin_ != null
            && origin_ != com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()) {
          getOriginBuilder().mergeFrom(value);
        } else {
          origin_ = value;
        }
      } else {
        originBuilder_.mergeFrom(value);
      }
      if (origin_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    public Builder clearOrigin() {
      bitField0_ = (bitField0_ & ~0x00000001);
      origin_ = null;
      if (originBuilder_ != null) {
        originBuilder_.dispose();
        originBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypoint.Builder getOriginBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getOriginFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypointOrBuilder getOriginOrBuilder() {
      if (originBuilder_ != null) {
        return originBuilder_.getMessageOrBuilder();
      } else {
        return origin_ == null
            ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
            : origin_;
      }
    }
    /**
     *
     *
     * <pre>
     * Origin geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint origin = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.GeocodedWaypoint,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder,
            com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        getOriginFieldBuilder() {
      if (originBuilder_ == null) {
        originBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.GeocodedWaypoint,
                com.google.maps.routing.v2.GeocodedWaypoint.Builder,
                com.google.maps.routing.v2.GeocodedWaypointOrBuilder>(
                getOrigin(), getParentForChildren(), isClean());
        origin_ = null;
      }
      return originBuilder_;
    }

    private com.google.maps.routing.v2.GeocodedWaypoint destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.GeocodedWaypoint,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder,
            com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        destinationBuilder_;
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     *
     * @return The destination.
     */
    public com.google.maps.routing.v2.GeocodedWaypoint getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    public Builder setDestination(com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
      } else {
        destinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    public Builder setDestination(
        com.google.maps.routing.v2.GeocodedWaypoint.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    public Builder mergeDestination(com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (destinationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && destination_ != null
            && destination_ != com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()) {
          getDestinationBuilder().mergeFrom(value);
        } else {
          destination_ = value;
        }
      } else {
        destinationBuilder_.mergeFrom(value);
      }
      if (destination_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    public Builder clearDestination() {
      bitField0_ = (bitField0_ & ~0x00000002);
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypoint.Builder getDestinationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypointOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()
            : destination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination geocoded waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodedWaypoint destination = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.GeocodedWaypoint,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder,
            com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.GeocodedWaypoint,
                com.google.maps.routing.v2.GeocodedWaypoint.Builder,
                com.google.maps.routing.v2.GeocodedWaypointOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private java.util.List<com.google.maps.routing.v2.GeocodedWaypoint> intermediates_ =
        java.util.Collections.emptyList();

    private void ensureIntermediatesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        intermediates_ =
            new java.util.ArrayList<com.google.maps.routing.v2.GeocodedWaypoint>(intermediates_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.GeocodedWaypoint,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder,
            com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        intermediatesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public java.util.List<com.google.maps.routing.v2.GeocodedWaypoint> getIntermediatesList() {
      if (intermediatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(intermediates_);
      } else {
        return intermediatesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public int getIntermediatesCount() {
      if (intermediatesBuilder_ == null) {
        return intermediates_.size();
      } else {
        return intermediatesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypoint getIntermediates(int index) {
      if (intermediatesBuilder_ == null) {
        return intermediates_.get(index);
      } else {
        return intermediatesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder setIntermediates(int index, com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (intermediatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntermediatesIsMutable();
        intermediates_.set(index, value);
        onChanged();
      } else {
        intermediatesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder setIntermediates(
        int index, com.google.maps.routing.v2.GeocodedWaypoint.Builder builderForValue) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.set(index, builderForValue.build());
        onChanged();
      } else {
        intermediatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder addIntermediates(com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (intermediatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntermediatesIsMutable();
        intermediates_.add(value);
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder addIntermediates(int index, com.google.maps.routing.v2.GeocodedWaypoint value) {
      if (intermediatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntermediatesIsMutable();
        intermediates_.add(index, value);
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder addIntermediates(
        com.google.maps.routing.v2.GeocodedWaypoint.Builder builderForValue) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.add(builderForValue.build());
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder addIntermediates(
        int index, com.google.maps.routing.v2.GeocodedWaypoint.Builder builderForValue) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.add(index, builderForValue.build());
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder addAllIntermediates(
        java.lang.Iterable<? extends com.google.maps.routing.v2.GeocodedWaypoint> values) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intermediates_);
        onChanged();
      } else {
        intermediatesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder clearIntermediates() {
      if (intermediatesBuilder_ == null) {
        intermediates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        intermediatesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public Builder removeIntermediates(int index) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.remove(index);
        onChanged();
      } else {
        intermediatesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypoint.Builder getIntermediatesBuilder(int index) {
      return getIntermediatesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypointOrBuilder getIntermediatesOrBuilder(
        int index) {
      if (intermediatesBuilder_ == null) {
        return intermediates_.get(index);
      } else {
        return intermediatesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        getIntermediatesOrBuilderList() {
      if (intermediatesBuilder_ != null) {
        return intermediatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(intermediates_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypoint.Builder addIntermediatesBuilder() {
      return getIntermediatesFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodedWaypoint.Builder addIntermediatesBuilder(int index) {
      return getIntermediatesFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of intermediate geocoded waypoints each containing an index field
     * that corresponds to the zero-based position of the waypoint in the order
     * they were specified in the request.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.GeocodedWaypoint intermediates = 3;</code>
     */
    public java.util.List<com.google.maps.routing.v2.GeocodedWaypoint.Builder>
        getIntermediatesBuilderList() {
      return getIntermediatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.GeocodedWaypoint,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder,
            com.google.maps.routing.v2.GeocodedWaypointOrBuilder>
        getIntermediatesFieldBuilder() {
      if (intermediatesBuilder_ == null) {
        intermediatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.GeocodedWaypoint,
                com.google.maps.routing.v2.GeocodedWaypoint.Builder,
                com.google.maps.routing.v2.GeocodedWaypointOrBuilder>(
                intermediates_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        intermediates_ = null;
      }
      return intermediatesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.GeocodingResults)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.GeocodingResults)
  private static final com.google.maps.routing.v2.GeocodingResults DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.GeocodingResults();
  }

  public static com.google.maps.routing.v2.GeocodingResults getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GeocodingResults> PARSER =
      new com.google.protobuf.AbstractParser<GeocodingResults>() {
        @java.lang.Override
        public GeocodingResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GeocodingResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GeocodingResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.GeocodingResults getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
