/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/routes_service.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * ComputeRoutes request message.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.ComputeRoutesRequest}
 */
public final class ComputeRoutesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.ComputeRoutesRequest)
    ComputeRoutesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ComputeRoutesRequest.newBuilder() to construct.
  private ComputeRoutesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeRoutesRequest() {
    intermediates_ = java.util.Collections.emptyList();
    travelMode_ = 0;
    routingPreference_ = 0;
    polylineQuality_ = 0;
    polylineEncoding_ = 0;
    languageCode_ = "";
    regionCode_ = "";
    units_ = 0;
    requestedReferenceRoutes_ = java.util.Collections.emptyList();
    extraComputations_ = java.util.Collections.emptyList();
    trafficModel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeRoutesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RoutesServiceProto
        .internal_static_google_maps_routing_v2_ComputeRoutesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RoutesServiceProto
        .internal_static_google_maps_routing_v2_ComputeRoutesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.ComputeRoutesRequest.class,
            com.google.maps.routing.v2.ComputeRoutesRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A supported reference route on the ComputeRoutesRequest.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute}
   */
  public enum ReferenceRoute implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used. Requests containing this value fail.
     * </pre>
     *
     * <code>REFERENCE_ROUTE_UNSPECIFIED = 0;</code>
     */
    REFERENCE_ROUTE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Fuel efficient route.
     * </pre>
     *
     * <code>FUEL_EFFICIENT = 1;</code>
     */
    FUEL_EFFICIENT(1),
    /**
     *
     *
     * <pre>
     * Route with shorter travel distance. This is an experimental feature.
     *
     * For `DRIVE` requests, this feature prioritizes shorter distance over
     * driving comfort. For example, it may prefer local roads instead of
     * highways, take dirt roads, cut through parking lots, etc. This feature
     * does not return any maneuvers that Google Maps knows to be illegal.
     *
     * For `BICYCLE` and `TWO_WHEELER` requests, this feature returns routes
     * similar to those returned when you don't specify
     * `requested_reference_routes`.
     *
     * This feature is not compatible with any other travel modes, via
     * intermediate waypoints, or `optimize_waypoint_order`; such requests will
     * fail. However, you can use it with any `routing_preference`.
     * </pre>
     *
     * <code>SHORTER_DISTANCE = 2;</code>
     */
    SHORTER_DISTANCE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used. Requests containing this value fail.
     * </pre>
     *
     * <code>REFERENCE_ROUTE_UNSPECIFIED = 0;</code>
     */
    public static final int REFERENCE_ROUTE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Fuel efficient route.
     * </pre>
     *
     * <code>FUEL_EFFICIENT = 1;</code>
     */
    public static final int FUEL_EFFICIENT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Route with shorter travel distance. This is an experimental feature.
     *
     * For `DRIVE` requests, this feature prioritizes shorter distance over
     * driving comfort. For example, it may prefer local roads instead of
     * highways, take dirt roads, cut through parking lots, etc. This feature
     * does not return any maneuvers that Google Maps knows to be illegal.
     *
     * For `BICYCLE` and `TWO_WHEELER` requests, this feature returns routes
     * similar to those returned when you don't specify
     * `requested_reference_routes`.
     *
     * This feature is not compatible with any other travel modes, via
     * intermediate waypoints, or `optimize_waypoint_order`; such requests will
     * fail. However, you can use it with any `routing_preference`.
     * </pre>
     *
     * <code>SHORTER_DISTANCE = 2;</code>
     */
    public static final int SHORTER_DISTANCE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReferenceRoute valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ReferenceRoute forNumber(int value) {
      switch (value) {
        case 0:
          return REFERENCE_ROUTE_UNSPECIFIED;
        case 1:
          return FUEL_EFFICIENT;
        case 2:
          return SHORTER_DISTANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ReferenceRoute> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ReferenceRoute> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ReferenceRoute>() {
          public ReferenceRoute findValueByNumber(int number) {
            return ReferenceRoute.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.ComputeRoutesRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final ReferenceRoute[] VALUES = values();

    public static ReferenceRoute valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ReferenceRoute(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute)
  }

  /**
   *
   *
   * <pre>
   * Extra computations to perform while completing the request.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation}
   */
  public enum ExtraComputation implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used. Requests containing this value will fail.
     * </pre>
     *
     * <code>EXTRA_COMPUTATION_UNSPECIFIED = 0;</code>
     */
    EXTRA_COMPUTATION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Toll information for the route(s).
     * </pre>
     *
     * <code>TOLLS = 1;</code>
     */
    TOLLS(1),
    /**
     *
     *
     * <pre>
     * Estimated fuel consumption for the route(s).
     * </pre>
     *
     * <code>FUEL_CONSUMPTION = 2;</code>
     */
    FUEL_CONSUMPTION(2),
    /**
     *
     *
     * <pre>
     * Traffic aware polylines for the route(s).
     * </pre>
     *
     * <code>TRAFFIC_ON_POLYLINE = 3;</code>
     */
    TRAFFIC_ON_POLYLINE(3),
    /**
     *
     *
     * <pre>
     * [`NavigationInstructions`](google.maps.routing.v2.NavigationInstructions.instructions)
     * presented as a formatted HTML text string. This content
     * is meant to be read as-is. This content is for display only.
     * Do not programmatically parse it.
     * </pre>
     *
     * <code>HTML_FORMATTED_NAVIGATION_INSTRUCTIONS = 4;</code>
     */
    HTML_FORMATTED_NAVIGATION_INSTRUCTIONS(4),
    /**
     *
     *
     * <pre>
     * Flyover information for the route(s). The
     * `routes.polyline_details.flyover_info` fieldmask must be specified to
     * return this information. This data will only currently be populated for
     * certain metros in India. This feature is experimental, and the
     * SKU/charge is subject to change.
     * </pre>
     *
     * <code>FLYOVER_INFO_ON_POLYLINE = 7;</code>
     */
    FLYOVER_INFO_ON_POLYLINE(7),
    /**
     *
     *
     * <pre>
     * Narrow road information for the route(s). The
     * `routes.polyline_details.narrow_road_info` fieldmask must be specified
     * to return this information. This data will only currently be populated
     * for certain metros in India. This feature is experimental, and the
     * SKU/charge is subject to change.
     * </pre>
     *
     * <code>NARROW_ROAD_INFO_ON_POLYLINE = 8;</code>
     */
    NARROW_ROAD_INFO_ON_POLYLINE(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used. Requests containing this value will fail.
     * </pre>
     *
     * <code>EXTRA_COMPUTATION_UNSPECIFIED = 0;</code>
     */
    public static final int EXTRA_COMPUTATION_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Toll information for the route(s).
     * </pre>
     *
     * <code>TOLLS = 1;</code>
     */
    public static final int TOLLS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Estimated fuel consumption for the route(s).
     * </pre>
     *
     * <code>FUEL_CONSUMPTION = 2;</code>
     */
    public static final int FUEL_CONSUMPTION_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Traffic aware polylines for the route(s).
     * </pre>
     *
     * <code>TRAFFIC_ON_POLYLINE = 3;</code>
     */
    public static final int TRAFFIC_ON_POLYLINE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * [`NavigationInstructions`](google.maps.routing.v2.NavigationInstructions.instructions)
     * presented as a formatted HTML text string. This content
     * is meant to be read as-is. This content is for display only.
     * Do not programmatically parse it.
     * </pre>
     *
     * <code>HTML_FORMATTED_NAVIGATION_INSTRUCTIONS = 4;</code>
     */
    public static final int HTML_FORMATTED_NAVIGATION_INSTRUCTIONS_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Flyover information for the route(s). The
     * `routes.polyline_details.flyover_info` fieldmask must be specified to
     * return this information. This data will only currently be populated for
     * certain metros in India. This feature is experimental, and the
     * SKU/charge is subject to change.
     * </pre>
     *
     * <code>FLYOVER_INFO_ON_POLYLINE = 7;</code>
     */
    public static final int FLYOVER_INFO_ON_POLYLINE_VALUE = 7;

    /**
     *
     *
     * <pre>
     * Narrow road information for the route(s). The
     * `routes.polyline_details.narrow_road_info` fieldmask must be specified
     * to return this information. This data will only currently be populated
     * for certain metros in India. This feature is experimental, and the
     * SKU/charge is subject to change.
     * </pre>
     *
     * <code>NARROW_ROAD_INFO_ON_POLYLINE = 8;</code>
     */
    public static final int NARROW_ROAD_INFO_ON_POLYLINE_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExtraComputation valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ExtraComputation forNumber(int value) {
      switch (value) {
        case 0:
          return EXTRA_COMPUTATION_UNSPECIFIED;
        case 1:
          return TOLLS;
        case 2:
          return FUEL_CONSUMPTION;
        case 3:
          return TRAFFIC_ON_POLYLINE;
        case 4:
          return HTML_FORMATTED_NAVIGATION_INSTRUCTIONS;
        case 7:
          return FLYOVER_INFO_ON_POLYLINE;
        case 8:
          return NARROW_ROAD_INFO_ON_POLYLINE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ExtraComputation> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ExtraComputation>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ExtraComputation>() {
              public ExtraComputation findValueByNumber(int number) {
                return ExtraComputation.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.ComputeRoutesRequest.getDescriptor().getEnumTypes().get(1);
    }

    private static final ExtraComputation[] VALUES = values();

    public static ExtraComputation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ExtraComputation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation)
  }

  private int bitField0_;
  public static final int ORIGIN_FIELD_NUMBER = 1;
  private com.google.maps.routing.v2.Waypoint origin_;

  /**
   *
   *
   * <pre>
   * Required. Origin waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the origin field is set.
   */
  @java.lang.Override
  public boolean hasOrigin() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Origin waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The origin.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Waypoint getOrigin() {
    return origin_ == null ? com.google.maps.routing.v2.Waypoint.getDefaultInstance() : origin_;
  }

  /**
   *
   *
   * <pre>
   * Required. Origin waypoint.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.WaypointOrBuilder getOriginOrBuilder() {
    return origin_ == null ? com.google.maps.routing.v2.Waypoint.getDefaultInstance() : origin_;
  }

  public static final int DESTINATION_FIELD_NUMBER = 2;
  private com.google.maps.routing.v2.Waypoint destination_;

  /**
   *
   *
   * <pre>
   * Required. Destination waypoint.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destination field is set.
   */
  @java.lang.Override
  public boolean hasDestination() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Destination waypoint.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destination.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Waypoint getDestination() {
    return destination_ == null
        ? com.google.maps.routing.v2.Waypoint.getDefaultInstance()
        : destination_;
  }

  /**
   *
   *
   * <pre>
   * Required. Destination waypoint.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.WaypointOrBuilder getDestinationOrBuilder() {
    return destination_ == null
        ? com.google.maps.routing.v2.Waypoint.getDefaultInstance()
        : destination_;
  }

  public static final int INTERMEDIATES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.Waypoint> intermediates_;

  /**
   *
   *
   * <pre>
   * Optional. A set of waypoints along the route (excluding terminal points),
   * for either stopping at or passing by. Up to 25 intermediate waypoints are
   * supported.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.Waypoint> getIntermediatesList() {
    return intermediates_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of waypoints along the route (excluding terminal points),
   * for either stopping at or passing by. Up to 25 intermediate waypoints are
   * supported.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.WaypointOrBuilder>
      getIntermediatesOrBuilderList() {
    return intermediates_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of waypoints along the route (excluding terminal points),
   * for either stopping at or passing by. Up to 25 intermediate waypoints are
   * supported.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getIntermediatesCount() {
    return intermediates_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of waypoints along the route (excluding terminal points),
   * for either stopping at or passing by. Up to 25 intermediate waypoints are
   * supported.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Waypoint getIntermediates(int index) {
    return intermediates_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of waypoints along the route (excluding terminal points),
   * for either stopping at or passing by. Up to 25 intermediate waypoints are
   * supported.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.WaypointOrBuilder getIntermediatesOrBuilder(int index) {
    return intermediates_.get(index);
  }

  public static final int TRAVEL_MODE_FIELD_NUMBER = 4;
  private int travelMode_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Specifies the mode of transportation.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for travelMode.
   */
  @java.lang.Override
  public int getTravelModeValue() {
    return travelMode_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the mode of transportation.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The travelMode.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteTravelMode getTravelMode() {
    com.google.maps.routing.v2.RouteTravelMode result =
        com.google.maps.routing.v2.RouteTravelMode.forNumber(travelMode_);
    return result == null ? com.google.maps.routing.v2.RouteTravelMode.UNRECOGNIZED : result;
  }

  public static final int ROUTING_PREFERENCE_FIELD_NUMBER = 5;
  private int routingPreference_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Specifies how to compute the route. The server
   * attempts to use the selected routing preference to compute the route. If
   *  the routing preference results in an error or an extra long latency, then
   * an error is returned. You can specify this option only when the
   * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for routingPreference.
   */
  @java.lang.Override
  public int getRoutingPreferenceValue() {
    return routingPreference_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies how to compute the route. The server
   * attempts to use the selected routing preference to compute the route. If
   *  the routing preference results in an error or an extra long latency, then
   * an error is returned. You can specify this option only when the
   * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The routingPreference.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RoutingPreference getRoutingPreference() {
    com.google.maps.routing.v2.RoutingPreference result =
        com.google.maps.routing.v2.RoutingPreference.forNumber(routingPreference_);
    return result == null ? com.google.maps.routing.v2.RoutingPreference.UNRECOGNIZED : result;
  }

  public static final int POLYLINE_QUALITY_FIELD_NUMBER = 6;
  private int polylineQuality_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Specifies your preference for the quality of the polyline.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for polylineQuality.
   */
  @java.lang.Override
  public int getPolylineQualityValue() {
    return polylineQuality_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies your preference for the quality of the polyline.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The polylineQuality.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineQuality getPolylineQuality() {
    com.google.maps.routing.v2.PolylineQuality result =
        com.google.maps.routing.v2.PolylineQuality.forNumber(polylineQuality_);
    return result == null ? com.google.maps.routing.v2.PolylineQuality.UNRECOGNIZED : result;
  }

  public static final int POLYLINE_ENCODING_FIELD_NUMBER = 12;
  private int polylineEncoding_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Specifies the preferred encoding for the polyline.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for polylineEncoding.
   */
  @java.lang.Override
  public int getPolylineEncodingValue() {
    return polylineEncoding_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the preferred encoding for the polyline.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The polylineEncoding.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineEncoding getPolylineEncoding() {
    com.google.maps.routing.v2.PolylineEncoding result =
        com.google.maps.routing.v2.PolylineEncoding.forNumber(polylineEncoding_);
    return result == null ? com.google.maps.routing.v2.PolylineEncoding.UNRECOGNIZED : result;
  }

  public static final int DEPARTURE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp departureTime_;

  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
   * days in the future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the departureTime field is set.
   */
  @java.lang.Override
  public boolean hasDepartureTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
   * days in the future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The departureTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDepartureTime() {
    return departureTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : departureTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The departure time. If you don't set this value, then this value
   * defaults to the time that you made the request.
   * NOTE: You can only specify a `departure_time` in the past when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
   * days in the future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder() {
    return departureTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : departureTime_;
  }

  public static final int ARRIVAL_TIME_FIELD_NUMBER = 19;
  private com.google.protobuf.Timestamp arrivalTime_;

  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
   * not both. Transit trips are available for up to 7 days in the past or 100
   * days in the future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the arrivalTime field is set.
   */
  @java.lang.Override
  public boolean hasArrivalTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
   * not both. Transit trips are available for up to 7 days in the past or 100
   * days in the future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The arrivalTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getArrivalTime() {
    return arrivalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : arrivalTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The arrival time.
   * NOTE: Can only be set when
   * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
   * not both. Transit trips are available for up to 7 days in the past or 100
   * days in the future.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder() {
    return arrivalTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : arrivalTime_;
  }

  public static final int COMPUTE_ALTERNATIVE_ROUTES_FIELD_NUMBER = 8;
  private boolean computeAlternativeRoutes_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Specifies whether to calculate alternate routes in addition to
   * the route. No alternative routes are returned for requests that have
   * intermediate waypoints.
   * </pre>
   *
   * <code>bool compute_alternative_routes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The computeAlternativeRoutes.
   */
  @java.lang.Override
  public boolean getComputeAlternativeRoutes() {
    return computeAlternativeRoutes_;
  }

  public static final int ROUTE_MODIFIERS_FIELD_NUMBER = 9;
  private com.google.maps.routing.v2.RouteModifiers routeModifiers_;

  /**
   *
   *
   * <pre>
   * Optional. A set of conditions to satisfy that affect the way routes are
   * calculated.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the routeModifiers field is set.
   */
  @java.lang.Override
  public boolean hasRouteModifiers() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of conditions to satisfy that affect the way routes are
   * calculated.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The routeModifiers.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteModifiers getRouteModifiers() {
    return routeModifiers_ == null
        ? com.google.maps.routing.v2.RouteModifiers.getDefaultInstance()
        : routeModifiers_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A set of conditions to satisfy that affect the way routes are
   * calculated.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteModifiersOrBuilder getRouteModifiersOrBuilder() {
    return routeModifiers_ == null
        ? com.google.maps.routing.v2.RouteModifiers.getDefaultInstance()
        : routeModifiers_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see [Unicode Locale
   * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
   * See [Language
   * Support](https://developers.google.com/maps/faq#languagesupport)
   * for the list of supported languages. When you don't provide this value, the
   * display language is inferred from the location of the route request.
   * </pre>
   *
   * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
   * information, see [Unicode Locale
   * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
   * See [Language
   * Support](https://developers.google.com/maps/faq#languagesupport)
   * for the list of supported languages. When you don't provide this value, the
   * display language is inferred from the location of the route request.
   * </pre>
   *
   * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_CODE_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object regionCode_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The region code, specified as a ccTLD ("top-level domain")
   * two-character value. For more information see [Country code top-level
   * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
   * </pre>
   *
   * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The regionCode.
   */
  @java.lang.Override
  public java.lang.String getRegionCode() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regionCode_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The region code, specified as a ccTLD ("top-level domain")
   * two-character value. For more information see [Country code top-level
   * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
   * </pre>
   *
   * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for regionCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionCodeBytes() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      regionCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNITS_FIELD_NUMBER = 11;
  private int units_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Specifies the units of measure for the display fields. These
   * fields include the `instruction` field in
   * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
   * The units of measure used for the route, leg, step distance, and duration
   * are not affected by this value. If you don't provide this value, then the
   * display units are inferred from the location of the first origin.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for units.
   */
  @java.lang.Override
  public int getUnitsValue() {
    return units_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the units of measure for the display fields. These
   * fields include the `instruction` field in
   * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
   * The units of measure used for the route, leg, step distance, and duration
   * are not affected by this value. If you don't provide this value, then the
   * display units are inferred from the location of the first origin.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The units.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Units getUnits() {
    com.google.maps.routing.v2.Units result = com.google.maps.routing.v2.Units.forNumber(units_);
    return result == null ? com.google.maps.routing.v2.Units.UNRECOGNIZED : result;
  }

  public static final int OPTIMIZE_WAYPOINT_ORDER_FIELD_NUMBER = 13;
  private boolean optimizeWaypointOrder_ = false;

  /**
   *
   *
   * <pre>
   * Optional. If set to true, the service attempts to minimize the overall cost
   * of the route by re-ordering the specified intermediate waypoints. The
   * request fails if any of the intermediate waypoints is a `via` waypoint. Use
   * `ComputeRoutesResponse.Routes.optimized_intermediate_waypoint_index` to
   * find the new ordering.
   * If `ComputeRoutesResponseroutes.optimized_intermediate_waypoint_index` is
   * not requested in the `X-Goog-FieldMask` header, the request fails.
   * If `optimize_waypoint_order` is set to false,
   * `ComputeRoutesResponse.optimized_intermediate_waypoint_index` will be
   * empty.
   * </pre>
   *
   * <code>bool optimize_waypoint_order = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The optimizeWaypointOrder.
   */
  @java.lang.Override
  public boolean getOptimizeWaypointOrder() {
    return optimizeWaypointOrder_;
  }

  public static final int REQUESTED_REFERENCE_ROUTES_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> requestedReferenceRoutes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>
      requestedReferenceRoutes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>() {
            public com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute convert(
                java.lang.Integer from) {
              com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute result =
                  com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute.forNumber(from);
              return result == null
                  ? com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. Specifies what reference routes to calculate as part of the
   * request in addition to the default route. A reference route is a route with
   * a different route calculation objective than the default route. For example
   * a `FUEL_EFFICIENT` reference route calculation takes into account various
   * parameters that would generate an optimal fuel efficient route. When using
   * this feature, look for
   * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
   * resulting routes.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the requestedReferenceRoutes.
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>
      getRequestedReferenceRoutesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>(
        requestedReferenceRoutes_, requestedReferenceRoutes_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies what reference routes to calculate as part of the
   * request in addition to the default route. A reference route is a route with
   * a different route calculation objective than the default route. For example
   * a `FUEL_EFFICIENT` reference route calculation takes into account various
   * parameters that would generate an optimal fuel efficient route. When using
   * this feature, look for
   * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
   * resulting routes.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of requestedReferenceRoutes.
   */
  @java.lang.Override
  public int getRequestedReferenceRoutesCount() {
    return requestedReferenceRoutes_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies what reference routes to calculate as part of the
   * request in addition to the default route. A reference route is a route with
   * a different route calculation objective than the default route. For example
   * a `FUEL_EFFICIENT` reference route calculation takes into account various
   * parameters that would generate an optimal fuel efficient route. When using
   * this feature, look for
   * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
   * resulting routes.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The requestedReferenceRoutes at the given index.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute getRequestedReferenceRoutes(
      int index) {
    return requestedReferenceRoutes_converter_.convert(requestedReferenceRoutes_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies what reference routes to calculate as part of the
   * request in addition to the default route. A reference route is a route with
   * a different route calculation objective than the default route. For example
   * a `FUEL_EFFICIENT` reference route calculation takes into account various
   * parameters that would generate an optimal fuel efficient route. When using
   * this feature, look for
   * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
   * resulting routes.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for requestedReferenceRoutes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getRequestedReferenceRoutesValueList() {
    return requestedReferenceRoutes_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies what reference routes to calculate as part of the
   * request in addition to the default route. A reference route is a route with
   * a different route calculation objective than the default route. For example
   * a `FUEL_EFFICIENT` reference route calculation takes into account various
   * parameters that would generate an optimal fuel efficient route. When using
   * this feature, look for
   * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
   * resulting routes.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of requestedReferenceRoutes at the given index.
   */
  @java.lang.Override
  public int getRequestedReferenceRoutesValue(int index) {
    return requestedReferenceRoutes_.get(index);
  }

  private int requestedReferenceRoutesMemoizedSerializedSize;

  public static final int EXTRA_COMPUTATIONS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> extraComputations_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>
      extraComputations_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>() {
            public com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation convert(
                java.lang.Integer from) {
              com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation result =
                  com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation.forNumber(from);
              return result == null
                  ? com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the extraComputations.
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>
      getExtraComputationsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>(
        extraComputations_, extraComputations_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of extraComputations.
   */
  @java.lang.Override
  public int getExtraComputationsCount() {
    return extraComputations_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The extraComputations at the given index.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation getExtraComputations(
      int index) {
    return extraComputations_converter_.convert(extraComputations_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for extraComputations.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getExtraComputationsValueList() {
    return extraComputations_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of extra computations which may be used to complete the
   * request. Note: These extra computations may return extra fields on the
   * response. These extra fields must also be specified in the field mask to be
   * returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of extraComputations at the given index.
   */
  @java.lang.Override
  public int getExtraComputationsValue(int index) {
    return extraComputations_.get(index);
  }

  private int extraComputationsMemoizedSerializedSize;

  public static final int TRAFFIC_MODEL_FIELD_NUMBER = 18;
  private int trafficModel_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Specifies the assumptions to use when calculating time in
   * traffic. This setting affects the value returned in the duration field in
   * the
   * [`Route`][google.maps.routing.v2.Route] and
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
   * time in traffic based on historical averages.
   * `TrafficModel` is only available for requests that have set
   * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
   * `TRAFFIC_AWARE_OPTIMAL` and
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
   * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
   * specified.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for trafficModel.
   */
  @java.lang.Override
  public int getTrafficModelValue() {
    return trafficModel_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the assumptions to use when calculating time in
   * traffic. This setting affects the value returned in the duration field in
   * the
   * [`Route`][google.maps.routing.v2.Route] and
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
   * time in traffic based on historical averages.
   * `TrafficModel` is only available for requests that have set
   * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
   * `TRAFFIC_AWARE_OPTIMAL` and
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
   * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
   * specified.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The trafficModel.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TrafficModel getTrafficModel() {
    com.google.maps.routing.v2.TrafficModel result =
        com.google.maps.routing.v2.TrafficModel.forNumber(trafficModel_);
    return result == null ? com.google.maps.routing.v2.TrafficModel.UNRECOGNIZED : result;
  }

  public static final int TRANSIT_PREFERENCES_FIELD_NUMBER = 20;
  private com.google.maps.routing.v2.TransitPreferences transitPreferences_;

  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the transitPreferences field is set.
   */
  @java.lang.Override
  public boolean hasTransitPreferences() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The transitPreferences.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferences getTransitPreferences() {
    return transitPreferences_ == null
        ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
        : transitPreferences_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies preferences that influence the route returned for
   * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
   * `TRANSIT`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
    return transitPreferences_ == null
        ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
        : transitPreferences_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getOrigin());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getDestination());
    }
    for (int i = 0; i < intermediates_.size(); i++) {
      output.writeMessage(3, intermediates_.get(i));
    }
    if (travelMode_
        != com.google.maps.routing.v2.RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, travelMode_);
    }
    if (routingPreference_
        != com.google.maps.routing.v2.RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, routingPreference_);
    }
    if (polylineQuality_
        != com.google.maps.routing.v2.PolylineQuality.POLYLINE_QUALITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, polylineQuality_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getDepartureTime());
    }
    if (computeAlternativeRoutes_ != false) {
      output.writeBool(8, computeAlternativeRoutes_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(9, getRouteModifiers());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, languageCode_);
    }
    if (units_ != com.google.maps.routing.v2.Units.UNITS_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, units_);
    }
    if (polylineEncoding_
        != com.google.maps.routing.v2.PolylineEncoding.POLYLINE_ENCODING_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, polylineEncoding_);
    }
    if (optimizeWaypointOrder_ != false) {
      output.writeBool(13, optimizeWaypointOrder_);
    }
    if (getRequestedReferenceRoutesList().size() > 0) {
      output.writeUInt32NoTag(114);
      output.writeUInt32NoTag(requestedReferenceRoutesMemoizedSerializedSize);
    }
    for (int i = 0; i < requestedReferenceRoutes_.size(); i++) {
      output.writeEnumNoTag(requestedReferenceRoutes_.get(i));
    }
    if (getExtraComputationsList().size() > 0) {
      output.writeUInt32NoTag(122);
      output.writeUInt32NoTag(extraComputationsMemoizedSerializedSize);
    }
    for (int i = 0; i < extraComputations_.size(); i++) {
      output.writeEnumNoTag(extraComputations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, regionCode_);
    }
    if (trafficModel_
        != com.google.maps.routing.v2.TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(18, trafficModel_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(19, getArrivalTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(20, getTransitPreferences());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOrigin());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDestination());
    }
    for (int i = 0; i < intermediates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, intermediates_.get(i));
    }
    if (travelMode_
        != com.google.maps.routing.v2.RouteTravelMode.TRAVEL_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, travelMode_);
    }
    if (routingPreference_
        != com.google.maps.routing.v2.RoutingPreference.ROUTING_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, routingPreference_);
    }
    if (polylineQuality_
        != com.google.maps.routing.v2.PolylineQuality.POLYLINE_QUALITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, polylineQuality_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDepartureTime());
    }
    if (computeAlternativeRoutes_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, computeAlternativeRoutes_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getRouteModifiers());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, languageCode_);
    }
    if (units_ != com.google.maps.routing.v2.Units.UNITS_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, units_);
    }
    if (polylineEncoding_
        != com.google.maps.routing.v2.PolylineEncoding.POLYLINE_ENCODING_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, polylineEncoding_);
    }
    if (optimizeWaypointOrder_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, optimizeWaypointOrder_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requestedReferenceRoutes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                requestedReferenceRoutes_.get(i));
      }
      size += dataSize;
      if (!getRequestedReferenceRoutesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      requestedReferenceRoutesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < extraComputations_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(extraComputations_.get(i));
      }
      size += dataSize;
      if (!getExtraComputationsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      extraComputationsMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, regionCode_);
    }
    if (trafficModel_
        != com.google.maps.routing.v2.TrafficModel.TRAFFIC_MODEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(18, trafficModel_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getArrivalTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getTransitPreferences());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.ComputeRoutesRequest)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.ComputeRoutesRequest other =
        (com.google.maps.routing.v2.ComputeRoutesRequest) obj;

    if (hasOrigin() != other.hasOrigin()) return false;
    if (hasOrigin()) {
      if (!getOrigin().equals(other.getOrigin())) return false;
    }
    if (hasDestination() != other.hasDestination()) return false;
    if (hasDestination()) {
      if (!getDestination().equals(other.getDestination())) return false;
    }
    if (!getIntermediatesList().equals(other.getIntermediatesList())) return false;
    if (travelMode_ != other.travelMode_) return false;
    if (routingPreference_ != other.routingPreference_) return false;
    if (polylineQuality_ != other.polylineQuality_) return false;
    if (polylineEncoding_ != other.polylineEncoding_) return false;
    if (hasDepartureTime() != other.hasDepartureTime()) return false;
    if (hasDepartureTime()) {
      if (!getDepartureTime().equals(other.getDepartureTime())) return false;
    }
    if (hasArrivalTime() != other.hasArrivalTime()) return false;
    if (hasArrivalTime()) {
      if (!getArrivalTime().equals(other.getArrivalTime())) return false;
    }
    if (getComputeAlternativeRoutes() != other.getComputeAlternativeRoutes()) return false;
    if (hasRouteModifiers() != other.hasRouteModifiers()) return false;
    if (hasRouteModifiers()) {
      if (!getRouteModifiers().equals(other.getRouteModifiers())) return false;
    }
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getRegionCode().equals(other.getRegionCode())) return false;
    if (units_ != other.units_) return false;
    if (getOptimizeWaypointOrder() != other.getOptimizeWaypointOrder()) return false;
    if (!requestedReferenceRoutes_.equals(other.requestedReferenceRoutes_)) return false;
    if (!extraComputations_.equals(other.extraComputations_)) return false;
    if (trafficModel_ != other.trafficModel_) return false;
    if (hasTransitPreferences() != other.hasTransitPreferences()) return false;
    if (hasTransitPreferences()) {
      if (!getTransitPreferences().equals(other.getTransitPreferences())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOrigin()) {
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
    }
    if (hasDestination()) {
      hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getDestination().hashCode();
    }
    if (getIntermediatesCount() > 0) {
      hash = (37 * hash) + INTERMEDIATES_FIELD_NUMBER;
      hash = (53 * hash) + getIntermediatesList().hashCode();
    }
    hash = (37 * hash) + TRAVEL_MODE_FIELD_NUMBER;
    hash = (53 * hash) + travelMode_;
    hash = (37 * hash) + ROUTING_PREFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + routingPreference_;
    hash = (37 * hash) + POLYLINE_QUALITY_FIELD_NUMBER;
    hash = (53 * hash) + polylineQuality_;
    hash = (37 * hash) + POLYLINE_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + polylineEncoding_;
    if (hasDepartureTime()) {
      hash = (37 * hash) + DEPARTURE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDepartureTime().hashCode();
    }
    if (hasArrivalTime()) {
      hash = (37 * hash) + ARRIVAL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getArrivalTime().hashCode();
    }
    hash = (37 * hash) + COMPUTE_ALTERNATIVE_ROUTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getComputeAlternativeRoutes());
    if (hasRouteModifiers()) {
      hash = (37 * hash) + ROUTE_MODIFIERS_FIELD_NUMBER;
      hash = (53 * hash) + getRouteModifiers().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getRegionCode().hashCode();
    hash = (37 * hash) + UNITS_FIELD_NUMBER;
    hash = (53 * hash) + units_;
    hash = (37 * hash) + OPTIMIZE_WAYPOINT_ORDER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOptimizeWaypointOrder());
    if (getRequestedReferenceRoutesCount() > 0) {
      hash = (37 * hash) + REQUESTED_REFERENCE_ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + requestedReferenceRoutes_.hashCode();
    }
    if (getExtraComputationsCount() > 0) {
      hash = (37 * hash) + EXTRA_COMPUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + extraComputations_.hashCode();
    }
    hash = (37 * hash) + TRAFFIC_MODEL_FIELD_NUMBER;
    hash = (53 * hash) + trafficModel_;
    if (hasTransitPreferences()) {
      hash = (37 * hash) + TRANSIT_PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getTransitPreferences().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.ComputeRoutesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * ComputeRoutes request message.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.ComputeRoutesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.ComputeRoutesRequest)
      com.google.maps.routing.v2.ComputeRoutesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRoutesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRoutesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.ComputeRoutesRequest.class,
              com.google.maps.routing.v2.ComputeRoutesRequest.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.ComputeRoutesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOriginFieldBuilder();
        getDestinationFieldBuilder();
        getIntermediatesFieldBuilder();
        getDepartureTimeFieldBuilder();
        getArrivalTimeFieldBuilder();
        getRouteModifiersFieldBuilder();
        getTransitPreferencesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      origin_ = null;
      if (originBuilder_ != null) {
        originBuilder_.dispose();
        originBuilder_ = null;
      }
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      if (intermediatesBuilder_ == null) {
        intermediates_ = java.util.Collections.emptyList();
      } else {
        intermediates_ = null;
        intermediatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      travelMode_ = 0;
      routingPreference_ = 0;
      polylineQuality_ = 0;
      polylineEncoding_ = 0;
      departureTime_ = null;
      if (departureTimeBuilder_ != null) {
        departureTimeBuilder_.dispose();
        departureTimeBuilder_ = null;
      }
      arrivalTime_ = null;
      if (arrivalTimeBuilder_ != null) {
        arrivalTimeBuilder_.dispose();
        arrivalTimeBuilder_ = null;
      }
      computeAlternativeRoutes_ = false;
      routeModifiers_ = null;
      if (routeModifiersBuilder_ != null) {
        routeModifiersBuilder_.dispose();
        routeModifiersBuilder_ = null;
      }
      languageCode_ = "";
      regionCode_ = "";
      units_ = 0;
      optimizeWaypointOrder_ = false;
      requestedReferenceRoutes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      extraComputations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      trafficModel_ = 0;
      transitPreferences_ = null;
      if (transitPreferencesBuilder_ != null) {
        transitPreferencesBuilder_.dispose();
        transitPreferencesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRoutesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRoutesRequest getDefaultInstanceForType() {
      return com.google.maps.routing.v2.ComputeRoutesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRoutesRequest build() {
      com.google.maps.routing.v2.ComputeRoutesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRoutesRequest buildPartial() {
      com.google.maps.routing.v2.ComputeRoutesRequest result =
          new com.google.maps.routing.v2.ComputeRoutesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.maps.routing.v2.ComputeRoutesRequest result) {
      if (intermediatesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          intermediates_ = java.util.Collections.unmodifiableList(intermediates_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.intermediates_ = intermediates_;
      } else {
        result.intermediates_ = intermediatesBuilder_.build();
      }
      if (((bitField0_ & 0x00008000) != 0)) {
        requestedReferenceRoutes_ =
            java.util.Collections.unmodifiableList(requestedReferenceRoutes_);
        bitField0_ = (bitField0_ & ~0x00008000);
      }
      result.requestedReferenceRoutes_ = requestedReferenceRoutes_;
      if (((bitField0_ & 0x00010000) != 0)) {
        extraComputations_ = java.util.Collections.unmodifiableList(extraComputations_);
        bitField0_ = (bitField0_ & ~0x00010000);
      }
      result.extraComputations_ = extraComputations_;
    }

    private void buildPartial0(com.google.maps.routing.v2.ComputeRoutesRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.origin_ = originBuilder_ == null ? origin_ : originBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.destination_ =
            destinationBuilder_ == null ? destination_ : destinationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.travelMode_ = travelMode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.routingPreference_ = routingPreference_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.polylineQuality_ = polylineQuality_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.polylineEncoding_ = polylineEncoding_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.departureTime_ =
            departureTimeBuilder_ == null ? departureTime_ : departureTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.arrivalTime_ =
            arrivalTimeBuilder_ == null ? arrivalTime_ : arrivalTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.computeAlternativeRoutes_ = computeAlternativeRoutes_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.routeModifiers_ =
            routeModifiersBuilder_ == null ? routeModifiers_ : routeModifiersBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.regionCode_ = regionCode_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.units_ = units_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.optimizeWaypointOrder_ = optimizeWaypointOrder_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.trafficModel_ = trafficModel_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.transitPreferences_ =
            transitPreferencesBuilder_ == null
                ? transitPreferences_
                : transitPreferencesBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.ComputeRoutesRequest) {
        return mergeFrom((com.google.maps.routing.v2.ComputeRoutesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.ComputeRoutesRequest other) {
      if (other == com.google.maps.routing.v2.ComputeRoutesRequest.getDefaultInstance())
        return this;
      if (other.hasOrigin()) {
        mergeOrigin(other.getOrigin());
      }
      if (other.hasDestination()) {
        mergeDestination(other.getDestination());
      }
      if (intermediatesBuilder_ == null) {
        if (!other.intermediates_.isEmpty()) {
          if (intermediates_.isEmpty()) {
            intermediates_ = other.intermediates_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureIntermediatesIsMutable();
            intermediates_.addAll(other.intermediates_);
          }
          onChanged();
        }
      } else {
        if (!other.intermediates_.isEmpty()) {
          if (intermediatesBuilder_.isEmpty()) {
            intermediatesBuilder_.dispose();
            intermediatesBuilder_ = null;
            intermediates_ = other.intermediates_;
            bitField0_ = (bitField0_ & ~0x00000004);
            intermediatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIntermediatesFieldBuilder()
                    : null;
          } else {
            intermediatesBuilder_.addAllMessages(other.intermediates_);
          }
        }
      }
      if (other.travelMode_ != 0) {
        setTravelModeValue(other.getTravelModeValue());
      }
      if (other.routingPreference_ != 0) {
        setRoutingPreferenceValue(other.getRoutingPreferenceValue());
      }
      if (other.polylineQuality_ != 0) {
        setPolylineQualityValue(other.getPolylineQualityValue());
      }
      if (other.polylineEncoding_ != 0) {
        setPolylineEncodingValue(other.getPolylineEncodingValue());
      }
      if (other.hasDepartureTime()) {
        mergeDepartureTime(other.getDepartureTime());
      }
      if (other.hasArrivalTime()) {
        mergeArrivalTime(other.getArrivalTime());
      }
      if (other.getComputeAlternativeRoutes() != false) {
        setComputeAlternativeRoutes(other.getComputeAlternativeRoutes());
      }
      if (other.hasRouteModifiers()) {
        mergeRouteModifiers(other.getRouteModifiers());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getRegionCode().isEmpty()) {
        regionCode_ = other.regionCode_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.units_ != 0) {
        setUnitsValue(other.getUnitsValue());
      }
      if (other.getOptimizeWaypointOrder() != false) {
        setOptimizeWaypointOrder(other.getOptimizeWaypointOrder());
      }
      if (!other.requestedReferenceRoutes_.isEmpty()) {
        if (requestedReferenceRoutes_.isEmpty()) {
          requestedReferenceRoutes_ = other.requestedReferenceRoutes_;
          bitField0_ = (bitField0_ & ~0x00008000);
        } else {
          ensureRequestedReferenceRoutesIsMutable();
          requestedReferenceRoutes_.addAll(other.requestedReferenceRoutes_);
        }
        onChanged();
      }
      if (!other.extraComputations_.isEmpty()) {
        if (extraComputations_.isEmpty()) {
          extraComputations_ = other.extraComputations_;
          bitField0_ = (bitField0_ & ~0x00010000);
        } else {
          ensureExtraComputationsIsMutable();
          extraComputations_.addAll(other.extraComputations_);
        }
        onChanged();
      }
      if (other.trafficModel_ != 0) {
        setTrafficModelValue(other.getTrafficModelValue());
      }
      if (other.hasTransitPreferences()) {
        mergeTransitPreferences(other.getTransitPreferences());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOriginFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDestinationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.maps.routing.v2.Waypoint m =
                    input.readMessage(
                        com.google.maps.routing.v2.Waypoint.parser(), extensionRegistry);
                if (intermediatesBuilder_ == null) {
                  ensureIntermediatesIsMutable();
                  intermediates_.add(m);
                } else {
                  intermediatesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                travelMode_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                routingPreference_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                polylineQuality_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 64:
              {
                computeAlternativeRoutes_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getRouteModifiersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 88:
              {
                units_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 88
            case 96:
              {
                polylineEncoding_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 96
            case 104:
              {
                optimizeWaypointOrder_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 104
            case 112:
              {
                int tmpRaw = input.readEnum();
                ensureRequestedReferenceRoutesIsMutable();
                requestedReferenceRoutes_.add(tmpRaw);
                break;
              } // case 112
            case 114:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureRequestedReferenceRoutesIsMutable();
                  requestedReferenceRoutes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 114
            case 120:
              {
                int tmpRaw = input.readEnum();
                ensureExtraComputationsIsMutable();
                extraComputations_.add(tmpRaw);
                break;
              } // case 120
            case 122:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureExtraComputationsIsMutable();
                  extraComputations_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 122
            case 130:
              {
                regionCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 130
            case 144:
              {
                trafficModel_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 144
            case 154:
              {
                input.readMessage(getArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getTransitPreferencesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.routing.v2.Waypoint origin_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Waypoint,
            com.google.maps.routing.v2.Waypoint.Builder,
            com.google.maps.routing.v2.WaypointOrBuilder>
        originBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the origin field is set.
     */
    public boolean hasOrigin() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The origin.
     */
    public com.google.maps.routing.v2.Waypoint getOrigin() {
      if (originBuilder_ == null) {
        return origin_ == null ? com.google.maps.routing.v2.Waypoint.getDefaultInstance() : origin_;
      } else {
        return originBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOrigin(com.google.maps.routing.v2.Waypoint value) {
      if (originBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        origin_ = value;
      } else {
        originBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOrigin(com.google.maps.routing.v2.Waypoint.Builder builderForValue) {
      if (originBuilder_ == null) {
        origin_ = builderForValue.build();
      } else {
        originBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOrigin(com.google.maps.routing.v2.Waypoint value) {
      if (originBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && origin_ != null
            && origin_ != com.google.maps.routing.v2.Waypoint.getDefaultInstance()) {
          getOriginBuilder().mergeFrom(value);
        } else {
          origin_ = value;
        }
      } else {
        originBuilder_.mergeFrom(value);
      }
      if (origin_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOrigin() {
      bitField0_ = (bitField0_ & ~0x00000001);
      origin_ = null;
      if (originBuilder_ != null) {
        originBuilder_.dispose();
        originBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.Waypoint.Builder getOriginBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getOriginFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.WaypointOrBuilder getOriginOrBuilder() {
      if (originBuilder_ != null) {
        return originBuilder_.getMessageOrBuilder();
      } else {
        return origin_ == null ? com.google.maps.routing.v2.Waypoint.getDefaultInstance() : origin_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Origin waypoint.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Waypoint origin = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Waypoint,
            com.google.maps.routing.v2.Waypoint.Builder,
            com.google.maps.routing.v2.WaypointOrBuilder>
        getOriginFieldBuilder() {
      if (originBuilder_ == null) {
        originBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Waypoint,
                com.google.maps.routing.v2.Waypoint.Builder,
                com.google.maps.routing.v2.WaypointOrBuilder>(
                getOrigin(), getParentForChildren(), isClean());
        origin_ = null;
      }
      return originBuilder_;
    }

    private com.google.maps.routing.v2.Waypoint destination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Waypoint,
            com.google.maps.routing.v2.Waypoint.Builder,
            com.google.maps.routing.v2.WaypointOrBuilder>
        destinationBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the destination field is set.
     */
    public boolean hasDestination() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The destination.
     */
    public com.google.maps.routing.v2.Waypoint getDestination() {
      if (destinationBuilder_ == null) {
        return destination_ == null
            ? com.google.maps.routing.v2.Waypoint.getDefaultInstance()
            : destination_;
      } else {
        return destinationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.maps.routing.v2.Waypoint value) {
      if (destinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
      } else {
        destinationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestination(com.google.maps.routing.v2.Waypoint.Builder builderForValue) {
      if (destinationBuilder_ == null) {
        destination_ = builderForValue.build();
      } else {
        destinationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDestination(com.google.maps.routing.v2.Waypoint value) {
      if (destinationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && destination_ != null
            && destination_ != com.google.maps.routing.v2.Waypoint.getDefaultInstance()) {
          getDestinationBuilder().mergeFrom(value);
        } else {
          destination_ = value;
        }
      } else {
        destinationBuilder_.mergeFrom(value);
      }
      if (destination_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestination() {
      bitField0_ = (bitField0_ & ~0x00000002);
      destination_ = null;
      if (destinationBuilder_ != null) {
        destinationBuilder_.dispose();
        destinationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.Waypoint.Builder getDestinationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDestinationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.maps.routing.v2.WaypointOrBuilder getDestinationOrBuilder() {
      if (destinationBuilder_ != null) {
        return destinationBuilder_.getMessageOrBuilder();
      } else {
        return destination_ == null
            ? com.google.maps.routing.v2.Waypoint.getDefaultInstance()
            : destination_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Destination waypoint.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.Waypoint destination = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.Waypoint,
            com.google.maps.routing.v2.Waypoint.Builder,
            com.google.maps.routing.v2.WaypointOrBuilder>
        getDestinationFieldBuilder() {
      if (destinationBuilder_ == null) {
        destinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.Waypoint,
                com.google.maps.routing.v2.Waypoint.Builder,
                com.google.maps.routing.v2.WaypointOrBuilder>(
                getDestination(), getParentForChildren(), isClean());
        destination_ = null;
      }
      return destinationBuilder_;
    }

    private java.util.List<com.google.maps.routing.v2.Waypoint> intermediates_ =
        java.util.Collections.emptyList();

    private void ensureIntermediatesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        intermediates_ =
            new java.util.ArrayList<com.google.maps.routing.v2.Waypoint>(intermediates_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.Waypoint,
            com.google.maps.routing.v2.Waypoint.Builder,
            com.google.maps.routing.v2.WaypointOrBuilder>
        intermediatesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.Waypoint> getIntermediatesList() {
      if (intermediatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(intermediates_);
      } else {
        return intermediatesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getIntermediatesCount() {
      if (intermediatesBuilder_ == null) {
        return intermediates_.size();
      } else {
        return intermediatesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.Waypoint getIntermediates(int index) {
      if (intermediatesBuilder_ == null) {
        return intermediates_.get(index);
      } else {
        return intermediatesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIntermediates(int index, com.google.maps.routing.v2.Waypoint value) {
      if (intermediatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntermediatesIsMutable();
        intermediates_.set(index, value);
        onChanged();
      } else {
        intermediatesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIntermediates(
        int index, com.google.maps.routing.v2.Waypoint.Builder builderForValue) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.set(index, builderForValue.build());
        onChanged();
      } else {
        intermediatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIntermediates(com.google.maps.routing.v2.Waypoint value) {
      if (intermediatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntermediatesIsMutable();
        intermediates_.add(value);
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIntermediates(int index, com.google.maps.routing.v2.Waypoint value) {
      if (intermediatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIntermediatesIsMutable();
        intermediates_.add(index, value);
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIntermediates(com.google.maps.routing.v2.Waypoint.Builder builderForValue) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.add(builderForValue.build());
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addIntermediates(
        int index, com.google.maps.routing.v2.Waypoint.Builder builderForValue) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.add(index, builderForValue.build());
        onChanged();
      } else {
        intermediatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllIntermediates(
        java.lang.Iterable<? extends com.google.maps.routing.v2.Waypoint> values) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, intermediates_);
        onChanged();
      } else {
        intermediatesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIntermediates() {
      if (intermediatesBuilder_ == null) {
        intermediates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        intermediatesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeIntermediates(int index) {
      if (intermediatesBuilder_ == null) {
        ensureIntermediatesIsMutable();
        intermediates_.remove(index);
        onChanged();
      } else {
        intermediatesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.Waypoint.Builder getIntermediatesBuilder(int index) {
      return getIntermediatesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.WaypointOrBuilder getIntermediatesOrBuilder(int index) {
      if (intermediatesBuilder_ == null) {
        return intermediates_.get(index);
      } else {
        return intermediatesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.WaypointOrBuilder>
        getIntermediatesOrBuilderList() {
      if (intermediatesBuilder_ != null) {
        return intermediatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(intermediates_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.Waypoint.Builder addIntermediatesBuilder() {
      return getIntermediatesFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.Waypoint.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.Waypoint.Builder addIntermediatesBuilder(int index) {
      return getIntermediatesFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.Waypoint.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of waypoints along the route (excluding terminal points),
     * for either stopping at or passing by. Up to 25 intermediate waypoints are
     * supported.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.Waypoint intermediates = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.Waypoint.Builder>
        getIntermediatesBuilderList() {
      return getIntermediatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.Waypoint,
            com.google.maps.routing.v2.Waypoint.Builder,
            com.google.maps.routing.v2.WaypointOrBuilder>
        getIntermediatesFieldBuilder() {
      if (intermediatesBuilder_ == null) {
        intermediatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.Waypoint,
                com.google.maps.routing.v2.Waypoint.Builder,
                com.google.maps.routing.v2.WaypointOrBuilder>(
                intermediates_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        intermediates_ = null;
      }
      return intermediatesBuilder_;
    }

    private int travelMode_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for travelMode.
     */
    @java.lang.Override
    public int getTravelModeValue() {
      return travelMode_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelModeValue(int value) {
      travelMode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The travelMode.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.RouteTravelMode getTravelMode() {
      com.google.maps.routing.v2.RouteTravelMode result =
          com.google.maps.routing.v2.RouteTravelMode.forNumber(travelMode_);
      return result == null ? com.google.maps.routing.v2.RouteTravelMode.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The travelMode to set.
     * @return This builder for chaining.
     */
    public Builder setTravelMode(com.google.maps.routing.v2.RouteTravelMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      travelMode_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the mode of transportation.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteTravelMode travel_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTravelMode() {
      bitField0_ = (bitField0_ & ~0x00000008);
      travelMode_ = 0;
      onChanged();
      return this;
    }

    private int routingPreference_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server
     * attempts to use the selected routing preference to compute the route. If
     *  the routing preference results in an error or an extra long latency, then
     * an error is returned. You can specify this option only when the
     * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for routingPreference.
     */
    @java.lang.Override
    public int getRoutingPreferenceValue() {
      return routingPreference_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server
     * attempts to use the selected routing preference to compute the route. If
     *  the routing preference results in an error or an extra long latency, then
     * an error is returned. You can specify this option only when the
     * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for routingPreference to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingPreferenceValue(int value) {
      routingPreference_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server
     * attempts to use the selected routing preference to compute the route. If
     *  the routing preference results in an error or an extra long latency, then
     * an error is returned. You can specify this option only when the
     * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The routingPreference.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.RoutingPreference getRoutingPreference() {
      com.google.maps.routing.v2.RoutingPreference result =
          com.google.maps.routing.v2.RoutingPreference.forNumber(routingPreference_);
      return result == null ? com.google.maps.routing.v2.RoutingPreference.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server
     * attempts to use the selected routing preference to compute the route. If
     *  the routing preference results in an error or an extra long latency, then
     * an error is returned. You can specify this option only when the
     * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The routingPreference to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingPreference(com.google.maps.routing.v2.RoutingPreference value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      routingPreference_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies how to compute the route. The server
     * attempts to use the selected routing preference to compute the route. If
     *  the routing preference results in an error or an extra long latency, then
     * an error is returned. You can specify this option only when the
     * `travel_mode` is `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RoutingPreference routing_preference = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutingPreference() {
      bitField0_ = (bitField0_ & ~0x00000010);
      routingPreference_ = 0;
      onChanged();
      return this;
    }

    private int polylineQuality_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Specifies your preference for the quality of the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for polylineQuality.
     */
    @java.lang.Override
    public int getPolylineQualityValue() {
      return polylineQuality_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies your preference for the quality of the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for polylineQuality to set.
     * @return This builder for chaining.
     */
    public Builder setPolylineQualityValue(int value) {
      polylineQuality_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies your preference for the quality of the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The polylineQuality.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineQuality getPolylineQuality() {
      com.google.maps.routing.v2.PolylineQuality result =
          com.google.maps.routing.v2.PolylineQuality.forNumber(polylineQuality_);
      return result == null ? com.google.maps.routing.v2.PolylineQuality.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies your preference for the quality of the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The polylineQuality to set.
     * @return This builder for chaining.
     */
    public Builder setPolylineQuality(com.google.maps.routing.v2.PolylineQuality value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      polylineQuality_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies your preference for the quality of the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineQuality polyline_quality = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolylineQuality() {
      bitField0_ = (bitField0_ & ~0x00000020);
      polylineQuality_ = 0;
      onChanged();
      return this;
    }

    private int polylineEncoding_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Specifies the preferred encoding for the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for polylineEncoding.
     */
    @java.lang.Override
    public int getPolylineEncodingValue() {
      return polylineEncoding_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the preferred encoding for the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for polylineEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setPolylineEncodingValue(int value) {
      polylineEncoding_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the preferred encoding for the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The polylineEncoding.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineEncoding getPolylineEncoding() {
      com.google.maps.routing.v2.PolylineEncoding result =
          com.google.maps.routing.v2.PolylineEncoding.forNumber(polylineEncoding_);
      return result == null ? com.google.maps.routing.v2.PolylineEncoding.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the preferred encoding for the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The polylineEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setPolylineEncoding(com.google.maps.routing.v2.PolylineEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      polylineEncoding_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the preferred encoding for the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineEncoding polyline_encoding = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolylineEncoding() {
      bitField0_ = (bitField0_ & ~0x00000040);
      polylineEncoding_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp departureTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        departureTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the departureTime field is set.
     */
    public boolean hasDepartureTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The departureTime.
     */
    public com.google.protobuf.Timestamp getDepartureTime() {
      if (departureTimeBuilder_ == null) {
        return departureTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : departureTime_;
      } else {
        return departureTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDepartureTime(com.google.protobuf.Timestamp value) {
      if (departureTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        departureTime_ = value;
      } else {
        departureTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDepartureTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (departureTimeBuilder_ == null) {
        departureTime_ = builderForValue.build();
      } else {
        departureTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDepartureTime(com.google.protobuf.Timestamp value) {
      if (departureTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && departureTime_ != null
            && departureTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDepartureTimeBuilder().mergeFrom(value);
        } else {
          departureTime_ = value;
        }
      } else {
        departureTimeBuilder_.mergeFrom(value);
      }
      if (departureTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDepartureTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      departureTime_ = null;
      if (departureTimeBuilder_ != null) {
        departureTimeBuilder_.dispose();
        departureTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDepartureTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDepartureTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder() {
      if (departureTimeBuilder_ != null) {
        return departureTimeBuilder_.getMessageOrBuilder();
      } else {
        return departureTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : departureTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The departure time. If you don't set this value, then this value
     * defaults to the time that you made the request.
     * NOTE: You can only specify a `departure_time` in the past when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp departure_time = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDepartureTimeFieldBuilder() {
      if (departureTimeBuilder_ == null) {
        departureTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDepartureTime(), getParentForChildren(), isClean());
        departureTime_ = null;
      }
      return departureTimeBuilder_;
    }

    private com.google.protobuf.Timestamp arrivalTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        arrivalTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the arrivalTime field is set.
     */
    public boolean hasArrivalTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The arrivalTime.
     */
    public com.google.protobuf.Timestamp getArrivalTime() {
      if (arrivalTimeBuilder_ == null) {
        return arrivalTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : arrivalTime_;
      } else {
        return arrivalTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setArrivalTime(com.google.protobuf.Timestamp value) {
      if (arrivalTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        arrivalTime_ = value;
      } else {
        arrivalTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setArrivalTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (arrivalTimeBuilder_ == null) {
        arrivalTime_ = builderForValue.build();
      } else {
        arrivalTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeArrivalTime(com.google.protobuf.Timestamp value) {
      if (arrivalTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && arrivalTime_ != null
            && arrivalTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getArrivalTimeBuilder().mergeFrom(value);
        } else {
          arrivalTime_ = value;
        }
      } else {
        arrivalTimeBuilder_.mergeFrom(value);
      }
      if (arrivalTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearArrivalTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      arrivalTime_ = null;
      if (arrivalTimeBuilder_ != null) {
        arrivalTimeBuilder_.dispose();
        arrivalTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getArrivalTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getArrivalTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder() {
      if (arrivalTimeBuilder_ != null) {
        return arrivalTimeBuilder_.getMessageOrBuilder();
      } else {
        return arrivalTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : arrivalTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The arrival time.
     * NOTE: Can only be set when
     * [RouteTravelMode][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`. You can specify either `departure_time` or `arrival_time`, but
     * not both. Transit trips are available for up to 7 days in the past or 100
     * days in the future.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 19 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getArrivalTimeFieldBuilder() {
      if (arrivalTimeBuilder_ == null) {
        arrivalTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getArrivalTime(), getParentForChildren(), isClean());
        arrivalTime_ = null;
      }
      return arrivalTimeBuilder_;
    }

    private boolean computeAlternativeRoutes_;

    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to calculate alternate routes in addition to
     * the route. No alternative routes are returned for requests that have
     * intermediate waypoints.
     * </pre>
     *
     * <code>bool compute_alternative_routes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The computeAlternativeRoutes.
     */
    @java.lang.Override
    public boolean getComputeAlternativeRoutes() {
      return computeAlternativeRoutes_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to calculate alternate routes in addition to
     * the route. No alternative routes are returned for requests that have
     * intermediate waypoints.
     * </pre>
     *
     * <code>bool compute_alternative_routes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The computeAlternativeRoutes to set.
     * @return This builder for chaining.
     */
    public Builder setComputeAlternativeRoutes(boolean value) {

      computeAlternativeRoutes_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies whether to calculate alternate routes in addition to
     * the route. No alternative routes are returned for requests that have
     * intermediate waypoints.
     * </pre>
     *
     * <code>bool compute_alternative_routes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComputeAlternativeRoutes() {
      bitField0_ = (bitField0_ & ~0x00000200);
      computeAlternativeRoutes_ = false;
      onChanged();
      return this;
    }

    private com.google.maps.routing.v2.RouteModifiers routeModifiers_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteModifiers,
            com.google.maps.routing.v2.RouteModifiers.Builder,
            com.google.maps.routing.v2.RouteModifiersOrBuilder>
        routeModifiersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the routeModifiers field is set.
     */
    public boolean hasRouteModifiers() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The routeModifiers.
     */
    public com.google.maps.routing.v2.RouteModifiers getRouteModifiers() {
      if (routeModifiersBuilder_ == null) {
        return routeModifiers_ == null
            ? com.google.maps.routing.v2.RouteModifiers.getDefaultInstance()
            : routeModifiers_;
      } else {
        return routeModifiersBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRouteModifiers(com.google.maps.routing.v2.RouteModifiers value) {
      if (routeModifiersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routeModifiers_ = value;
      } else {
        routeModifiersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRouteModifiers(
        com.google.maps.routing.v2.RouteModifiers.Builder builderForValue) {
      if (routeModifiersBuilder_ == null) {
        routeModifiers_ = builderForValue.build();
      } else {
        routeModifiersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRouteModifiers(com.google.maps.routing.v2.RouteModifiers value) {
      if (routeModifiersBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && routeModifiers_ != null
            && routeModifiers_ != com.google.maps.routing.v2.RouteModifiers.getDefaultInstance()) {
          getRouteModifiersBuilder().mergeFrom(value);
        } else {
          routeModifiers_ = value;
        }
      } else {
        routeModifiersBuilder_.mergeFrom(value);
      }
      if (routeModifiers_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRouteModifiers() {
      bitField0_ = (bitField0_ & ~0x00000400);
      routeModifiers_ = null;
      if (routeModifiersBuilder_ != null) {
        routeModifiersBuilder_.dispose();
        routeModifiersBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.RouteModifiers.Builder getRouteModifiersBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getRouteModifiersFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.RouteModifiersOrBuilder getRouteModifiersOrBuilder() {
      if (routeModifiersBuilder_ != null) {
        return routeModifiersBuilder_.getMessageOrBuilder();
      } else {
        return routeModifiers_ == null
            ? com.google.maps.routing.v2.RouteModifiers.getDefaultInstance()
            : routeModifiers_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A set of conditions to satisfy that affect the way routes are
     * calculated.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteModifiers route_modifiers = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteModifiers,
            com.google.maps.routing.v2.RouteModifiers.Builder,
            com.google.maps.routing.v2.RouteModifiersOrBuilder>
        getRouteModifiersFieldBuilder() {
      if (routeModifiersBuilder_ == null) {
        routeModifiersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteModifiers,
                com.google.maps.routing.v2.RouteModifiers.Builder,
                com.google.maps.routing.v2.RouteModifiersOrBuilder>(
                getRouteModifiers(), getParentForChildren(), isClean());
        routeModifiers_ = null;
      }
      return routeModifiersBuilder_;
    }

    private java.lang.Object languageCode_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Unicode Locale
     * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
     * See [Language
     * Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the route request.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Unicode Locale
     * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
     * See [Language
     * Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the route request.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Unicode Locale
     * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
     * See [Language
     * Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the route request.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Unicode Locale
     * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
     * See [Language
     * Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the route request.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
     * information, see [Unicode Locale
     * Identifier](http://www.unicode.org/reports/tr35/#Unicode_locale_identifier).
     * See [Language
     * Support](https://developers.google.com/maps/faq#languagesupport)
     * for the list of supported languages. When you don't provide this value, the
     * display language is inferred from the location of the route request.
     * </pre>
     *
     * <code>string language_code = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object regionCode_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see [Country code top-level
     * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
     * </pre>
     *
     * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The regionCode.
     */
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see [Country code top-level
     * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
     * </pre>
     *
     * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for regionCode.
     */
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see [Country code top-level
     * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
     * </pre>
     *
     * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      regionCode_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see [Country code top-level
     * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
     * </pre>
     *
     * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegionCode() {
      regionCode_ = getDefaultInstance().getRegionCode();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The region code, specified as a ccTLD ("top-level domain")
     * two-character value. For more information see [Country code top-level
     * domains](https://en.wikipedia.org/wiki/List_of_Internet_top-level_domains#Country_code_top-level_domains).
     * </pre>
     *
     * <code>string region_code = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      regionCode_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int units_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Specifies the units of measure for the display fields. These
     * fields include the `instruction` field in
     * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
     * The units of measure used for the route, leg, step distance, and duration
     * are not affected by this value. If you don't provide this value, then the
     * display units are inferred from the location of the first origin.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for units.
     */
    @java.lang.Override
    public int getUnitsValue() {
      return units_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the units of measure for the display fields. These
     * fields include the `instruction` field in
     * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
     * The units of measure used for the route, leg, step distance, and duration
     * are not affected by this value. If you don't provide this value, then the
     * display units are inferred from the location of the first origin.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for units to set.
     * @return This builder for chaining.
     */
    public Builder setUnitsValue(int value) {
      units_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the units of measure for the display fields. These
     * fields include the `instruction` field in
     * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
     * The units of measure used for the route, leg, step distance, and duration
     * are not affected by this value. If you don't provide this value, then the
     * display units are inferred from the location of the first origin.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The units.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.Units getUnits() {
      com.google.maps.routing.v2.Units result = com.google.maps.routing.v2.Units.forNumber(units_);
      return result == null ? com.google.maps.routing.v2.Units.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the units of measure for the display fields. These
     * fields include the `instruction` field in
     * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
     * The units of measure used for the route, leg, step distance, and duration
     * are not affected by this value. If you don't provide this value, then the
     * display units are inferred from the location of the first origin.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The units to set.
     * @return This builder for chaining.
     */
    public Builder setUnits(com.google.maps.routing.v2.Units value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      units_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the units of measure for the display fields. These
     * fields include the `instruction` field in
     * [`NavigationInstruction`][google.maps.routing.v2.NavigationInstruction].
     * The units of measure used for the route, leg, step distance, and duration
     * are not affected by this value. If you don't provide this value, then the
     * display units are inferred from the location of the first origin.
     * </pre>
     *
     * <code>.google.maps.routing.v2.Units units = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnits() {
      bitField0_ = (bitField0_ & ~0x00002000);
      units_ = 0;
      onChanged();
      return this;
    }

    private boolean optimizeWaypointOrder_;

    /**
     *
     *
     * <pre>
     * Optional. If set to true, the service attempts to minimize the overall cost
     * of the route by re-ordering the specified intermediate waypoints. The
     * request fails if any of the intermediate waypoints is a `via` waypoint. Use
     * `ComputeRoutesResponse.Routes.optimized_intermediate_waypoint_index` to
     * find the new ordering.
     * If `ComputeRoutesResponseroutes.optimized_intermediate_waypoint_index` is
     * not requested in the `X-Goog-FieldMask` header, the request fails.
     * If `optimize_waypoint_order` is set to false,
     * `ComputeRoutesResponse.optimized_intermediate_waypoint_index` will be
     * empty.
     * </pre>
     *
     * <code>bool optimize_waypoint_order = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The optimizeWaypointOrder.
     */
    @java.lang.Override
    public boolean getOptimizeWaypointOrder() {
      return optimizeWaypointOrder_;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, the service attempts to minimize the overall cost
     * of the route by re-ordering the specified intermediate waypoints. The
     * request fails if any of the intermediate waypoints is a `via` waypoint. Use
     * `ComputeRoutesResponse.Routes.optimized_intermediate_waypoint_index` to
     * find the new ordering.
     * If `ComputeRoutesResponseroutes.optimized_intermediate_waypoint_index` is
     * not requested in the `X-Goog-FieldMask` header, the request fails.
     * If `optimize_waypoint_order` is set to false,
     * `ComputeRoutesResponse.optimized_intermediate_waypoint_index` will be
     * empty.
     * </pre>
     *
     * <code>bool optimize_waypoint_order = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The optimizeWaypointOrder to set.
     * @return This builder for chaining.
     */
    public Builder setOptimizeWaypointOrder(boolean value) {

      optimizeWaypointOrder_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If set to true, the service attempts to minimize the overall cost
     * of the route by re-ordering the specified intermediate waypoints. The
     * request fails if any of the intermediate waypoints is a `via` waypoint. Use
     * `ComputeRoutesResponse.Routes.optimized_intermediate_waypoint_index` to
     * find the new ordering.
     * If `ComputeRoutesResponseroutes.optimized_intermediate_waypoint_index` is
     * not requested in the `X-Goog-FieldMask` header, the request fails.
     * If `optimize_waypoint_order` is set to false,
     * `ComputeRoutesResponse.optimized_intermediate_waypoint_index` will be
     * empty.
     * </pre>
     *
     * <code>bool optimize_waypoint_order = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptimizeWaypointOrder() {
      bitField0_ = (bitField0_ & ~0x00004000);
      optimizeWaypointOrder_ = false;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> requestedReferenceRoutes_ =
        java.util.Collections.emptyList();

    private void ensureRequestedReferenceRoutesIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        requestedReferenceRoutes_ =
            new java.util.ArrayList<java.lang.Integer>(requestedReferenceRoutes_);
        bitField0_ |= 0x00008000;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the requestedReferenceRoutes.
     */
    public java.util.List<com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>
        getRequestedReferenceRoutesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>(
          requestedReferenceRoutes_, requestedReferenceRoutes_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of requestedReferenceRoutes.
     */
    public int getRequestedReferenceRoutesCount() {
      return requestedReferenceRoutes_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The requestedReferenceRoutes at the given index.
     */
    public com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute
        getRequestedReferenceRoutes(int index) {
      return requestedReferenceRoutes_converter_.convert(requestedReferenceRoutes_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The requestedReferenceRoutes to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedReferenceRoutes(
        int index, com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestedReferenceRoutesIsMutable();
      requestedReferenceRoutes_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The requestedReferenceRoutes to add.
     * @return This builder for chaining.
     */
    public Builder addRequestedReferenceRoutes(
        com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestedReferenceRoutesIsMutable();
      requestedReferenceRoutes_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The requestedReferenceRoutes to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequestedReferenceRoutes(
        java.lang.Iterable<? extends com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute>
            values) {
      ensureRequestedReferenceRoutesIsMutable();
      for (com.google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute value : values) {
        requestedReferenceRoutes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedReferenceRoutes() {
      requestedReferenceRoutes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for requestedReferenceRoutes.
     */
    public java.util.List<java.lang.Integer> getRequestedReferenceRoutesValueList() {
      return java.util.Collections.unmodifiableList(requestedReferenceRoutes_);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of requestedReferenceRoutes at the given index.
     */
    public int getRequestedReferenceRoutesValue(int index) {
      return requestedReferenceRoutes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for requestedReferenceRoutes to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedReferenceRoutesValue(int index, int value) {
      ensureRequestedReferenceRoutesIsMutable();
      requestedReferenceRoutes_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for requestedReferenceRoutes to add.
     * @return This builder for chaining.
     */
    public Builder addRequestedReferenceRoutesValue(int value) {
      ensureRequestedReferenceRoutesIsMutable();
      requestedReferenceRoutes_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies what reference routes to calculate as part of the
     * request in addition to the default route. A reference route is a route with
     * a different route calculation objective than the default route. For example
     * a `FUEL_EFFICIENT` reference route calculation takes into account various
     * parameters that would generate an optimal fuel efficient route. When using
     * this feature, look for
     * [`route_labels`][google.maps.routing.v2.Route.route_labels] on the
     * resulting routes.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ReferenceRoute requested_reference_routes = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for requestedReferenceRoutes to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequestedReferenceRoutesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureRequestedReferenceRoutesIsMutable();
      for (int value : values) {
        requestedReferenceRoutes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> extraComputations_ =
        java.util.Collections.emptyList();

    private void ensureExtraComputationsIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        extraComputations_ = new java.util.ArrayList<java.lang.Integer>(extraComputations_);
        bitField0_ |= 0x00010000;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the extraComputations.
     */
    public java.util.List<com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>
        getExtraComputationsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>(
          extraComputations_, extraComputations_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of extraComputations.
     */
    public int getExtraComputationsCount() {
      return extraComputations_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The extraComputations at the given index.
     */
    public com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation getExtraComputations(
        int index) {
      return extraComputations_converter_.convert(extraComputations_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The extraComputations to set.
     * @return This builder for chaining.
     */
    public Builder setExtraComputations(
        int index, com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraComputationsIsMutable();
      extraComputations_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addExtraComputations(
        com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExtraComputationsIsMutable();
      extraComputations_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraComputations(
        java.lang.Iterable<
                ? extends com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation>
            values) {
      ensureExtraComputationsIsMutable();
      for (com.google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation value : values) {
        extraComputations_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExtraComputations() {
      extraComputations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for extraComputations.
     */
    public java.util.List<java.lang.Integer> getExtraComputationsValueList() {
      return java.util.Collections.unmodifiableList(extraComputations_);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of extraComputations at the given index.
     */
    public int getExtraComputationsValue(int index) {
      return extraComputations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for extraComputations to set.
     * @return This builder for chaining.
     */
    public Builder setExtraComputationsValue(int index, int value) {
      ensureExtraComputationsIsMutable();
      extraComputations_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addExtraComputationsValue(int value) {
      ensureExtraComputationsIsMutable();
      extraComputations_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of extra computations which may be used to complete the
     * request. Note: These extra computations may return extra fields on the
     * response. These extra fields must also be specified in the field mask to be
     * returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.ComputeRoutesRequest.ExtraComputation extra_computations = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for extraComputations to add.
     * @return This builder for chaining.
     */
    public Builder addAllExtraComputationsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureExtraComputationsIsMutable();
      for (int value : values) {
        extraComputations_.add(value);
      }
      onChanged();
      return this;
    }

    private int trafficModel_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the
     * [`Route`][google.maps.routing.v2.Route] and
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
     * time in traffic based on historical averages.
     * `TrafficModel` is only available for requests that have set
     * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for trafficModel.
     */
    @java.lang.Override
    public int getTrafficModelValue() {
      return trafficModel_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the
     * [`Route`][google.maps.routing.v2.Route] and
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
     * time in traffic based on historical averages.
     * `TrafficModel` is only available for requests that have set
     * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for trafficModel to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficModelValue(int value) {
      trafficModel_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the
     * [`Route`][google.maps.routing.v2.Route] and
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
     * time in traffic based on historical averages.
     * `TrafficModel` is only available for requests that have set
     * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The trafficModel.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TrafficModel getTrafficModel() {
      com.google.maps.routing.v2.TrafficModel result =
          com.google.maps.routing.v2.TrafficModel.forNumber(trafficModel_);
      return result == null ? com.google.maps.routing.v2.TrafficModel.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the
     * [`Route`][google.maps.routing.v2.Route] and
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
     * time in traffic based on historical averages.
     * `TrafficModel` is only available for requests that have set
     * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The trafficModel to set.
     * @return This builder for chaining.
     */
    public Builder setTrafficModel(com.google.maps.routing.v2.TrafficModel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      trafficModel_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the assumptions to use when calculating time in
     * traffic. This setting affects the value returned in the duration field in
     * the
     * [`Route`][google.maps.routing.v2.Route] and
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg] which contains the predicted
     * time in traffic based on historical averages.
     * `TrafficModel` is only available for requests that have set
     * [`RoutingPreference`][google.maps.routing.v2.RoutingPreference] to
     * `TRAFFIC_AWARE_OPTIMAL` and
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] to `DRIVE`.
     * Defaults to `BEST_GUESS` if traffic is requested and `TrafficModel` is not
     * specified.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TrafficModel traffic_model = 18 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrafficModel() {
      bitField0_ = (bitField0_ & ~0x00020000);
      trafficModel_ = 0;
      onChanged();
      return this;
    }

    private com.google.maps.routing.v2.TransitPreferences transitPreferences_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitPreferences,
            com.google.maps.routing.v2.TransitPreferences.Builder,
            com.google.maps.routing.v2.TransitPreferencesOrBuilder>
        transitPreferencesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the transitPreferences field is set.
     */
    public boolean hasTransitPreferences() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The transitPreferences.
     */
    public com.google.maps.routing.v2.TransitPreferences getTransitPreferences() {
      if (transitPreferencesBuilder_ == null) {
        return transitPreferences_ == null
            ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
            : transitPreferences_;
      } else {
        return transitPreferencesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransitPreferences(com.google.maps.routing.v2.TransitPreferences value) {
      if (transitPreferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transitPreferences_ = value;
      } else {
        transitPreferencesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTransitPreferences(
        com.google.maps.routing.v2.TransitPreferences.Builder builderForValue) {
      if (transitPreferencesBuilder_ == null) {
        transitPreferences_ = builderForValue.build();
      } else {
        transitPreferencesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTransitPreferences(com.google.maps.routing.v2.TransitPreferences value) {
      if (transitPreferencesBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && transitPreferences_ != null
            && transitPreferences_
                != com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()) {
          getTransitPreferencesBuilder().mergeFrom(value);
        } else {
          transitPreferences_ = value;
        }
      } else {
        transitPreferencesBuilder_.mergeFrom(value);
      }
      if (transitPreferences_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTransitPreferences() {
      bitField0_ = (bitField0_ & ~0x00040000);
      transitPreferences_ = null;
      if (transitPreferencesBuilder_ != null) {
        transitPreferencesBuilder_.dispose();
        transitPreferencesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.TransitPreferences.Builder getTransitPreferencesBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getTransitPreferencesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.maps.routing.v2.TransitPreferencesOrBuilder getTransitPreferencesOrBuilder() {
      if (transitPreferencesBuilder_ != null) {
        return transitPreferencesBuilder_.getMessageOrBuilder();
      } else {
        return transitPreferences_ == null
            ? com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()
            : transitPreferences_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies preferences that influence the route returned for
     * `TRANSIT` routes. NOTE: You can only specify a `transit_preferences` when
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode] is set to
     * `TRANSIT`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences transit_preferences = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitPreferences,
            com.google.maps.routing.v2.TransitPreferences.Builder,
            com.google.maps.routing.v2.TransitPreferencesOrBuilder>
        getTransitPreferencesFieldBuilder() {
      if (transitPreferencesBuilder_ == null) {
        transitPreferencesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.TransitPreferences,
                com.google.maps.routing.v2.TransitPreferences.Builder,
                com.google.maps.routing.v2.TransitPreferencesOrBuilder>(
                getTransitPreferences(), getParentForChildren(), isClean());
        transitPreferences_ = null;
      }
      return transitPreferencesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.ComputeRoutesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.ComputeRoutesRequest)
  private static final com.google.maps.routing.v2.ComputeRoutesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.ComputeRoutesRequest();
  }

  public static com.google.maps.routing.v2.ComputeRoutesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeRoutesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ComputeRoutesRequest>() {
        @java.lang.Override
        public ComputeRoutesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeRoutesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeRoutesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.ComputeRoutesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
