/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/polyline_details.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Details corresponding to a given index or contiguous segment of a polyline.
 * Given a polyline with points P_0, P_1, ... , P_N (zero-based index), the
 * `PolylineDetails` defines an interval and associated metadata.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.PolylineDetails}
 */
public final class PolylineDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.PolylineDetails)
    PolylineDetailsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PolylineDetails.newBuilder() to construct.
  private PolylineDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PolylineDetails() {
    flyoverInfo_ = java.util.Collections.emptyList();
    narrowRoadInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PolylineDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.PolylineDetailsProto
        .internal_static_google_maps_routing_v2_PolylineDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.PolylineDetailsProto
        .internal_static_google_maps_routing_v2_PolylineDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.PolylineDetails.class,
            com.google.maps.routing.v2.PolylineDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Encapsulates the states of road features along a stretch of polyline.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.PolylineDetails.RoadFeatureState}
   */
  public enum RoadFeatureState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The road feature's state was not computed (default value).
     * </pre>
     *
     * <code>ROAD_FEATURE_STATE_UNSPECIFIED = 0;</code>
     */
    ROAD_FEATURE_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The road feature exists.
     * </pre>
     *
     * <code>EXISTS = 1;</code>
     */
    EXISTS(1),
    /**
     *
     *
     * <pre>
     * The road feature does not exist.
     * </pre>
     *
     * <code>DOES_NOT_EXIST = 2;</code>
     */
    DOES_NOT_EXIST(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The road feature's state was not computed (default value).
     * </pre>
     *
     * <code>ROAD_FEATURE_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int ROAD_FEATURE_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The road feature exists.
     * </pre>
     *
     * <code>EXISTS = 1;</code>
     */
    public static final int EXISTS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The road feature does not exist.
     * </pre>
     *
     * <code>DOES_NOT_EXIST = 2;</code>
     */
    public static final int DOES_NOT_EXIST_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoadFeatureState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RoadFeatureState forNumber(int value) {
      switch (value) {
        case 0:
          return ROAD_FEATURE_STATE_UNSPECIFIED;
        case 1:
          return EXISTS;
        case 2:
          return DOES_NOT_EXIST;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RoadFeatureState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RoadFeatureState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<RoadFeatureState>() {
              public RoadFeatureState findValueByNumber(int number) {
                return RoadFeatureState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.PolylineDetails.getDescriptor().getEnumTypes().get(0);
    }

    private static final RoadFeatureState[] VALUES = values();

    public static RoadFeatureState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RoadFeatureState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.PolylineDetails.RoadFeatureState)
  }

  public interface PolylinePointIndexOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.PolylineDetails.PolylinePointIndex)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The start index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return Whether the startIndex field is set.
     */
    boolean hasStartIndex();

    /**
     *
     *
     * <pre>
     * The start index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return The startIndex.
     */
    int getStartIndex();

    /**
     *
     *
     * <pre>
     * The end index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return Whether the endIndex field is set.
     */
    boolean hasEndIndex();

    /**
     *
     *
     * <pre>
     * The end index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return The endIndex.
     */
    int getEndIndex();
  }

  /**
   *
   *
   * <pre>
   * Encapsulates the start and end indexes for a polyline detail.
   * For instances where the data corresponds to a single point, `start_index`
   * and `end_index` will be equal.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.PolylineDetails.PolylinePointIndex}
   */
  public static final class PolylinePointIndex extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.PolylineDetails.PolylinePointIndex)
      PolylinePointIndexOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PolylinePointIndex.newBuilder() to construct.
    private PolylinePointIndex(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PolylinePointIndex() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PolylinePointIndex();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_PolylinePointIndex_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_PolylinePointIndex_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.class,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder.class);
    }

    private int bitField0_;
    public static final int START_INDEX_FIELD_NUMBER = 1;
    private int startIndex_ = 0;

    /**
     *
     *
     * <pre>
     * The start index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return Whether the startIndex field is set.
     */
    @java.lang.Override
    public boolean hasStartIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The start index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 start_index = 1;</code>
     *
     * @return The startIndex.
     */
    @java.lang.Override
    public int getStartIndex() {
      return startIndex_;
    }

    public static final int END_INDEX_FIELD_NUMBER = 2;
    private int endIndex_ = 0;

    /**
     *
     *
     * <pre>
     * The end index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return Whether the endIndex field is set.
     */
    @java.lang.Override
    public boolean hasEndIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The end index of this detail in the polyline.
     * </pre>
     *
     * <code>optional int32 end_index = 2;</code>
     *
     * @return The endIndex.
     */
    @java.lang.Override
    public int getEndIndex() {
      return endIndex_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(1, startIndex_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, endIndex_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, startIndex_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, endIndex_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex other =
          (com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex) obj;

      if (hasStartIndex() != other.hasStartIndex()) return false;
      if (hasStartIndex()) {
        if (getStartIndex() != other.getStartIndex()) return false;
      }
      if (hasEndIndex() != other.hasEndIndex()) return false;
      if (hasEndIndex()) {
        if (getEndIndex() != other.getEndIndex()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartIndex()) {
        hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getStartIndex();
      }
      if (hasEndIndex()) {
        hash = (37 * hash) + END_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getEndIndex();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates the start and end indexes for a polyline detail.
     * For instances where the data corresponds to a single point, `start_index`
     * and `end_index` will be equal.
     * </pre>
     *
     * Protobuf type {@code google.maps.routing.v2.PolylineDetails.PolylinePointIndex}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.PolylineDetails.PolylinePointIndex)
        com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_PolylinePointIndex_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_PolylinePointIndex_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.class,
                com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder.class);
      }

      // Construct using com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startIndex_ = 0;
        endIndex_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_PolylinePointIndex_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex
          getDefaultInstanceForType() {
        return com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex build() {
        com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex buildPartial() {
        com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex result =
            new com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startIndex_ = startIndex_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endIndex_ = endIndex_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex) {
          return mergeFrom((com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex other) {
        if (other
            == com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance())
          return this;
        if (other.hasStartIndex()) {
          setStartIndex(other.getStartIndex());
        }
        if (other.hasEndIndex()) {
          setEndIndex(other.getEndIndex());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  startIndex_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  endIndex_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int startIndex_;

      /**
       *
       *
       * <pre>
       * The start index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 start_index = 1;</code>
       *
       * @return Whether the startIndex field is set.
       */
      @java.lang.Override
      public boolean hasStartIndex() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The start index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 start_index = 1;</code>
       *
       * @return The startIndex.
       */
      @java.lang.Override
      public int getStartIndex() {
        return startIndex_;
      }

      /**
       *
       *
       * <pre>
       * The start index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 start_index = 1;</code>
       *
       * @param value The startIndex to set.
       * @return This builder for chaining.
       */
      public Builder setStartIndex(int value) {

        startIndex_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The start index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 start_index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStartIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startIndex_ = 0;
        onChanged();
        return this;
      }

      private int endIndex_;

      /**
       *
       *
       * <pre>
       * The end index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 end_index = 2;</code>
       *
       * @return Whether the endIndex field is set.
       */
      @java.lang.Override
      public boolean hasEndIndex() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The end index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 end_index = 2;</code>
       *
       * @return The endIndex.
       */
      @java.lang.Override
      public int getEndIndex() {
        return endIndex_;
      }

      /**
       *
       *
       * <pre>
       * The end index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 end_index = 2;</code>
       *
       * @param value The endIndex to set.
       * @return This builder for chaining.
       */
      public Builder setEndIndex(int value) {

        endIndex_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The end index of this detail in the polyline.
       * </pre>
       *
       * <code>optional int32 end_index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        endIndex_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.PolylineDetails.PolylinePointIndex)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.PolylineDetails.PolylinePointIndex)
    private static final com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex();
    }

    public static com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PolylinePointIndex> PARSER =
        new com.google.protobuf.AbstractParser<PolylinePointIndex>() {
          @java.lang.Override
          public PolylinePointIndex parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PolylinePointIndex> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PolylinePointIndex> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FlyoverInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.PolylineDetails.FlyoverInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a flyover exists for a given stretch of the
     * polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for flyoverPresence.
     */
    int getFlyoverPresenceValue();

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a flyover exists for a given stretch of the
     * polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The flyoverPresence.
     */
    com.google.maps.routing.v2.PolylineDetails.RoadFeatureState getFlyoverPresence();

    /**
     *
     *
     * <pre>
     * The location of flyover related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return Whether the polylinePointIndex field is set.
     */
    boolean hasPolylinePointIndex();

    /**
     *
     *
     * <pre>
     * The location of flyover related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return The polylinePointIndex.
     */
    com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex getPolylinePointIndex();

    /**
     *
     *
     * <pre>
     * The location of flyover related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     */
    com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder
        getPolylinePointIndexOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Encapsulates information about flyovers along the polyline.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.PolylineDetails.FlyoverInfo}
   */
  public static final class FlyoverInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.PolylineDetails.FlyoverInfo)
      FlyoverInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FlyoverInfo.newBuilder() to construct.
    private FlyoverInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FlyoverInfo() {
      flyoverPresence_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FlyoverInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_FlyoverInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_FlyoverInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.class,
              com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder.class);
    }

    private int bitField0_;
    public static final int FLYOVER_PRESENCE_FIELD_NUMBER = 1;
    private int flyoverPresence_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a flyover exists for a given stretch of the
     * polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for flyoverPresence.
     */
    @java.lang.Override
    public int getFlyoverPresenceValue() {
      return flyoverPresence_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a flyover exists for a given stretch of the
     * polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The flyoverPresence.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.RoadFeatureState getFlyoverPresence() {
      com.google.maps.routing.v2.PolylineDetails.RoadFeatureState result =
          com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.forNumber(flyoverPresence_);
      return result == null
          ? com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.UNRECOGNIZED
          : result;
    }

    public static final int POLYLINE_POINT_INDEX_FIELD_NUMBER = 2;
    private com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polylinePointIndex_;

    /**
     *
     *
     * <pre>
     * The location of flyover related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return Whether the polylinePointIndex field is set.
     */
    @java.lang.Override
    public boolean hasPolylinePointIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The location of flyover related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return The polylinePointIndex.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex getPolylinePointIndex() {
      return polylinePointIndex_ == null
          ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
          : polylinePointIndex_;
    }

    /**
     *
     *
     * <pre>
     * The location of flyover related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder
        getPolylinePointIndexOrBuilder() {
      return polylinePointIndex_ == null
          ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
          : polylinePointIndex_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (flyoverPresence_
          != com.google.maps.routing.v2.PolylineDetails.RoadFeatureState
              .ROAD_FEATURE_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, flyoverPresence_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getPolylinePointIndex());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (flyoverPresence_
          != com.google.maps.routing.v2.PolylineDetails.RoadFeatureState
              .ROAD_FEATURE_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, flyoverPresence_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPolylinePointIndex());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.maps.routing.v2.PolylineDetails.FlyoverInfo)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.PolylineDetails.FlyoverInfo other =
          (com.google.maps.routing.v2.PolylineDetails.FlyoverInfo) obj;

      if (flyoverPresence_ != other.flyoverPresence_) return false;
      if (hasPolylinePointIndex() != other.hasPolylinePointIndex()) return false;
      if (hasPolylinePointIndex()) {
        if (!getPolylinePointIndex().equals(other.getPolylinePointIndex())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FLYOVER_PRESENCE_FIELD_NUMBER;
      hash = (53 * hash) + flyoverPresence_;
      if (hasPolylinePointIndex()) {
        hash = (37 * hash) + POLYLINE_POINT_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getPolylinePointIndex().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.PolylineDetails.FlyoverInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about flyovers along the polyline.
     * </pre>
     *
     * Protobuf type {@code google.maps.routing.v2.PolylineDetails.FlyoverInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.PolylineDetails.FlyoverInfo)
        com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_FlyoverInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_FlyoverInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.class,
                com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder.class);
      }

      // Construct using com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPolylinePointIndexFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        flyoverPresence_ = 0;
        polylinePointIndex_ = null;
        if (polylinePointIndexBuilder_ != null) {
          polylinePointIndexBuilder_.dispose();
          polylinePointIndexBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_FlyoverInfo_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo getDefaultInstanceForType() {
        return com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo build() {
        com.google.maps.routing.v2.PolylineDetails.FlyoverInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo buildPartial() {
        com.google.maps.routing.v2.PolylineDetails.FlyoverInfo result =
            new com.google.maps.routing.v2.PolylineDetails.FlyoverInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.maps.routing.v2.PolylineDetails.FlyoverInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.flyoverPresence_ = flyoverPresence_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.polylinePointIndex_ =
              polylinePointIndexBuilder_ == null
                  ? polylinePointIndex_
                  : polylinePointIndexBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.maps.routing.v2.PolylineDetails.FlyoverInfo) {
          return mergeFrom((com.google.maps.routing.v2.PolylineDetails.FlyoverInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.maps.routing.v2.PolylineDetails.FlyoverInfo other) {
        if (other == com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.getDefaultInstance())
          return this;
        if (other.flyoverPresence_ != 0) {
          setFlyoverPresenceValue(other.getFlyoverPresenceValue());
        }
        if (other.hasPolylinePointIndex()) {
          mergePolylinePointIndex(other.getPolylinePointIndex());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  flyoverPresence_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getPolylinePointIndexFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int flyoverPresence_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a flyover exists for a given stretch of the
       * polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for flyoverPresence.
       */
      @java.lang.Override
      public int getFlyoverPresenceValue() {
        return flyoverPresence_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a flyover exists for a given stretch of the
       * polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for flyoverPresence to set.
       * @return This builder for chaining.
       */
      public Builder setFlyoverPresenceValue(int value) {
        flyoverPresence_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a flyover exists for a given stretch of the
       * polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The flyoverPresence.
       */
      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.RoadFeatureState getFlyoverPresence() {
        com.google.maps.routing.v2.PolylineDetails.RoadFeatureState result =
            com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.forNumber(flyoverPresence_);
        return result == null
            ? com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a flyover exists for a given stretch of the
       * polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The flyoverPresence to set.
       * @return This builder for chaining.
       */
      public Builder setFlyoverPresence(
          com.google.maps.routing.v2.PolylineDetails.RoadFeatureState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        flyoverPresence_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a flyover exists for a given stretch of the
       * polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState flyover_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFlyoverPresence() {
        bitField0_ = (bitField0_ & ~0x00000001);
        flyoverPresence_ = 0;
        onChanged();
        return this;
      }

      private com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polylinePointIndex_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder>
          polylinePointIndexBuilder_;

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       *
       * @return Whether the polylinePointIndex field is set.
       */
      public boolean hasPolylinePointIndex() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       *
       * @return The polylinePointIndex.
       */
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex getPolylinePointIndex() {
        if (polylinePointIndexBuilder_ == null) {
          return polylinePointIndex_ == null
              ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
              : polylinePointIndex_;
        } else {
          return polylinePointIndexBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder setPolylinePointIndex(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex value) {
        if (polylinePointIndexBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          polylinePointIndex_ = value;
        } else {
          polylinePointIndexBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder setPolylinePointIndex(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder builderForValue) {
        if (polylinePointIndexBuilder_ == null) {
          polylinePointIndex_ = builderForValue.build();
        } else {
          polylinePointIndexBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder mergePolylinePointIndex(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex value) {
        if (polylinePointIndexBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && polylinePointIndex_ != null
              && polylinePointIndex_
                  != com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex
                      .getDefaultInstance()) {
            getPolylinePointIndexBuilder().mergeFrom(value);
          } else {
            polylinePointIndex_ = value;
          }
        } else {
          polylinePointIndexBuilder_.mergeFrom(value);
        }
        if (polylinePointIndex_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder clearPolylinePointIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        polylinePointIndex_ = null;
        if (polylinePointIndexBuilder_ != null) {
          polylinePointIndexBuilder_.dispose();
          polylinePointIndexBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder
          getPolylinePointIndexBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPolylinePointIndexFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder
          getPolylinePointIndexOrBuilder() {
        if (polylinePointIndexBuilder_ != null) {
          return polylinePointIndexBuilder_.getMessageOrBuilder();
        } else {
          return polylinePointIndex_ == null
              ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
              : polylinePointIndex_;
        }
      }

      /**
       *
       *
       * <pre>
       * The location of flyover related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder>
          getPolylinePointIndexFieldBuilder() {
        if (polylinePointIndexBuilder_ == null) {
          polylinePointIndexBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex,
                  com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder,
                  com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder>(
                  getPolylinePointIndex(), getParentForChildren(), isClean());
          polylinePointIndex_ = null;
        }
        return polylinePointIndexBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.PolylineDetails.FlyoverInfo)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.PolylineDetails.FlyoverInfo)
    private static final com.google.maps.routing.v2.PolylineDetails.FlyoverInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.maps.routing.v2.PolylineDetails.FlyoverInfo();
    }

    public static com.google.maps.routing.v2.PolylineDetails.FlyoverInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FlyoverInfo> PARSER =
        new com.google.protobuf.AbstractParser<FlyoverInfo>() {
          @java.lang.Override
          public FlyoverInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FlyoverInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FlyoverInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NarrowRoadInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.PolylineDetails.NarrowRoadInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a narrow road exists for a given stretch of
     * the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for narrowRoadPresence.
     */
    int getNarrowRoadPresenceValue();

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a narrow road exists for a given stretch of
     * the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The narrowRoadPresence.
     */
    com.google.maps.routing.v2.PolylineDetails.RoadFeatureState getNarrowRoadPresence();

    /**
     *
     *
     * <pre>
     * The location of narrow road related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return Whether the polylinePointIndex field is set.
     */
    boolean hasPolylinePointIndex();

    /**
     *
     *
     * <pre>
     * The location of narrow road related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return The polylinePointIndex.
     */
    com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex getPolylinePointIndex();

    /**
     *
     *
     * <pre>
     * The location of narrow road related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     */
    com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder
        getPolylinePointIndexOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Encapsulates information about narrow roads along the polyline.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.PolylineDetails.NarrowRoadInfo}
   */
  public static final class NarrowRoadInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.PolylineDetails.NarrowRoadInfo)
      NarrowRoadInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NarrowRoadInfo.newBuilder() to construct.
    private NarrowRoadInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NarrowRoadInfo() {
      narrowRoadPresence_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NarrowRoadInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_NarrowRoadInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_NarrowRoadInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.class,
              com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder.class);
    }

    private int bitField0_;
    public static final int NARROW_ROAD_PRESENCE_FIELD_NUMBER = 1;
    private int narrowRoadPresence_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a narrow road exists for a given stretch of
     * the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for narrowRoadPresence.
     */
    @java.lang.Override
    public int getNarrowRoadPresenceValue() {
      return narrowRoadPresence_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Denotes whether a narrow road exists for a given stretch of
     * the polyline.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The narrowRoadPresence.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.RoadFeatureState getNarrowRoadPresence() {
      com.google.maps.routing.v2.PolylineDetails.RoadFeatureState result =
          com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.forNumber(
              narrowRoadPresence_);
      return result == null
          ? com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.UNRECOGNIZED
          : result;
    }

    public static final int POLYLINE_POINT_INDEX_FIELD_NUMBER = 2;
    private com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polylinePointIndex_;

    /**
     *
     *
     * <pre>
     * The location of narrow road related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return Whether the polylinePointIndex field is set.
     */
    @java.lang.Override
    public boolean hasPolylinePointIndex() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The location of narrow road related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     *
     * @return The polylinePointIndex.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex getPolylinePointIndex() {
      return polylinePointIndex_ == null
          ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
          : polylinePointIndex_;
    }

    /**
     *
     *
     * <pre>
     * The location of narrow road related information along the polyline.
     * </pre>
     *
     * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder
        getPolylinePointIndexOrBuilder() {
      return polylinePointIndex_ == null
          ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
          : polylinePointIndex_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (narrowRoadPresence_
          != com.google.maps.routing.v2.PolylineDetails.RoadFeatureState
              .ROAD_FEATURE_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, narrowRoadPresence_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getPolylinePointIndex());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (narrowRoadPresence_
          != com.google.maps.routing.v2.PolylineDetails.RoadFeatureState
              .ROAD_FEATURE_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, narrowRoadPresence_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPolylinePointIndex());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo other =
          (com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo) obj;

      if (narrowRoadPresence_ != other.narrowRoadPresence_) return false;
      if (hasPolylinePointIndex() != other.hasPolylinePointIndex()) return false;
      if (hasPolylinePointIndex()) {
        if (!getPolylinePointIndex().equals(other.getPolylinePointIndex())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NARROW_ROAD_PRESENCE_FIELD_NUMBER;
      hash = (53 * hash) + narrowRoadPresence_;
      if (hasPolylinePointIndex()) {
        hash = (37 * hash) + POLYLINE_POINT_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getPolylinePointIndex().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about narrow roads along the polyline.
     * </pre>
     *
     * Protobuf type {@code google.maps.routing.v2.PolylineDetails.NarrowRoadInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.PolylineDetails.NarrowRoadInfo)
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_NarrowRoadInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_NarrowRoadInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.class,
                com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder.class);
      }

      // Construct using com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPolylinePointIndexFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        narrowRoadPresence_ = 0;
        polylinePointIndex_ = null;
        if (polylinePointIndexBuilder_ != null) {
          polylinePointIndexBuilder_.dispose();
          polylinePointIndexBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.PolylineDetailsProto
            .internal_static_google_maps_routing_v2_PolylineDetails_NarrowRoadInfo_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo getDefaultInstanceForType() {
        return com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo build() {
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo buildPartial() {
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo result =
            new com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.narrowRoadPresence_ = narrowRoadPresence_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.polylinePointIndex_ =
              polylinePointIndexBuilder_ == null
                  ? polylinePointIndex_
                  : polylinePointIndexBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo) {
          return mergeFrom((com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo other) {
        if (other == com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.getDefaultInstance())
          return this;
        if (other.narrowRoadPresence_ != 0) {
          setNarrowRoadPresenceValue(other.getNarrowRoadPresenceValue());
        }
        if (other.hasPolylinePointIndex()) {
          mergePolylinePointIndex(other.getPolylinePointIndex());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  narrowRoadPresence_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getPolylinePointIndexFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int narrowRoadPresence_ = 0;

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a narrow road exists for a given stretch of
       * the polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for narrowRoadPresence.
       */
      @java.lang.Override
      public int getNarrowRoadPresenceValue() {
        return narrowRoadPresence_;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a narrow road exists for a given stretch of
       * the polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for narrowRoadPresence to set.
       * @return This builder for chaining.
       */
      public Builder setNarrowRoadPresenceValue(int value) {
        narrowRoadPresence_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a narrow road exists for a given stretch of
       * the polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The narrowRoadPresence.
       */
      @java.lang.Override
      public com.google.maps.routing.v2.PolylineDetails.RoadFeatureState getNarrowRoadPresence() {
        com.google.maps.routing.v2.PolylineDetails.RoadFeatureState result =
            com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.forNumber(
                narrowRoadPresence_);
        return result == null
            ? com.google.maps.routing.v2.PolylineDetails.RoadFeatureState.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a narrow road exists for a given stretch of
       * the polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The narrowRoadPresence to set.
       * @return This builder for chaining.
       */
      public Builder setNarrowRoadPresence(
          com.google.maps.routing.v2.PolylineDetails.RoadFeatureState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        narrowRoadPresence_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Denotes whether a narrow road exists for a given stretch of
       * the polyline.
       * </pre>
       *
       * <code>
       * .google.maps.routing.v2.PolylineDetails.RoadFeatureState narrow_road_presence = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNarrowRoadPresence() {
        bitField0_ = (bitField0_ & ~0x00000001);
        narrowRoadPresence_ = 0;
        onChanged();
        return this;
      }

      private com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polylinePointIndex_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder>
          polylinePointIndexBuilder_;

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       *
       * @return Whether the polylinePointIndex field is set.
       */
      public boolean hasPolylinePointIndex() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       *
       * @return The polylinePointIndex.
       */
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex getPolylinePointIndex() {
        if (polylinePointIndexBuilder_ == null) {
          return polylinePointIndex_ == null
              ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
              : polylinePointIndex_;
        } else {
          return polylinePointIndexBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder setPolylinePointIndex(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex value) {
        if (polylinePointIndexBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          polylinePointIndex_ = value;
        } else {
          polylinePointIndexBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder setPolylinePointIndex(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder builderForValue) {
        if (polylinePointIndexBuilder_ == null) {
          polylinePointIndex_ = builderForValue.build();
        } else {
          polylinePointIndexBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder mergePolylinePointIndex(
          com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex value) {
        if (polylinePointIndexBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && polylinePointIndex_ != null
              && polylinePointIndex_
                  != com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex
                      .getDefaultInstance()) {
            getPolylinePointIndexBuilder().mergeFrom(value);
          } else {
            polylinePointIndex_ = value;
          }
        } else {
          polylinePointIndexBuilder_.mergeFrom(value);
        }
        if (polylinePointIndex_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public Builder clearPolylinePointIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        polylinePointIndex_ = null;
        if (polylinePointIndexBuilder_ != null) {
          polylinePointIndexBuilder_.dispose();
          polylinePointIndexBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder
          getPolylinePointIndexBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPolylinePointIndexFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      public com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder
          getPolylinePointIndexOrBuilder() {
        if (polylinePointIndexBuilder_ != null) {
          return polylinePointIndexBuilder_.getMessageOrBuilder();
        } else {
          return polylinePointIndex_ == null
              ? com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.getDefaultInstance()
              : polylinePointIndex_;
        }
      }

      /**
       *
       *
       * <pre>
       * The location of narrow road related information along the polyline.
       * </pre>
       *
       * <code>.google.maps.routing.v2.PolylineDetails.PolylinePointIndex polyline_point_index = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder,
              com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder>
          getPolylinePointIndexFieldBuilder() {
        if (polylinePointIndexBuilder_ == null) {
          polylinePointIndexBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex,
                  com.google.maps.routing.v2.PolylineDetails.PolylinePointIndex.Builder,
                  com.google.maps.routing.v2.PolylineDetails.PolylinePointIndexOrBuilder>(
                  getPolylinePointIndex(), getParentForChildren(), isClean());
          polylinePointIndex_ = null;
        }
        return polylinePointIndexBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.PolylineDetails.NarrowRoadInfo)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.PolylineDetails.NarrowRoadInfo)
    private static final com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo();
    }

    public static com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NarrowRoadInfo> PARSER =
        new com.google.protobuf.AbstractParser<NarrowRoadInfo>() {
          @java.lang.Override
          public NarrowRoadInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NarrowRoadInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NarrowRoadInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FLYOVER_INFO_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.PolylineDetails.FlyoverInfo> flyoverInfo_;

  /**
   *
   *
   * <pre>
   * Flyover details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.PolylineDetails.FlyoverInfo>
      getFlyoverInfoList() {
    return flyoverInfo_;
  }

  /**
   *
   *
   * <pre>
   * Flyover details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder>
      getFlyoverInfoOrBuilderList() {
    return flyoverInfo_;
  }

  /**
   *
   *
   * <pre>
   * Flyover details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
   */
  @java.lang.Override
  public int getFlyoverInfoCount() {
    return flyoverInfo_.size();
  }

  /**
   *
   *
   * <pre>
   * Flyover details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo getFlyoverInfo(int index) {
    return flyoverInfo_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Flyover details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder getFlyoverInfoOrBuilder(
      int index) {
    return flyoverInfo_.get(index);
  }

  public static final int NARROW_ROAD_INFO_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo> narrowRoadInfo_;

  /**
   *
   *
   * <pre>
   * Narrow road details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo>
      getNarrowRoadInfoList() {
    return narrowRoadInfo_;
  }

  /**
   *
   *
   * <pre>
   * Narrow road details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder>
      getNarrowRoadInfoOrBuilderList() {
    return narrowRoadInfo_;
  }

  /**
   *
   *
   * <pre>
   * Narrow road details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
   * </code>
   */
  @java.lang.Override
  public int getNarrowRoadInfoCount() {
    return narrowRoadInfo_.size();
  }

  /**
   *
   *
   * <pre>
   * Narrow road details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo getNarrowRoadInfo(int index) {
    return narrowRoadInfo_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Narrow road details along the polyline.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder
      getNarrowRoadInfoOrBuilder(int index) {
    return narrowRoadInfo_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < flyoverInfo_.size(); i++) {
      output.writeMessage(12, flyoverInfo_.get(i));
    }
    for (int i = 0; i < narrowRoadInfo_.size(); i++) {
      output.writeMessage(13, narrowRoadInfo_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < flyoverInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, flyoverInfo_.get(i));
    }
    for (int i = 0; i < narrowRoadInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, narrowRoadInfo_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.PolylineDetails)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.PolylineDetails other =
        (com.google.maps.routing.v2.PolylineDetails) obj;

    if (!getFlyoverInfoList().equals(other.getFlyoverInfoList())) return false;
    if (!getNarrowRoadInfoList().equals(other.getNarrowRoadInfoList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFlyoverInfoCount() > 0) {
      hash = (37 * hash) + FLYOVER_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getFlyoverInfoList().hashCode();
    }
    if (getNarrowRoadInfoCount() > 0) {
      hash = (37 * hash) + NARROW_ROAD_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getNarrowRoadInfoList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.PolylineDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.PolylineDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Details corresponding to a given index or contiguous segment of a polyline.
   * Given a polyline with points P_0, P_1, ... , P_N (zero-based index), the
   * `PolylineDetails` defines an interval and associated metadata.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.PolylineDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.PolylineDetails)
      com.google.maps.routing.v2.PolylineDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.PolylineDetails.class,
              com.google.maps.routing.v2.PolylineDetails.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.PolylineDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (flyoverInfoBuilder_ == null) {
        flyoverInfo_ = java.util.Collections.emptyList();
      } else {
        flyoverInfo_ = null;
        flyoverInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (narrowRoadInfoBuilder_ == null) {
        narrowRoadInfo_ = java.util.Collections.emptyList();
      } else {
        narrowRoadInfo_ = null;
        narrowRoadInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.PolylineDetailsProto
          .internal_static_google_maps_routing_v2_PolylineDetails_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails getDefaultInstanceForType() {
      return com.google.maps.routing.v2.PolylineDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails build() {
      com.google.maps.routing.v2.PolylineDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.PolylineDetails buildPartial() {
      com.google.maps.routing.v2.PolylineDetails result =
          new com.google.maps.routing.v2.PolylineDetails(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.PolylineDetails result) {
      if (flyoverInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          flyoverInfo_ = java.util.Collections.unmodifiableList(flyoverInfo_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.flyoverInfo_ = flyoverInfo_;
      } else {
        result.flyoverInfo_ = flyoverInfoBuilder_.build();
      }
      if (narrowRoadInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          narrowRoadInfo_ = java.util.Collections.unmodifiableList(narrowRoadInfo_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.narrowRoadInfo_ = narrowRoadInfo_;
      } else {
        result.narrowRoadInfo_ = narrowRoadInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.routing.v2.PolylineDetails result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.PolylineDetails) {
        return mergeFrom((com.google.maps.routing.v2.PolylineDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.PolylineDetails other) {
      if (other == com.google.maps.routing.v2.PolylineDetails.getDefaultInstance()) return this;
      if (flyoverInfoBuilder_ == null) {
        if (!other.flyoverInfo_.isEmpty()) {
          if (flyoverInfo_.isEmpty()) {
            flyoverInfo_ = other.flyoverInfo_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFlyoverInfoIsMutable();
            flyoverInfo_.addAll(other.flyoverInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.flyoverInfo_.isEmpty()) {
          if (flyoverInfoBuilder_.isEmpty()) {
            flyoverInfoBuilder_.dispose();
            flyoverInfoBuilder_ = null;
            flyoverInfo_ = other.flyoverInfo_;
            bitField0_ = (bitField0_ & ~0x00000001);
            flyoverInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFlyoverInfoFieldBuilder()
                    : null;
          } else {
            flyoverInfoBuilder_.addAllMessages(other.flyoverInfo_);
          }
        }
      }
      if (narrowRoadInfoBuilder_ == null) {
        if (!other.narrowRoadInfo_.isEmpty()) {
          if (narrowRoadInfo_.isEmpty()) {
            narrowRoadInfo_ = other.narrowRoadInfo_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureNarrowRoadInfoIsMutable();
            narrowRoadInfo_.addAll(other.narrowRoadInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.narrowRoadInfo_.isEmpty()) {
          if (narrowRoadInfoBuilder_.isEmpty()) {
            narrowRoadInfoBuilder_.dispose();
            narrowRoadInfoBuilder_ = null;
            narrowRoadInfo_ = other.narrowRoadInfo_;
            bitField0_ = (bitField0_ & ~0x00000002);
            narrowRoadInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNarrowRoadInfoFieldBuilder()
                    : null;
          } else {
            narrowRoadInfoBuilder_.addAllMessages(other.narrowRoadInfo_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 98:
              {
                com.google.maps.routing.v2.PolylineDetails.FlyoverInfo m =
                    input.readMessage(
                        com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.parser(),
                        extensionRegistry);
                if (flyoverInfoBuilder_ == null) {
                  ensureFlyoverInfoIsMutable();
                  flyoverInfo_.add(m);
                } else {
                  flyoverInfoBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo m =
                    input.readMessage(
                        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.parser(),
                        extensionRegistry);
                if (narrowRoadInfoBuilder_ == null) {
                  ensureNarrowRoadInfoIsMutable();
                  narrowRoadInfo_.add(m);
                } else {
                  narrowRoadInfoBuilder_.addMessage(m);
                }
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.maps.routing.v2.PolylineDetails.FlyoverInfo> flyoverInfo_ =
        java.util.Collections.emptyList();

    private void ensureFlyoverInfoIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        flyoverInfo_ =
            new java.util.ArrayList<com.google.maps.routing.v2.PolylineDetails.FlyoverInfo>(
                flyoverInfo_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.PolylineDetails.FlyoverInfo,
            com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder,
            com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder>
        flyoverInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public java.util.List<com.google.maps.routing.v2.PolylineDetails.FlyoverInfo>
        getFlyoverInfoList() {
      if (flyoverInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(flyoverInfo_);
      } else {
        return flyoverInfoBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public int getFlyoverInfoCount() {
      if (flyoverInfoBuilder_ == null) {
        return flyoverInfo_.size();
      } else {
        return flyoverInfoBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo getFlyoverInfo(int index) {
      if (flyoverInfoBuilder_ == null) {
        return flyoverInfo_.get(index);
      } else {
        return flyoverInfoBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder setFlyoverInfo(
        int index, com.google.maps.routing.v2.PolylineDetails.FlyoverInfo value) {
      if (flyoverInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.set(index, value);
        onChanged();
      } else {
        flyoverInfoBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder setFlyoverInfo(
        int index, com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder builderForValue) {
      if (flyoverInfoBuilder_ == null) {
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        flyoverInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder addFlyoverInfo(com.google.maps.routing.v2.PolylineDetails.FlyoverInfo value) {
      if (flyoverInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.add(value);
        onChanged();
      } else {
        flyoverInfoBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder addFlyoverInfo(
        int index, com.google.maps.routing.v2.PolylineDetails.FlyoverInfo value) {
      if (flyoverInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.add(index, value);
        onChanged();
      } else {
        flyoverInfoBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder addFlyoverInfo(
        com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder builderForValue) {
      if (flyoverInfoBuilder_ == null) {
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.add(builderForValue.build());
        onChanged();
      } else {
        flyoverInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder addFlyoverInfo(
        int index, com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder builderForValue) {
      if (flyoverInfoBuilder_ == null) {
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        flyoverInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder addAllFlyoverInfo(
        java.lang.Iterable<? extends com.google.maps.routing.v2.PolylineDetails.FlyoverInfo>
            values) {
      if (flyoverInfoBuilder_ == null) {
        ensureFlyoverInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, flyoverInfo_);
        onChanged();
      } else {
        flyoverInfoBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder clearFlyoverInfo() {
      if (flyoverInfoBuilder_ == null) {
        flyoverInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        flyoverInfoBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public Builder removeFlyoverInfo(int index) {
      if (flyoverInfoBuilder_ == null) {
        ensureFlyoverInfoIsMutable();
        flyoverInfo_.remove(index);
        onChanged();
      } else {
        flyoverInfoBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder getFlyoverInfoBuilder(
        int index) {
      return getFlyoverInfoFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder getFlyoverInfoOrBuilder(
        int index) {
      if (flyoverInfoBuilder_ == null) {
        return flyoverInfo_.get(index);
      } else {
        return flyoverInfoBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder>
        getFlyoverInfoOrBuilderList() {
      if (flyoverInfoBuilder_ != null) {
        return flyoverInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(flyoverInfo_);
      }
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder addFlyoverInfoBuilder() {
      return getFlyoverInfoFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder addFlyoverInfoBuilder(
        int index) {
      return getFlyoverInfoFieldBuilder()
          .addBuilder(
              index, com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Flyover details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.FlyoverInfo flyover_info = 12;</code>
     */
    public java.util.List<com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder>
        getFlyoverInfoBuilderList() {
      return getFlyoverInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.PolylineDetails.FlyoverInfo,
            com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder,
            com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder>
        getFlyoverInfoFieldBuilder() {
      if (flyoverInfoBuilder_ == null) {
        flyoverInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.PolylineDetails.FlyoverInfo,
                com.google.maps.routing.v2.PolylineDetails.FlyoverInfo.Builder,
                com.google.maps.routing.v2.PolylineDetails.FlyoverInfoOrBuilder>(
                flyoverInfo_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        flyoverInfo_ = null;
      }
      return flyoverInfoBuilder_;
    }

    private java.util.List<com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo>
        narrowRoadInfo_ = java.util.Collections.emptyList();

    private void ensureNarrowRoadInfoIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        narrowRoadInfo_ =
            new java.util.ArrayList<com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo>(
                narrowRoadInfo_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo,
            com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder,
            com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder>
        narrowRoadInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo>
        getNarrowRoadInfoList() {
      if (narrowRoadInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(narrowRoadInfo_);
      } else {
        return narrowRoadInfoBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public int getNarrowRoadInfoCount() {
      if (narrowRoadInfoBuilder_ == null) {
        return narrowRoadInfo_.size();
      } else {
        return narrowRoadInfoBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo getNarrowRoadInfo(int index) {
      if (narrowRoadInfoBuilder_ == null) {
        return narrowRoadInfo_.get(index);
      } else {
        return narrowRoadInfoBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder setNarrowRoadInfo(
        int index, com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo value) {
      if (narrowRoadInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.set(index, value);
        onChanged();
      } else {
        narrowRoadInfoBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder setNarrowRoadInfo(
        int index,
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder builderForValue) {
      if (narrowRoadInfoBuilder_ == null) {
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        narrowRoadInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder addNarrowRoadInfo(
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo value) {
      if (narrowRoadInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.add(value);
        onChanged();
      } else {
        narrowRoadInfoBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder addNarrowRoadInfo(
        int index, com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo value) {
      if (narrowRoadInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.add(index, value);
        onChanged();
      } else {
        narrowRoadInfoBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder addNarrowRoadInfo(
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder builderForValue) {
      if (narrowRoadInfoBuilder_ == null) {
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.add(builderForValue.build());
        onChanged();
      } else {
        narrowRoadInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder addNarrowRoadInfo(
        int index,
        com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder builderForValue) {
      if (narrowRoadInfoBuilder_ == null) {
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        narrowRoadInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder addAllNarrowRoadInfo(
        java.lang.Iterable<? extends com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo>
            values) {
      if (narrowRoadInfoBuilder_ == null) {
        ensureNarrowRoadInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, narrowRoadInfo_);
        onChanged();
      } else {
        narrowRoadInfoBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder clearNarrowRoadInfo() {
      if (narrowRoadInfoBuilder_ == null) {
        narrowRoadInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        narrowRoadInfoBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public Builder removeNarrowRoadInfo(int index) {
      if (narrowRoadInfoBuilder_ == null) {
        ensureNarrowRoadInfoIsMutable();
        narrowRoadInfo_.remove(index);
        onChanged();
      } else {
        narrowRoadInfoBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder
        getNarrowRoadInfoBuilder(int index) {
      return getNarrowRoadInfoFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder
        getNarrowRoadInfoOrBuilder(int index) {
      if (narrowRoadInfoBuilder_ == null) {
        return narrowRoadInfo_.get(index);
      } else {
        return narrowRoadInfoBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public java.util.List<
            ? extends com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder>
        getNarrowRoadInfoOrBuilderList() {
      if (narrowRoadInfoBuilder_ != null) {
        return narrowRoadInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(narrowRoadInfo_);
      }
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder
        addNarrowRoadInfoBuilder() {
      return getNarrowRoadInfoFieldBuilder()
          .addBuilder(
              com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder
        addNarrowRoadInfoBuilder(int index) {
      return getNarrowRoadInfoFieldBuilder()
          .addBuilder(
              index,
              com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Narrow road details along the polyline.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.PolylineDetails.NarrowRoadInfo narrow_road_info = 13;
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder>
        getNarrowRoadInfoBuilderList() {
      return getNarrowRoadInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo,
            com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder,
            com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder>
        getNarrowRoadInfoFieldBuilder() {
      if (narrowRoadInfoBuilder_ == null) {
        narrowRoadInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo,
                com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfo.Builder,
                com.google.maps.routing.v2.PolylineDetails.NarrowRoadInfoOrBuilder>(
                narrowRoadInfo_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        narrowRoadInfo_ = null;
      }
      return narrowRoadInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.PolylineDetails)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.PolylineDetails)
  private static final com.google.maps.routing.v2.PolylineDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.PolylineDetails();
  }

  public static com.google.maps.routing.v2.PolylineDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PolylineDetails> PARSER =
      new com.google.protobuf.AbstractParser<PolylineDetails>() {
        @java.lang.Override
        public PolylineDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PolylineDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PolylineDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.PolylineDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
