/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/route.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Additional information for the `RouteLegStep` related to `TRANSIT` routes.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.RouteLegStepTransitDetails}
 */
public final class RouteLegStepTransitDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteLegStepTransitDetails)
    RouteLegStepTransitDetailsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouteLegStepTransitDetails.newBuilder() to construct.
  private RouteLegStepTransitDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouteLegStepTransitDetails() {
    headsign_ = "";
    tripShortText_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouteLegStepTransitDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.RouteLegStepTransitDetails.class,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder.class);
  }

  public interface TransitStopDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Information about the arrival stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
     *
     * @return Whether the arrivalStop field is set.
     */
    boolean hasArrivalStop();

    /**
     *
     *
     * <pre>
     * Information about the arrival stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
     *
     * @return The arrivalStop.
     */
    com.google.maps.routing.v2.TransitStop getArrivalStop();

    /**
     *
     *
     * <pre>
     * Information about the arrival stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
     */
    com.google.maps.routing.v2.TransitStopOrBuilder getArrivalStopOrBuilder();

    /**
     *
     *
     * <pre>
     * The estimated time of arrival for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
     *
     * @return Whether the arrivalTime field is set.
     */
    boolean hasArrivalTime();

    /**
     *
     *
     * <pre>
     * The estimated time of arrival for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
     *
     * @return The arrivalTime.
     */
    com.google.protobuf.Timestamp getArrivalTime();

    /**
     *
     *
     * <pre>
     * The estimated time of arrival for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Information about the departure stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
     *
     * @return Whether the departureStop field is set.
     */
    boolean hasDepartureStop();

    /**
     *
     *
     * <pre>
     * Information about the departure stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
     *
     * @return The departureStop.
     */
    com.google.maps.routing.v2.TransitStop getDepartureStop();

    /**
     *
     *
     * <pre>
     * Information about the departure stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
     */
    com.google.maps.routing.v2.TransitStopOrBuilder getDepartureStopOrBuilder();

    /**
     *
     *
     * <pre>
     * The estimated time of departure for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp departure_time = 4;</code>
     *
     * @return Whether the departureTime field is set.
     */
    boolean hasDepartureTime();

    /**
     *
     *
     * <pre>
     * The estimated time of departure for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp departure_time = 4;</code>
     *
     * @return The departureTime.
     */
    com.google.protobuf.Timestamp getDepartureTime();

    /**
     *
     *
     * <pre>
     * The estimated time of departure for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp departure_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Details about the transit stops for the `RouteLegStep`.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails}
   */
  public static final class TransitStopDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails)
      TransitStopDetailsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TransitStopDetails.newBuilder() to construct.
    private TransitStopDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransitStopDetails() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransitStopDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitStopDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitStopDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.class,
              com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder
                  .class);
    }

    private int bitField0_;
    public static final int ARRIVAL_STOP_FIELD_NUMBER = 1;
    private com.google.maps.routing.v2.TransitStop arrivalStop_;

    /**
     *
     *
     * <pre>
     * Information about the arrival stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
     *
     * @return Whether the arrivalStop field is set.
     */
    @java.lang.Override
    public boolean hasArrivalStop() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
     *
     * @return The arrivalStop.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TransitStop getArrivalStop() {
      return arrivalStop_ == null
          ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
          : arrivalStop_;
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TransitStopOrBuilder getArrivalStopOrBuilder() {
      return arrivalStop_ == null
          ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
          : arrivalStop_;
    }

    public static final int ARRIVAL_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp arrivalTime_;

    /**
     *
     *
     * <pre>
     * The estimated time of arrival for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
     *
     * @return Whether the arrivalTime field is set.
     */
    @java.lang.Override
    public boolean hasArrivalTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The estimated time of arrival for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
     *
     * @return The arrivalTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getArrivalTime() {
      return arrivalTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : arrivalTime_;
    }

    /**
     *
     *
     * <pre>
     * The estimated time of arrival for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder() {
      return arrivalTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : arrivalTime_;
    }

    public static final int DEPARTURE_STOP_FIELD_NUMBER = 3;
    private com.google.maps.routing.v2.TransitStop departureStop_;

    /**
     *
     *
     * <pre>
     * Information about the departure stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
     *
     * @return Whether the departureStop field is set.
     */
    @java.lang.Override
    public boolean hasDepartureStop() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Information about the departure stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
     *
     * @return The departureStop.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TransitStop getDepartureStop() {
      return departureStop_ == null
          ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
          : departureStop_;
    }

    /**
     *
     *
     * <pre>
     * Information about the departure stop for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TransitStopOrBuilder getDepartureStopOrBuilder() {
      return departureStop_ == null
          ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
          : departureStop_;
    }

    public static final int DEPARTURE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp departureTime_;

    /**
     *
     *
     * <pre>
     * The estimated time of departure for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp departure_time = 4;</code>
     *
     * @return Whether the departureTime field is set.
     */
    @java.lang.Override
    public boolean hasDepartureTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The estimated time of departure for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp departure_time = 4;</code>
     *
     * @return The departureTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getDepartureTime() {
      return departureTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : departureTime_;
    }

    /**
     *
     *
     * <pre>
     * The estimated time of departure for the step.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp departure_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder() {
      return departureTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : departureTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getArrivalStop());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getArrivalTime());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getDepartureStop());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getDepartureTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getArrivalStop());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getArrivalTime());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDepartureStop());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDepartureTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails other =
          (com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails) obj;

      if (hasArrivalStop() != other.hasArrivalStop()) return false;
      if (hasArrivalStop()) {
        if (!getArrivalStop().equals(other.getArrivalStop())) return false;
      }
      if (hasArrivalTime() != other.hasArrivalTime()) return false;
      if (hasArrivalTime()) {
        if (!getArrivalTime().equals(other.getArrivalTime())) return false;
      }
      if (hasDepartureStop() != other.hasDepartureStop()) return false;
      if (hasDepartureStop()) {
        if (!getDepartureStop().equals(other.getDepartureStop())) return false;
      }
      if (hasDepartureTime() != other.hasDepartureTime()) return false;
      if (hasDepartureTime()) {
        if (!getDepartureTime().equals(other.getDepartureTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasArrivalStop()) {
        hash = (37 * hash) + ARRIVAL_STOP_FIELD_NUMBER;
        hash = (53 * hash) + getArrivalStop().hashCode();
      }
      if (hasArrivalTime()) {
        hash = (37 * hash) + ARRIVAL_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getArrivalTime().hashCode();
      }
      if (hasDepartureStop()) {
        hash = (37 * hash) + DEPARTURE_STOP_FIELD_NUMBER;
        hash = (53 * hash) + getDepartureStop().hashCode();
      }
      if (hasDepartureTime()) {
        hash = (37 * hash) + DEPARTURE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDepartureTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Details about the transit stops for the `RouteLegStep`.
     * </pre>
     *
     * Protobuf type {@code google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails)
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitStopDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitStopDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.class,
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder
                    .class);
      }

      // Construct using
      // com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getArrivalStopFieldBuilder();
          getArrivalTimeFieldBuilder();
          getDepartureStopFieldBuilder();
          getDepartureTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        arrivalStop_ = null;
        if (arrivalStopBuilder_ != null) {
          arrivalStopBuilder_.dispose();
          arrivalStopBuilder_ = null;
        }
        arrivalTime_ = null;
        if (arrivalTimeBuilder_ != null) {
          arrivalTimeBuilder_.dispose();
          arrivalTimeBuilder_ = null;
        }
        departureStop_ = null;
        if (departureStopBuilder_ != null) {
          departureStopBuilder_.dispose();
          departureStopBuilder_ = null;
        }
        departureTime_ = null;
        if (departureTimeBuilder_ != null) {
          departureTimeBuilder_.dispose();
          departureTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitStopDetails_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
          getDefaultInstanceForType() {
        return com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails build() {
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
          buildPartial() {
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails result =
            new com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.arrivalStop_ =
              arrivalStopBuilder_ == null ? arrivalStop_ : arrivalStopBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.arrivalTime_ =
              arrivalTimeBuilder_ == null ? arrivalTime_ : arrivalTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.departureStop_ =
              departureStopBuilder_ == null ? departureStop_ : departureStopBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.departureTime_ =
              departureTimeBuilder_ == null ? departureTime_ : departureTimeBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails) {
          return mergeFrom(
              (com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails other) {
        if (other
            == com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
                .getDefaultInstance()) return this;
        if (other.hasArrivalStop()) {
          mergeArrivalStop(other.getArrivalStop());
        }
        if (other.hasArrivalTime()) {
          mergeArrivalTime(other.getArrivalTime());
        }
        if (other.hasDepartureStop()) {
          mergeDepartureStop(other.getDepartureStop());
        }
        if (other.hasDepartureTime()) {
          mergeDepartureTime(other.getDepartureTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getArrivalStopFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getDepartureStopFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.maps.routing.v2.TransitStop arrivalStop_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.TransitStop,
              com.google.maps.routing.v2.TransitStop.Builder,
              com.google.maps.routing.v2.TransitStopOrBuilder>
          arrivalStopBuilder_;

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       *
       * @return Whether the arrivalStop field is set.
       */
      public boolean hasArrivalStop() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       *
       * @return The arrivalStop.
       */
      public com.google.maps.routing.v2.TransitStop getArrivalStop() {
        if (arrivalStopBuilder_ == null) {
          return arrivalStop_ == null
              ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
              : arrivalStop_;
        } else {
          return arrivalStopBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      public Builder setArrivalStop(com.google.maps.routing.v2.TransitStop value) {
        if (arrivalStopBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          arrivalStop_ = value;
        } else {
          arrivalStopBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      public Builder setArrivalStop(
          com.google.maps.routing.v2.TransitStop.Builder builderForValue) {
        if (arrivalStopBuilder_ == null) {
          arrivalStop_ = builderForValue.build();
        } else {
          arrivalStopBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      public Builder mergeArrivalStop(com.google.maps.routing.v2.TransitStop value) {
        if (arrivalStopBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && arrivalStop_ != null
              && arrivalStop_ != com.google.maps.routing.v2.TransitStop.getDefaultInstance()) {
            getArrivalStopBuilder().mergeFrom(value);
          } else {
            arrivalStop_ = value;
          }
        } else {
          arrivalStopBuilder_.mergeFrom(value);
        }
        if (arrivalStop_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      public Builder clearArrivalStop() {
        bitField0_ = (bitField0_ & ~0x00000001);
        arrivalStop_ = null;
        if (arrivalStopBuilder_ != null) {
          arrivalStopBuilder_.dispose();
          arrivalStopBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      public com.google.maps.routing.v2.TransitStop.Builder getArrivalStopBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getArrivalStopFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      public com.google.maps.routing.v2.TransitStopOrBuilder getArrivalStopOrBuilder() {
        if (arrivalStopBuilder_ != null) {
          return arrivalStopBuilder_.getMessageOrBuilder();
        } else {
          return arrivalStop_ == null
              ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
              : arrivalStop_;
        }
      }

      /**
       *
       *
       * <pre>
       * Information about the arrival stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop arrival_stop = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.TransitStop,
              com.google.maps.routing.v2.TransitStop.Builder,
              com.google.maps.routing.v2.TransitStopOrBuilder>
          getArrivalStopFieldBuilder() {
        if (arrivalStopBuilder_ == null) {
          arrivalStopBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.maps.routing.v2.TransitStop,
                  com.google.maps.routing.v2.TransitStop.Builder,
                  com.google.maps.routing.v2.TransitStopOrBuilder>(
                  getArrivalStop(), getParentForChildren(), isClean());
          arrivalStop_ = null;
        }
        return arrivalStopBuilder_;
      }

      private com.google.protobuf.Timestamp arrivalTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          arrivalTimeBuilder_;

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       *
       * @return Whether the arrivalTime field is set.
       */
      public boolean hasArrivalTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       *
       * @return The arrivalTime.
       */
      public com.google.protobuf.Timestamp getArrivalTime() {
        if (arrivalTimeBuilder_ == null) {
          return arrivalTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : arrivalTime_;
        } else {
          return arrivalTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      public Builder setArrivalTime(com.google.protobuf.Timestamp value) {
        if (arrivalTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          arrivalTime_ = value;
        } else {
          arrivalTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      public Builder setArrivalTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (arrivalTimeBuilder_ == null) {
          arrivalTime_ = builderForValue.build();
        } else {
          arrivalTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      public Builder mergeArrivalTime(com.google.protobuf.Timestamp value) {
        if (arrivalTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && arrivalTime_ != null
              && arrivalTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getArrivalTimeBuilder().mergeFrom(value);
          } else {
            arrivalTime_ = value;
          }
        } else {
          arrivalTimeBuilder_.mergeFrom(value);
        }
        if (arrivalTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      public Builder clearArrivalTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        arrivalTime_ = null;
        if (arrivalTimeBuilder_ != null) {
          arrivalTimeBuilder_.dispose();
          arrivalTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getArrivalTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getArrivalTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getArrivalTimeOrBuilder() {
        if (arrivalTimeBuilder_ != null) {
          return arrivalTimeBuilder_.getMessageOrBuilder();
        } else {
          return arrivalTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : arrivalTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * The estimated time of arrival for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp arrival_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getArrivalTimeFieldBuilder() {
        if (arrivalTimeBuilder_ == null) {
          arrivalTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getArrivalTime(), getParentForChildren(), isClean());
          arrivalTime_ = null;
        }
        return arrivalTimeBuilder_;
      }

      private com.google.maps.routing.v2.TransitStop departureStop_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.TransitStop,
              com.google.maps.routing.v2.TransitStop.Builder,
              com.google.maps.routing.v2.TransitStopOrBuilder>
          departureStopBuilder_;

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       *
       * @return Whether the departureStop field is set.
       */
      public boolean hasDepartureStop() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       *
       * @return The departureStop.
       */
      public com.google.maps.routing.v2.TransitStop getDepartureStop() {
        if (departureStopBuilder_ == null) {
          return departureStop_ == null
              ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
              : departureStop_;
        } else {
          return departureStopBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      public Builder setDepartureStop(com.google.maps.routing.v2.TransitStop value) {
        if (departureStopBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          departureStop_ = value;
        } else {
          departureStopBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      public Builder setDepartureStop(
          com.google.maps.routing.v2.TransitStop.Builder builderForValue) {
        if (departureStopBuilder_ == null) {
          departureStop_ = builderForValue.build();
        } else {
          departureStopBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      public Builder mergeDepartureStop(com.google.maps.routing.v2.TransitStop value) {
        if (departureStopBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && departureStop_ != null
              && departureStop_ != com.google.maps.routing.v2.TransitStop.getDefaultInstance()) {
            getDepartureStopBuilder().mergeFrom(value);
          } else {
            departureStop_ = value;
          }
        } else {
          departureStopBuilder_.mergeFrom(value);
        }
        if (departureStop_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      public Builder clearDepartureStop() {
        bitField0_ = (bitField0_ & ~0x00000004);
        departureStop_ = null;
        if (departureStopBuilder_ != null) {
          departureStopBuilder_.dispose();
          departureStopBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      public com.google.maps.routing.v2.TransitStop.Builder getDepartureStopBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getDepartureStopFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      public com.google.maps.routing.v2.TransitStopOrBuilder getDepartureStopOrBuilder() {
        if (departureStopBuilder_ != null) {
          return departureStopBuilder_.getMessageOrBuilder();
        } else {
          return departureStop_ == null
              ? com.google.maps.routing.v2.TransitStop.getDefaultInstance()
              : departureStop_;
        }
      }

      /**
       *
       *
       * <pre>
       * Information about the departure stop for the step.
       * </pre>
       *
       * <code>.google.maps.routing.v2.TransitStop departure_stop = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.TransitStop,
              com.google.maps.routing.v2.TransitStop.Builder,
              com.google.maps.routing.v2.TransitStopOrBuilder>
          getDepartureStopFieldBuilder() {
        if (departureStopBuilder_ == null) {
          departureStopBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.maps.routing.v2.TransitStop,
                  com.google.maps.routing.v2.TransitStop.Builder,
                  com.google.maps.routing.v2.TransitStopOrBuilder>(
                  getDepartureStop(), getParentForChildren(), isClean());
          departureStop_ = null;
        }
        return departureStopBuilder_;
      }

      private com.google.protobuf.Timestamp departureTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          departureTimeBuilder_;

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       *
       * @return Whether the departureTime field is set.
       */
      public boolean hasDepartureTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       *
       * @return The departureTime.
       */
      public com.google.protobuf.Timestamp getDepartureTime() {
        if (departureTimeBuilder_ == null) {
          return departureTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : departureTime_;
        } else {
          return departureTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      public Builder setDepartureTime(com.google.protobuf.Timestamp value) {
        if (departureTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          departureTime_ = value;
        } else {
          departureTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      public Builder setDepartureTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (departureTimeBuilder_ == null) {
          departureTime_ = builderForValue.build();
        } else {
          departureTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      public Builder mergeDepartureTime(com.google.protobuf.Timestamp value) {
        if (departureTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && departureTime_ != null
              && departureTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getDepartureTimeBuilder().mergeFrom(value);
          } else {
            departureTime_ = value;
          }
        } else {
          departureTimeBuilder_.mergeFrom(value);
        }
        if (departureTime_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      public Builder clearDepartureTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        departureTime_ = null;
        if (departureTimeBuilder_ != null) {
          departureTimeBuilder_.dispose();
          departureTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getDepartureTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getDepartureTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getDepartureTimeOrBuilder() {
        if (departureTimeBuilder_ != null) {
          return departureTimeBuilder_.getMessageOrBuilder();
        } else {
          return departureTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : departureTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * The estimated time of departure for the step.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp departure_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getDepartureTimeFieldBuilder() {
        if (departureTimeBuilder_ == null) {
          departureTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getDepartureTime(), getParentForChildren(), isClean());
          departureTime_ = null;
        }
        return departureTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails)
    private static final com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails();
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransitStopDetails> PARSER =
        new com.google.protobuf.AbstractParser<TransitStopDetails>() {
          @java.lang.Override
          public TransitStopDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransitStopDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransitStopDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransitDetailsLocalizedValuesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
     *
     * @return Whether the arrivalTime field is set.
     */
    boolean hasArrivalTime();

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
     *
     * @return The arrivalTime.
     */
    com.google.maps.routing.v2.LocalizedTime getArrivalTime();

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
     */
    com.google.maps.routing.v2.LocalizedTimeOrBuilder getArrivalTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
     *
     * @return Whether the departureTime field is set.
     */
    boolean hasDepartureTime();

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
     *
     * @return The departureTime.
     */
    com.google.maps.routing.v2.LocalizedTime getDepartureTime();

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
     */
    com.google.maps.routing.v2.LocalizedTimeOrBuilder getDepartureTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Localized descriptions of values for `RouteTransitDetails`.
   * </pre>
   *
   * Protobuf type {@code
   * google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues}
   */
  public static final class TransitDetailsLocalizedValues
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)
      TransitDetailsLocalizedValuesOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TransitDetailsLocalizedValues.newBuilder() to construct.
    private TransitDetailsLocalizedValues(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransitDetailsLocalizedValues() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransitDetailsLocalizedValues();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitDetailsLocalizedValues_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitDetailsLocalizedValues_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                  .class,
              com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                  .Builder.class);
    }

    private int bitField0_;
    public static final int ARRIVAL_TIME_FIELD_NUMBER = 1;
    private com.google.maps.routing.v2.LocalizedTime arrivalTime_;

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
     *
     * @return Whether the arrivalTime field is set.
     */
    @java.lang.Override
    public boolean hasArrivalTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
     *
     * @return The arrivalTime.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.LocalizedTime getArrivalTime() {
      return arrivalTime_ == null
          ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
          : arrivalTime_;
    }

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
     */
    @java.lang.Override
    public com.google.maps.routing.v2.LocalizedTimeOrBuilder getArrivalTimeOrBuilder() {
      return arrivalTime_ == null
          ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
          : arrivalTime_;
    }

    public static final int DEPARTURE_TIME_FIELD_NUMBER = 2;
    private com.google.maps.routing.v2.LocalizedTime departureTime_;

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
     *
     * @return Whether the departureTime field is set.
     */
    @java.lang.Override
    public boolean hasDepartureTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
     *
     * @return The departureTime.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.LocalizedTime getDepartureTime() {
      return departureTime_ == null
          ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
          : departureTime_;
    }

    /**
     *
     *
     * <pre>
     * Time in its formatted text representation with a corresponding time zone.
     * </pre>
     *
     * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
     */
    @java.lang.Override
    public com.google.maps.routing.v2.LocalizedTimeOrBuilder getDepartureTimeOrBuilder() {
      return departureTime_ == null
          ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
          : departureTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getArrivalTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getDepartureTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getArrivalTime());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDepartureTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)) {
        return super.equals(obj);
      }
      com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues other =
          (com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues) obj;

      if (hasArrivalTime() != other.hasArrivalTime()) return false;
      if (hasArrivalTime()) {
        if (!getArrivalTime().equals(other.getArrivalTime())) return false;
      }
      if (hasDepartureTime() != other.hasDepartureTime()) return false;
      if (hasDepartureTime()) {
        if (!getDepartureTime().equals(other.getDepartureTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasArrivalTime()) {
        hash = (37 * hash) + ARRIVAL_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getArrivalTime().hashCode();
      }
      if (hasDepartureTime()) {
        hash = (37 * hash) + DEPARTURE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDepartureTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Localized descriptions of values for `RouteTransitDetails`.
     * </pre>
     *
     * Protobuf type {@code
     * google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)
        com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValuesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitDetailsLocalizedValues_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitDetailsLocalizedValues_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                    .class,
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                    .Builder.class);
      }

      // Construct using
      // com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getArrivalTimeFieldBuilder();
          getDepartureTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        arrivalTime_ = null;
        if (arrivalTimeBuilder_ != null) {
          arrivalTimeBuilder_.dispose();
          arrivalTimeBuilder_ = null;
        }
        departureTime_ = null;
        if (departureTimeBuilder_ != null) {
          departureTimeBuilder_.dispose();
          departureTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.maps.routing.v2.RouteProto
            .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_TransitDetailsLocalizedValues_descriptor;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
          getDefaultInstanceForType() {
        return com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
          build() {
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
          buildPartial() {
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues result =
            new com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.arrivalTime_ =
              arrivalTimeBuilder_ == null ? arrivalTime_ : arrivalTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.departureTime_ =
              departureTimeBuilder_ == null ? departureTime_ : departureTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues) {
          return mergeFrom(
              (com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
              other) {
        if (other
            == com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                .getDefaultInstance()) return this;
        if (other.hasArrivalTime()) {
          mergeArrivalTime(other.getArrivalTime());
        }
        if (other.hasDepartureTime()) {
          mergeDepartureTime(other.getDepartureTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getArrivalTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.maps.routing.v2.LocalizedTime arrivalTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.LocalizedTime,
              com.google.maps.routing.v2.LocalizedTime.Builder,
              com.google.maps.routing.v2.LocalizedTimeOrBuilder>
          arrivalTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       *
       * @return Whether the arrivalTime field is set.
       */
      public boolean hasArrivalTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       *
       * @return The arrivalTime.
       */
      public com.google.maps.routing.v2.LocalizedTime getArrivalTime() {
        if (arrivalTimeBuilder_ == null) {
          return arrivalTime_ == null
              ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
              : arrivalTime_;
        } else {
          return arrivalTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      public Builder setArrivalTime(com.google.maps.routing.v2.LocalizedTime value) {
        if (arrivalTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          arrivalTime_ = value;
        } else {
          arrivalTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      public Builder setArrivalTime(
          com.google.maps.routing.v2.LocalizedTime.Builder builderForValue) {
        if (arrivalTimeBuilder_ == null) {
          arrivalTime_ = builderForValue.build();
        } else {
          arrivalTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      public Builder mergeArrivalTime(com.google.maps.routing.v2.LocalizedTime value) {
        if (arrivalTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && arrivalTime_ != null
              && arrivalTime_ != com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()) {
            getArrivalTimeBuilder().mergeFrom(value);
          } else {
            arrivalTime_ = value;
          }
        } else {
          arrivalTimeBuilder_.mergeFrom(value);
        }
        if (arrivalTime_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      public Builder clearArrivalTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        arrivalTime_ = null;
        if (arrivalTimeBuilder_ != null) {
          arrivalTimeBuilder_.dispose();
          arrivalTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      public com.google.maps.routing.v2.LocalizedTime.Builder getArrivalTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getArrivalTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      public com.google.maps.routing.v2.LocalizedTimeOrBuilder getArrivalTimeOrBuilder() {
        if (arrivalTimeBuilder_ != null) {
          return arrivalTimeBuilder_.getMessageOrBuilder();
        } else {
          return arrivalTime_ == null
              ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
              : arrivalTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime arrival_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.LocalizedTime,
              com.google.maps.routing.v2.LocalizedTime.Builder,
              com.google.maps.routing.v2.LocalizedTimeOrBuilder>
          getArrivalTimeFieldBuilder() {
        if (arrivalTimeBuilder_ == null) {
          arrivalTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.maps.routing.v2.LocalizedTime,
                  com.google.maps.routing.v2.LocalizedTime.Builder,
                  com.google.maps.routing.v2.LocalizedTimeOrBuilder>(
                  getArrivalTime(), getParentForChildren(), isClean());
          arrivalTime_ = null;
        }
        return arrivalTimeBuilder_;
      }

      private com.google.maps.routing.v2.LocalizedTime departureTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.LocalizedTime,
              com.google.maps.routing.v2.LocalizedTime.Builder,
              com.google.maps.routing.v2.LocalizedTimeOrBuilder>
          departureTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       *
       * @return Whether the departureTime field is set.
       */
      public boolean hasDepartureTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       *
       * @return The departureTime.
       */
      public com.google.maps.routing.v2.LocalizedTime getDepartureTime() {
        if (departureTimeBuilder_ == null) {
          return departureTime_ == null
              ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
              : departureTime_;
        } else {
          return departureTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      public Builder setDepartureTime(com.google.maps.routing.v2.LocalizedTime value) {
        if (departureTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          departureTime_ = value;
        } else {
          departureTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      public Builder setDepartureTime(
          com.google.maps.routing.v2.LocalizedTime.Builder builderForValue) {
        if (departureTimeBuilder_ == null) {
          departureTime_ = builderForValue.build();
        } else {
          departureTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      public Builder mergeDepartureTime(com.google.maps.routing.v2.LocalizedTime value) {
        if (departureTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && departureTime_ != null
              && departureTime_ != com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()) {
            getDepartureTimeBuilder().mergeFrom(value);
          } else {
            departureTime_ = value;
          }
        } else {
          departureTimeBuilder_.mergeFrom(value);
        }
        if (departureTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      public Builder clearDepartureTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        departureTime_ = null;
        if (departureTimeBuilder_ != null) {
          departureTimeBuilder_.dispose();
          departureTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      public com.google.maps.routing.v2.LocalizedTime.Builder getDepartureTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDepartureTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      public com.google.maps.routing.v2.LocalizedTimeOrBuilder getDepartureTimeOrBuilder() {
        if (departureTimeBuilder_ != null) {
          return departureTimeBuilder_.getMessageOrBuilder();
        } else {
          return departureTime_ == null
              ? com.google.maps.routing.v2.LocalizedTime.getDefaultInstance()
              : departureTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Time in its formatted text representation with a corresponding time zone.
       * </pre>
       *
       * <code>.google.maps.routing.v2.LocalizedTime departure_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.maps.routing.v2.LocalizedTime,
              com.google.maps.routing.v2.LocalizedTime.Builder,
              com.google.maps.routing.v2.LocalizedTimeOrBuilder>
          getDepartureTimeFieldBuilder() {
        if (departureTimeBuilder_ == null) {
          departureTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.maps.routing.v2.LocalizedTime,
                  com.google.maps.routing.v2.LocalizedTime.Builder,
                  com.google.maps.routing.v2.LocalizedTimeOrBuilder>(
                  getDepartureTime(), getParentForChildren(), isClean());
          departureTime_ = null;
        }
        return departureTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)
    }

    // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues)
    private static final com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues();
    }

    public static com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValues
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransitDetailsLocalizedValues> PARSER =
        new com.google.protobuf.AbstractParser<TransitDetailsLocalizedValues>() {
          @java.lang.Override
          public TransitDetailsLocalizedValues parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransitDetailsLocalizedValues> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransitDetailsLocalizedValues> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int STOP_DETAILS_FIELD_NUMBER = 1;
  private com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stopDetails_;

  /**
   *
   *
   * <pre>
   * Information about the arrival and departure stops for the step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
   * </code>
   *
   * @return Whether the stopDetails field is set.
   */
  @java.lang.Override
  public boolean hasStopDetails() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Information about the arrival and departure stops for the step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
   * </code>
   *
   * @return The stopDetails.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails getStopDetails() {
    return stopDetails_ == null
        ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
            .getDefaultInstance()
        : stopDetails_;
  }

  /**
   *
   *
   * <pre>
   * Information about the arrival and departure stops for the step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetailsOrBuilder
      getStopDetailsOrBuilder() {
    return stopDetails_ == null
        ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
            .getDefaultInstance()
        : stopDetails_;
  }

  public static final int LOCALIZED_VALUES_FIELD_NUMBER = 2;
  private com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
      localizedValues_;

  /**
   *
   *
   * <pre>
   * Text representations of properties of the `RouteLegStepTransitDetails`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
   * </code>
   *
   * @return Whether the localizedValues field is set.
   */
  @java.lang.Override
  public boolean hasLocalizedValues() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Text representations of properties of the `RouteLegStepTransitDetails`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
   * </code>
   *
   * @return The localizedValues.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
      getLocalizedValues() {
    return localizedValues_ == null
        ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
            .getDefaultInstance()
        : localizedValues_;
  }

  /**
   *
   *
   * <pre>
   * Text representations of properties of the `RouteLegStepTransitDetails`.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetails
          .TransitDetailsLocalizedValuesOrBuilder
      getLocalizedValuesOrBuilder() {
    return localizedValues_ == null
        ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
            .getDefaultInstance()
        : localizedValues_;
  }

  public static final int HEADSIGN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object headsign_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the direction in which to travel on this line as marked on
   * the vehicle or at the departure stop. The direction is often the terminus
   * station.
   * </pre>
   *
   * <code>string headsign = 3;</code>
   *
   * @return The headsign.
   */
  @java.lang.Override
  public java.lang.String getHeadsign() {
    java.lang.Object ref = headsign_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      headsign_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the direction in which to travel on this line as marked on
   * the vehicle or at the departure stop. The direction is often the terminus
   * station.
   * </pre>
   *
   * <code>string headsign = 3;</code>
   *
   * @return The bytes for headsign.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHeadsignBytes() {
    java.lang.Object ref = headsign_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      headsign_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADWAY_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration headway_;

  /**
   *
   *
   * <pre>
   * Specifies the expected time as a duration between departures from the same
   * stop at this time. For example, with a headway seconds value of 600, you
   * would expect a ten minute wait if you should miss your bus.
   * </pre>
   *
   * <code>.google.protobuf.Duration headway = 4;</code>
   *
   * @return Whether the headway field is set.
   */
  @java.lang.Override
  public boolean hasHeadway() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the expected time as a duration between departures from the same
   * stop at this time. For example, with a headway seconds value of 600, you
   * would expect a ten minute wait if you should miss your bus.
   * </pre>
   *
   * <code>.google.protobuf.Duration headway = 4;</code>
   *
   * @return The headway.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getHeadway() {
    return headway_ == null ? com.google.protobuf.Duration.getDefaultInstance() : headway_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the expected time as a duration between departures from the same
   * stop at this time. For example, with a headway seconds value of 600, you
   * would expect a ten minute wait if you should miss your bus.
   * </pre>
   *
   * <code>.google.protobuf.Duration headway = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getHeadwayOrBuilder() {
    return headway_ == null ? com.google.protobuf.Duration.getDefaultInstance() : headway_;
  }

  public static final int TRANSIT_LINE_FIELD_NUMBER = 5;
  private com.google.maps.routing.v2.TransitLine transitLine_;

  /**
   *
   *
   * <pre>
   * Information about the transit line used in this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
   *
   * @return Whether the transitLine field is set.
   */
  @java.lang.Override
  public boolean hasTransitLine() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Information about the transit line used in this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
   *
   * @return The transitLine.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitLine getTransitLine() {
    return transitLine_ == null
        ? com.google.maps.routing.v2.TransitLine.getDefaultInstance()
        : transitLine_;
  }

  /**
   *
   *
   * <pre>
   * Information about the transit line used in this step.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitLineOrBuilder getTransitLineOrBuilder() {
    return transitLine_ == null
        ? com.google.maps.routing.v2.TransitLine.getDefaultInstance()
        : transitLine_;
  }

  public static final int STOP_COUNT_FIELD_NUMBER = 6;
  private int stopCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of stops from the departure to the arrival stop. This count
   * includes the arrival stop, but excludes the departure stop. For example, if
   * your route leaves from Stop A, passes through stops B and C, and arrives at
   * stop D, &lt;code&gt;stop_count&lt;/code&gt; returns 3.
   * </pre>
   *
   * <code>int32 stop_count = 6;</code>
   *
   * @return The stopCount.
   */
  @java.lang.Override
  public int getStopCount() {
    return stopCount_;
  }

  public static final int TRIP_SHORT_TEXT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tripShortText_ = "";

  /**
   *
   *
   * <pre>
   * The text that appears in schedules and sign boards to identify a transit
   * trip to passengers. The text should uniquely identify a trip within a
   * service day. For example, "538" is the `trip_short_text` of the Amtrak
   * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
   * </pre>
   *
   * <code>string trip_short_text = 7;</code>
   *
   * @return The tripShortText.
   */
  @java.lang.Override
  public java.lang.String getTripShortText() {
    java.lang.Object ref = tripShortText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tripShortText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The text that appears in schedules and sign boards to identify a transit
   * trip to passengers. The text should uniquely identify a trip within a
   * service day. For example, "538" is the `trip_short_text` of the Amtrak
   * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
   * </pre>
   *
   * <code>string trip_short_text = 7;</code>
   *
   * @return The bytes for tripShortText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTripShortTextBytes() {
    java.lang.Object ref = tripShortText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tripShortText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStopDetails());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getLocalizedValues());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headsign_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, headsign_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getHeadway());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getTransitLine());
    }
    if (stopCount_ != 0) {
      output.writeInt32(6, stopCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tripShortText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tripShortText_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStopDetails());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getLocalizedValues());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headsign_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, headsign_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getHeadway());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTransitLine());
    }
    if (stopCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, stopCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tripShortText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, tripShortText_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.RouteLegStepTransitDetails)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.RouteLegStepTransitDetails other =
        (com.google.maps.routing.v2.RouteLegStepTransitDetails) obj;

    if (hasStopDetails() != other.hasStopDetails()) return false;
    if (hasStopDetails()) {
      if (!getStopDetails().equals(other.getStopDetails())) return false;
    }
    if (hasLocalizedValues() != other.hasLocalizedValues()) return false;
    if (hasLocalizedValues()) {
      if (!getLocalizedValues().equals(other.getLocalizedValues())) return false;
    }
    if (!getHeadsign().equals(other.getHeadsign())) return false;
    if (hasHeadway() != other.hasHeadway()) return false;
    if (hasHeadway()) {
      if (!getHeadway().equals(other.getHeadway())) return false;
    }
    if (hasTransitLine() != other.hasTransitLine()) return false;
    if (hasTransitLine()) {
      if (!getTransitLine().equals(other.getTransitLine())) return false;
    }
    if (getStopCount() != other.getStopCount()) return false;
    if (!getTripShortText().equals(other.getTripShortText())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStopDetails()) {
      hash = (37 * hash) + STOP_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getStopDetails().hashCode();
    }
    if (hasLocalizedValues()) {
      hash = (37 * hash) + LOCALIZED_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getLocalizedValues().hashCode();
    }
    hash = (37 * hash) + HEADSIGN_FIELD_NUMBER;
    hash = (53 * hash) + getHeadsign().hashCode();
    if (hasHeadway()) {
      hash = (37 * hash) + HEADWAY_FIELD_NUMBER;
      hash = (53 * hash) + getHeadway().hashCode();
    }
    if (hasTransitLine()) {
      hash = (37 * hash) + TRANSIT_LINE_FIELD_NUMBER;
      hash = (53 * hash) + getTransitLine().hashCode();
    }
    hash = (37 * hash) + STOP_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getStopCount();
    hash = (37 * hash) + TRIP_SHORT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getTripShortText().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.maps.routing.v2.RouteLegStepTransitDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Additional information for the `RouteLegStep` related to `TRANSIT` routes.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.RouteLegStepTransitDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteLegStepTransitDetails)
      com.google.maps.routing.v2.RouteLegStepTransitDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteLegStepTransitDetails.class,
              com.google.maps.routing.v2.RouteLegStepTransitDetails.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.RouteLegStepTransitDetails.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStopDetailsFieldBuilder();
        getLocalizedValuesFieldBuilder();
        getHeadwayFieldBuilder();
        getTransitLineFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      stopDetails_ = null;
      if (stopDetailsBuilder_ != null) {
        stopDetailsBuilder_.dispose();
        stopDetailsBuilder_ = null;
      }
      localizedValues_ = null;
      if (localizedValuesBuilder_ != null) {
        localizedValuesBuilder_.dispose();
        localizedValuesBuilder_ = null;
      }
      headsign_ = "";
      headway_ = null;
      if (headwayBuilder_ != null) {
        headwayBuilder_.dispose();
        headwayBuilder_ = null;
      }
      transitLine_ = null;
      if (transitLineBuilder_ != null) {
        transitLineBuilder_.dispose();
        transitLineBuilder_ = null;
      }
      stopCount_ = 0;
      tripShortText_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegStepTransitDetails_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStepTransitDetails getDefaultInstanceForType() {
      return com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStepTransitDetails build() {
      com.google.maps.routing.v2.RouteLegStepTransitDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegStepTransitDetails buildPartial() {
      com.google.maps.routing.v2.RouteLegStepTransitDetails result =
          new com.google.maps.routing.v2.RouteLegStepTransitDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.routing.v2.RouteLegStepTransitDetails result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.stopDetails_ =
            stopDetailsBuilder_ == null ? stopDetails_ : stopDetailsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.localizedValues_ =
            localizedValuesBuilder_ == null ? localizedValues_ : localizedValuesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.headsign_ = headsign_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.headway_ = headwayBuilder_ == null ? headway_ : headwayBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.transitLine_ =
            transitLineBuilder_ == null ? transitLine_ : transitLineBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.stopCount_ = stopCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.tripShortText_ = tripShortText_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.RouteLegStepTransitDetails) {
        return mergeFrom((com.google.maps.routing.v2.RouteLegStepTransitDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.RouteLegStepTransitDetails other) {
      if (other == com.google.maps.routing.v2.RouteLegStepTransitDetails.getDefaultInstance())
        return this;
      if (other.hasStopDetails()) {
        mergeStopDetails(other.getStopDetails());
      }
      if (other.hasLocalizedValues()) {
        mergeLocalizedValues(other.getLocalizedValues());
      }
      if (!other.getHeadsign().isEmpty()) {
        headsign_ = other.headsign_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasHeadway()) {
        mergeHeadway(other.getHeadway());
      }
      if (other.hasTransitLine()) {
        mergeTransitLine(other.getTransitLine());
      }
      if (other.getStopCount() != 0) {
        setStopCount(other.getStopCount());
      }
      if (!other.getTripShortText().isEmpty()) {
        tripShortText_ = other.tripShortText_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStopDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getLocalizedValuesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                headsign_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getHeadwayFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getTransitLineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                stopCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                tripShortText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stopDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetailsOrBuilder>
        stopDetailsBuilder_;

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     *
     * @return Whether the stopDetails field is set.
     */
    public boolean hasStopDetails() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     *
     * @return The stopDetails.
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
        getStopDetails() {
      if (stopDetailsBuilder_ == null) {
        return stopDetails_ == null
            ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
                .getDefaultInstance()
            : stopDetails_;
      } else {
        return stopDetailsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    public Builder setStopDetails(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails value) {
      if (stopDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stopDetails_ = value;
      } else {
        stopDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    public Builder setStopDetails(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder
            builderForValue) {
      if (stopDetailsBuilder_ == null) {
        stopDetails_ = builderForValue.build();
      } else {
        stopDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    public Builder mergeStopDetails(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails value) {
      if (stopDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && stopDetails_ != null
            && stopDetails_
                != com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
                    .getDefaultInstance()) {
          getStopDetailsBuilder().mergeFrom(value);
        } else {
          stopDetails_ = value;
        }
      } else {
        stopDetailsBuilder_.mergeFrom(value);
      }
      if (stopDetails_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    public Builder clearStopDetails() {
      bitField0_ = (bitField0_ & ~0x00000001);
      stopDetails_ = null;
      if (stopDetailsBuilder_ != null) {
        stopDetailsBuilder_.dispose();
        stopDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder
        getStopDetailsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStopDetailsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetailsOrBuilder
        getStopDetailsOrBuilder() {
      if (stopDetailsBuilder_ != null) {
        return stopDetailsBuilder_.getMessageOrBuilder();
      } else {
        return stopDetails_ == null
            ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails
                .getDefaultInstance()
            : stopDetails_;
      }
    }

    /**
     *
     *
     * <pre>
     * Information about the arrival and departure stops for the step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails stop_details = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetailsOrBuilder>
        getStopDetailsFieldBuilder() {
      if (stopDetailsBuilder_ == null) {
        stopDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails,
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetails.Builder,
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitStopDetailsOrBuilder>(
                getStopDetails(), getParentForChildren(), isClean());
        stopDetails_ = null;
      }
      return stopDetailsBuilder_;
    }

    private com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
        localizedValues_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                .Builder,
            com.google.maps.routing.v2.RouteLegStepTransitDetails
                .TransitDetailsLocalizedValuesOrBuilder>
        localizedValuesBuilder_;

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     *
     * @return Whether the localizedValues field is set.
     */
    public boolean hasLocalizedValues() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     *
     * @return The localizedValues.
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
        getLocalizedValues() {
      if (localizedValuesBuilder_ == null) {
        return localizedValues_ == null
            ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                .getDefaultInstance()
            : localizedValues_;
      } else {
        return localizedValuesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    public Builder setLocalizedValues(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues value) {
      if (localizedValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        localizedValues_ = value;
      } else {
        localizedValuesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    public Builder setLocalizedValues(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues.Builder
            builderForValue) {
      if (localizedValuesBuilder_ == null) {
        localizedValues_ = builderForValue.build();
      } else {
        localizedValuesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    public Builder mergeLocalizedValues(
        com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues value) {
      if (localizedValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && localizedValues_ != null
            && localizedValues_
                != com.google.maps.routing.v2.RouteLegStepTransitDetails
                    .TransitDetailsLocalizedValues.getDefaultInstance()) {
          getLocalizedValuesBuilder().mergeFrom(value);
        } else {
          localizedValues_ = value;
        }
      } else {
        localizedValuesBuilder_.mergeFrom(value);
      }
      if (localizedValues_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    public Builder clearLocalizedValues() {
      bitField0_ = (bitField0_ & ~0x00000002);
      localizedValues_ = null;
      if (localizedValuesBuilder_ != null) {
        localizedValuesBuilder_.dispose();
        localizedValuesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
            .Builder
        getLocalizedValuesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getLocalizedValuesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    public com.google.maps.routing.v2.RouteLegStepTransitDetails
            .TransitDetailsLocalizedValuesOrBuilder
        getLocalizedValuesOrBuilder() {
      if (localizedValuesBuilder_ != null) {
        return localizedValuesBuilder_.getMessageOrBuilder();
      } else {
        return localizedValues_ == null
            ? com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                .getDefaultInstance()
            : localizedValues_;
      }
    }

    /**
     *
     *
     * <pre>
     * Text representations of properties of the `RouteLegStepTransitDetails`.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues localized_values = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues,
            com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                .Builder,
            com.google.maps.routing.v2.RouteLegStepTransitDetails
                .TransitDetailsLocalizedValuesOrBuilder>
        getLocalizedValuesFieldBuilder() {
      if (localizedValuesBuilder_ == null) {
        localizedValuesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues,
                com.google.maps.routing.v2.RouteLegStepTransitDetails.TransitDetailsLocalizedValues
                    .Builder,
                com.google.maps.routing.v2.RouteLegStepTransitDetails
                    .TransitDetailsLocalizedValuesOrBuilder>(
                getLocalizedValues(), getParentForChildren(), isClean());
        localizedValues_ = null;
      }
      return localizedValuesBuilder_;
    }

    private java.lang.Object headsign_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the direction in which to travel on this line as marked on
     * the vehicle or at the departure stop. The direction is often the terminus
     * station.
     * </pre>
     *
     * <code>string headsign = 3;</code>
     *
     * @return The headsign.
     */
    public java.lang.String getHeadsign() {
      java.lang.Object ref = headsign_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        headsign_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the direction in which to travel on this line as marked on
     * the vehicle or at the departure stop. The direction is often the terminus
     * station.
     * </pre>
     *
     * <code>string headsign = 3;</code>
     *
     * @return The bytes for headsign.
     */
    public com.google.protobuf.ByteString getHeadsignBytes() {
      java.lang.Object ref = headsign_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        headsign_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the direction in which to travel on this line as marked on
     * the vehicle or at the departure stop. The direction is often the terminus
     * station.
     * </pre>
     *
     * <code>string headsign = 3;</code>
     *
     * @param value The headsign to set.
     * @return This builder for chaining.
     */
    public Builder setHeadsign(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      headsign_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the direction in which to travel on this line as marked on
     * the vehicle or at the departure stop. The direction is often the terminus
     * station.
     * </pre>
     *
     * <code>string headsign = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeadsign() {
      headsign_ = getDefaultInstance().getHeadsign();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the direction in which to travel on this line as marked on
     * the vehicle or at the departure stop. The direction is often the terminus
     * station.
     * </pre>
     *
     * <code>string headsign = 3;</code>
     *
     * @param value The bytes for headsign to set.
     * @return This builder for chaining.
     */
    public Builder setHeadsignBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      headsign_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration headway_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        headwayBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     *
     * @return Whether the headway field is set.
     */
    public boolean hasHeadway() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     *
     * @return The headway.
     */
    public com.google.protobuf.Duration getHeadway() {
      if (headwayBuilder_ == null) {
        return headway_ == null ? com.google.protobuf.Duration.getDefaultInstance() : headway_;
      } else {
        return headwayBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    public Builder setHeadway(com.google.protobuf.Duration value) {
      if (headwayBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        headway_ = value;
      } else {
        headwayBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    public Builder setHeadway(com.google.protobuf.Duration.Builder builderForValue) {
      if (headwayBuilder_ == null) {
        headway_ = builderForValue.build();
      } else {
        headwayBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    public Builder mergeHeadway(com.google.protobuf.Duration value) {
      if (headwayBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && headway_ != null
            && headway_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getHeadwayBuilder().mergeFrom(value);
        } else {
          headway_ = value;
        }
      } else {
        headwayBuilder_.mergeFrom(value);
      }
      if (headway_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    public Builder clearHeadway() {
      bitField0_ = (bitField0_ & ~0x00000008);
      headway_ = null;
      if (headwayBuilder_ != null) {
        headwayBuilder_.dispose();
        headwayBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getHeadwayBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getHeadwayFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getHeadwayOrBuilder() {
      if (headwayBuilder_ != null) {
        return headwayBuilder_.getMessageOrBuilder();
      } else {
        return headway_ == null ? com.google.protobuf.Duration.getDefaultInstance() : headway_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the expected time as a duration between departures from the same
     * stop at this time. For example, with a headway seconds value of 600, you
     * would expect a ten minute wait if you should miss your bus.
     * </pre>
     *
     * <code>.google.protobuf.Duration headway = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getHeadwayFieldBuilder() {
      if (headwayBuilder_ == null) {
        headwayBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getHeadway(), getParentForChildren(), isClean());
        headway_ = null;
      }
      return headwayBuilder_;
    }

    private com.google.maps.routing.v2.TransitLine transitLine_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitLine,
            com.google.maps.routing.v2.TransitLine.Builder,
            com.google.maps.routing.v2.TransitLineOrBuilder>
        transitLineBuilder_;

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     *
     * @return Whether the transitLine field is set.
     */
    public boolean hasTransitLine() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     *
     * @return The transitLine.
     */
    public com.google.maps.routing.v2.TransitLine getTransitLine() {
      if (transitLineBuilder_ == null) {
        return transitLine_ == null
            ? com.google.maps.routing.v2.TransitLine.getDefaultInstance()
            : transitLine_;
      } else {
        return transitLineBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    public Builder setTransitLine(com.google.maps.routing.v2.TransitLine value) {
      if (transitLineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transitLine_ = value;
      } else {
        transitLineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    public Builder setTransitLine(com.google.maps.routing.v2.TransitLine.Builder builderForValue) {
      if (transitLineBuilder_ == null) {
        transitLine_ = builderForValue.build();
      } else {
        transitLineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    public Builder mergeTransitLine(com.google.maps.routing.v2.TransitLine value) {
      if (transitLineBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && transitLine_ != null
            && transitLine_ != com.google.maps.routing.v2.TransitLine.getDefaultInstance()) {
          getTransitLineBuilder().mergeFrom(value);
        } else {
          transitLine_ = value;
        }
      } else {
        transitLineBuilder_.mergeFrom(value);
      }
      if (transitLine_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    public Builder clearTransitLine() {
      bitField0_ = (bitField0_ & ~0x00000010);
      transitLine_ = null;
      if (transitLineBuilder_ != null) {
        transitLineBuilder_.dispose();
        transitLineBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    public com.google.maps.routing.v2.TransitLine.Builder getTransitLineBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTransitLineFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    public com.google.maps.routing.v2.TransitLineOrBuilder getTransitLineOrBuilder() {
      if (transitLineBuilder_ != null) {
        return transitLineBuilder_.getMessageOrBuilder();
      } else {
        return transitLine_ == null
            ? com.google.maps.routing.v2.TransitLine.getDefaultInstance()
            : transitLine_;
      }
    }

    /**
     *
     *
     * <pre>
     * Information about the transit line used in this step.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitLine transit_line = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TransitLine,
            com.google.maps.routing.v2.TransitLine.Builder,
            com.google.maps.routing.v2.TransitLineOrBuilder>
        getTransitLineFieldBuilder() {
      if (transitLineBuilder_ == null) {
        transitLineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.TransitLine,
                com.google.maps.routing.v2.TransitLine.Builder,
                com.google.maps.routing.v2.TransitLineOrBuilder>(
                getTransitLine(), getParentForChildren(), isClean());
        transitLine_ = null;
      }
      return transitLineBuilder_;
    }

    private int stopCount_;

    /**
     *
     *
     * <pre>
     * The number of stops from the departure to the arrival stop. This count
     * includes the arrival stop, but excludes the departure stop. For example, if
     * your route leaves from Stop A, passes through stops B and C, and arrives at
     * stop D, &lt;code&gt;stop_count&lt;/code&gt; returns 3.
     * </pre>
     *
     * <code>int32 stop_count = 6;</code>
     *
     * @return The stopCount.
     */
    @java.lang.Override
    public int getStopCount() {
      return stopCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of stops from the departure to the arrival stop. This count
     * includes the arrival stop, but excludes the departure stop. For example, if
     * your route leaves from Stop A, passes through stops B and C, and arrives at
     * stop D, &lt;code&gt;stop_count&lt;/code&gt; returns 3.
     * </pre>
     *
     * <code>int32 stop_count = 6;</code>
     *
     * @param value The stopCount to set.
     * @return This builder for chaining.
     */
    public Builder setStopCount(int value) {

      stopCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of stops from the departure to the arrival stop. This count
     * includes the arrival stop, but excludes the departure stop. For example, if
     * your route leaves from Stop A, passes through stops B and C, and arrives at
     * stop D, &lt;code&gt;stop_count&lt;/code&gt; returns 3.
     * </pre>
     *
     * <code>int32 stop_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStopCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      stopCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object tripShortText_ = "";

    /**
     *
     *
     * <pre>
     * The text that appears in schedules and sign boards to identify a transit
     * trip to passengers. The text should uniquely identify a trip within a
     * service day. For example, "538" is the `trip_short_text` of the Amtrak
     * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
     * </pre>
     *
     * <code>string trip_short_text = 7;</code>
     *
     * @return The tripShortText.
     */
    public java.lang.String getTripShortText() {
      java.lang.Object ref = tripShortText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tripShortText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The text that appears in schedules and sign boards to identify a transit
     * trip to passengers. The text should uniquely identify a trip within a
     * service day. For example, "538" is the `trip_short_text` of the Amtrak
     * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
     * </pre>
     *
     * <code>string trip_short_text = 7;</code>
     *
     * @return The bytes for tripShortText.
     */
    public com.google.protobuf.ByteString getTripShortTextBytes() {
      java.lang.Object ref = tripShortText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tripShortText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The text that appears in schedules and sign boards to identify a transit
     * trip to passengers. The text should uniquely identify a trip within a
     * service day. For example, "538" is the `trip_short_text` of the Amtrak
     * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
     * </pre>
     *
     * <code>string trip_short_text = 7;</code>
     *
     * @param value The tripShortText to set.
     * @return This builder for chaining.
     */
    public Builder setTripShortText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tripShortText_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The text that appears in schedules and sign boards to identify a transit
     * trip to passengers. The text should uniquely identify a trip within a
     * service day. For example, "538" is the `trip_short_text` of the Amtrak
     * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
     * </pre>
     *
     * <code>string trip_short_text = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTripShortText() {
      tripShortText_ = getDefaultInstance().getTripShortText();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The text that appears in schedules and sign boards to identify a transit
     * trip to passengers. The text should uniquely identify a trip within a
     * service day. For example, "538" is the `trip_short_text` of the Amtrak
     * train that leaves San Jose, CA at 15:10 on weekdays to Sacramento, CA.
     * </pre>
     *
     * <code>string trip_short_text = 7;</code>
     *
     * @param value The bytes for tripShortText to set.
     * @return This builder for chaining.
     */
    public Builder setTripShortTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tripShortText_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteLegStepTransitDetails)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteLegStepTransitDetails)
  private static final com.google.maps.routing.v2.RouteLegStepTransitDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.RouteLegStepTransitDetails();
  }

  public static com.google.maps.routing.v2.RouteLegStepTransitDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouteLegStepTransitDetails> PARSER =
      new com.google.protobuf.AbstractParser<RouteLegStepTransitDetails>() {
        @java.lang.Override
        public RouteLegStepTransitDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouteLegStepTransitDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouteLegStepTransitDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegStepTransitDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
