/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/route_modifiers.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Encapsulates a set of optional conditions to satisfy when calculating the
 * routes.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.RouteModifiers}
 */
public final class RouteModifiers extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteModifiers)
    RouteModifiersOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouteModifiers.newBuilder() to construct.
  private RouteModifiers(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouteModifiers() {
    tollPasses_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouteModifiers();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RouteModifiersProto
        .internal_static_google_maps_routing_v2_RouteModifiers_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RouteModifiersProto
        .internal_static_google_maps_routing_v2_RouteModifiers_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.RouteModifiers.class,
            com.google.maps.routing.v2.RouteModifiers.Builder.class);
  }

  private int bitField0_;
  public static final int AVOID_TOLLS_FIELD_NUMBER = 1;
  private boolean avoidTolls_ = false;

  /**
   *
   *
   * <pre>
   * When set to true, avoids toll roads where reasonable, giving preference to
   * routes not containing toll roads. Applies only to the `DRIVE` and
   * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>bool avoid_tolls = 1;</code>
   *
   * @return The avoidTolls.
   */
  @java.lang.Override
  public boolean getAvoidTolls() {
    return avoidTolls_;
  }

  public static final int AVOID_HIGHWAYS_FIELD_NUMBER = 2;
  private boolean avoidHighways_ = false;

  /**
   *
   *
   * <pre>
   * When set to true, avoids highways where reasonable, giving preference to
   * routes not containing highways. Applies only to the `DRIVE` and
   * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>bool avoid_highways = 2;</code>
   *
   * @return The avoidHighways.
   */
  @java.lang.Override
  public boolean getAvoidHighways() {
    return avoidHighways_;
  }

  public static final int AVOID_FERRIES_FIELD_NUMBER = 3;
  private boolean avoidFerries_ = false;

  /**
   *
   *
   * <pre>
   * When set to true, avoids ferries where reasonable, giving preference to
   * routes not containing ferries. Applies only to the `DRIVE` and`TWO_WHEELER`
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>bool avoid_ferries = 3;</code>
   *
   * @return The avoidFerries.
   */
  @java.lang.Override
  public boolean getAvoidFerries() {
    return avoidFerries_;
  }

  public static final int AVOID_INDOOR_FIELD_NUMBER = 4;
  private boolean avoidIndoor_ = false;

  /**
   *
   *
   * <pre>
   * When set to true, avoids navigating indoors where reasonable, giving
   * preference to routes not containing indoor navigation. Applies only to the
   * `WALK` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>bool avoid_indoor = 4;</code>
   *
   * @return The avoidIndoor.
   */
  @java.lang.Override
  public boolean getAvoidIndoor() {
    return avoidIndoor_;
  }

  public static final int VEHICLE_INFO_FIELD_NUMBER = 5;
  private com.google.maps.routing.v2.VehicleInfo vehicleInfo_;

  /**
   *
   *
   * <pre>
   * Specifies the vehicle information.
   * </pre>
   *
   * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
   *
   * @return Whether the vehicleInfo field is set.
   */
  @java.lang.Override
  public boolean hasVehicleInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the vehicle information.
   * </pre>
   *
   * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
   *
   * @return The vehicleInfo.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.VehicleInfo getVehicleInfo() {
    return vehicleInfo_ == null
        ? com.google.maps.routing.v2.VehicleInfo.getDefaultInstance()
        : vehicleInfo_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the vehicle information.
   * </pre>
   *
   * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.VehicleInfoOrBuilder getVehicleInfoOrBuilder() {
    return vehicleInfo_ == null
        ? com.google.maps.routing.v2.VehicleInfo.getDefaultInstance()
        : vehicleInfo_;
  }

  public static final int TOLL_PASSES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> tollPasses_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.maps.routing.v2.TollPass>
      tollPasses_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.maps.routing.v2.TollPass>() {
            public com.google.maps.routing.v2.TollPass convert(java.lang.Integer from) {
              com.google.maps.routing.v2.TollPass result =
                  com.google.maps.routing.v2.TollPass.forNumber(from);
              return result == null ? com.google.maps.routing.v2.TollPass.UNRECOGNIZED : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Encapsulates information about toll passes.
   * If toll passes are provided, the API tries to return the pass price. If
   * toll passes are not provided, the API treats the toll pass as unknown and
   * tries to return the cash price.
   * Applies only to the `DRIVE` and `TWO_WHEELER`
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
   *
   * @return A list containing the tollPasses.
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.TollPass> getTollPassesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.maps.routing.v2.TollPass>(tollPasses_, tollPasses_converter_);
  }

  /**
   *
   *
   * <pre>
   * Encapsulates information about toll passes.
   * If toll passes are provided, the API tries to return the pass price. If
   * toll passes are not provided, the API treats the toll pass as unknown and
   * tries to return the cash price.
   * Applies only to the `DRIVE` and `TWO_WHEELER`
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
   *
   * @return The count of tollPasses.
   */
  @java.lang.Override
  public int getTollPassesCount() {
    return tollPasses_.size();
  }

  /**
   *
   *
   * <pre>
   * Encapsulates information about toll passes.
   * If toll passes are provided, the API tries to return the pass price. If
   * toll passes are not provided, the API treats the toll pass as unknown and
   * tries to return the cash price.
   * Applies only to the `DRIVE` and `TWO_WHEELER`
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The tollPasses at the given index.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TollPass getTollPasses(int index) {
    return tollPasses_converter_.convert(tollPasses_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Encapsulates information about toll passes.
   * If toll passes are provided, the API tries to return the pass price. If
   * toll passes are not provided, the API treats the toll pass as unknown and
   * tries to return the cash price.
   * Applies only to the `DRIVE` and `TWO_WHEELER`
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
   *
   * @return A list containing the enum numeric values on the wire for tollPasses.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getTollPassesValueList() {
    return tollPasses_;
  }

  /**
   *
   *
   * <pre>
   * Encapsulates information about toll passes.
   * If toll passes are provided, the API tries to return the pass price. If
   * toll passes are not provided, the API treats the toll pass as unknown and
   * tries to return the cash price.
   * Applies only to the `DRIVE` and `TWO_WHEELER`
   * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of tollPasses at the given index.
   */
  @java.lang.Override
  public int getTollPassesValue(int index) {
    return tollPasses_.get(index);
  }

  private int tollPassesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (avoidTolls_ != false) {
      output.writeBool(1, avoidTolls_);
    }
    if (avoidHighways_ != false) {
      output.writeBool(2, avoidHighways_);
    }
    if (avoidFerries_ != false) {
      output.writeBool(3, avoidFerries_);
    }
    if (avoidIndoor_ != false) {
      output.writeBool(4, avoidIndoor_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getVehicleInfo());
    }
    if (getTollPassesList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(tollPassesMemoizedSerializedSize);
    }
    for (int i = 0; i < tollPasses_.size(); i++) {
      output.writeEnumNoTag(tollPasses_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (avoidTolls_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, avoidTolls_);
    }
    if (avoidHighways_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, avoidHighways_);
    }
    if (avoidFerries_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, avoidFerries_);
    }
    if (avoidIndoor_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, avoidIndoor_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getVehicleInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tollPasses_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(tollPasses_.get(i));
      }
      size += dataSize;
      if (!getTollPassesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      tollPassesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.RouteModifiers)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.RouteModifiers other =
        (com.google.maps.routing.v2.RouteModifiers) obj;

    if (getAvoidTolls() != other.getAvoidTolls()) return false;
    if (getAvoidHighways() != other.getAvoidHighways()) return false;
    if (getAvoidFerries() != other.getAvoidFerries()) return false;
    if (getAvoidIndoor() != other.getAvoidIndoor()) return false;
    if (hasVehicleInfo() != other.hasVehicleInfo()) return false;
    if (hasVehicleInfo()) {
      if (!getVehicleInfo().equals(other.getVehicleInfo())) return false;
    }
    if (!tollPasses_.equals(other.tollPasses_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AVOID_TOLLS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAvoidTolls());
    hash = (37 * hash) + AVOID_HIGHWAYS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAvoidHighways());
    hash = (37 * hash) + AVOID_FERRIES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAvoidFerries());
    hash = (37 * hash) + AVOID_INDOOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAvoidIndoor());
    if (hasVehicleInfo()) {
      hash = (37 * hash) + VEHICLE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getVehicleInfo().hashCode();
    }
    if (getTollPassesCount() > 0) {
      hash = (37 * hash) + TOLL_PASSES_FIELD_NUMBER;
      hash = (53 * hash) + tollPasses_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteModifiers parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.RouteModifiers prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Encapsulates a set of optional conditions to satisfy when calculating the
   * routes.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.RouteModifiers}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteModifiers)
      com.google.maps.routing.v2.RouteModifiersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteModifiersProto
          .internal_static_google_maps_routing_v2_RouteModifiers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteModifiersProto
          .internal_static_google_maps_routing_v2_RouteModifiers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteModifiers.class,
              com.google.maps.routing.v2.RouteModifiers.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.RouteModifiers.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVehicleInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      avoidTolls_ = false;
      avoidHighways_ = false;
      avoidFerries_ = false;
      avoidIndoor_ = false;
      vehicleInfo_ = null;
      if (vehicleInfoBuilder_ != null) {
        vehicleInfoBuilder_.dispose();
        vehicleInfoBuilder_ = null;
      }
      tollPasses_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RouteModifiersProto
          .internal_static_google_maps_routing_v2_RouteModifiers_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteModifiers getDefaultInstanceForType() {
      return com.google.maps.routing.v2.RouteModifiers.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteModifiers build() {
      com.google.maps.routing.v2.RouteModifiers result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteModifiers buildPartial() {
      com.google.maps.routing.v2.RouteModifiers result =
          new com.google.maps.routing.v2.RouteModifiers(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.RouteModifiers result) {
      if (((bitField0_ & 0x00000020) != 0)) {
        tollPasses_ = java.util.Collections.unmodifiableList(tollPasses_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.tollPasses_ = tollPasses_;
    }

    private void buildPartial0(com.google.maps.routing.v2.RouteModifiers result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.avoidTolls_ = avoidTolls_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.avoidHighways_ = avoidHighways_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.avoidFerries_ = avoidFerries_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.avoidIndoor_ = avoidIndoor_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.vehicleInfo_ =
            vehicleInfoBuilder_ == null ? vehicleInfo_ : vehicleInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.RouteModifiers) {
        return mergeFrom((com.google.maps.routing.v2.RouteModifiers) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.RouteModifiers other) {
      if (other == com.google.maps.routing.v2.RouteModifiers.getDefaultInstance()) return this;
      if (other.getAvoidTolls() != false) {
        setAvoidTolls(other.getAvoidTolls());
      }
      if (other.getAvoidHighways() != false) {
        setAvoidHighways(other.getAvoidHighways());
      }
      if (other.getAvoidFerries() != false) {
        setAvoidFerries(other.getAvoidFerries());
      }
      if (other.getAvoidIndoor() != false) {
        setAvoidIndoor(other.getAvoidIndoor());
      }
      if (other.hasVehicleInfo()) {
        mergeVehicleInfo(other.getVehicleInfo());
      }
      if (!other.tollPasses_.isEmpty()) {
        if (tollPasses_.isEmpty()) {
          tollPasses_ = other.tollPasses_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureTollPassesIsMutable();
          tollPasses_.addAll(other.tollPasses_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                avoidTolls_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                avoidHighways_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                avoidFerries_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                avoidIndoor_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getVehicleInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                int tmpRaw = input.readEnum();
                ensureTollPassesIsMutable();
                tollPasses_.add(tmpRaw);
                break;
              } // case 48
            case 50:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureTollPassesIsMutable();
                  tollPasses_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean avoidTolls_;

    /**
     *
     *
     * <pre>
     * When set to true, avoids toll roads where reasonable, giving preference to
     * routes not containing toll roads. Applies only to the `DRIVE` and
     * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_tolls = 1;</code>
     *
     * @return The avoidTolls.
     */
    @java.lang.Override
    public boolean getAvoidTolls() {
      return avoidTolls_;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids toll roads where reasonable, giving preference to
     * routes not containing toll roads. Applies only to the `DRIVE` and
     * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_tolls = 1;</code>
     *
     * @param value The avoidTolls to set.
     * @return This builder for chaining.
     */
    public Builder setAvoidTolls(boolean value) {

      avoidTolls_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids toll roads where reasonable, giving preference to
     * routes not containing toll roads. Applies only to the `DRIVE` and
     * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_tolls = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvoidTolls() {
      bitField0_ = (bitField0_ & ~0x00000001);
      avoidTolls_ = false;
      onChanged();
      return this;
    }

    private boolean avoidHighways_;

    /**
     *
     *
     * <pre>
     * When set to true, avoids highways where reasonable, giving preference to
     * routes not containing highways. Applies only to the `DRIVE` and
     * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_highways = 2;</code>
     *
     * @return The avoidHighways.
     */
    @java.lang.Override
    public boolean getAvoidHighways() {
      return avoidHighways_;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids highways where reasonable, giving preference to
     * routes not containing highways. Applies only to the `DRIVE` and
     * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_highways = 2;</code>
     *
     * @param value The avoidHighways to set.
     * @return This builder for chaining.
     */
    public Builder setAvoidHighways(boolean value) {

      avoidHighways_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids highways where reasonable, giving preference to
     * routes not containing highways. Applies only to the `DRIVE` and
     * `TWO_WHEELER` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_highways = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvoidHighways() {
      bitField0_ = (bitField0_ & ~0x00000002);
      avoidHighways_ = false;
      onChanged();
      return this;
    }

    private boolean avoidFerries_;

    /**
     *
     *
     * <pre>
     * When set to true, avoids ferries where reasonable, giving preference to
     * routes not containing ferries. Applies only to the `DRIVE` and`TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_ferries = 3;</code>
     *
     * @return The avoidFerries.
     */
    @java.lang.Override
    public boolean getAvoidFerries() {
      return avoidFerries_;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids ferries where reasonable, giving preference to
     * routes not containing ferries. Applies only to the `DRIVE` and`TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_ferries = 3;</code>
     *
     * @param value The avoidFerries to set.
     * @return This builder for chaining.
     */
    public Builder setAvoidFerries(boolean value) {

      avoidFerries_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids ferries where reasonable, giving preference to
     * routes not containing ferries. Applies only to the `DRIVE` and`TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_ferries = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvoidFerries() {
      bitField0_ = (bitField0_ & ~0x00000004);
      avoidFerries_ = false;
      onChanged();
      return this;
    }

    private boolean avoidIndoor_;

    /**
     *
     *
     * <pre>
     * When set to true, avoids navigating indoors where reasonable, giving
     * preference to routes not containing indoor navigation. Applies only to the
     * `WALK` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_indoor = 4;</code>
     *
     * @return The avoidIndoor.
     */
    @java.lang.Override
    public boolean getAvoidIndoor() {
      return avoidIndoor_;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids navigating indoors where reasonable, giving
     * preference to routes not containing indoor navigation. Applies only to the
     * `WALK` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_indoor = 4;</code>
     *
     * @param value The avoidIndoor to set.
     * @return This builder for chaining.
     */
    public Builder setAvoidIndoor(boolean value) {

      avoidIndoor_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When set to true, avoids navigating indoors where reasonable, giving
     * preference to routes not containing indoor navigation. Applies only to the
     * `WALK` [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>bool avoid_indoor = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvoidIndoor() {
      bitField0_ = (bitField0_ & ~0x00000008);
      avoidIndoor_ = false;
      onChanged();
      return this;
    }

    private com.google.maps.routing.v2.VehicleInfo vehicleInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.VehicleInfo,
            com.google.maps.routing.v2.VehicleInfo.Builder,
            com.google.maps.routing.v2.VehicleInfoOrBuilder>
        vehicleInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     *
     * @return Whether the vehicleInfo field is set.
     */
    public boolean hasVehicleInfo() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     *
     * @return The vehicleInfo.
     */
    public com.google.maps.routing.v2.VehicleInfo getVehicleInfo() {
      if (vehicleInfoBuilder_ == null) {
        return vehicleInfo_ == null
            ? com.google.maps.routing.v2.VehicleInfo.getDefaultInstance()
            : vehicleInfo_;
      } else {
        return vehicleInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    public Builder setVehicleInfo(com.google.maps.routing.v2.VehicleInfo value) {
      if (vehicleInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vehicleInfo_ = value;
      } else {
        vehicleInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    public Builder setVehicleInfo(com.google.maps.routing.v2.VehicleInfo.Builder builderForValue) {
      if (vehicleInfoBuilder_ == null) {
        vehicleInfo_ = builderForValue.build();
      } else {
        vehicleInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    public Builder mergeVehicleInfo(com.google.maps.routing.v2.VehicleInfo value) {
      if (vehicleInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && vehicleInfo_ != null
            && vehicleInfo_ != com.google.maps.routing.v2.VehicleInfo.getDefaultInstance()) {
          getVehicleInfoBuilder().mergeFrom(value);
        } else {
          vehicleInfo_ = value;
        }
      } else {
        vehicleInfoBuilder_.mergeFrom(value);
      }
      if (vehicleInfo_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    public Builder clearVehicleInfo() {
      bitField0_ = (bitField0_ & ~0x00000010);
      vehicleInfo_ = null;
      if (vehicleInfoBuilder_ != null) {
        vehicleInfoBuilder_.dispose();
        vehicleInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    public com.google.maps.routing.v2.VehicleInfo.Builder getVehicleInfoBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getVehicleInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    public com.google.maps.routing.v2.VehicleInfoOrBuilder getVehicleInfoOrBuilder() {
      if (vehicleInfoBuilder_ != null) {
        return vehicleInfoBuilder_.getMessageOrBuilder();
      } else {
        return vehicleInfo_ == null
            ? com.google.maps.routing.v2.VehicleInfo.getDefaultInstance()
            : vehicleInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the vehicle information.
     * </pre>
     *
     * <code>.google.maps.routing.v2.VehicleInfo vehicle_info = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.VehicleInfo,
            com.google.maps.routing.v2.VehicleInfo.Builder,
            com.google.maps.routing.v2.VehicleInfoOrBuilder>
        getVehicleInfoFieldBuilder() {
      if (vehicleInfoBuilder_ == null) {
        vehicleInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.VehicleInfo,
                com.google.maps.routing.v2.VehicleInfo.Builder,
                com.google.maps.routing.v2.VehicleInfoOrBuilder>(
                getVehicleInfo(), getParentForChildren(), isClean());
        vehicleInfo_ = null;
      }
      return vehicleInfoBuilder_;
    }

    private java.util.List<java.lang.Integer> tollPasses_ = java.util.Collections.emptyList();

    private void ensureTollPassesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        tollPasses_ = new java.util.ArrayList<java.lang.Integer>(tollPasses_);
        bitField0_ |= 0x00000020;
      }
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @return A list containing the tollPasses.
     */
    public java.util.List<com.google.maps.routing.v2.TollPass> getTollPassesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.maps.routing.v2.TollPass>(
          tollPasses_, tollPasses_converter_);
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @return The count of tollPasses.
     */
    public int getTollPassesCount() {
      return tollPasses_.size();
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The tollPasses at the given index.
     */
    public com.google.maps.routing.v2.TollPass getTollPasses(int index) {
      return tollPasses_converter_.convert(tollPasses_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The tollPasses to set.
     * @return This builder for chaining.
     */
    public Builder setTollPasses(int index, com.google.maps.routing.v2.TollPass value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTollPassesIsMutable();
      tollPasses_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param value The tollPasses to add.
     * @return This builder for chaining.
     */
    public Builder addTollPasses(com.google.maps.routing.v2.TollPass value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTollPassesIsMutable();
      tollPasses_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param values The tollPasses to add.
     * @return This builder for chaining.
     */
    public Builder addAllTollPasses(
        java.lang.Iterable<? extends com.google.maps.routing.v2.TollPass> values) {
      ensureTollPassesIsMutable();
      for (com.google.maps.routing.v2.TollPass value : values) {
        tollPasses_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTollPasses() {
      tollPasses_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @return A list containing the enum numeric values on the wire for tollPasses.
     */
    public java.util.List<java.lang.Integer> getTollPassesValueList() {
      return java.util.Collections.unmodifiableList(tollPasses_);
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of tollPasses at the given index.
     */
    public int getTollPassesValue(int index) {
      return tollPasses_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for tollPasses to set.
     * @return This builder for chaining.
     */
    public Builder setTollPassesValue(int index, int value) {
      ensureTollPassesIsMutable();
      tollPasses_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param value The enum numeric value on the wire for tollPasses to add.
     * @return This builder for chaining.
     */
    public Builder addTollPassesValue(int value) {
      ensureTollPassesIsMutable();
      tollPasses_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Encapsulates information about toll passes.
     * If toll passes are provided, the API tries to return the pass price. If
     * toll passes are not provided, the API treats the toll pass as unknown and
     * tries to return the cash price.
     * Applies only to the `DRIVE` and `TWO_WHEELER`
     * [`RouteTravelMode`][google.maps.routing.v2.RouteTravelMode].
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.TollPass toll_passes = 6;</code>
     *
     * @param values The enum numeric values on the wire for tollPasses to add.
     * @return This builder for chaining.
     */
    public Builder addAllTollPassesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureTollPassesIsMutable();
      for (int value : values) {
        tollPasses_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteModifiers)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteModifiers)
  private static final com.google.maps.routing.v2.RouteModifiers DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.RouteModifiers();
  }

  public static com.google.maps.routing.v2.RouteModifiers getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouteModifiers> PARSER =
      new com.google.protobuf.AbstractParser<RouteModifiers>() {
        @java.lang.Override
        public RouteModifiers parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouteModifiers> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouteModifiers> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.RouteModifiers getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
