/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/route.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

public interface RouteOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.maps.routing.v2.Route)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @return A list containing the routeLabels.
   */
  java.util.List<com.google.maps.routing.v2.RouteLabel> getRouteLabelsList();

  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @return The count of routeLabels.
   */
  int getRouteLabelsCount();

  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The routeLabels at the given index.
   */
  com.google.maps.routing.v2.RouteLabel getRouteLabels(int index);

  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @return A list containing the enum numeric values on the wire for routeLabels.
   */
  java.util.List<java.lang.Integer> getRouteLabelsValueList();

  /**
   *
   *
   * <pre>
   * Labels for the `Route` that are useful to identify specific properties
   * of the route to compare against others.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLabel route_labels = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of routeLabels at the given index.
   */
  int getRouteLabelsValue(int index);

  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [`Waypoints`][google.maps.routing.v2.Waypoint]. For example, a route with
   * no intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  java.util.List<com.google.maps.routing.v2.RouteLeg> getLegsList();

  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [`Waypoints`][google.maps.routing.v2.Waypoint]. For example, a route with
   * no intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  com.google.maps.routing.v2.RouteLeg getLegs(int index);

  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [`Waypoints`][google.maps.routing.v2.Waypoint]. For example, a route with
   * no intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  int getLegsCount();

  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [`Waypoints`][google.maps.routing.v2.Waypoint]. For example, a route with
   * no intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  java.util.List<? extends com.google.maps.routing.v2.RouteLegOrBuilder> getLegsOrBuilderList();

  /**
   *
   *
   * <pre>
   * A collection of legs (path segments between waypoints) that make up the
   * route. Each leg corresponds to the trip between two non-`via`
   * [`Waypoints`][google.maps.routing.v2.Waypoint]. For example, a route with
   * no intermediate waypoints has only one leg. A route that includes one
   * non-`via` intermediate waypoint has two legs. A route that includes one
   * `via` intermediate waypoint has one leg. The order of the legs matches the
   * order of waypoints from `origin` to `intermediates` to `destination`.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.RouteLeg legs = 1;</code>
   */
  com.google.maps.routing.v2.RouteLegOrBuilder getLegsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The travel distance of the route, in meters.
   * </pre>
   *
   * <code>int32 distance_meters = 2;</code>
   *
   * @return The distanceMeters.
   */
  int getDistanceMeters();

  /**
   *
   *
   * <pre>
   * The length of time needed to navigate the route. If you set the
   * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
   * `static_duration`. If you set the `routing_preference` to either
   * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
   * taking traffic conditions into account.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 3;</code>
   *
   * @return Whether the duration field is set.
   */
  boolean hasDuration();

  /**
   *
   *
   * <pre>
   * The length of time needed to navigate the route. If you set the
   * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
   * `static_duration`. If you set the `routing_preference` to either
   * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
   * taking traffic conditions into account.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 3;</code>
   *
   * @return The duration.
   */
  com.google.protobuf.Duration getDuration();

  /**
   *
   *
   * <pre>
   * The length of time needed to navigate the route. If you set the
   * `routing_preference` to `TRAFFIC_UNAWARE`, then this value is the same as
   * `static_duration`. If you set the `routing_preference` to either
   * `TRAFFIC_AWARE` or `TRAFFIC_AWARE_OPTIMAL`, then this value is calculated
   * taking traffic conditions into account.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 3;</code>
   */
  com.google.protobuf.DurationOrBuilder getDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * The duration of travel through the route without taking traffic
   * conditions into consideration.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 4;</code>
   *
   * @return Whether the staticDuration field is set.
   */
  boolean hasStaticDuration();

  /**
   *
   *
   * <pre>
   * The duration of travel through the route without taking traffic
   * conditions into consideration.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 4;</code>
   *
   * @return The staticDuration.
   */
  com.google.protobuf.Duration getStaticDuration();

  /**
   *
   *
   * <pre>
   * The duration of travel through the route without taking traffic
   * conditions into consideration.
   * </pre>
   *
   * <code>.google.protobuf.Duration static_duration = 4;</code>
   */
  com.google.protobuf.DurationOrBuilder getStaticDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * The overall route polyline. This polyline is the combined polyline of
   * all `legs`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
   *
   * @return Whether the polyline field is set.
   */
  boolean hasPolyline();

  /**
   *
   *
   * <pre>
   * The overall route polyline. This polyline is the combined polyline of
   * all `legs`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
   *
   * @return The polyline.
   */
  com.google.maps.routing.v2.Polyline getPolyline();

  /**
   *
   *
   * <pre>
   * The overall route polyline. This polyline is the combined polyline of
   * all `legs`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Polyline polyline = 5;</code>
   */
  com.google.maps.routing.v2.PolylineOrBuilder getPolylineOrBuilder();

  /**
   *
   *
   * <pre>
   * A description of the route.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * A description of the route.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @return A list containing the warnings.
   */
  java.util.List<java.lang.String> getWarningsList();

  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @return The count of warnings.
   */
  int getWarningsCount();

  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  java.lang.String getWarnings(int index);

  /**
   *
   *
   * <pre>
   * An array of warnings to show when displaying the route.
   * </pre>
   *
   * <code>repeated string warnings = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  com.google.protobuf.ByteString getWarningsBytes(int index);

  /**
   *
   *
   * <pre>
   * The viewport bounding box of the polyline.
   * </pre>
   *
   * <code>.google.geo.type.Viewport viewport = 8;</code>
   *
   * @return Whether the viewport field is set.
   */
  boolean hasViewport();

  /**
   *
   *
   * <pre>
   * The viewport bounding box of the polyline.
   * </pre>
   *
   * <code>.google.geo.type.Viewport viewport = 8;</code>
   *
   * @return The viewport.
   */
  com.google.geo.type.Viewport getViewport();

  /**
   *
   *
   * <pre>
   * The viewport bounding box of the polyline.
   * </pre>
   *
   * <code>.google.geo.type.Viewport viewport = 8;</code>
   */
  com.google.geo.type.ViewportOrBuilder getViewportOrBuilder();

  /**
   *
   *
   * <pre>
   * Additional information about the route.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
   *
   * @return Whether the travelAdvisory field is set.
   */
  boolean hasTravelAdvisory();

  /**
   *
   *
   * <pre>
   * Additional information about the route.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
   *
   * @return The travelAdvisory.
   */
  com.google.maps.routing.v2.RouteTravelAdvisory getTravelAdvisory();

  /**
   *
   *
   * <pre>
   * Additional information about the route.
   * </pre>
   *
   * <code>.google.maps.routing.v2.RouteTravelAdvisory travel_advisory = 9;</code>
   */
  com.google.maps.routing.v2.RouteTravelAdvisoryOrBuilder getTravelAdvisoryOrBuilder();

  /**
   *
   *
   * <pre>
   * If you set
   * [`optimize_waypoint_order`][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
   * to true, this field contains the optimized ordering of intermediate
   * waypoints. Otherwise, this field is empty.
   * For example, if you give an input of Origin: LA; Intermediate waypoints:
   * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
   * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
   * contains the values [2, 0, 1]. The index starts with 0 for the first
   * intermediate waypoint provided in the input.
   * </pre>
   *
   * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
   *
   * @return A list containing the optimizedIntermediateWaypointIndex.
   */
  java.util.List<java.lang.Integer> getOptimizedIntermediateWaypointIndexList();

  /**
   *
   *
   * <pre>
   * If you set
   * [`optimize_waypoint_order`][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
   * to true, this field contains the optimized ordering of intermediate
   * waypoints. Otherwise, this field is empty.
   * For example, if you give an input of Origin: LA; Intermediate waypoints:
   * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
   * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
   * contains the values [2, 0, 1]. The index starts with 0 for the first
   * intermediate waypoint provided in the input.
   * </pre>
   *
   * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
   *
   * @return The count of optimizedIntermediateWaypointIndex.
   */
  int getOptimizedIntermediateWaypointIndexCount();

  /**
   *
   *
   * <pre>
   * If you set
   * [`optimize_waypoint_order`][google.maps.routing.v2.ComputeRoutesRequest.optimize_waypoint_order]
   * to true, this field contains the optimized ordering of intermediate
   * waypoints. Otherwise, this field is empty.
   * For example, if you give an input of Origin: LA; Intermediate waypoints:
   * Dallas, Bangor, Phoenix; Destination: New York; and the optimized
   * intermediate waypoint order is Phoenix, Dallas, Bangor, then this field
   * contains the values [2, 0, 1]. The index starts with 0 for the first
   * intermediate waypoint provided in the input.
   * </pre>
   *
   * <code>repeated int32 optimized_intermediate_waypoint_index = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The optimizedIntermediateWaypointIndex at the given index.
   */
  int getOptimizedIntermediateWaypointIndex(int index);

  /**
   *
   *
   * <pre>
   * Text representations of properties of the `Route`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
   *
   * @return Whether the localizedValues field is set.
   */
  boolean hasLocalizedValues();

  /**
   *
   *
   * <pre>
   * Text representations of properties of the `Route`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
   *
   * @return The localizedValues.
   */
  com.google.maps.routing.v2.Route.RouteLocalizedValues getLocalizedValues();

  /**
   *
   *
   * <pre>
   * Text representations of properties of the `Route`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.Route.RouteLocalizedValues localized_values = 11;</code>
   */
  com.google.maps.routing.v2.Route.RouteLocalizedValuesOrBuilder getLocalizedValuesOrBuilder();

  /**
   *
   *
   * <pre>
   * An opaque token that can be passed to [Navigation
   * SDK](https://developers.google.com/maps/documentation/navigation) to
   * reconstruct the route during navigation, and, in the event of rerouting,
   * honor the original intention when the route was created. Treat this token
   * as an opaque blob.  Don't compare its value across requests as its value
   * may change even if the service returns the exact same route.
   *
   * NOTE: `Route.route_token` is only available for requests that have set
   * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
   * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
   * that have Via waypoints.
   * </pre>
   *
   * <code>string route_token = 12;</code>
   *
   * @return The routeToken.
   */
  java.lang.String getRouteToken();

  /**
   *
   *
   * <pre>
   * An opaque token that can be passed to [Navigation
   * SDK](https://developers.google.com/maps/documentation/navigation) to
   * reconstruct the route during navigation, and, in the event of rerouting,
   * honor the original intention when the route was created. Treat this token
   * as an opaque blob.  Don't compare its value across requests as its value
   * may change even if the service returns the exact same route.
   *
   * NOTE: `Route.route_token` is only available for requests that have set
   * `ComputeRoutesRequest.routing_preference` to `TRAFFIC_AWARE` or
   * `TRAFFIC_AWARE_OPTIMAL`. `Route.route_token` is not supported for requests
   * that have Via waypoints.
   * </pre>
   *
   * <code>string route_token = 12;</code>
   *
   * @return The bytes for routeToken.
   */
  com.google.protobuf.ByteString getRouteTokenBytes();

  /**
   *
   *
   * <pre>
   * Contains information about details along the polyline.
   * </pre>
   *
   * <code>.google.maps.routing.v2.PolylineDetails polyline_details = 14;</code>
   *
   * @return Whether the polylineDetails field is set.
   */
  boolean hasPolylineDetails();

  /**
   *
   *
   * <pre>
   * Contains information about details along the polyline.
   * </pre>
   *
   * <code>.google.maps.routing.v2.PolylineDetails polyline_details = 14;</code>
   *
   * @return The polylineDetails.
   */
  com.google.maps.routing.v2.PolylineDetails getPolylineDetails();

  /**
   *
   *
   * <pre>
   * Contains information about details along the polyline.
   * </pre>
   *
   * <code>.google.maps.routing.v2.PolylineDetails polyline_details = 14;</code>
   */
  com.google.maps.routing.v2.PolylineDetailsOrBuilder getPolylineDetailsOrBuilder();
}
