/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/toll_info.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Encapsulates toll information on a [`Route`][google.maps.routing.v2.Route] or
 * on a [`RouteLeg`][google.maps.routing.v2.RouteLeg].
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.TollInfo}
 */
public final class TollInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.TollInfo)
    TollInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TollInfo.newBuilder() to construct.
  private TollInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TollInfo() {
    estimatedPrice_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TollInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.TollInfoProto
        .internal_static_google_maps_routing_v2_TollInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.TollInfoProto
        .internal_static_google_maps_routing_v2_TollInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.TollInfo.class,
            com.google.maps.routing.v2.TollInfo.Builder.class);
  }

  public static final int ESTIMATED_PRICE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.type.Money> estimatedPrice_;

  /**
   *
   *
   * <pre>
   * The monetary amount of tolls for the corresponding
   * [`Route`][google.maps.routing.v2.Route] or
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
   * amount for each currency that is expected to be charged by the toll
   * stations. Typically this list will contain only one item for routes with
   * tolls in one currency. For international trips, this list may contain
   * multiple items to reflect tolls in different currencies.
   * </pre>
   *
   * <code>repeated .google.type.Money estimated_price = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.type.Money> getEstimatedPriceList() {
    return estimatedPrice_;
  }

  /**
   *
   *
   * <pre>
   * The monetary amount of tolls for the corresponding
   * [`Route`][google.maps.routing.v2.Route] or
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
   * amount for each currency that is expected to be charged by the toll
   * stations. Typically this list will contain only one item for routes with
   * tolls in one currency. For international trips, this list may contain
   * multiple items to reflect tolls in different currencies.
   * </pre>
   *
   * <code>repeated .google.type.Money estimated_price = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.type.MoneyOrBuilder> getEstimatedPriceOrBuilderList() {
    return estimatedPrice_;
  }

  /**
   *
   *
   * <pre>
   * The monetary amount of tolls for the corresponding
   * [`Route`][google.maps.routing.v2.Route] or
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
   * amount for each currency that is expected to be charged by the toll
   * stations. Typically this list will contain only one item for routes with
   * tolls in one currency. For international trips, this list may contain
   * multiple items to reflect tolls in different currencies.
   * </pre>
   *
   * <code>repeated .google.type.Money estimated_price = 1;</code>
   */
  @java.lang.Override
  public int getEstimatedPriceCount() {
    return estimatedPrice_.size();
  }

  /**
   *
   *
   * <pre>
   * The monetary amount of tolls for the corresponding
   * [`Route`][google.maps.routing.v2.Route] or
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
   * amount for each currency that is expected to be charged by the toll
   * stations. Typically this list will contain only one item for routes with
   * tolls in one currency. For international trips, this list may contain
   * multiple items to reflect tolls in different currencies.
   * </pre>
   *
   * <code>repeated .google.type.Money estimated_price = 1;</code>
   */
  @java.lang.Override
  public com.google.type.Money getEstimatedPrice(int index) {
    return estimatedPrice_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The monetary amount of tolls for the corresponding
   * [`Route`][google.maps.routing.v2.Route] or
   * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
   * amount for each currency that is expected to be charged by the toll
   * stations. Typically this list will contain only one item for routes with
   * tolls in one currency. For international trips, this list may contain
   * multiple items to reflect tolls in different currencies.
   * </pre>
   *
   * <code>repeated .google.type.Money estimated_price = 1;</code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getEstimatedPriceOrBuilder(int index) {
    return estimatedPrice_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < estimatedPrice_.size(); i++) {
      output.writeMessage(1, estimatedPrice_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < estimatedPrice_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, estimatedPrice_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.TollInfo)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.TollInfo other = (com.google.maps.routing.v2.TollInfo) obj;

    if (!getEstimatedPriceList().equals(other.getEstimatedPriceList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getEstimatedPriceCount() > 0) {
      hash = (37 * hash) + ESTIMATED_PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getEstimatedPriceList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TollInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TollInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TollInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.TollInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Encapsulates toll information on a [`Route`][google.maps.routing.v2.Route] or
   * on a [`RouteLeg`][google.maps.routing.v2.RouteLeg].
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.TollInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.TollInfo)
      com.google.maps.routing.v2.TollInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.TollInfoProto
          .internal_static_google_maps_routing_v2_TollInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.TollInfoProto
          .internal_static_google_maps_routing_v2_TollInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.TollInfo.class,
              com.google.maps.routing.v2.TollInfo.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.TollInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (estimatedPriceBuilder_ == null) {
        estimatedPrice_ = java.util.Collections.emptyList();
      } else {
        estimatedPrice_ = null;
        estimatedPriceBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.TollInfoProto
          .internal_static_google_maps_routing_v2_TollInfo_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TollInfo getDefaultInstanceForType() {
      return com.google.maps.routing.v2.TollInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TollInfo build() {
      com.google.maps.routing.v2.TollInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TollInfo buildPartial() {
      com.google.maps.routing.v2.TollInfo result = new com.google.maps.routing.v2.TollInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.TollInfo result) {
      if (estimatedPriceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          estimatedPrice_ = java.util.Collections.unmodifiableList(estimatedPrice_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.estimatedPrice_ = estimatedPrice_;
      } else {
        result.estimatedPrice_ = estimatedPriceBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.routing.v2.TollInfo result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.TollInfo) {
        return mergeFrom((com.google.maps.routing.v2.TollInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.TollInfo other) {
      if (other == com.google.maps.routing.v2.TollInfo.getDefaultInstance()) return this;
      if (estimatedPriceBuilder_ == null) {
        if (!other.estimatedPrice_.isEmpty()) {
          if (estimatedPrice_.isEmpty()) {
            estimatedPrice_ = other.estimatedPrice_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEstimatedPriceIsMutable();
            estimatedPrice_.addAll(other.estimatedPrice_);
          }
          onChanged();
        }
      } else {
        if (!other.estimatedPrice_.isEmpty()) {
          if (estimatedPriceBuilder_.isEmpty()) {
            estimatedPriceBuilder_.dispose();
            estimatedPriceBuilder_ = null;
            estimatedPrice_ = other.estimatedPrice_;
            bitField0_ = (bitField0_ & ~0x00000001);
            estimatedPriceBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEstimatedPriceFieldBuilder()
                    : null;
          } else {
            estimatedPriceBuilder_.addAllMessages(other.estimatedPrice_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.type.Money m =
                    input.readMessage(com.google.type.Money.parser(), extensionRegistry);
                if (estimatedPriceBuilder_ == null) {
                  ensureEstimatedPriceIsMutable();
                  estimatedPrice_.add(m);
                } else {
                  estimatedPriceBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.type.Money> estimatedPrice_ =
        java.util.Collections.emptyList();

    private void ensureEstimatedPriceIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        estimatedPrice_ = new java.util.ArrayList<com.google.type.Money>(estimatedPrice_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        estimatedPriceBuilder_;

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public java.util.List<com.google.type.Money> getEstimatedPriceList() {
      if (estimatedPriceBuilder_ == null) {
        return java.util.Collections.unmodifiableList(estimatedPrice_);
      } else {
        return estimatedPriceBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public int getEstimatedPriceCount() {
      if (estimatedPriceBuilder_ == null) {
        return estimatedPrice_.size();
      } else {
        return estimatedPriceBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public com.google.type.Money getEstimatedPrice(int index) {
      if (estimatedPriceBuilder_ == null) {
        return estimatedPrice_.get(index);
      } else {
        return estimatedPriceBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder setEstimatedPrice(int index, com.google.type.Money value) {
      if (estimatedPriceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.set(index, value);
        onChanged();
      } else {
        estimatedPriceBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder setEstimatedPrice(int index, com.google.type.Money.Builder builderForValue) {
      if (estimatedPriceBuilder_ == null) {
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.set(index, builderForValue.build());
        onChanged();
      } else {
        estimatedPriceBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder addEstimatedPrice(com.google.type.Money value) {
      if (estimatedPriceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.add(value);
        onChanged();
      } else {
        estimatedPriceBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder addEstimatedPrice(int index, com.google.type.Money value) {
      if (estimatedPriceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.add(index, value);
        onChanged();
      } else {
        estimatedPriceBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder addEstimatedPrice(com.google.type.Money.Builder builderForValue) {
      if (estimatedPriceBuilder_ == null) {
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.add(builderForValue.build());
        onChanged();
      } else {
        estimatedPriceBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder addEstimatedPrice(int index, com.google.type.Money.Builder builderForValue) {
      if (estimatedPriceBuilder_ == null) {
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.add(index, builderForValue.build());
        onChanged();
      } else {
        estimatedPriceBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder addAllEstimatedPrice(
        java.lang.Iterable<? extends com.google.type.Money> values) {
      if (estimatedPriceBuilder_ == null) {
        ensureEstimatedPriceIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, estimatedPrice_);
        onChanged();
      } else {
        estimatedPriceBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder clearEstimatedPrice() {
      if (estimatedPriceBuilder_ == null) {
        estimatedPrice_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        estimatedPriceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public Builder removeEstimatedPrice(int index) {
      if (estimatedPriceBuilder_ == null) {
        ensureEstimatedPriceIsMutable();
        estimatedPrice_.remove(index);
        onChanged();
      } else {
        estimatedPriceBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public com.google.type.Money.Builder getEstimatedPriceBuilder(int index) {
      return getEstimatedPriceFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public com.google.type.MoneyOrBuilder getEstimatedPriceOrBuilder(int index) {
      if (estimatedPriceBuilder_ == null) {
        return estimatedPrice_.get(index);
      } else {
        return estimatedPriceBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public java.util.List<? extends com.google.type.MoneyOrBuilder>
        getEstimatedPriceOrBuilderList() {
      if (estimatedPriceBuilder_ != null) {
        return estimatedPriceBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(estimatedPrice_);
      }
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public com.google.type.Money.Builder addEstimatedPriceBuilder() {
      return getEstimatedPriceFieldBuilder().addBuilder(com.google.type.Money.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public com.google.type.Money.Builder addEstimatedPriceBuilder(int index) {
      return getEstimatedPriceFieldBuilder()
          .addBuilder(index, com.google.type.Money.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The monetary amount of tolls for the corresponding
     * [`Route`][google.maps.routing.v2.Route] or
     * [`RouteLeg`][google.maps.routing.v2.RouteLeg]. This list contains a money
     * amount for each currency that is expected to be charged by the toll
     * stations. Typically this list will contain only one item for routes with
     * tolls in one currency. For international trips, this list may contain
     * multiple items to reflect tolls in different currencies.
     * </pre>
     *
     * <code>repeated .google.type.Money estimated_price = 1;</code>
     */
    public java.util.List<com.google.type.Money.Builder> getEstimatedPriceBuilderList() {
      return getEstimatedPriceFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getEstimatedPriceFieldBuilder() {
      if (estimatedPriceBuilder_ == null) {
        estimatedPriceBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                estimatedPrice_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        estimatedPrice_ = null;
      }
      return estimatedPriceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.TollInfo)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.TollInfo)
  private static final com.google.maps.routing.v2.TollInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.TollInfo();
  }

  public static com.google.maps.routing.v2.TollInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TollInfo> PARSER =
      new com.google.protobuf.AbstractParser<TollInfo>() {
        @java.lang.Override
        public TollInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TollInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TollInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.TollInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
