/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/transit_preferences.proto

// Protobuf Java Version: 3.25.5
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Preferences for `TRANSIT` based routes that influence the route that is
 * returned.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.TransitPreferences}
 */
public final class TransitPreferences extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.TransitPreferences)
    TransitPreferencesOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TransitPreferences.newBuilder() to construct.
  private TransitPreferences(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitPreferences() {
    allowedTravelModes_ = java.util.Collections.emptyList();
    routingPreference_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitPreferences();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.TransitPreferencesProto
        .internal_static_google_maps_routing_v2_TransitPreferences_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.TransitPreferencesProto
        .internal_static_google_maps_routing_v2_TransitPreferences_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.TransitPreferences.class,
            com.google.maps.routing.v2.TransitPreferences.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A set of values used to specify the mode of transit.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.TransitPreferences.TransitTravelMode}
   */
  public enum TransitTravelMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No transit travel mode specified.
     * </pre>
     *
     * <code>TRANSIT_TRAVEL_MODE_UNSPECIFIED = 0;</code>
     */
    TRANSIT_TRAVEL_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Travel by bus.
     * </pre>
     *
     * <code>BUS = 1;</code>
     */
    BUS(1),
    /**
     *
     *
     * <pre>
     * Travel by subway.
     * </pre>
     *
     * <code>SUBWAY = 2;</code>
     */
    SUBWAY(2),
    /**
     *
     *
     * <pre>
     * Travel by train.
     * </pre>
     *
     * <code>TRAIN = 3;</code>
     */
    TRAIN(3),
    /**
     *
     *
     * <pre>
     * Travel by light rail or tram.
     * </pre>
     *
     * <code>LIGHT_RAIL = 4;</code>
     */
    LIGHT_RAIL(4),
    /**
     *
     *
     * <pre>
     * Travel by rail. This is equivalent to a combination of `SUBWAY`, `TRAIN`,
     * and `LIGHT_RAIL`.
     * </pre>
     *
     * <code>RAIL = 5;</code>
     */
    RAIL(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No transit travel mode specified.
     * </pre>
     *
     * <code>TRANSIT_TRAVEL_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int TRANSIT_TRAVEL_MODE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Travel by bus.
     * </pre>
     *
     * <code>BUS = 1;</code>
     */
    public static final int BUS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Travel by subway.
     * </pre>
     *
     * <code>SUBWAY = 2;</code>
     */
    public static final int SUBWAY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Travel by train.
     * </pre>
     *
     * <code>TRAIN = 3;</code>
     */
    public static final int TRAIN_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Travel by light rail or tram.
     * </pre>
     *
     * <code>LIGHT_RAIL = 4;</code>
     */
    public static final int LIGHT_RAIL_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Travel by rail. This is equivalent to a combination of `SUBWAY`, `TRAIN`,
     * and `LIGHT_RAIL`.
     * </pre>
     *
     * <code>RAIL = 5;</code>
     */
    public static final int RAIL_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransitTravelMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransitTravelMode forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSIT_TRAVEL_MODE_UNSPECIFIED;
        case 1:
          return BUS;
        case 2:
          return SUBWAY;
        case 3:
          return TRAIN;
        case 4:
          return LIGHT_RAIL;
        case 5:
          return RAIL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransitTravelMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransitTravelMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TransitTravelMode>() {
              public TransitTravelMode findValueByNumber(int number) {
                return TransitTravelMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.TransitPreferences.getDescriptor().getEnumTypes().get(0);
    }

    private static final TransitTravelMode[] VALUES = values();

    public static TransitTravelMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransitTravelMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.TransitPreferences.TransitTravelMode)
  }

  /**
   *
   *
   * <pre>
   * Specifies routing preferences for transit routes.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.TransitPreferences.TransitRoutingPreference}
   */
  public enum TransitRoutingPreference implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No preference specified.
     * </pre>
     *
     * <code>TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED = 0;</code>
     */
    TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that the calculated route should prefer limited amounts of
     * walking.
     * </pre>
     *
     * <code>LESS_WALKING = 1;</code>
     */
    LESS_WALKING(1),
    /**
     *
     *
     * <pre>
     * Indicates that the calculated route should prefer a limited number of
     * transfers.
     * </pre>
     *
     * <code>FEWER_TRANSFERS = 2;</code>
     */
    FEWER_TRANSFERS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No preference specified.
     * </pre>
     *
     * <code>TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED = 0;</code>
     */
    public static final int TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Indicates that the calculated route should prefer limited amounts of
     * walking.
     * </pre>
     *
     * <code>LESS_WALKING = 1;</code>
     */
    public static final int LESS_WALKING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Indicates that the calculated route should prefer a limited number of
     * transfers.
     * </pre>
     *
     * <code>FEWER_TRANSFERS = 2;</code>
     */
    public static final int FEWER_TRANSFERS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransitRoutingPreference valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransitRoutingPreference forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED;
        case 1:
          return LESS_WALKING;
        case 2:
          return FEWER_TRANSFERS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransitRoutingPreference>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransitRoutingPreference>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TransitRoutingPreference>() {
              public TransitRoutingPreference findValueByNumber(int number) {
                return TransitRoutingPreference.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.TransitPreferences.getDescriptor().getEnumTypes().get(1);
    }

    private static final TransitRoutingPreference[] VALUES = values();

    public static TransitRoutingPreference valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransitRoutingPreference(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.TransitPreferences.TransitRoutingPreference)
  }

  public static final int ALLOWED_TRAVEL_MODES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> allowedTravelModes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>
      allowedTravelModes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>() {
            public com.google.maps.routing.v2.TransitPreferences.TransitTravelMode convert(
                java.lang.Integer from) {
              com.google.maps.routing.v2.TransitPreferences.TransitTravelMode result =
                  com.google.maps.routing.v2.TransitPreferences.TransitTravelMode.forNumber(from);
              return result == null
                  ? com.google.maps.routing.v2.TransitPreferences.TransitTravelMode.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
   * all supported modes of travel.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
   * </code>
   *
   * @return A list containing the allowedTravelModes.
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>
      getAllowedTravelModesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>(
        allowedTravelModes_, allowedTravelModes_converter_);
  }

  /**
   *
   *
   * <pre>
   * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
   * all supported modes of travel.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
   * </code>
   *
   * @return The count of allowedTravelModes.
   */
  @java.lang.Override
  public int getAllowedTravelModesCount() {
    return allowedTravelModes_.size();
  }

  /**
   *
   *
   * <pre>
   * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
   * all supported modes of travel.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The allowedTravelModes at the given index.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferences.TransitTravelMode getAllowedTravelModes(
      int index) {
    return allowedTravelModes_converter_.convert(allowedTravelModes_.get(index));
  }

  /**
   *
   *
   * <pre>
   * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
   * all supported modes of travel.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for allowedTravelModes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAllowedTravelModesValueList() {
    return allowedTravelModes_;
  }

  /**
   *
   *
   * <pre>
   * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
   * all supported modes of travel.
   * </pre>
   *
   * <code>
   * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of allowedTravelModes at the given index.
   */
  @java.lang.Override
  public int getAllowedTravelModesValue(int index) {
    return allowedTravelModes_.get(index);
  }

  private int allowedTravelModesMemoizedSerializedSize;

  public static final int ROUTING_PREFERENCE_FIELD_NUMBER = 2;
  private int routingPreference_ = 0;

  /**
   *
   *
   * <pre>
   * A routing preference that, when specified, influences the `TRANSIT` route
   * returned.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for routingPreference.
   */
  @java.lang.Override
  public int getRoutingPreferenceValue() {
    return routingPreference_;
  }

  /**
   *
   *
   * <pre>
   * A routing preference that, when specified, influences the `TRANSIT` route
   * returned.
   * </pre>
   *
   * <code>
   * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
   * </code>
   *
   * @return The routingPreference.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference
      getRoutingPreference() {
    com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference result =
        com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference.forNumber(
            routingPreference_);
    return result == null
        ? com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getAllowedTravelModesList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(allowedTravelModesMemoizedSerializedSize);
    }
    for (int i = 0; i < allowedTravelModes_.size(); i++) {
      output.writeEnumNoTag(allowedTravelModes_.get(i));
    }
    if (routingPreference_
        != com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference
            .TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, routingPreference_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < allowedTravelModes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(allowedTravelModes_.get(i));
      }
      size += dataSize;
      if (!getAllowedTravelModesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      allowedTravelModesMemoizedSerializedSize = dataSize;
    }
    if (routingPreference_
        != com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference
            .TRANSIT_ROUTING_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, routingPreference_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.TransitPreferences)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.TransitPreferences other =
        (com.google.maps.routing.v2.TransitPreferences) obj;

    if (!allowedTravelModes_.equals(other.allowedTravelModes_)) return false;
    if (routingPreference_ != other.routingPreference_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedTravelModesCount() > 0) {
      hash = (37 * hash) + ALLOWED_TRAVEL_MODES_FIELD_NUMBER;
      hash = (53 * hash) + allowedTravelModes_.hashCode();
    }
    hash = (37 * hash) + ROUTING_PREFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + routingPreference_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitPreferences parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.TransitPreferences prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Preferences for `TRANSIT` based routes that influence the route that is
   * returned.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.TransitPreferences}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.TransitPreferences)
      com.google.maps.routing.v2.TransitPreferencesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.TransitPreferencesProto
          .internal_static_google_maps_routing_v2_TransitPreferences_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.TransitPreferencesProto
          .internal_static_google_maps_routing_v2_TransitPreferences_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.TransitPreferences.class,
              com.google.maps.routing.v2.TransitPreferences.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.TransitPreferences.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowedTravelModes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      routingPreference_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.TransitPreferencesProto
          .internal_static_google_maps_routing_v2_TransitPreferences_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitPreferences getDefaultInstanceForType() {
      return com.google.maps.routing.v2.TransitPreferences.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitPreferences build() {
      com.google.maps.routing.v2.TransitPreferences result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitPreferences buildPartial() {
      com.google.maps.routing.v2.TransitPreferences result =
          new com.google.maps.routing.v2.TransitPreferences(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.maps.routing.v2.TransitPreferences result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        allowedTravelModes_ = java.util.Collections.unmodifiableList(allowedTravelModes_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.allowedTravelModes_ = allowedTravelModes_;
    }

    private void buildPartial0(com.google.maps.routing.v2.TransitPreferences result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.routingPreference_ = routingPreference_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.TransitPreferences) {
        return mergeFrom((com.google.maps.routing.v2.TransitPreferences) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.TransitPreferences other) {
      if (other == com.google.maps.routing.v2.TransitPreferences.getDefaultInstance()) return this;
      if (!other.allowedTravelModes_.isEmpty()) {
        if (allowedTravelModes_.isEmpty()) {
          allowedTravelModes_ = other.allowedTravelModes_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureAllowedTravelModesIsMutable();
          allowedTravelModes_.addAll(other.allowedTravelModes_);
        }
        onChanged();
      }
      if (other.routingPreference_ != 0) {
        setRoutingPreferenceValue(other.getRoutingPreferenceValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureAllowedTravelModesIsMutable();
                allowedTravelModes_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAllowedTravelModesIsMutable();
                  allowedTravelModes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            case 16:
              {
                routingPreference_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> allowedTravelModes_ =
        java.util.Collections.emptyList();

    private void ensureAllowedTravelModesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedTravelModes_ = new java.util.ArrayList<java.lang.Integer>(allowedTravelModes_);
        bitField0_ |= 0x00000001;
      }
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @return A list containing the allowedTravelModes.
     */
    public java.util.List<com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>
        getAllowedTravelModesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>(
          allowedTravelModes_, allowedTravelModes_converter_);
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @return The count of allowedTravelModes.
     */
    public int getAllowedTravelModesCount() {
      return allowedTravelModes_.size();
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The allowedTravelModes at the given index.
     */
    public com.google.maps.routing.v2.TransitPreferences.TransitTravelMode getAllowedTravelModes(
        int index) {
      return allowedTravelModes_converter_.convert(allowedTravelModes_.get(index));
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The allowedTravelModes to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedTravelModes(
        int index, com.google.maps.routing.v2.TransitPreferences.TransitTravelMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedTravelModesIsMutable();
      allowedTravelModes_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param value The allowedTravelModes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedTravelModes(
        com.google.maps.routing.v2.TransitPreferences.TransitTravelMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedTravelModesIsMutable();
      allowedTravelModes_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param values The allowedTravelModes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedTravelModes(
        java.lang.Iterable<
                ? extends com.google.maps.routing.v2.TransitPreferences.TransitTravelMode>
            values) {
      ensureAllowedTravelModesIsMutable();
      for (com.google.maps.routing.v2.TransitPreferences.TransitTravelMode value : values) {
        allowedTravelModes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedTravelModes() {
      allowedTravelModes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for allowedTravelModes.
     */
    public java.util.List<java.lang.Integer> getAllowedTravelModesValueList() {
      return java.util.Collections.unmodifiableList(allowedTravelModes_);
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allowedTravelModes at the given index.
     */
    public int getAllowedTravelModesValue(int index) {
      return allowedTravelModes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for allowedTravelModes to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedTravelModesValue(int index, int value) {
      ensureAllowedTravelModesIsMutable();
      allowedTravelModes_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for allowedTravelModes to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedTravelModesValue(int value) {
      ensureAllowedTravelModesIsMutable();
      allowedTravelModes_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A set of travel modes to use when getting a `TRANSIT` route. Defaults to
     * all supported modes of travel.
     * </pre>
     *
     * <code>
     * repeated .google.maps.routing.v2.TransitPreferences.TransitTravelMode allowed_travel_modes = 1;
     * </code>
     *
     * @param values The enum numeric values on the wire for allowedTravelModes to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedTravelModesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureAllowedTravelModesIsMutable();
      for (int value : values) {
        allowedTravelModes_.add(value);
      }
      onChanged();
      return this;
    }

    private int routingPreference_ = 0;

    /**
     *
     *
     * <pre>
     * A routing preference that, when specified, influences the `TRANSIT` route
     * returned.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for routingPreference.
     */
    @java.lang.Override
    public int getRoutingPreferenceValue() {
      return routingPreference_;
    }

    /**
     *
     *
     * <pre>
     * A routing preference that, when specified, influences the `TRANSIT` route
     * returned.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for routingPreference to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingPreferenceValue(int value) {
      routingPreference_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A routing preference that, when specified, influences the `TRANSIT` route
     * returned.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
     * </code>
     *
     * @return The routingPreference.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference
        getRoutingPreference() {
      com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference result =
          com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference.forNumber(
              routingPreference_);
      return result == null
          ? com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * A routing preference that, when specified, influences the `TRANSIT` route
     * returned.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
     * </code>
     *
     * @param value The routingPreference to set.
     * @return This builder for chaining.
     */
    public Builder setRoutingPreference(
        com.google.maps.routing.v2.TransitPreferences.TransitRoutingPreference value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      routingPreference_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A routing preference that, when specified, influences the `TRANSIT` route
     * returned.
     * </pre>
     *
     * <code>
     * .google.maps.routing.v2.TransitPreferences.TransitRoutingPreference routing_preference = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutingPreference() {
      bitField0_ = (bitField0_ & ~0x00000002);
      routingPreference_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.TransitPreferences)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.TransitPreferences)
  private static final com.google.maps.routing.v2.TransitPreferences DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.TransitPreferences();
  }

  public static com.google.maps.routing.v2.TransitPreferences getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitPreferences> PARSER =
      new com.google.protobuf.AbstractParser<TransitPreferences>() {
        @java.lang.Override
        public TransitPreferences parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitPreferences> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitPreferences> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.TransitPreferences getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
