/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/geocoding_results.proto

// Protobuf Java Version: 3.25.8
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Details about the locations used as waypoints. Only populated for address
 * waypoints. Includes details about the geocoding results for the purposes of
 * determining what the address was geocoded to.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.GeocodedWaypoint}
 */
public final class GeocodedWaypoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.GeocodedWaypoint)
    GeocodedWaypointOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GeocodedWaypoint.newBuilder() to construct.
  private GeocodedWaypoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GeocodedWaypoint() {
    type_ = com.google.protobuf.LazyStringArrayList.emptyList();
    placeId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GeocodedWaypoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.GeocodingResultsProto
        .internal_static_google_maps_routing_v2_GeocodedWaypoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.GeocodingResultsProto
        .internal_static_google_maps_routing_v2_GeocodedWaypoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.GeocodedWaypoint.class,
            com.google.maps.routing.v2.GeocodedWaypoint.Builder.class);
  }

  private int bitField0_;
  public static final int GEOCODER_STATUS_FIELD_NUMBER = 1;
  private com.google.rpc.Status geocoderStatus_;

  /**
   *
   *
   * <pre>
   * Indicates the status code resulting from the geocoding operation.
   * </pre>
   *
   * <code>.google.rpc.Status geocoder_status = 1;</code>
   *
   * @return Whether the geocoderStatus field is set.
   */
  @java.lang.Override
  public boolean hasGeocoderStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Indicates the status code resulting from the geocoding operation.
   * </pre>
   *
   * <code>.google.rpc.Status geocoder_status = 1;</code>
   *
   * @return The geocoderStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getGeocoderStatus() {
    return geocoderStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : geocoderStatus_;
  }

  /**
   *
   *
   * <pre>
   * Indicates the status code resulting from the geocoding operation.
   * </pre>
   *
   * <code>.google.rpc.Status geocoder_status = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getGeocoderStatusOrBuilder() {
    return geocoderStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : geocoderStatus_;
  }

  public static final int INTERMEDIATE_WAYPOINT_REQUEST_INDEX_FIELD_NUMBER = 2;
  private int intermediateWaypointRequestIndex_ = 0;

  /**
   *
   *
   * <pre>
   * The index of the corresponding intermediate waypoint in the request.
   * Only populated if the corresponding waypoint is an intermediate
   * waypoint.
   * </pre>
   *
   * <code>optional int32 intermediate_waypoint_request_index = 2;</code>
   *
   * @return Whether the intermediateWaypointRequestIndex field is set.
   */
  @java.lang.Override
  public boolean hasIntermediateWaypointRequestIndex() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The index of the corresponding intermediate waypoint in the request.
   * Only populated if the corresponding waypoint is an intermediate
   * waypoint.
   * </pre>
   *
   * <code>optional int32 intermediate_waypoint_request_index = 2;</code>
   *
   * @return The intermediateWaypointRequestIndex.
   */
  @java.lang.Override
  public int getIntermediateWaypointRequestIndex() {
    return intermediateWaypointRequestIndex_;
  }

  public static final int TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList type_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The type(s) of the result, in the form of zero or more type tags.
   * Supported types: [Address types and address component
   * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string type = 3;</code>
   *
   * @return A list containing the type.
   */
  public com.google.protobuf.ProtocolStringList getTypeList() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * The type(s) of the result, in the form of zero or more type tags.
   * Supported types: [Address types and address component
   * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string type = 3;</code>
   *
   * @return The count of type.
   */
  public int getTypeCount() {
    return type_.size();
  }

  /**
   *
   *
   * <pre>
   * The type(s) of the result, in the form of zero or more type tags.
   * Supported types: [Address types and address component
   * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string type = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The type at the given index.
   */
  public java.lang.String getType(int index) {
    return type_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The type(s) of the result, in the form of zero or more type tags.
   * Supported types: [Address types and address component
   * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
   * </pre>
   *
   * <code>repeated string type = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the type at the given index.
   */
  public com.google.protobuf.ByteString getTypeBytes(int index) {
    return type_.getByteString(index);
  }

  public static final int PARTIAL_MATCH_FIELD_NUMBER = 4;
  private boolean partialMatch_ = false;

  /**
   *
   *
   * <pre>
   * Indicates that the geocoder did not return an exact match for the original
   * request, though it was able to match part of the requested address. You may
   * wish to examine the original request for misspellings and/or an incomplete
   * address.
   * </pre>
   *
   * <code>bool partial_match = 4;</code>
   *
   * @return The partialMatch.
   */
  @java.lang.Override
  public boolean getPartialMatch() {
    return partialMatch_;
  }

  public static final int PLACE_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object placeId_ = "";

  /**
   *
   *
   * <pre>
   * The place ID for this result.
   * </pre>
   *
   * <code>string place_id = 5;</code>
   *
   * @return The placeId.
   */
  @java.lang.Override
  public java.lang.String getPlaceId() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      placeId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The place ID for this result.
   * </pre>
   *
   * <code>string place_id = 5;</code>
   *
   * @return The bytes for placeId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlaceIdBytes() {
    java.lang.Object ref = placeId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      placeId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getGeocoderStatus());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(2, intermediateWaypointRequestIndex_);
    }
    for (int i = 0; i < type_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_.getRaw(i));
    }
    if (partialMatch_ != false) {
      output.writeBool(4, partialMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, placeId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getGeocoderStatus());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              2, intermediateWaypointRequestIndex_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < type_.size(); i++) {
        dataSize += computeStringSizeNoTag(type_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTypeList().size();
    }
    if (partialMatch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, partialMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(placeId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, placeId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.GeocodedWaypoint)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.GeocodedWaypoint other =
        (com.google.maps.routing.v2.GeocodedWaypoint) obj;

    if (hasGeocoderStatus() != other.hasGeocoderStatus()) return false;
    if (hasGeocoderStatus()) {
      if (!getGeocoderStatus().equals(other.getGeocoderStatus())) return false;
    }
    if (hasIntermediateWaypointRequestIndex() != other.hasIntermediateWaypointRequestIndex())
      return false;
    if (hasIntermediateWaypointRequestIndex()) {
      if (getIntermediateWaypointRequestIndex() != other.getIntermediateWaypointRequestIndex())
        return false;
    }
    if (!getTypeList().equals(other.getTypeList())) return false;
    if (getPartialMatch() != other.getPartialMatch()) return false;
    if (!getPlaceId().equals(other.getPlaceId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGeocoderStatus()) {
      hash = (37 * hash) + GEOCODER_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getGeocoderStatus().hashCode();
    }
    if (hasIntermediateWaypointRequestIndex()) {
      hash = (37 * hash) + INTERMEDIATE_WAYPOINT_REQUEST_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIntermediateWaypointRequestIndex();
    }
    if (getTypeCount() > 0) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getTypeList().hashCode();
    }
    hash = (37 * hash) + PARTIAL_MATCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPartialMatch());
    hash = (37 * hash) + PLACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPlaceId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.GeocodedWaypoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Details about the locations used as waypoints. Only populated for address
   * waypoints. Includes details about the geocoding results for the purposes of
   * determining what the address was geocoded to.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.GeocodedWaypoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.GeocodedWaypoint)
      com.google.maps.routing.v2.GeocodedWaypointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.GeocodingResultsProto
          .internal_static_google_maps_routing_v2_GeocodedWaypoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.GeocodingResultsProto
          .internal_static_google_maps_routing_v2_GeocodedWaypoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.GeocodedWaypoint.class,
              com.google.maps.routing.v2.GeocodedWaypoint.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.GeocodedWaypoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGeocoderStatusFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      geocoderStatus_ = null;
      if (geocoderStatusBuilder_ != null) {
        geocoderStatusBuilder_.dispose();
        geocoderStatusBuilder_ = null;
      }
      intermediateWaypointRequestIndex_ = 0;
      type_ = com.google.protobuf.LazyStringArrayList.emptyList();
      partialMatch_ = false;
      placeId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.GeocodingResultsProto
          .internal_static_google_maps_routing_v2_GeocodedWaypoint_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.GeocodedWaypoint getDefaultInstanceForType() {
      return com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.GeocodedWaypoint build() {
      com.google.maps.routing.v2.GeocodedWaypoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.GeocodedWaypoint buildPartial() {
      com.google.maps.routing.v2.GeocodedWaypoint result =
          new com.google.maps.routing.v2.GeocodedWaypoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.routing.v2.GeocodedWaypoint result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.geocoderStatus_ =
            geocoderStatusBuilder_ == null ? geocoderStatus_ : geocoderStatusBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.intermediateWaypointRequestIndex_ = intermediateWaypointRequestIndex_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        type_.makeImmutable();
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.partialMatch_ = partialMatch_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.placeId_ = placeId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.GeocodedWaypoint) {
        return mergeFrom((com.google.maps.routing.v2.GeocodedWaypoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.GeocodedWaypoint other) {
      if (other == com.google.maps.routing.v2.GeocodedWaypoint.getDefaultInstance()) return this;
      if (other.hasGeocoderStatus()) {
        mergeGeocoderStatus(other.getGeocoderStatus());
      }
      if (other.hasIntermediateWaypointRequestIndex()) {
        setIntermediateWaypointRequestIndex(other.getIntermediateWaypointRequestIndex());
      }
      if (!other.type_.isEmpty()) {
        if (type_.isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000004;
        } else {
          ensureTypeIsMutable();
          type_.addAll(other.type_);
        }
        onChanged();
      }
      if (other.getPartialMatch() != false) {
        setPartialMatch(other.getPartialMatch());
      }
      if (!other.getPlaceId().isEmpty()) {
        placeId_ = other.placeId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGeocoderStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                intermediateWaypointRequestIndex_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTypeIsMutable();
                type_.add(s);
                break;
              } // case 26
            case 32:
              {
                partialMatch_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                placeId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.rpc.Status geocoderStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        geocoderStatusBuilder_;

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     *
     * @return Whether the geocoderStatus field is set.
     */
    public boolean hasGeocoderStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     *
     * @return The geocoderStatus.
     */
    public com.google.rpc.Status getGeocoderStatus() {
      if (geocoderStatusBuilder_ == null) {
        return geocoderStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : geocoderStatus_;
      } else {
        return geocoderStatusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    public Builder setGeocoderStatus(com.google.rpc.Status value) {
      if (geocoderStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geocoderStatus_ = value;
      } else {
        geocoderStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    public Builder setGeocoderStatus(com.google.rpc.Status.Builder builderForValue) {
      if (geocoderStatusBuilder_ == null) {
        geocoderStatus_ = builderForValue.build();
      } else {
        geocoderStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    public Builder mergeGeocoderStatus(com.google.rpc.Status value) {
      if (geocoderStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && geocoderStatus_ != null
            && geocoderStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getGeocoderStatusBuilder().mergeFrom(value);
        } else {
          geocoderStatus_ = value;
        }
      } else {
        geocoderStatusBuilder_.mergeFrom(value);
      }
      if (geocoderStatus_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    public Builder clearGeocoderStatus() {
      bitField0_ = (bitField0_ & ~0x00000001);
      geocoderStatus_ = null;
      if (geocoderStatusBuilder_ != null) {
        geocoderStatusBuilder_.dispose();
        geocoderStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    public com.google.rpc.Status.Builder getGeocoderStatusBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getGeocoderStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    public com.google.rpc.StatusOrBuilder getGeocoderStatusOrBuilder() {
      if (geocoderStatusBuilder_ != null) {
        return geocoderStatusBuilder_.getMessageOrBuilder();
      } else {
        return geocoderStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : geocoderStatus_;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the status code resulting from the geocoding operation.
     * </pre>
     *
     * <code>.google.rpc.Status geocoder_status = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getGeocoderStatusFieldBuilder() {
      if (geocoderStatusBuilder_ == null) {
        geocoderStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getGeocoderStatus(), getParentForChildren(), isClean());
        geocoderStatus_ = null;
      }
      return geocoderStatusBuilder_;
    }

    private int intermediateWaypointRequestIndex_;

    /**
     *
     *
     * <pre>
     * The index of the corresponding intermediate waypoint in the request.
     * Only populated if the corresponding waypoint is an intermediate
     * waypoint.
     * </pre>
     *
     * <code>optional int32 intermediate_waypoint_request_index = 2;</code>
     *
     * @return Whether the intermediateWaypointRequestIndex field is set.
     */
    @java.lang.Override
    public boolean hasIntermediateWaypointRequestIndex() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The index of the corresponding intermediate waypoint in the request.
     * Only populated if the corresponding waypoint is an intermediate
     * waypoint.
     * </pre>
     *
     * <code>optional int32 intermediate_waypoint_request_index = 2;</code>
     *
     * @return The intermediateWaypointRequestIndex.
     */
    @java.lang.Override
    public int getIntermediateWaypointRequestIndex() {
      return intermediateWaypointRequestIndex_;
    }

    /**
     *
     *
     * <pre>
     * The index of the corresponding intermediate waypoint in the request.
     * Only populated if the corresponding waypoint is an intermediate
     * waypoint.
     * </pre>
     *
     * <code>optional int32 intermediate_waypoint_request_index = 2;</code>
     *
     * @param value The intermediateWaypointRequestIndex to set.
     * @return This builder for chaining.
     */
    public Builder setIntermediateWaypointRequestIndex(int value) {

      intermediateWaypointRequestIndex_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The index of the corresponding intermediate waypoint in the request.
     * Only populated if the corresponding waypoint is an intermediate
     * waypoint.
     * </pre>
     *
     * <code>optional int32 intermediate_waypoint_request_index = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntermediateWaypointRequestIndex() {
      bitField0_ = (bitField0_ & ~0x00000002);
      intermediateWaypointRequestIndex_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList type_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTypeIsMutable() {
      if (!type_.isModifiable()) {
        type_ = new com.google.protobuf.LazyStringArrayList(type_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @return A list containing the type.
     */
    public com.google.protobuf.ProtocolStringList getTypeList() {
      type_.makeImmutable();
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @return The count of type.
     */
    public int getTypeCount() {
      return type_.size();
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The type at the given index.
     */
    public java.lang.String getType(int index) {
      return type_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the type at the given index.
     */
    public com.google.protobuf.ByteString getTypeBytes(int index) {
      return type_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypeIsMutable();
      type_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @param value The type to add.
     * @return This builder for chaining.
     */
    public Builder addType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypeIsMutable();
      type_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @param values The type to add.
     * @return This builder for chaining.
     */
    public Builder addAllType(java.lang.Iterable<java.lang.String> values) {
      ensureTypeIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, type_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type(s) of the result, in the form of zero or more type tags.
     * Supported types: [Address types and address component
     * types](https://developers.google.com/maps/documentation/geocoding/requests-geocoding#Types).
     * </pre>
     *
     * <code>repeated string type = 3;</code>
     *
     * @param value The bytes of the type to add.
     * @return This builder for chaining.
     */
    public Builder addTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTypeIsMutable();
      type_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean partialMatch_;

    /**
     *
     *
     * <pre>
     * Indicates that the geocoder did not return an exact match for the original
     * request, though it was able to match part of the requested address. You may
     * wish to examine the original request for misspellings and/or an incomplete
     * address.
     * </pre>
     *
     * <code>bool partial_match = 4;</code>
     *
     * @return The partialMatch.
     */
    @java.lang.Override
    public boolean getPartialMatch() {
      return partialMatch_;
    }

    /**
     *
     *
     * <pre>
     * Indicates that the geocoder did not return an exact match for the original
     * request, though it was able to match part of the requested address. You may
     * wish to examine the original request for misspellings and/or an incomplete
     * address.
     * </pre>
     *
     * <code>bool partial_match = 4;</code>
     *
     * @param value The partialMatch to set.
     * @return This builder for chaining.
     */
    public Builder setPartialMatch(boolean value) {

      partialMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Indicates that the geocoder did not return an exact match for the original
     * request, though it was able to match part of the requested address. You may
     * wish to examine the original request for misspellings and/or an incomplete
     * address.
     * </pre>
     *
     * <code>bool partial_match = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartialMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      partialMatch_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object placeId_ = "";

    /**
     *
     *
     * <pre>
     * The place ID for this result.
     * </pre>
     *
     * <code>string place_id = 5;</code>
     *
     * @return The placeId.
     */
    public java.lang.String getPlaceId() {
      java.lang.Object ref = placeId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        placeId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The place ID for this result.
     * </pre>
     *
     * <code>string place_id = 5;</code>
     *
     * @return The bytes for placeId.
     */
    public com.google.protobuf.ByteString getPlaceIdBytes() {
      java.lang.Object ref = placeId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        placeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The place ID for this result.
     * </pre>
     *
     * <code>string place_id = 5;</code>
     *
     * @param value The placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      placeId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The place ID for this result.
     * </pre>
     *
     * <code>string place_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlaceId() {
      placeId_ = getDefaultInstance().getPlaceId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The place ID for this result.
     * </pre>
     *
     * <code>string place_id = 5;</code>
     *
     * @param value The bytes for placeId to set.
     * @return This builder for chaining.
     */
    public Builder setPlaceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      placeId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.GeocodedWaypoint)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.GeocodedWaypoint)
  private static final com.google.maps.routing.v2.GeocodedWaypoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.GeocodedWaypoint();
  }

  public static com.google.maps.routing.v2.GeocodedWaypoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GeocodedWaypoint> PARSER =
      new com.google.protobuf.AbstractParser<GeocodedWaypoint>() {
        @java.lang.Override
        public GeocodedWaypoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GeocodedWaypoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GeocodedWaypoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.GeocodedWaypoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
