/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/route.proto

// Protobuf Java Version: 3.25.8
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Contains the additional information that the user should be informed
 * about on a leg step, such as possible traffic zone restrictions.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.RouteLegTravelAdvisory}
 */
public final class RouteLegTravelAdvisory extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.RouteLegTravelAdvisory)
    RouteLegTravelAdvisoryOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RouteLegTravelAdvisory.newBuilder() to construct.
  private RouteLegTravelAdvisory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RouteLegTravelAdvisory() {
    speedReadingIntervals_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RouteLegTravelAdvisory();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_RouteLegTravelAdvisory_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RouteProto
        .internal_static_google_maps_routing_v2_RouteLegTravelAdvisory_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.RouteLegTravelAdvisory.class,
            com.google.maps.routing.v2.RouteLegTravelAdvisory.Builder.class);
  }

  private int bitField0_;
  public static final int TOLL_INFO_FIELD_NUMBER = 1;
  private com.google.maps.routing.v2.TollInfo tollInfo_;

  /**
   *
   *
   * <pre>
   * Contains information about tolls on the specific `RouteLeg`.
   * This field is only populated if we expect there are tolls on the
   * `RouteLeg`. If this field is set but the estimated_price subfield is not
   * populated, we expect that road contains tolls but we do not know an
   * estimated price. If this field does not exist, then there is no toll on the
   * `RouteLeg`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
   *
   * @return Whether the tollInfo field is set.
   */
  @java.lang.Override
  public boolean hasTollInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Contains information about tolls on the specific `RouteLeg`.
   * This field is only populated if we expect there are tolls on the
   * `RouteLeg`. If this field is set but the estimated_price subfield is not
   * populated, we expect that road contains tolls but we do not know an
   * estimated price. If this field does not exist, then there is no toll on the
   * `RouteLeg`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
   *
   * @return The tollInfo.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TollInfo getTollInfo() {
    return tollInfo_ == null ? com.google.maps.routing.v2.TollInfo.getDefaultInstance() : tollInfo_;
  }

  /**
   *
   *
   * <pre>
   * Contains information about tolls on the specific `RouteLeg`.
   * This field is only populated if we expect there are tolls on the
   * `RouteLeg`. If this field is set but the estimated_price subfield is not
   * populated, we expect that road contains tolls but we do not know an
   * estimated price. If this field does not exist, then there is no toll on the
   * `RouteLeg`.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TollInfoOrBuilder getTollInfoOrBuilder() {
    return tollInfo_ == null ? com.google.maps.routing.v2.TollInfo.getDefaultInstance() : tollInfo_;
  }

  public static final int SPEED_READING_INTERVALS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.SpeedReadingInterval> speedReadingIntervals_;

  /**
   *
   *
   * <pre>
   * Speed reading intervals detailing traffic density. Applicable in case of
   * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
   * The intervals cover the entire polyline of the `RouteLeg` without overlap.
   * The start point of a specified interval is the same as the end point of the
   * preceding interval.
   *
   * Example:
   *
   *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
   *     speed_reading_intervals: [A,C), [C,D), [D,G).
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.SpeedReadingInterval>
      getSpeedReadingIntervalsList() {
    return speedReadingIntervals_;
  }

  /**
   *
   *
   * <pre>
   * Speed reading intervals detailing traffic density. Applicable in case of
   * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
   * The intervals cover the entire polyline of the `RouteLeg` without overlap.
   * The start point of a specified interval is the same as the end point of the
   * preceding interval.
   *
   * Example:
   *
   *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
   *     speed_reading_intervals: [A,C), [C,D), [D,G).
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder>
      getSpeedReadingIntervalsOrBuilderList() {
    return speedReadingIntervals_;
  }

  /**
   *
   *
   * <pre>
   * Speed reading intervals detailing traffic density. Applicable in case of
   * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
   * The intervals cover the entire polyline of the `RouteLeg` without overlap.
   * The start point of a specified interval is the same as the end point of the
   * preceding interval.
   *
   * Example:
   *
   *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
   *     speed_reading_intervals: [A,C), [C,D), [D,G).
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;</code>
   */
  @java.lang.Override
  public int getSpeedReadingIntervalsCount() {
    return speedReadingIntervals_.size();
  }

  /**
   *
   *
   * <pre>
   * Speed reading intervals detailing traffic density. Applicable in case of
   * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
   * The intervals cover the entire polyline of the `RouteLeg` without overlap.
   * The start point of a specified interval is the same as the end point of the
   * preceding interval.
   *
   * Example:
   *
   *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
   *     speed_reading_intervals: [A,C), [C,D), [D,G).
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.SpeedReadingInterval getSpeedReadingIntervals(int index) {
    return speedReadingIntervals_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Speed reading intervals detailing traffic density. Applicable in case of
   * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
   * The intervals cover the entire polyline of the `RouteLeg` without overlap.
   * The start point of a specified interval is the same as the end point of the
   * preceding interval.
   *
   * Example:
   *
   *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
   *     speed_reading_intervals: [A,C), [C,D), [D,G).
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder getSpeedReadingIntervalsOrBuilder(
      int index) {
    return speedReadingIntervals_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getTollInfo());
    }
    for (int i = 0; i < speedReadingIntervals_.size(); i++) {
      output.writeMessage(2, speedReadingIntervals_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTollInfo());
    }
    for (int i = 0; i < speedReadingIntervals_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, speedReadingIntervals_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.RouteLegTravelAdvisory)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.RouteLegTravelAdvisory other =
        (com.google.maps.routing.v2.RouteLegTravelAdvisory) obj;

    if (hasTollInfo() != other.hasTollInfo()) return false;
    if (hasTollInfo()) {
      if (!getTollInfo().equals(other.getTollInfo())) return false;
    }
    if (!getSpeedReadingIntervalsList().equals(other.getSpeedReadingIntervalsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTollInfo()) {
      hash = (37 * hash) + TOLL_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTollInfo().hashCode();
    }
    if (getSpeedReadingIntervalsCount() > 0) {
      hash = (37 * hash) + SPEED_READING_INTERVALS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeedReadingIntervalsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.RouteLegTravelAdvisory prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Contains the additional information that the user should be informed
   * about on a leg step, such as possible traffic zone restrictions.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.RouteLegTravelAdvisory}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.RouteLegTravelAdvisory)
      com.google.maps.routing.v2.RouteLegTravelAdvisoryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegTravelAdvisory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegTravelAdvisory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.RouteLegTravelAdvisory.class,
              com.google.maps.routing.v2.RouteLegTravelAdvisory.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.RouteLegTravelAdvisory.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTollInfoFieldBuilder();
        getSpeedReadingIntervalsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tollInfo_ = null;
      if (tollInfoBuilder_ != null) {
        tollInfoBuilder_.dispose();
        tollInfoBuilder_ = null;
      }
      if (speedReadingIntervalsBuilder_ == null) {
        speedReadingIntervals_ = java.util.Collections.emptyList();
      } else {
        speedReadingIntervals_ = null;
        speedReadingIntervalsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RouteProto
          .internal_static_google_maps_routing_v2_RouteLegTravelAdvisory_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegTravelAdvisory getDefaultInstanceForType() {
      return com.google.maps.routing.v2.RouteLegTravelAdvisory.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegTravelAdvisory build() {
      com.google.maps.routing.v2.RouteLegTravelAdvisory result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.RouteLegTravelAdvisory buildPartial() {
      com.google.maps.routing.v2.RouteLegTravelAdvisory result =
          new com.google.maps.routing.v2.RouteLegTravelAdvisory(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.maps.routing.v2.RouteLegTravelAdvisory result) {
      if (speedReadingIntervalsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          speedReadingIntervals_ = java.util.Collections.unmodifiableList(speedReadingIntervals_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.speedReadingIntervals_ = speedReadingIntervals_;
      } else {
        result.speedReadingIntervals_ = speedReadingIntervalsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.routing.v2.RouteLegTravelAdvisory result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tollInfo_ = tollInfoBuilder_ == null ? tollInfo_ : tollInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.RouteLegTravelAdvisory) {
        return mergeFrom((com.google.maps.routing.v2.RouteLegTravelAdvisory) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.RouteLegTravelAdvisory other) {
      if (other == com.google.maps.routing.v2.RouteLegTravelAdvisory.getDefaultInstance())
        return this;
      if (other.hasTollInfo()) {
        mergeTollInfo(other.getTollInfo());
      }
      if (speedReadingIntervalsBuilder_ == null) {
        if (!other.speedReadingIntervals_.isEmpty()) {
          if (speedReadingIntervals_.isEmpty()) {
            speedReadingIntervals_ = other.speedReadingIntervals_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSpeedReadingIntervalsIsMutable();
            speedReadingIntervals_.addAll(other.speedReadingIntervals_);
          }
          onChanged();
        }
      } else {
        if (!other.speedReadingIntervals_.isEmpty()) {
          if (speedReadingIntervalsBuilder_.isEmpty()) {
            speedReadingIntervalsBuilder_.dispose();
            speedReadingIntervalsBuilder_ = null;
            speedReadingIntervals_ = other.speedReadingIntervals_;
            bitField0_ = (bitField0_ & ~0x00000002);
            speedReadingIntervalsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeedReadingIntervalsFieldBuilder()
                    : null;
          } else {
            speedReadingIntervalsBuilder_.addAllMessages(other.speedReadingIntervals_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getTollInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.maps.routing.v2.SpeedReadingInterval m =
                    input.readMessage(
                        com.google.maps.routing.v2.SpeedReadingInterval.parser(),
                        extensionRegistry);
                if (speedReadingIntervalsBuilder_ == null) {
                  ensureSpeedReadingIntervalsIsMutable();
                  speedReadingIntervals_.add(m);
                } else {
                  speedReadingIntervalsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.maps.routing.v2.TollInfo tollInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TollInfo,
            com.google.maps.routing.v2.TollInfo.Builder,
            com.google.maps.routing.v2.TollInfoOrBuilder>
        tollInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     *
     * @return Whether the tollInfo field is set.
     */
    public boolean hasTollInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     *
     * @return The tollInfo.
     */
    public com.google.maps.routing.v2.TollInfo getTollInfo() {
      if (tollInfoBuilder_ == null) {
        return tollInfo_ == null
            ? com.google.maps.routing.v2.TollInfo.getDefaultInstance()
            : tollInfo_;
      } else {
        return tollInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    public Builder setTollInfo(com.google.maps.routing.v2.TollInfo value) {
      if (tollInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tollInfo_ = value;
      } else {
        tollInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    public Builder setTollInfo(com.google.maps.routing.v2.TollInfo.Builder builderForValue) {
      if (tollInfoBuilder_ == null) {
        tollInfo_ = builderForValue.build();
      } else {
        tollInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    public Builder mergeTollInfo(com.google.maps.routing.v2.TollInfo value) {
      if (tollInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && tollInfo_ != null
            && tollInfo_ != com.google.maps.routing.v2.TollInfo.getDefaultInstance()) {
          getTollInfoBuilder().mergeFrom(value);
        } else {
          tollInfo_ = value;
        }
      } else {
        tollInfoBuilder_.mergeFrom(value);
      }
      if (tollInfo_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    public Builder clearTollInfo() {
      bitField0_ = (bitField0_ & ~0x00000001);
      tollInfo_ = null;
      if (tollInfoBuilder_ != null) {
        tollInfoBuilder_.dispose();
        tollInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    public com.google.maps.routing.v2.TollInfo.Builder getTollInfoBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getTollInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    public com.google.maps.routing.v2.TollInfoOrBuilder getTollInfoOrBuilder() {
      if (tollInfoBuilder_ != null) {
        return tollInfoBuilder_.getMessageOrBuilder();
      } else {
        return tollInfo_ == null
            ? com.google.maps.routing.v2.TollInfo.getDefaultInstance()
            : tollInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Contains information about tolls on the specific `RouteLeg`.
     * This field is only populated if we expect there are tolls on the
     * `RouteLeg`. If this field is set but the estimated_price subfield is not
     * populated, we expect that road contains tolls but we do not know an
     * estimated price. If this field does not exist, then there is no toll on the
     * `RouteLeg`.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TollInfo toll_info = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.TollInfo,
            com.google.maps.routing.v2.TollInfo.Builder,
            com.google.maps.routing.v2.TollInfoOrBuilder>
        getTollInfoFieldBuilder() {
      if (tollInfoBuilder_ == null) {
        tollInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.TollInfo,
                com.google.maps.routing.v2.TollInfo.Builder,
                com.google.maps.routing.v2.TollInfoOrBuilder>(
                getTollInfo(), getParentForChildren(), isClean());
        tollInfo_ = null;
      }
      return tollInfoBuilder_;
    }

    private java.util.List<com.google.maps.routing.v2.SpeedReadingInterval> speedReadingIntervals_ =
        java.util.Collections.emptyList();

    private void ensureSpeedReadingIntervalsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        speedReadingIntervals_ =
            new java.util.ArrayList<com.google.maps.routing.v2.SpeedReadingInterval>(
                speedReadingIntervals_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.SpeedReadingInterval,
            com.google.maps.routing.v2.SpeedReadingInterval.Builder,
            com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder>
        speedReadingIntervalsBuilder_;

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.SpeedReadingInterval>
        getSpeedReadingIntervalsList() {
      if (speedReadingIntervalsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speedReadingIntervals_);
      } else {
        return speedReadingIntervalsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public int getSpeedReadingIntervalsCount() {
      if (speedReadingIntervalsBuilder_ == null) {
        return speedReadingIntervals_.size();
      } else {
        return speedReadingIntervalsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public com.google.maps.routing.v2.SpeedReadingInterval getSpeedReadingIntervals(int index) {
      if (speedReadingIntervalsBuilder_ == null) {
        return speedReadingIntervals_.get(index);
      } else {
        return speedReadingIntervalsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder setSpeedReadingIntervals(
        int index, com.google.maps.routing.v2.SpeedReadingInterval value) {
      if (speedReadingIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.set(index, value);
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder setSpeedReadingIntervals(
        int index, com.google.maps.routing.v2.SpeedReadingInterval.Builder builderForValue) {
      if (speedReadingIntervalsBuilder_ == null) {
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.set(index, builderForValue.build());
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder addSpeedReadingIntervals(com.google.maps.routing.v2.SpeedReadingInterval value) {
      if (speedReadingIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.add(value);
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder addSpeedReadingIntervals(
        int index, com.google.maps.routing.v2.SpeedReadingInterval value) {
      if (speedReadingIntervalsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.add(index, value);
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder addSpeedReadingIntervals(
        com.google.maps.routing.v2.SpeedReadingInterval.Builder builderForValue) {
      if (speedReadingIntervalsBuilder_ == null) {
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.add(builderForValue.build());
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder addSpeedReadingIntervals(
        int index, com.google.maps.routing.v2.SpeedReadingInterval.Builder builderForValue) {
      if (speedReadingIntervalsBuilder_ == null) {
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.add(index, builderForValue.build());
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder addAllSpeedReadingIntervals(
        java.lang.Iterable<? extends com.google.maps.routing.v2.SpeedReadingInterval> values) {
      if (speedReadingIntervalsBuilder_ == null) {
        ensureSpeedReadingIntervalsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, speedReadingIntervals_);
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder clearSpeedReadingIntervals() {
      if (speedReadingIntervalsBuilder_ == null) {
        speedReadingIntervals_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public Builder removeSpeedReadingIntervals(int index) {
      if (speedReadingIntervalsBuilder_ == null) {
        ensureSpeedReadingIntervalsIsMutable();
        speedReadingIntervals_.remove(index);
        onChanged();
      } else {
        speedReadingIntervalsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public com.google.maps.routing.v2.SpeedReadingInterval.Builder getSpeedReadingIntervalsBuilder(
        int index) {
      return getSpeedReadingIntervalsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder
        getSpeedReadingIntervalsOrBuilder(int index) {
      if (speedReadingIntervalsBuilder_ == null) {
        return speedReadingIntervals_.get(index);
      } else {
        return speedReadingIntervalsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder>
        getSpeedReadingIntervalsOrBuilderList() {
      if (speedReadingIntervalsBuilder_ != null) {
        return speedReadingIntervalsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speedReadingIntervals_);
      }
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public com.google.maps.routing.v2.SpeedReadingInterval.Builder
        addSpeedReadingIntervalsBuilder() {
      return getSpeedReadingIntervalsFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.SpeedReadingInterval.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public com.google.maps.routing.v2.SpeedReadingInterval.Builder addSpeedReadingIntervalsBuilder(
        int index) {
      return getSpeedReadingIntervalsFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.SpeedReadingInterval.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Speed reading intervals detailing traffic density. Applicable in case of
     * `TRAFFIC_AWARE` and `TRAFFIC_AWARE_OPTIMAL` routing preferences.
     * The intervals cover the entire polyline of the `RouteLeg` without overlap.
     * The start point of a specified interval is the same as the end point of the
     * preceding interval.
     *
     * Example:
     *
     *     polyline: A ---- B ---- C ---- D ---- E ---- F ---- G
     *     speed_reading_intervals: [A,C), [C,D), [D,G).
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.SpeedReadingInterval speed_reading_intervals = 2;
     * </code>
     */
    public java.util.List<com.google.maps.routing.v2.SpeedReadingInterval.Builder>
        getSpeedReadingIntervalsBuilderList() {
      return getSpeedReadingIntervalsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.SpeedReadingInterval,
            com.google.maps.routing.v2.SpeedReadingInterval.Builder,
            com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder>
        getSpeedReadingIntervalsFieldBuilder() {
      if (speedReadingIntervalsBuilder_ == null) {
        speedReadingIntervalsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.SpeedReadingInterval,
                com.google.maps.routing.v2.SpeedReadingInterval.Builder,
                com.google.maps.routing.v2.SpeedReadingIntervalOrBuilder>(
                speedReadingIntervals_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        speedReadingIntervals_ = null;
      }
      return speedReadingIntervalsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.RouteLegTravelAdvisory)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.RouteLegTravelAdvisory)
  private static final com.google.maps.routing.v2.RouteLegTravelAdvisory DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.RouteLegTravelAdvisory();
  }

  public static com.google.maps.routing.v2.RouteLegTravelAdvisory getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RouteLegTravelAdvisory> PARSER =
      new com.google.protobuf.AbstractParser<RouteLegTravelAdvisory>() {
        @java.lang.Override
        public RouteLegTravelAdvisory parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RouteLegTravelAdvisory> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RouteLegTravelAdvisory> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.RouteLegTravelAdvisory getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
