/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/routes_service.proto

// Protobuf Java Version: 3.25.8
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * ComputeRoutes the response message.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.ComputeRoutesResponse}
 */
public final class ComputeRoutesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.ComputeRoutesResponse)
    ComputeRoutesResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ComputeRoutesResponse.newBuilder() to construct.
  private ComputeRoutesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeRoutesResponse() {
    routes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeRoutesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.RoutesServiceProto
        .internal_static_google_maps_routing_v2_ComputeRoutesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.RoutesServiceProto
        .internal_static_google_maps_routing_v2_ComputeRoutesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.ComputeRoutesResponse.class,
            com.google.maps.routing.v2.ComputeRoutesResponse.Builder.class);
  }

  private int bitField0_;
  public static final int ROUTES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.maps.routing.v2.Route> routes_;

  /**
   *
   *
   * <pre>
   * Contains an array of computed routes (up to three) when you specify
   * `compute_alternatives_routes`, and contains just one route when you don't.
   * When this array contains multiple entries, the first one is the most
   * recommended route. If the array is empty, then it means no route could be
   * found.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.maps.routing.v2.Route> getRoutesList() {
    return routes_;
  }

  /**
   *
   *
   * <pre>
   * Contains an array of computed routes (up to three) when you specify
   * `compute_alternatives_routes`, and contains just one route when you don't.
   * When this array contains multiple entries, the first one is the most
   * recommended route. If the array is empty, then it means no route could be
   * found.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.maps.routing.v2.RouteOrBuilder>
      getRoutesOrBuilderList() {
    return routes_;
  }

  /**
   *
   *
   * <pre>
   * Contains an array of computed routes (up to three) when you specify
   * `compute_alternatives_routes`, and contains just one route when you don't.
   * When this array contains multiple entries, the first one is the most
   * recommended route. If the array is empty, then it means no route could be
   * found.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
   */
  @java.lang.Override
  public int getRoutesCount() {
    return routes_.size();
  }

  /**
   *
   *
   * <pre>
   * Contains an array of computed routes (up to three) when you specify
   * `compute_alternatives_routes`, and contains just one route when you don't.
   * When this array contains multiple entries, the first one is the most
   * recommended route. If the array is empty, then it means no route could be
   * found.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.Route getRoutes(int index) {
    return routes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Contains an array of computed routes (up to three) when you specify
   * `compute_alternatives_routes`, and contains just one route when you don't.
   * When this array contains multiple entries, the first one is the most
   * recommended route. If the array is empty, then it means no route could be
   * found.
   * </pre>
   *
   * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.RouteOrBuilder getRoutesOrBuilder(int index) {
    return routes_.get(index);
  }

  public static final int FALLBACK_INFO_FIELD_NUMBER = 2;
  private com.google.maps.routing.v2.FallbackInfo fallbackInfo_;

  /**
   *
   *
   * <pre>
   * In some cases when the server is not able to compute the route results with
   * all of the input preferences, it may fallback to using a different way of
   * computation. When fallback mode is used, this field contains detailed info
   * about the fallback response. Otherwise this field is unset.
   * </pre>
   *
   * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
   *
   * @return Whether the fallbackInfo field is set.
   */
  @java.lang.Override
  public boolean hasFallbackInfo() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * In some cases when the server is not able to compute the route results with
   * all of the input preferences, it may fallback to using a different way of
   * computation. When fallback mode is used, this field contains detailed info
   * about the fallback response. Otherwise this field is unset.
   * </pre>
   *
   * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
   *
   * @return The fallbackInfo.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.FallbackInfo getFallbackInfo() {
    return fallbackInfo_ == null
        ? com.google.maps.routing.v2.FallbackInfo.getDefaultInstance()
        : fallbackInfo_;
  }

  /**
   *
   *
   * <pre>
   * In some cases when the server is not able to compute the route results with
   * all of the input preferences, it may fallback to using a different way of
   * computation. When fallback mode is used, this field contains detailed info
   * about the fallback response. Otherwise this field is unset.
   * </pre>
   *
   * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.FallbackInfoOrBuilder getFallbackInfoOrBuilder() {
    return fallbackInfo_ == null
        ? com.google.maps.routing.v2.FallbackInfo.getDefaultInstance()
        : fallbackInfo_;
  }

  public static final int GEOCODING_RESULTS_FIELD_NUMBER = 3;
  private com.google.maps.routing.v2.GeocodingResults geocodingResults_;

  /**
   *
   *
   * <pre>
   * Contains geocoding response info for waypoints specified as addresses.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
   *
   * @return Whether the geocodingResults field is set.
   */
  @java.lang.Override
  public boolean hasGeocodingResults() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Contains geocoding response info for waypoints specified as addresses.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
   *
   * @return The geocodingResults.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodingResults getGeocodingResults() {
    return geocodingResults_ == null
        ? com.google.maps.routing.v2.GeocodingResults.getDefaultInstance()
        : geocodingResults_;
  }

  /**
   *
   *
   * <pre>
   * Contains geocoding response info for waypoints specified as addresses.
   * </pre>
   *
   * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
   */
  @java.lang.Override
  public com.google.maps.routing.v2.GeocodingResultsOrBuilder getGeocodingResultsOrBuilder() {
    return geocodingResults_ == null
        ? com.google.maps.routing.v2.GeocodingResults.getDefaultInstance()
        : geocodingResults_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < routes_.size(); i++) {
      output.writeMessage(1, routes_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getFallbackInfo());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getGeocodingResults());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < routes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, routes_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFallbackInfo());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getGeocodingResults());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.ComputeRoutesResponse)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.ComputeRoutesResponse other =
        (com.google.maps.routing.v2.ComputeRoutesResponse) obj;

    if (!getRoutesList().equals(other.getRoutesList())) return false;
    if (hasFallbackInfo() != other.hasFallbackInfo()) return false;
    if (hasFallbackInfo()) {
      if (!getFallbackInfo().equals(other.getFallbackInfo())) return false;
    }
    if (hasGeocodingResults() != other.hasGeocodingResults()) return false;
    if (hasGeocodingResults()) {
      if (!getGeocodingResults().equals(other.getGeocodingResults())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRoutesCount() > 0) {
      hash = (37 * hash) + ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getRoutesList().hashCode();
    }
    if (hasFallbackInfo()) {
      hash = (37 * hash) + FALLBACK_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getFallbackInfo().hashCode();
    }
    if (hasGeocodingResults()) {
      hash = (37 * hash) + GEOCODING_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getGeocodingResults().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.ComputeRoutesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * ComputeRoutes the response message.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.ComputeRoutesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.ComputeRoutesResponse)
      com.google.maps.routing.v2.ComputeRoutesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRoutesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRoutesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.ComputeRoutesResponse.class,
              com.google.maps.routing.v2.ComputeRoutesResponse.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.ComputeRoutesResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRoutesFieldBuilder();
        getFallbackInfoFieldBuilder();
        getGeocodingResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
      } else {
        routes_ = null;
        routesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      fallbackInfo_ = null;
      if (fallbackInfoBuilder_ != null) {
        fallbackInfoBuilder_.dispose();
        fallbackInfoBuilder_ = null;
      }
      geocodingResults_ = null;
      if (geocodingResultsBuilder_ != null) {
        geocodingResultsBuilder_.dispose();
        geocodingResultsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.RoutesServiceProto
          .internal_static_google_maps_routing_v2_ComputeRoutesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRoutesResponse getDefaultInstanceForType() {
      return com.google.maps.routing.v2.ComputeRoutesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRoutesResponse build() {
      com.google.maps.routing.v2.ComputeRoutesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.ComputeRoutesResponse buildPartial() {
      com.google.maps.routing.v2.ComputeRoutesResponse result =
          new com.google.maps.routing.v2.ComputeRoutesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.maps.routing.v2.ComputeRoutesResponse result) {
      if (routesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          routes_ = java.util.Collections.unmodifiableList(routes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.routes_ = routes_;
      } else {
        result.routes_ = routesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.maps.routing.v2.ComputeRoutesResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fallbackInfo_ =
            fallbackInfoBuilder_ == null ? fallbackInfo_ : fallbackInfoBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.geocodingResults_ =
            geocodingResultsBuilder_ == null ? geocodingResults_ : geocodingResultsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.ComputeRoutesResponse) {
        return mergeFrom((com.google.maps.routing.v2.ComputeRoutesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.ComputeRoutesResponse other) {
      if (other == com.google.maps.routing.v2.ComputeRoutesResponse.getDefaultInstance())
        return this;
      if (routesBuilder_ == null) {
        if (!other.routes_.isEmpty()) {
          if (routes_.isEmpty()) {
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRoutesIsMutable();
            routes_.addAll(other.routes_);
          }
          onChanged();
        }
      } else {
        if (!other.routes_.isEmpty()) {
          if (routesBuilder_.isEmpty()) {
            routesBuilder_.dispose();
            routesBuilder_ = null;
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            routesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRoutesFieldBuilder()
                    : null;
          } else {
            routesBuilder_.addAllMessages(other.routes_);
          }
        }
      }
      if (other.hasFallbackInfo()) {
        mergeFallbackInfo(other.getFallbackInfo());
      }
      if (other.hasGeocodingResults()) {
        mergeGeocodingResults(other.getGeocodingResults());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.maps.routing.v2.Route m =
                    input.readMessage(com.google.maps.routing.v2.Route.parser(), extensionRegistry);
                if (routesBuilder_ == null) {
                  ensureRoutesIsMutable();
                  routes_.add(m);
                } else {
                  routesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFallbackInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGeocodingResultsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.maps.routing.v2.Route> routes_ =
        java.util.Collections.emptyList();

    private void ensureRoutesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        routes_ = new java.util.ArrayList<com.google.maps.routing.v2.Route>(routes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.Route,
            com.google.maps.routing.v2.Route.Builder,
            com.google.maps.routing.v2.RouteOrBuilder>
        routesBuilder_;

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public java.util.List<com.google.maps.routing.v2.Route> getRoutesList() {
      if (routesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routes_);
      } else {
        return routesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public int getRoutesCount() {
      if (routesBuilder_ == null) {
        return routes_.size();
      } else {
        return routesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public com.google.maps.routing.v2.Route getRoutes(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder setRoutes(int index, com.google.maps.routing.v2.Route value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.set(index, value);
        onChanged();
      } else {
        routesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder setRoutes(int index, com.google.maps.routing.v2.Route.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.set(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder addRoutes(com.google.maps.routing.v2.Route value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(value);
        onChanged();
      } else {
        routesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder addRoutes(int index, com.google.maps.routing.v2.Route value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(index, value);
        onChanged();
      } else {
        routesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder addRoutes(com.google.maps.routing.v2.Route.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder addRoutes(int index, com.google.maps.routing.v2.Route.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder addAllRoutes(
        java.lang.Iterable<? extends com.google.maps.routing.v2.Route> values) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, routes_);
        onChanged();
      } else {
        routesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder clearRoutes() {
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        routesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public Builder removeRoutes(int index) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.remove(index);
        onChanged();
      } else {
        routesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public com.google.maps.routing.v2.Route.Builder getRoutesBuilder(int index) {
      return getRoutesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public com.google.maps.routing.v2.RouteOrBuilder getRoutesOrBuilder(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public java.util.List<? extends com.google.maps.routing.v2.RouteOrBuilder>
        getRoutesOrBuilderList() {
      if (routesBuilder_ != null) {
        return routesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public com.google.maps.routing.v2.Route.Builder addRoutesBuilder() {
      return getRoutesFieldBuilder()
          .addBuilder(com.google.maps.routing.v2.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public com.google.maps.routing.v2.Route.Builder addRoutesBuilder(int index) {
      return getRoutesFieldBuilder()
          .addBuilder(index, com.google.maps.routing.v2.Route.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Contains an array of computed routes (up to three) when you specify
     * `compute_alternatives_routes`, and contains just one route when you don't.
     * When this array contains multiple entries, the first one is the most
     * recommended route. If the array is empty, then it means no route could be
     * found.
     * </pre>
     *
     * <code>repeated .google.maps.routing.v2.Route routes = 1;</code>
     */
    public java.util.List<com.google.maps.routing.v2.Route.Builder> getRoutesBuilderList() {
      return getRoutesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.maps.routing.v2.Route,
            com.google.maps.routing.v2.Route.Builder,
            com.google.maps.routing.v2.RouteOrBuilder>
        getRoutesFieldBuilder() {
      if (routesBuilder_ == null) {
        routesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.maps.routing.v2.Route,
                com.google.maps.routing.v2.Route.Builder,
                com.google.maps.routing.v2.RouteOrBuilder>(
                routes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        routes_ = null;
      }
      return routesBuilder_;
    }

    private com.google.maps.routing.v2.FallbackInfo fallbackInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.FallbackInfo,
            com.google.maps.routing.v2.FallbackInfo.Builder,
            com.google.maps.routing.v2.FallbackInfoOrBuilder>
        fallbackInfoBuilder_;

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     *
     * @return Whether the fallbackInfo field is set.
     */
    public boolean hasFallbackInfo() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     *
     * @return The fallbackInfo.
     */
    public com.google.maps.routing.v2.FallbackInfo getFallbackInfo() {
      if (fallbackInfoBuilder_ == null) {
        return fallbackInfo_ == null
            ? com.google.maps.routing.v2.FallbackInfo.getDefaultInstance()
            : fallbackInfo_;
      } else {
        return fallbackInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    public Builder setFallbackInfo(com.google.maps.routing.v2.FallbackInfo value) {
      if (fallbackInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fallbackInfo_ = value;
      } else {
        fallbackInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    public Builder setFallbackInfo(
        com.google.maps.routing.v2.FallbackInfo.Builder builderForValue) {
      if (fallbackInfoBuilder_ == null) {
        fallbackInfo_ = builderForValue.build();
      } else {
        fallbackInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    public Builder mergeFallbackInfo(com.google.maps.routing.v2.FallbackInfo value) {
      if (fallbackInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && fallbackInfo_ != null
            && fallbackInfo_ != com.google.maps.routing.v2.FallbackInfo.getDefaultInstance()) {
          getFallbackInfoBuilder().mergeFrom(value);
        } else {
          fallbackInfo_ = value;
        }
      } else {
        fallbackInfoBuilder_.mergeFrom(value);
      }
      if (fallbackInfo_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    public Builder clearFallbackInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      fallbackInfo_ = null;
      if (fallbackInfoBuilder_ != null) {
        fallbackInfoBuilder_.dispose();
        fallbackInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    public com.google.maps.routing.v2.FallbackInfo.Builder getFallbackInfoBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFallbackInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    public com.google.maps.routing.v2.FallbackInfoOrBuilder getFallbackInfoOrBuilder() {
      if (fallbackInfoBuilder_ != null) {
        return fallbackInfoBuilder_.getMessageOrBuilder();
      } else {
        return fallbackInfo_ == null
            ? com.google.maps.routing.v2.FallbackInfo.getDefaultInstance()
            : fallbackInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * In some cases when the server is not able to compute the route results with
     * all of the input preferences, it may fallback to using a different way of
     * computation. When fallback mode is used, this field contains detailed info
     * about the fallback response. Otherwise this field is unset.
     * </pre>
     *
     * <code>.google.maps.routing.v2.FallbackInfo fallback_info = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.FallbackInfo,
            com.google.maps.routing.v2.FallbackInfo.Builder,
            com.google.maps.routing.v2.FallbackInfoOrBuilder>
        getFallbackInfoFieldBuilder() {
      if (fallbackInfoBuilder_ == null) {
        fallbackInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.FallbackInfo,
                com.google.maps.routing.v2.FallbackInfo.Builder,
                com.google.maps.routing.v2.FallbackInfoOrBuilder>(
                getFallbackInfo(), getParentForChildren(), isClean());
        fallbackInfo_ = null;
      }
      return fallbackInfoBuilder_;
    }

    private com.google.maps.routing.v2.GeocodingResults geocodingResults_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.GeocodingResults,
            com.google.maps.routing.v2.GeocodingResults.Builder,
            com.google.maps.routing.v2.GeocodingResultsOrBuilder>
        geocodingResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     *
     * @return Whether the geocodingResults field is set.
     */
    public boolean hasGeocodingResults() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     *
     * @return The geocodingResults.
     */
    public com.google.maps.routing.v2.GeocodingResults getGeocodingResults() {
      if (geocodingResultsBuilder_ == null) {
        return geocodingResults_ == null
            ? com.google.maps.routing.v2.GeocodingResults.getDefaultInstance()
            : geocodingResults_;
      } else {
        return geocodingResultsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    public Builder setGeocodingResults(com.google.maps.routing.v2.GeocodingResults value) {
      if (geocodingResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        geocodingResults_ = value;
      } else {
        geocodingResultsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    public Builder setGeocodingResults(
        com.google.maps.routing.v2.GeocodingResults.Builder builderForValue) {
      if (geocodingResultsBuilder_ == null) {
        geocodingResults_ = builderForValue.build();
      } else {
        geocodingResultsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    public Builder mergeGeocodingResults(com.google.maps.routing.v2.GeocodingResults value) {
      if (geocodingResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && geocodingResults_ != null
            && geocodingResults_
                != com.google.maps.routing.v2.GeocodingResults.getDefaultInstance()) {
          getGeocodingResultsBuilder().mergeFrom(value);
        } else {
          geocodingResults_ = value;
        }
      } else {
        geocodingResultsBuilder_.mergeFrom(value);
      }
      if (geocodingResults_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    public Builder clearGeocodingResults() {
      bitField0_ = (bitField0_ & ~0x00000004);
      geocodingResults_ = null;
      if (geocodingResultsBuilder_ != null) {
        geocodingResultsBuilder_.dispose();
        geocodingResultsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodingResults.Builder getGeocodingResultsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getGeocodingResultsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    public com.google.maps.routing.v2.GeocodingResultsOrBuilder getGeocodingResultsOrBuilder() {
      if (geocodingResultsBuilder_ != null) {
        return geocodingResultsBuilder_.getMessageOrBuilder();
      } else {
        return geocodingResults_ == null
            ? com.google.maps.routing.v2.GeocodingResults.getDefaultInstance()
            : geocodingResults_;
      }
    }

    /**
     *
     *
     * <pre>
     * Contains geocoding response info for waypoints specified as addresses.
     * </pre>
     *
     * <code>.google.maps.routing.v2.GeocodingResults geocoding_results = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.maps.routing.v2.GeocodingResults,
            com.google.maps.routing.v2.GeocodingResults.Builder,
            com.google.maps.routing.v2.GeocodingResultsOrBuilder>
        getGeocodingResultsFieldBuilder() {
      if (geocodingResultsBuilder_ == null) {
        geocodingResultsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.maps.routing.v2.GeocodingResults,
                com.google.maps.routing.v2.GeocodingResults.Builder,
                com.google.maps.routing.v2.GeocodingResultsOrBuilder>(
                getGeocodingResults(), getParentForChildren(), isClean());
        geocodingResults_ = null;
      }
      return geocodingResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.ComputeRoutesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.ComputeRoutesResponse)
  private static final com.google.maps.routing.v2.ComputeRoutesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.ComputeRoutesResponse();
  }

  public static com.google.maps.routing.v2.ComputeRoutesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeRoutesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ComputeRoutesResponse>() {
        @java.lang.Override
        public ComputeRoutesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeRoutesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeRoutesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.ComputeRoutesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
