/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/maps/routing/v2/transit.proto

// Protobuf Java Version: 3.25.8
package com.google.maps.routing.v2;

/**
 *
 *
 * <pre>
 * Information about a vehicle used in transit routes.
 * </pre>
 *
 * Protobuf type {@code google.maps.routing.v2.TransitVehicle}
 */
public final class TransitVehicle extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.maps.routing.v2.TransitVehicle)
    TransitVehicleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TransitVehicle.newBuilder() to construct.
  private TransitVehicle(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitVehicle() {
    type_ = 0;
    iconUri_ = "";
    localIconUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitVehicle();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.maps.routing.v2.TransitProto
        .internal_static_google_maps_routing_v2_TransitVehicle_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.maps.routing.v2.TransitProto
        .internal_static_google_maps_routing_v2_TransitVehicle_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.maps.routing.v2.TransitVehicle.class,
            com.google.maps.routing.v2.TransitVehicle.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of vehicles for transit routes.
   * </pre>
   *
   * Protobuf enum {@code google.maps.routing.v2.TransitVehicle.TransitVehicleType}
   */
  public enum TransitVehicleType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>TRANSIT_VEHICLE_TYPE_UNSPECIFIED = 0;</code>
     */
    TRANSIT_VEHICLE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Bus.
     * </pre>
     *
     * <code>BUS = 1;</code>
     */
    BUS(1),
    /**
     *
     *
     * <pre>
     * A vehicle that operates on a cable, usually on the ground. Aerial cable
     * cars may be of the type `GONDOLA_LIFT`.
     * </pre>
     *
     * <code>CABLE_CAR = 2;</code>
     */
    CABLE_CAR(2),
    /**
     *
     *
     * <pre>
     * Commuter rail.
     * </pre>
     *
     * <code>COMMUTER_TRAIN = 3;</code>
     */
    COMMUTER_TRAIN(3),
    /**
     *
     *
     * <pre>
     * Ferry.
     * </pre>
     *
     * <code>FERRY = 4;</code>
     */
    FERRY(4),
    /**
     *
     *
     * <pre>
     * A vehicle that is pulled up a steep incline by a cable. A Funicular
     * typically consists of two cars, with each car acting as a counterweight
     * for the other.
     * </pre>
     *
     * <code>FUNICULAR = 5;</code>
     */
    FUNICULAR(5),
    /**
     *
     *
     * <pre>
     * An aerial cable car.
     * </pre>
     *
     * <code>GONDOLA_LIFT = 6;</code>
     */
    GONDOLA_LIFT(6),
    /**
     *
     *
     * <pre>
     * Heavy rail.
     * </pre>
     *
     * <code>HEAVY_RAIL = 7;</code>
     */
    HEAVY_RAIL(7),
    /**
     *
     *
     * <pre>
     * High speed train.
     * </pre>
     *
     * <code>HIGH_SPEED_TRAIN = 8;</code>
     */
    HIGH_SPEED_TRAIN(8),
    /**
     *
     *
     * <pre>
     * Intercity bus.
     * </pre>
     *
     * <code>INTERCITY_BUS = 9;</code>
     */
    INTERCITY_BUS(9),
    /**
     *
     *
     * <pre>
     * Long distance train.
     * </pre>
     *
     * <code>LONG_DISTANCE_TRAIN = 10;</code>
     */
    LONG_DISTANCE_TRAIN(10),
    /**
     *
     *
     * <pre>
     * Light rail transit.
     * </pre>
     *
     * <code>METRO_RAIL = 11;</code>
     */
    METRO_RAIL(11),
    /**
     *
     *
     * <pre>
     * Monorail.
     * </pre>
     *
     * <code>MONORAIL = 12;</code>
     */
    MONORAIL(12),
    /**
     *
     *
     * <pre>
     * All other vehicles.
     * </pre>
     *
     * <code>OTHER = 13;</code>
     */
    OTHER(13),
    /**
     *
     *
     * <pre>
     * Rail.
     * </pre>
     *
     * <code>RAIL = 14;</code>
     */
    RAIL(14),
    /**
     *
     *
     * <pre>
     * Share taxi is a kind of bus with the ability to drop off and pick up
     * passengers anywhere on its route.
     * </pre>
     *
     * <code>SHARE_TAXI = 15;</code>
     */
    SHARE_TAXI(15),
    /**
     *
     *
     * <pre>
     * Underground light rail.
     * </pre>
     *
     * <code>SUBWAY = 16;</code>
     */
    SUBWAY(16),
    /**
     *
     *
     * <pre>
     * Above ground light rail.
     * </pre>
     *
     * <code>TRAM = 17;</code>
     */
    TRAM(17),
    /**
     *
     *
     * <pre>
     * Trolleybus.
     * </pre>
     *
     * <code>TROLLEYBUS = 18;</code>
     */
    TROLLEYBUS(18),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>TRANSIT_VEHICLE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TRANSIT_VEHICLE_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Bus.
     * </pre>
     *
     * <code>BUS = 1;</code>
     */
    public static final int BUS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * A vehicle that operates on a cable, usually on the ground. Aerial cable
     * cars may be of the type `GONDOLA_LIFT`.
     * </pre>
     *
     * <code>CABLE_CAR = 2;</code>
     */
    public static final int CABLE_CAR_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Commuter rail.
     * </pre>
     *
     * <code>COMMUTER_TRAIN = 3;</code>
     */
    public static final int COMMUTER_TRAIN_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Ferry.
     * </pre>
     *
     * <code>FERRY = 4;</code>
     */
    public static final int FERRY_VALUE = 4;

    /**
     *
     *
     * <pre>
     * A vehicle that is pulled up a steep incline by a cable. A Funicular
     * typically consists of two cars, with each car acting as a counterweight
     * for the other.
     * </pre>
     *
     * <code>FUNICULAR = 5;</code>
     */
    public static final int FUNICULAR_VALUE = 5;

    /**
     *
     *
     * <pre>
     * An aerial cable car.
     * </pre>
     *
     * <code>GONDOLA_LIFT = 6;</code>
     */
    public static final int GONDOLA_LIFT_VALUE = 6;

    /**
     *
     *
     * <pre>
     * Heavy rail.
     * </pre>
     *
     * <code>HEAVY_RAIL = 7;</code>
     */
    public static final int HEAVY_RAIL_VALUE = 7;

    /**
     *
     *
     * <pre>
     * High speed train.
     * </pre>
     *
     * <code>HIGH_SPEED_TRAIN = 8;</code>
     */
    public static final int HIGH_SPEED_TRAIN_VALUE = 8;

    /**
     *
     *
     * <pre>
     * Intercity bus.
     * </pre>
     *
     * <code>INTERCITY_BUS = 9;</code>
     */
    public static final int INTERCITY_BUS_VALUE = 9;

    /**
     *
     *
     * <pre>
     * Long distance train.
     * </pre>
     *
     * <code>LONG_DISTANCE_TRAIN = 10;</code>
     */
    public static final int LONG_DISTANCE_TRAIN_VALUE = 10;

    /**
     *
     *
     * <pre>
     * Light rail transit.
     * </pre>
     *
     * <code>METRO_RAIL = 11;</code>
     */
    public static final int METRO_RAIL_VALUE = 11;

    /**
     *
     *
     * <pre>
     * Monorail.
     * </pre>
     *
     * <code>MONORAIL = 12;</code>
     */
    public static final int MONORAIL_VALUE = 12;

    /**
     *
     *
     * <pre>
     * All other vehicles.
     * </pre>
     *
     * <code>OTHER = 13;</code>
     */
    public static final int OTHER_VALUE = 13;

    /**
     *
     *
     * <pre>
     * Rail.
     * </pre>
     *
     * <code>RAIL = 14;</code>
     */
    public static final int RAIL_VALUE = 14;

    /**
     *
     *
     * <pre>
     * Share taxi is a kind of bus with the ability to drop off and pick up
     * passengers anywhere on its route.
     * </pre>
     *
     * <code>SHARE_TAXI = 15;</code>
     */
    public static final int SHARE_TAXI_VALUE = 15;

    /**
     *
     *
     * <pre>
     * Underground light rail.
     * </pre>
     *
     * <code>SUBWAY = 16;</code>
     */
    public static final int SUBWAY_VALUE = 16;

    /**
     *
     *
     * <pre>
     * Above ground light rail.
     * </pre>
     *
     * <code>TRAM = 17;</code>
     */
    public static final int TRAM_VALUE = 17;

    /**
     *
     *
     * <pre>
     * Trolleybus.
     * </pre>
     *
     * <code>TROLLEYBUS = 18;</code>
     */
    public static final int TROLLEYBUS_VALUE = 18;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransitVehicleType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TransitVehicleType forNumber(int value) {
      switch (value) {
        case 0:
          return TRANSIT_VEHICLE_TYPE_UNSPECIFIED;
        case 1:
          return BUS;
        case 2:
          return CABLE_CAR;
        case 3:
          return COMMUTER_TRAIN;
        case 4:
          return FERRY;
        case 5:
          return FUNICULAR;
        case 6:
          return GONDOLA_LIFT;
        case 7:
          return HEAVY_RAIL;
        case 8:
          return HIGH_SPEED_TRAIN;
        case 9:
          return INTERCITY_BUS;
        case 10:
          return LONG_DISTANCE_TRAIN;
        case 11:
          return METRO_RAIL;
        case 12:
          return MONORAIL;
        case 13:
          return OTHER;
        case 14:
          return RAIL;
        case 15:
          return SHARE_TAXI;
        case 16:
          return SUBWAY;
        case 17:
          return TRAM;
        case 18:
          return TROLLEYBUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TransitVehicleType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TransitVehicleType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TransitVehicleType>() {
              public TransitVehicleType findValueByNumber(int number) {
                return TransitVehicleType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.maps.routing.v2.TransitVehicle.getDescriptor().getEnumTypes().get(0);
    }

    private static final TransitVehicleType[] VALUES = values();

    public static TransitVehicleType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TransitVehicleType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.maps.routing.v2.TransitVehicle.TransitVehicleType)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private com.google.type.LocalizedText name_;

  /**
   *
   *
   * <pre>
   * The name of this vehicle, capitalized.
   * </pre>
   *
   * <code>.google.type.LocalizedText name = 1;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The name of this vehicle, capitalized.
   * </pre>
   *
   * <code>.google.type.LocalizedText name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public com.google.type.LocalizedText getName() {
    return name_ == null ? com.google.type.LocalizedText.getDefaultInstance() : name_;
  }

  /**
   *
   *
   * <pre>
   * The name of this vehicle, capitalized.
   * </pre>
   *
   * <code>.google.type.LocalizedText name = 1;</code>
   */
  @java.lang.Override
  public com.google.type.LocalizedTextOrBuilder getNameOrBuilder() {
    return name_ == null ? com.google.type.LocalizedText.getDefaultInstance() : name_;
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * The type of vehicle used.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * The type of vehicle used.
   * </pre>
   *
   * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.maps.routing.v2.TransitVehicle.TransitVehicleType getType() {
    com.google.maps.routing.v2.TransitVehicle.TransitVehicleType result =
        com.google.maps.routing.v2.TransitVehicle.TransitVehicleType.forNumber(type_);
    return result == null
        ? com.google.maps.routing.v2.TransitVehicle.TransitVehicleType.UNRECOGNIZED
        : result;
  }

  public static final int ICON_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object iconUri_ = "";

  /**
   *
   *
   * <pre>
   * The URI for an icon associated with this vehicle type.
   * </pre>
   *
   * <code>string icon_uri = 3;</code>
   *
   * @return The iconUri.
   */
  @java.lang.Override
  public java.lang.String getIconUri() {
    java.lang.Object ref = iconUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      iconUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URI for an icon associated with this vehicle type.
   * </pre>
   *
   * <code>string icon_uri = 3;</code>
   *
   * @return The bytes for iconUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIconUriBytes() {
    java.lang.Object ref = iconUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      iconUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCAL_ICON_URI_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object localIconUri_ = "";

  /**
   *
   *
   * <pre>
   * The URI for the icon associated with this vehicle type, based on the local
   * transport signage.
   * </pre>
   *
   * <code>string local_icon_uri = 4;</code>
   *
   * @return The localIconUri.
   */
  @java.lang.Override
  public java.lang.String getLocalIconUri() {
    java.lang.Object ref = localIconUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      localIconUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URI for the icon associated with this vehicle type, based on the local
   * transport signage.
   * </pre>
   *
   * <code>string local_icon_uri = 4;</code>
   *
   * @return The bytes for localIconUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocalIconUriBytes() {
    java.lang.Object ref = localIconUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      localIconUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getName());
    }
    if (type_
        != com.google.maps.routing.v2.TransitVehicle.TransitVehicleType
            .TRANSIT_VEHICLE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(iconUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, iconUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(localIconUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, localIconUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getName());
    }
    if (type_
        != com.google.maps.routing.v2.TransitVehicle.TransitVehicleType
            .TRANSIT_VEHICLE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(iconUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, iconUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(localIconUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, localIconUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.maps.routing.v2.TransitVehicle)) {
      return super.equals(obj);
    }
    com.google.maps.routing.v2.TransitVehicle other =
        (com.google.maps.routing.v2.TransitVehicle) obj;

    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (type_ != other.type_) return false;
    if (!getIconUri().equals(other.getIconUri())) return false;
    if (!getLocalIconUri().equals(other.getLocalIconUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + ICON_URI_FIELD_NUMBER;
    hash = (53 * hash) + getIconUri().hashCode();
    hash = (37 * hash) + LOCAL_ICON_URI_FIELD_NUMBER;
    hash = (53 * hash) + getLocalIconUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.maps.routing.v2.TransitVehicle parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.maps.routing.v2.TransitVehicle prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Information about a vehicle used in transit routes.
   * </pre>
   *
   * Protobuf type {@code google.maps.routing.v2.TransitVehicle}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.maps.routing.v2.TransitVehicle)
      com.google.maps.routing.v2.TransitVehicleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.maps.routing.v2.TransitProto
          .internal_static_google_maps_routing_v2_TransitVehicle_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.maps.routing.v2.TransitProto
          .internal_static_google_maps_routing_v2_TransitVehicle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.maps.routing.v2.TransitVehicle.class,
              com.google.maps.routing.v2.TransitVehicle.Builder.class);
    }

    // Construct using com.google.maps.routing.v2.TransitVehicle.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNameFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = null;
      if (nameBuilder_ != null) {
        nameBuilder_.dispose();
        nameBuilder_ = null;
      }
      type_ = 0;
      iconUri_ = "";
      localIconUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.maps.routing.v2.TransitProto
          .internal_static_google_maps_routing_v2_TransitVehicle_descriptor;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitVehicle getDefaultInstanceForType() {
      return com.google.maps.routing.v2.TransitVehicle.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitVehicle build() {
      com.google.maps.routing.v2.TransitVehicle result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.maps.routing.v2.TransitVehicle buildPartial() {
      com.google.maps.routing.v2.TransitVehicle result =
          new com.google.maps.routing.v2.TransitVehicle(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.maps.routing.v2.TransitVehicle result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = nameBuilder_ == null ? name_ : nameBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.iconUri_ = iconUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.localIconUri_ = localIconUri_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.maps.routing.v2.TransitVehicle) {
        return mergeFrom((com.google.maps.routing.v2.TransitVehicle) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.maps.routing.v2.TransitVehicle other) {
      if (other == com.google.maps.routing.v2.TransitVehicle.getDefaultInstance()) return this;
      if (other.hasName()) {
        mergeName(other.getName());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getIconUri().isEmpty()) {
        iconUri_ = other.iconUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLocalIconUri().isEmpty()) {
        localIconUri_ = other.localIconUri_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getNameFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                iconUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                localIconUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.type.LocalizedText name_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LocalizedText,
            com.google.type.LocalizedText.Builder,
            com.google.type.LocalizedTextOrBuilder>
        nameBuilder_;

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     *
     * @return The name.
     */
    public com.google.type.LocalizedText getName() {
      if (nameBuilder_ == null) {
        return name_ == null ? com.google.type.LocalizedText.getDefaultInstance() : name_;
      } else {
        return nameBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    public Builder setName(com.google.type.LocalizedText value) {
      if (nameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
      } else {
        nameBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    public Builder setName(com.google.type.LocalizedText.Builder builderForValue) {
      if (nameBuilder_ == null) {
        name_ = builderForValue.build();
      } else {
        nameBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    public Builder mergeName(com.google.type.LocalizedText value) {
      if (nameBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && name_ != null
            && name_ != com.google.type.LocalizedText.getDefaultInstance()) {
          getNameBuilder().mergeFrom(value);
        } else {
          name_ = value;
        }
      } else {
        nameBuilder_.mergeFrom(value);
      }
      if (name_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    public Builder clearName() {
      bitField0_ = (bitField0_ & ~0x00000001);
      name_ = null;
      if (nameBuilder_ != null) {
        nameBuilder_.dispose();
        nameBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    public com.google.type.LocalizedText.Builder getNameBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getNameFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    public com.google.type.LocalizedTextOrBuilder getNameOrBuilder() {
      if (nameBuilder_ != null) {
        return nameBuilder_.getMessageOrBuilder();
      } else {
        return name_ == null ? com.google.type.LocalizedText.getDefaultInstance() : name_;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of this vehicle, capitalized.
     * </pre>
     *
     * <code>.google.type.LocalizedText name = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LocalizedText,
            com.google.type.LocalizedText.Builder,
            com.google.type.LocalizedTextOrBuilder>
        getNameFieldBuilder() {
      if (nameBuilder_ == null) {
        nameBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LocalizedText,
                com.google.type.LocalizedText.Builder,
                com.google.type.LocalizedTextOrBuilder>(
                getName(), getParentForChildren(), isClean());
        name_ = null;
      }
      return nameBuilder_;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of vehicle used.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of vehicle used.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of vehicle used.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.maps.routing.v2.TransitVehicle.TransitVehicleType getType() {
      com.google.maps.routing.v2.TransitVehicle.TransitVehicleType result =
          com.google.maps.routing.v2.TransitVehicle.TransitVehicleType.forNumber(type_);
      return result == null
          ? com.google.maps.routing.v2.TransitVehicle.TransitVehicleType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The type of vehicle used.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.maps.routing.v2.TransitVehicle.TransitVehicleType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of vehicle used.
     * </pre>
     *
     * <code>.google.maps.routing.v2.TransitVehicle.TransitVehicleType type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object iconUri_ = "";

    /**
     *
     *
     * <pre>
     * The URI for an icon associated with this vehicle type.
     * </pre>
     *
     * <code>string icon_uri = 3;</code>
     *
     * @return The iconUri.
     */
    public java.lang.String getIconUri() {
      java.lang.Object ref = iconUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        iconUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI for an icon associated with this vehicle type.
     * </pre>
     *
     * <code>string icon_uri = 3;</code>
     *
     * @return The bytes for iconUri.
     */
    public com.google.protobuf.ByteString getIconUriBytes() {
      java.lang.Object ref = iconUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        iconUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI for an icon associated with this vehicle type.
     * </pre>
     *
     * <code>string icon_uri = 3;</code>
     *
     * @param value The iconUri to set.
     * @return This builder for chaining.
     */
    public Builder setIconUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iconUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI for an icon associated with this vehicle type.
     * </pre>
     *
     * <code>string icon_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIconUri() {
      iconUri_ = getDefaultInstance().getIconUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI for an icon associated with this vehicle type.
     * </pre>
     *
     * <code>string icon_uri = 3;</code>
     *
     * @param value The bytes for iconUri to set.
     * @return This builder for chaining.
     */
    public Builder setIconUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iconUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object localIconUri_ = "";

    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this vehicle type, based on the local
     * transport signage.
     * </pre>
     *
     * <code>string local_icon_uri = 4;</code>
     *
     * @return The localIconUri.
     */
    public java.lang.String getLocalIconUri() {
      java.lang.Object ref = localIconUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        localIconUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this vehicle type, based on the local
     * transport signage.
     * </pre>
     *
     * <code>string local_icon_uri = 4;</code>
     *
     * @return The bytes for localIconUri.
     */
    public com.google.protobuf.ByteString getLocalIconUriBytes() {
      java.lang.Object ref = localIconUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        localIconUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this vehicle type, based on the local
     * transport signage.
     * </pre>
     *
     * <code>string local_icon_uri = 4;</code>
     *
     * @param value The localIconUri to set.
     * @return This builder for chaining.
     */
    public Builder setLocalIconUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      localIconUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this vehicle type, based on the local
     * transport signage.
     * </pre>
     *
     * <code>string local_icon_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocalIconUri() {
      localIconUri_ = getDefaultInstance().getLocalIconUri();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI for the icon associated with this vehicle type, based on the local
     * transport signage.
     * </pre>
     *
     * <code>string local_icon_uri = 4;</code>
     *
     * @param value The bytes for localIconUri to set.
     * @return This builder for chaining.
     */
    public Builder setLocalIconUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      localIconUri_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.maps.routing.v2.TransitVehicle)
  }

  // @@protoc_insertion_point(class_scope:google.maps.routing.v2.TransitVehicle)
  private static final com.google.maps.routing.v2.TransitVehicle DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.maps.routing.v2.TransitVehicle();
  }

  public static com.google.maps.routing.v2.TransitVehicle getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitVehicle> PARSER =
      new com.google.protobuf.AbstractParser<TransitVehicle>() {
        @java.lang.Override
        public TransitVehicle parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitVehicle> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitVehicle> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.maps.routing.v2.TransitVehicle getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
