/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth;

import com.google.auto.value.AutoValue;
import com.google.fleetengine.auth.AutoValue_AuthTokenMinter;
import com.google.fleetengine.auth.FleetEngineAuthTokenStateManager;
import com.google.fleetengine.auth.NaiveAuthStateManager;
import com.google.fleetengine.auth.client.FleetEngineTokenProvider;
import com.google.fleetengine.auth.token.DeliveryVehicleClaims;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;
import com.google.fleetengine.auth.token.TaskClaims;
import com.google.fleetengine.auth.token.TrackingClaims;
import com.google.fleetengine.auth.token.TripClaims;
import com.google.fleetengine.auth.token.VehicleClaims;
import com.google.fleetengine.auth.token.factory.FleetEngineTokenFactory;
import com.google.fleetengine.auth.token.factory.FleetEngineTokenFactorySettings;
import com.google.fleetengine.auth.token.factory.TokenFactory;
import com.google.fleetengine.auth.token.factory.signer.Signer;
import com.google.fleetengine.auth.token.factory.signer.SigningTokenException;
import javax.annotation.Nullable;

@AutoValue
public abstract class AuthTokenMinter
implements FleetEngineTokenProvider {
    @Nullable
    public abstract Signer serverSigner();

    @Nullable
    public abstract Signer driverSigner();

    @Nullable
    public abstract Signer consumerSigner();

    @Nullable
    public abstract Signer deliveryServerSigner();

    @Nullable
    public abstract Signer deliveryConsumerSigner();

    @Nullable
    public abstract Signer untrustedDeliveryDriverSigner();

    @Nullable
    public abstract Signer trustedDeliveryDriverSigner();

    @Nullable
    public abstract Signer deliveryFleetReaderSigner();

    @Nullable
    public abstract Signer customSigner();

    public abstract TokenFactory tokenFactory();

    public abstract FleetEngineAuthTokenStateManager tokenStateManager();

    abstract DefaultServerTokenType defaultServerTokenType();

    public static Builder builder() {
        FleetEngineTokenFactorySettings settings = FleetEngineTokenFactorySettings.builder().build();
        return new AutoValue_AuthTokenMinter.Builder().setTokenStateManager(new NaiveAuthStateManager()).setTokenFactory(new FleetEngineTokenFactory(settings)).setDefaultServerTokenType(DefaultServerTokenType.ODRD);
    }

    public static Builder deliveryBuilder() {
        FleetEngineTokenFactorySettings settings = FleetEngineTokenFactorySettings.builder().build();
        return new AutoValue_AuthTokenMinter.Builder().setTokenStateManager(new NaiveAuthStateManager()).setTokenFactory(new FleetEngineTokenFactory(settings)).setDefaultServerTokenType(DefaultServerTokenType.LMFS);
    }

    public FleetEngineToken getServerToken() throws SigningTokenException {
        FleetEngineToken unsignedToken = this.tokenFactory().createServerToken();
        return this.tokenStateManager().signToken(this.serverSigner(), unsignedToken);
    }

    public FleetEngineToken getDriverToken(VehicleClaims claims) throws SigningTokenException {
        if (this.driverSigner() == null) {
            throw new SigningTokenException("Unable to sign Driver tokens due to the driver signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createDriverToken(claims);
        return this.tokenStateManager().signToken(this.driverSigner(), unsignedToken);
    }

    public FleetEngineToken getConsumerToken(TripClaims claims) throws SigningTokenException {
        if (this.consumerSigner() == null) {
            throw new SigningTokenException("Unable to sign consumer tokens due to the consumer signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createConsumerToken(claims);
        return this.tokenStateManager().signToken(this.consumerSigner(), unsignedToken);
    }

    public FleetEngineToken getDeliveryServerToken() throws SigningTokenException {
        FleetEngineToken unsignedToken = this.tokenFactory().createDeliveryServerToken();
        return this.tokenStateManager().signToken(this.deliveryServerSigner(), unsignedToken);
    }

    public FleetEngineToken getDeliveryConsumerToken(TaskClaims claims) throws SigningTokenException {
        if (this.deliveryConsumerSigner() == null) {
            throw new SigningTokenException("Unable to sign delivery consumer tokens due to the delivery consumer signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createDeliveryConsumerToken(claims);
        return this.tokenStateManager().signToken(this.deliveryConsumerSigner(), unsignedToken);
    }

    public FleetEngineToken getDeliveryConsumerToken(TrackingClaims claims) throws SigningTokenException {
        if (this.deliveryConsumerSigner() == null) {
            throw new SigningTokenException("Unable to sign delivery consumer tokens due to the delivery consumer signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createDeliveryConsumerToken(claims);
        return this.tokenStateManager().signToken(this.deliveryConsumerSigner(), unsignedToken);
    }

    public FleetEngineToken getUntrustedDeliveryVehicleToken(DeliveryVehicleClaims claims) throws SigningTokenException {
        if (this.untrustedDeliveryDriverSigner() == null) {
            throw new SigningTokenException("Unable to sign untrusted delivery driver tokens due to the untrusted delivery driver signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createUntrustedDeliveryDriverToken(claims);
        return this.tokenStateManager().signToken(this.untrustedDeliveryDriverSigner(), unsignedToken);
    }

    public FleetEngineToken getTrustedDeliveryVehicleToken(DeliveryVehicleClaims claims) throws SigningTokenException {
        if (this.trustedDeliveryDriverSigner() == null) {
            throw new SigningTokenException("Unable to sign trusted delivery driver tokens due to the trusted delivery driver signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createTrustedDeliveryDriverToken(claims);
        return this.tokenStateManager().signToken(this.trustedDeliveryDriverSigner(), unsignedToken);
    }

    public FleetEngineToken getTrustedDeliveryVehicleToken(DeliveryVehicleClaims vehicleClaims, TaskClaims taskClaims) throws SigningTokenException {
        if (this.trustedDeliveryDriverSigner() == null) {
            throw new SigningTokenException("Unable to sign trusted delivery driver tokens due to the trusted delivery driver signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createTrustedDeliveryDriverToken(vehicleClaims, taskClaims);
        return this.tokenStateManager().signToken(this.trustedDeliveryDriverSigner(), unsignedToken);
    }

    public FleetEngineToken getDeliveryFleetReaderToken() throws SigningTokenException {
        FleetEngineToken unsignedToken = this.tokenFactory().createDeliveryFleetReaderToken();
        return this.tokenStateManager().signToken(this.deliveryFleetReaderSigner(), unsignedToken);
    }

    public FleetEngineToken getCustomToken(FleetEngineTokenClaims claims) throws SigningTokenException {
        if (this.customSigner() == null) {
            throw new SigningTokenException("Unable to sign custom tokens due to the custom signer not being set.");
        }
        FleetEngineToken unsignedToken = this.tokenFactory().createCustomToken(claims);
        return this.tokenStateManager().signToken(this.customSigner(), unsignedToken);
    }

    @Override
    public FleetEngineToken getSignedToken() throws SigningTokenException {
        if (this.defaultServerTokenType() == DefaultServerTokenType.LMFS) {
            return this.getDeliveryServerToken();
        }
        return this.getServerToken();
    }

    static enum DefaultServerTokenType {
        ODRD,
        LMFS;

    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setServerSigner(Signer var1);

        public abstract Builder setDriverSigner(Signer var1);

        public abstract Builder setConsumerSigner(Signer var1);

        public abstract Builder setCustomSigner(Signer var1);

        public abstract Builder setDeliveryServerSigner(Signer var1);

        public abstract Builder setDeliveryConsumerSigner(Signer var1);

        public abstract Builder setUntrustedDeliveryDriverSigner(Signer var1);

        public abstract Builder setTrustedDeliveryDriverSigner(Signer var1);

        public abstract Builder setDeliveryFleetReaderSigner(Signer var1);

        public abstract Builder setTokenFactory(TokenFactory var1);

        public abstract Builder setTokenStateManager(FleetEngineAuthTokenStateManager var1);

        abstract Builder setDefaultServerTokenType(DefaultServerTokenType var1);

        public abstract AuthTokenMinter build();
    }
}

