/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.fleetengine.auth.token.FleetEngineToken;
import java.time.Clock;
import java.time.Duration;

public class FleetEngineTokenExpiryValidator {
    private static final FleetEngineTokenExpiryValidator singleton = new FleetEngineTokenExpiryValidator(Clock.systemUTC());
    private final Clock clock;

    public static FleetEngineTokenExpiryValidator getInstance() {
        return singleton;
    }

    @VisibleForTesting
    FleetEngineTokenExpiryValidator(Clock clock) {
        this.clock = clock;
    }

    public boolean isTokenExpired(FleetEngineToken token, Duration expirationWindow) {
        return token.expirationTimestamp().toInstant().minus(expirationWindow).isBefore(this.clock.instant());
    }
}

