/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.fleetengine.auth.FleetEngineAuthTokenStateManager;
import com.google.fleetengine.auth.FleetEngineTokenExpiryValidator;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.FleetEngineTokenType;
import com.google.fleetengine.auth.token.factory.signer.Signer;
import com.google.fleetengine.auth.token.factory.signer.SigningTokenException;
import java.util.concurrent.ConcurrentHashMap;

public class NaiveAuthStateManager
implements FleetEngineAuthTokenStateManager {
    private final FleetEngineTokenExpiryValidator tokenExpiryValidator;
    private final ConcurrentHashMap<FleetEngineTokenType, FleetEngineToken> cachedWildcardTokens;

    public NaiveAuthStateManager() {
        this(FleetEngineTokenExpiryValidator.getInstance());
    }

    @VisibleForTesting
    NaiveAuthStateManager(FleetEngineTokenExpiryValidator tokenExpiryValidator) {
        this.tokenExpiryValidator = tokenExpiryValidator;
        this.cachedWildcardTokens = new ConcurrentHashMap(3);
    }

    @Override
    public FleetEngineToken signToken(Signer signer, FleetEngineToken token) throws SigningTokenException {
        if (!token.authorizationClaims().isWildcard()) {
            return signer.sign(token);
        }
        FleetEngineToken cachedToken = this.cachedWildcardTokens.get((Object)token.tokenType());
        if (cachedToken != null && !this.tokenExpiryValidator.isTokenExpired(cachedToken, EXPIRATION_WINDOW_DURATION)) {
            return cachedToken;
        }
        FleetEngineToken signedToken = signer.sign(token);
        this.cachedWildcardTokens.put(signedToken.tokenType(), signedToken);
        return signedToken;
    }
}

