/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.client;

import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.fleetengine.auth.client.FleetEngineTokenProvider;
import com.google.fleetengine.auth.client.WritingAuthorizationHeaderException;
import com.google.fleetengine.auth.token.factory.signer.SigningTokenException;
import java.util.Map;

public class FleetEngineAuthClientHeaderProvider
implements HeaderProvider {
    private static final String AUTHORIZATION_HEADER_NAME = "authorization";
    @VisibleForTesting
    final FleetEngineTokenProvider tokenProvider;
    @VisibleForTesting
    final HeaderProvider underlyingHeaderProvider;

    public static FleetEngineAuthClientHeaderProvider create(FleetEngineTokenProvider tokenProvider) {
        return new FleetEngineAuthClientHeaderProvider(tokenProvider, (HeaderProvider)FixedHeaderProvider.create((String[])new String[0]));
    }

    public static FleetEngineAuthClientHeaderProvider create(FleetEngineTokenProvider tokenProvider, HeaderProvider underlyingHeaderProvider) {
        return new FleetEngineAuthClientHeaderProvider(tokenProvider, underlyingHeaderProvider);
    }

    private FleetEngineAuthClientHeaderProvider(FleetEngineTokenProvider tokenProvider, HeaderProvider underlyingHeaderProvider) {
        this.underlyingHeaderProvider = underlyingHeaderProvider;
        this.tokenProvider = tokenProvider;
    }

    public Map<String, String> getHeaders() {
        try {
            Map underlyingMap = Maps.filterEntries((Map)this.underlyingHeaderProvider.getHeaders(), entry -> !AUTHORIZATION_HEADER_NAME.equals(entry.getKey()));
            return new ImmutableMap.Builder().putAll(underlyingMap).put((Object)AUTHORIZATION_HEADER_NAME, (Object)String.format("Bearer %s", this.tokenProvider.getSignedToken().jwt())).buildOrThrow();
        }
        catch (SigningTokenException e) {
            throw new WritingAuthorizationHeaderException("Exception while getting server token.", e);
        }
    }
}

