/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.fleetengine.auth.client.FleetEngineTokenProvider;
import com.google.fleetengine.auth.client.WritingAuthorizationHeaderException;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.factory.signer.SigningTokenException;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class FleetEngineAuthClientInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> AUTHORIZATION_HEADER = Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final FleetEngineTokenProvider tokenProvider;

    public static FleetEngineAuthClientInterceptor create(FleetEngineTokenProvider tokenProvider) {
        return new FleetEngineAuthClientInterceptor(tokenProvider);
    }

    private FleetEngineAuthClientInterceptor(FleetEngineTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                FleetEngineAuthClientInterceptor.this.addAuthorizationHeader(headers);
                super.start(responseListener, headers);
            }
        };
    }

    @VisibleForTesting
    void addAuthorizationHeader(Metadata headers) {
        try {
            FleetEngineToken token = this.tokenProvider.getSignedToken();
            headers.put(AUTHORIZATION_HEADER, (Object)String.format("Bearer %s", token.jwt()));
        }
        catch (SigningTokenException e) {
            throw new WritingAuthorizationHeaderException("Exception while getting token.", e);
        }
    }
}

