/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;

public class DeliveryVehicleClaims
implements FleetEngineTokenClaims {
    private static final String WILDCARD = "*";
    static final String CLAIM_DELIVERY_VEHICLE_ID = "deliveryvehicleid";
    private final ImmutableMap<String, String> map;
    private final boolean isWildcardClaim;

    public static DeliveryVehicleClaims create() {
        return new DeliveryVehicleClaims(WILDCARD, true);
    }

    public static DeliveryVehicleClaims create(String deliveryVehicleId) {
        if (Strings.isNullOrEmpty((String)deliveryVehicleId)) {
            throw new IllegalArgumentException("deliveryVehicleId must have a value");
        }
        return new DeliveryVehicleClaims(deliveryVehicleId, false);
    }

    private DeliveryVehicleClaims(String deliveryVehicleId, boolean isWildcard) {
        this.map = ImmutableMap.of((Object)CLAIM_DELIVERY_VEHICLE_ID, (Object)deliveryVehicleId);
        this.isWildcardClaim = isWildcard;
    }

    @Override
    public ImmutableMap<String, String> toMap() {
        return this.map;
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcardClaim;
    }
}

