/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;

public class TaskClaims
implements FleetEngineTokenClaims {
    private static final String WILDCARD = "*";
    static final String CLAIM_TASK_ID = "taskid";
    private final ImmutableMap<String, String> map;
    private final boolean isWildcardClaim;

    public static TaskClaims create() {
        return new TaskClaims(WILDCARD, true);
    }

    public static TaskClaims create(String taskId) {
        if (Strings.isNullOrEmpty((String)taskId)) {
            throw new IllegalArgumentException("taskId must have a value");
        }
        return new TaskClaims(taskId, false);
    }

    private TaskClaims(String taskId, boolean isWildcard) {
        this.map = ImmutableMap.of((Object)CLAIM_TASK_ID, (Object)taskId);
        this.isWildcardClaim = isWildcard;
    }

    @Override
    public ImmutableMap<String, String> toMap() {
        return this.map;
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcardClaim;
    }
}

