/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;

public class TrackingClaims
implements FleetEngineTokenClaims {
    private static final String WILDCARD = "*";
    static final String CLAIM_TRACKING_ID = "trackingid";
    private final ImmutableMap<String, String> map;
    private final boolean isWildcardClaim;

    public static TrackingClaims create() {
        return new TrackingClaims(WILDCARD, true);
    }

    public static TrackingClaims create(String trackingId) {
        if (Strings.isNullOrEmpty((String)trackingId)) {
            throw new IllegalArgumentException("trackingId must have a value");
        }
        return new TrackingClaims(trackingId, false);
    }

    private TrackingClaims(String trackingId, boolean isWildcard) {
        this.map = ImmutableMap.of((Object)CLAIM_TRACKING_ID, (Object)trackingId);
        this.isWildcardClaim = isWildcard;
    }

    @Override
    public ImmutableMap<String, String> toMap() {
        return this.map;
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcardClaim;
    }
}

