/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;

public class TripClaims
implements FleetEngineTokenClaims {
    private static final String WILDCARD = "*";
    static final String CLAIM_TRIP_ID = "tripid";
    private final boolean isWildcard;
    private final ImmutableMap<String, String> map;

    public static TripClaims create() {
        return new TripClaims(WILDCARD);
    }

    public static TripClaims create(String tripId) {
        if (Strings.isNullOrEmpty((String)tripId)) {
            throw new IllegalArgumentException("tripId must have a value");
        }
        return new TripClaims(tripId);
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    private TripClaims(String tripId) {
        this.map = ImmutableMap.of((Object)CLAIM_TRIP_ID, (Object)tripId);
        this.isWildcard = WILDCARD.equals(tripId);
    }

    @Override
    public ImmutableMap<String, String> toMap() {
        return this.map;
    }
}

