/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;

public class VehicleClaims
implements FleetEngineTokenClaims {
    private static final String WILDCARD = "*";
    static final String CLAIM_VEHICLE_ID = "vehicleid";
    private final boolean isWildcard;
    private final ImmutableMap<String, String> map;

    public static VehicleClaims create() {
        return new VehicleClaims(WILDCARD);
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    public static VehicleClaims create(String vehicleId) {
        if (Strings.isNullOrEmpty((String)vehicleId)) {
            throw new IllegalArgumentException("vehicleId must have a value");
        }
        return new VehicleClaims(vehicleId);
    }

    private VehicleClaims(String vehicleId) {
        this.map = ImmutableMap.of((Object)CLAIM_VEHICLE_ID, (Object)vehicleId);
        this.isWildcard = WILDCARD.equals(vehicleId);
    }

    @Override
    public ImmutableMap<String, String> toMap() {
        return this.map;
    }
}

