/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token.factory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.DeliveryFleetReaderClaims;
import com.google.fleetengine.auth.token.DeliveryServerTokenClaims;
import com.google.fleetengine.auth.token.DeliveryVehicleClaims;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.FleetEngineTokenClaims;
import com.google.fleetengine.auth.token.FleetEngineTokenType;
import com.google.fleetengine.auth.token.ServerTokenClaims;
import com.google.fleetengine.auth.token.TaskClaims;
import com.google.fleetengine.auth.token.TrackingClaims;
import com.google.fleetengine.auth.token.TripClaims;
import com.google.fleetengine.auth.token.VehicleClaims;
import com.google.fleetengine.auth.token.factory.FleetEngineTokenFactorySettings;
import com.google.fleetengine.auth.token.factory.TokenFactory;
import java.sql.Date;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public final class FleetEngineTokenFactory
implements TokenFactory {
    private final Clock clock;
    private final FleetEngineTokenFactorySettings settings;
    @VisibleForTesting
    static final Duration TOKEN_EXPIRATION = Duration.ofMinutes(60L);

    public FleetEngineTokenFactorySettings getSettings() {
        return this.settings;
    }

    public FleetEngineTokenFactory(FleetEngineTokenFactorySettings settings) {
        this(Clock.systemUTC(), settings);
    }

    @VisibleForTesting
    FleetEngineTokenFactory(Clock clock, FleetEngineTokenFactorySettings settings) {
        this.clock = clock;
        this.settings = settings;
    }

    @Override
    public FleetEngineToken createServerToken() {
        return this.createToken(FleetEngineTokenType.SERVER, ServerTokenClaims.create());
    }

    @Override
    public FleetEngineToken createDriverToken(VehicleClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.DRIVER, claims);
    }

    @Override
    public FleetEngineToken createConsumerToken(TripClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.CONSUMER, claims);
    }

    @Override
    public FleetEngineToken createDeliveryServerToken() {
        return this.createToken(FleetEngineTokenType.DELIVERY_SERVER, DeliveryServerTokenClaims.create());
    }

    @Override
    public FleetEngineToken createDeliveryConsumerToken(TaskClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.DELIVERY_CONSUMER, claims);
    }

    @Override
    public FleetEngineToken createDeliveryConsumerToken(TrackingClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.DELIVERY_CONSUMER, claims);
    }

    @Override
    public FleetEngineToken createUntrustedDeliveryDriverToken(DeliveryVehicleClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.UNTRUSTED_DELIVERY_DRIVER, claims);
    }

    @Override
    public FleetEngineToken createTrustedDeliveryDriverToken(DeliveryVehicleClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.TRUSTED_DELIVERY_DRIVER, claims);
    }

    @Override
    public FleetEngineToken createTrustedDeliveryDriverToken(DeliveryVehicleClaims vehicleClaims, TaskClaims taskClaims) {
        Objects.requireNonNull(vehicleClaims);
        Objects.requireNonNull(taskClaims);
        return this.createToken(FleetEngineTokenType.TRUSTED_DELIVERY_DRIVER, vehicleClaims, taskClaims);
    }

    @Override
    public FleetEngineToken createDeliveryFleetReaderToken() {
        return this.createToken(FleetEngineTokenType.DELIVERY_FLEET_READER, DeliveryFleetReaderClaims.create());
    }

    @Override
    public FleetEngineToken createCustomToken(FleetEngineTokenClaims claims) {
        Objects.requireNonNull(claims);
        return this.createToken(FleetEngineTokenType.CUSTOM, claims);
    }

    private FleetEngineToken createToken(FleetEngineTokenType tokenType, FleetEngineTokenClaims ... claims) {
        Instant creationInstant = Instant.now(this.clock);
        Instant expirationInstant = creationInstant.plus(TOKEN_EXPIRATION);
        return FleetEngineToken.builder().setTokenType(tokenType).setCreationTimestamp(Date.from(creationInstant)).setExpirationTimestamp(Date.from(expirationInstant)).setAudience(this.settings.audience()).setAuthorizationClaims(this.mergeClaims(claims)).build();
    }

    private FleetEngineTokenClaims mergeClaims(FleetEngineTokenClaims[] claims) {
        if (claims.length == 1) {
            return claims[0];
        }
        boolean isWildcard = true;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FleetEngineTokenClaims c : claims) {
            builder.putAll(c.toMap());
            isWildcard = isWildcard && c.isWildcard();
        }
        ImmutableMap map = builder.build();
        return new MergedClaims((ImmutableMap<String, String>)map, isWildcard);
    }

    private static class MergedClaims
    implements FleetEngineTokenClaims {
        private final ImmutableMap<String, String> map;
        private final boolean isWildcard;

        public MergedClaims(ImmutableMap<String, String> map, boolean isWildcard) {
            this.map = map;
            this.isWildcard = isWildcard;
        }

        @Override
        public ImmutableMap<String, String> toMap() {
            return this.map;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }
    }
}

