/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token.factory.signer;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.factory.signer.Signer;
import com.google.fleetengine.auth.token.factory.signer.SignerInitializationException;
import java.io.IOException;

public class DefaultServiceAccountSigner
implements Signer {
    private static final String ALGORITHM_NAME = "RS256";
    private static final String ALGORITHM_DESCRIPTION = "SHA256withRSA";
    private final ServiceAccountSignerCredentials serviceAccountCredentials;

    public static DefaultServiceAccountSigner create() throws SignerInitializationException {
        GoogleCredentials defaultCredentials;
        try {
            defaultCredentials = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new SignerInitializationException("Could not retrieve credentials for default application.", e);
        }
        return DefaultServiceAccountSigner.create(defaultCredentials);
    }

    @VisibleForTesting
    static DefaultServiceAccountSigner create(GoogleCredentials defaultCredentials) throws SignerInitializationException {
        if (!(defaultCredentials instanceof ServiceAccountCredentials)) {
            throw new SignerInitializationException("GCP default user account running the application is a NOT a service account.");
        }
        return new DefaultServiceAccountSigner(new ServiceAccountSignerCredentials((ServiceAccountCredentials)defaultCredentials));
    }

    @VisibleForTesting
    DefaultServiceAccountSigner(ServiceAccountSignerCredentials serviceAccountCredentials) {
        this.serviceAccountCredentials = serviceAccountCredentials;
    }

    @Override
    public FleetEngineToken sign(FleetEngineToken token) {
        String signedToken = JWT.create().withIssuer(this.serviceAccountCredentials.getClientEmail()).withSubject(this.serviceAccountCredentials.getClientEmail()).withAudience(new String[]{token.audience()}).withExpiresAt(token.expirationTimestamp()).withIssuedAt(token.creationTimestamp()).withClaim("authorization", token.authorizationClaims().toMap()).sign((Algorithm)new ServiceAccountSignerAlgorithm(this.serviceAccountCredentials));
        return token.toBuilder().setJwt(signedToken).build();
    }

    static class ServiceAccountSignerCredentials {
        private final ServiceAccountCredentials credentials;

        ServiceAccountSignerCredentials(ServiceAccountCredentials credentials) {
            this.credentials = credentials;
        }

        String getClientEmail() {
            return this.credentials.getClientEmail();
        }

        byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
            byte[] contentBytes = new byte[headerBytes.length + 1 + payloadBytes.length];
            System.arraycopy(headerBytes, 0, contentBytes, 0, headerBytes.length);
            contentBytes[headerBytes.length] = 46;
            System.arraycopy(payloadBytes, 0, contentBytes, headerBytes.length + 1, payloadBytes.length);
            return this.credentials.sign(contentBytes);
        }
    }

    static class ServiceAccountSignerAlgorithm
    extends Algorithm {
        private final ServiceAccountSignerCredentials serviceAccountCredentials;

        public ServiceAccountSignerAlgorithm(ServiceAccountSignerCredentials serviceAccountCredentials) {
            super(DefaultServiceAccountSigner.ALGORITHM_NAME, DefaultServiceAccountSigner.ALGORITHM_DESCRIPTION);
            this.serviceAccountCredentials = serviceAccountCredentials;
        }

        public void verify(DecodedJWT jwt) {
            throw new SignatureVerificationException((Algorithm)this, (Throwable)new RuntimeException("Verify not implemented"));
        }

        public byte[] sign(byte[] contentBytes) {
            throw new SignatureVerificationException((Algorithm)this, (Throwable)new RuntimeException("sign(byte[]) is deprecated and not implemented"));
        }

        public byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
            return this.serviceAccountCredentials.sign(headerBytes, payloadBytes);
        }
    }
}

