/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token.factory.signer;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.factory.signer.Signer;
import com.google.fleetengine.auth.token.factory.signer.SignerInitializationException;
import java.io.IOException;
import java.util.Arrays;

public class ImpersonatedSigner
implements Signer {
    private static final String ALGORITHM_NAME = "RS256";
    private static final String ALGORITHM_DESCRIPTION = "SHA256withRSA";
    static final ImmutableList<String> IAM_SCOPE = ImmutableList.of((Object)"https://www.googleapis.com/auth/iam");
    @VisibleForTesting
    final ImpersonatedAccountSignerCredentials impersonatedCredentials;

    public static ImpersonatedSigner create(String serviceAccount) throws SignerInitializationException {
        GoogleCredentials defaultCredentials;
        try {
            defaultCredentials = GoogleCredentials.getApplicationDefault().createScoped(IAM_SCOPE);
        }
        catch (IOException e) {
            throw new SignerInitializationException("Could not retrieve credentials for default application.", e);
        }
        return ImpersonatedSigner.create(serviceAccount, defaultCredentials);
    }

    @VisibleForTesting
    static ImpersonatedSigner create(String serviceAccount, GoogleCredentials defaultCredentials) {
        ImpersonatedCredentials impersonatedCredentials = ImpersonatedSigner.createImpersonatedCredentials(serviceAccount, defaultCredentials).build();
        return new ImpersonatedSigner(new ImpersonatedAccountSignerCredentials(impersonatedCredentials));
    }

    @VisibleForTesting
    ImpersonatedSigner(ImpersonatedAccountSignerCredentials credentials) {
        this.impersonatedCredentials = credentials;
    }

    private static ImpersonatedCredentials.Builder createImpersonatedCredentials(String serviceAccount, GoogleCredentials defaultCredentials) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(defaultCredentials).setTargetPrincipal(serviceAccount).setScopes(IAM_SCOPE);
    }

    @Override
    public FleetEngineToken sign(FleetEngineToken token) {
        String signedToken = JWT.create().withIssuer(this.impersonatedCredentials.getAccount()).withSubject(this.impersonatedCredentials.getAccount()).withAudience(new String[]{token.audience()}).withExpiresAt(token.expirationTimestamp()).withIssuedAt(token.creationTimestamp()).withClaim("authorization", token.authorizationClaims().toMap()).sign((Algorithm)new ImpersonatedSignerAlgorithm(this.impersonatedCredentials));
        return token.toBuilder().setJwt(signedToken).build();
    }

    static class ImpersonatedAccountSignerCredentials {
        private final ImpersonatedCredentials credentials;

        public ImpersonatedCredentials getUnderlyingCredentials() {
            return this.credentials;
        }

        ImpersonatedAccountSignerCredentials(ImpersonatedCredentials credentials) {
            this.credentials = credentials;
        }

        public String getAccount() {
            return this.credentials.getAccount();
        }

        byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
            byte[] contentBytes = Arrays.copyOf(headerBytes, headerBytes.length + 1 + payloadBytes.length);
            contentBytes[headerBytes.length] = 46;
            System.arraycopy(payloadBytes, 0, contentBytes, headerBytes.length + 1, payloadBytes.length);
            return this.credentials.sign(contentBytes);
        }
    }

    static class ImpersonatedSignerAlgorithm
    extends Algorithm {
        private final ImpersonatedAccountSignerCredentials impersonatedCredentials;

        public ImpersonatedSignerAlgorithm(ImpersonatedAccountSignerCredentials impersonatedCredentials) {
            super(ImpersonatedSigner.ALGORITHM_NAME, ImpersonatedSigner.ALGORITHM_DESCRIPTION);
            this.impersonatedCredentials = impersonatedCredentials;
        }

        public void verify(DecodedJWT jwt) {
            throw new SignatureVerificationException((Algorithm)this, (Throwable)new RuntimeException("Verify not implemented"));
        }

        public byte[] sign(byte[] contentBytes) {
            throw new SignatureVerificationException((Algorithm)this, (Throwable)new RuntimeException("sign(byte[]) is deprecated and not implemented"));
        }

        public byte[] sign(byte[] headerBytes, byte[] payloadBytes) {
            return this.impersonatedCredentials.sign(headerBytes, payloadBytes);
        }
    }
}

