/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token.factory.signer;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.collect.ImmutableMap;
import com.google.fleetengine.auth.token.FleetEngineToken;
import com.google.fleetengine.auth.token.factory.signer.Signer;
import com.google.fleetengine.auth.token.factory.signer.SigningTokenException;
import com.google.fleetengine.auth.token.factory.signer.util.RSAPrivateKeyUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.logging.Logger;

public final class LocalSigner
implements Signer {
    private static final Logger logger = Logger.getLogger(LocalSigner.class.getName());
    private static final String JWT_CLAIM_HEADER_KID_PROPERTY = "kid";
    private static final String CLIENT_EMAIL_PROPERTY = "client_email";
    private static final String PRIVATE_KEY_ID_PROPERTY = "private_key_id";
    private static final String PRIVATE_KEY_PROPERTY = "private_key";
    private final String clientEmail;
    private final String privateKeyId;
    private final String privateKey;

    public static LocalSigner create(String clientEmail, String privateKeyId, String privateKey) {
        return new LocalSigner(clientEmail, privateKeyId, privateKey);
    }

    public static LocalSigner create(InputStream keyStream) {
        JsonObject serviceAccountKey = LocalSigner.readGCPKeyFile(keyStream);
        return new LocalSigner(serviceAccountKey.get(CLIENT_EMAIL_PROPERTY).getAsString(), serviceAccountKey.get(PRIVATE_KEY_ID_PROPERTY).getAsString(), serviceAccountKey.get(PRIVATE_KEY_PROPERTY).getAsString());
    }

    private LocalSigner(String clientEmail, String privateKeyId, String privateKey) {
        this.clientEmail = clientEmail;
        this.privateKeyId = privateKeyId;
        this.privateKey = privateKey;
    }

    @Override
    public FleetEngineToken sign(FleetEngineToken token) throws SigningTokenException {
        try {
            String signedToken = JWT.create().withHeader(LocalSigner.getHeader(this.privateKeyId)).withExpiresAt(token.expirationTimestamp()).withIssuer(this.clientEmail).withSubject(this.clientEmail).withAudience(new String[]{token.audience()}).withIssuedAt(token.creationTimestamp()).withClaim("authorization", token.authorizationClaims().toMap()).sign(LocalSigner.getAlgorithm(this.privateKey));
            return token.toBuilder().setJwt(signedToken).build();
        }
        catch (InvalidKeySpecException e) {
            throw new SigningTokenException("Error while signing JWT.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject readGCPKeyFile(InputStream keyStream) {
        try (BufferedInputStream inputStream = new BufferedInputStream(keyStream);){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
                jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            }
            return jsonObject;
        }
        catch (IOException exception) {
            logger.warning("Error reading service account key. Please verify your file.");
            throw new IllegalStateException(exception);
        }
    }

    private static ImmutableMap<String, Object> getHeader(String keyId) {
        return ImmutableMap.of((Object)JWT_CLAIM_HEADER_KID_PROPERTY, (Object)keyId);
    }

    private static Algorithm getAlgorithm(String key) throws InvalidKeySpecException {
        RSAPrivateKey privateKey = RSAPrivateKeyUtils.getPrivateKey(key);
        return Algorithm.RSA256(null, (RSAPrivateKey)privateKey);
    }
}

