/*
 * Decompiled with CFR 0.152.
 */
package com.google.fleetengine.auth.token.factory.signer.util;

import com.google.common.io.BaseEncoding;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Logger;

public final class RSAPrivateKeyUtils {
    public static final String KEY_ALGORITHM = "RSA";
    private static final Logger logger = Logger.getLogger(RSAPrivateKeyUtils.class.getName());
    private static final String NEW_LINE = "\n";
    private static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";

    private RSAPrivateKeyUtils() {
    }

    public static RSAPrivateKey getPrivateKey(String privateKey) throws InvalidKeySpecException {
        KeyFactory keyFactory;
        String key = RSAPrivateKeyUtils.cleanUpKeyString(privateKey);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(BaseEncoding.base64().decode((CharSequence)key));
        try {
            keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning(String.format("Algorithm [%s] is not supported.", KEY_ALGORITHM));
            throw new IllegalStateException(e);
        }
        return (RSAPrivateKey)keyFactory.generatePrivate(spec);
    }

    private static final String cleanUpKeyString(String privateKey) {
        return privateKey.replace(BEGIN_PRIVATE_KEY, "").replace(END_PRIVATE_KEY, "").replace(NEW_LINE, "");
    }
}

