/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.maps.PendingResult;
import com.google.maps.PhotoRequest;
import com.google.maps.errors.ApiException;
import com.google.maps.errors.OverQueryLimitException;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.DateTimeAdapter;
import com.google.maps.internal.DayOfWeekAdaptor;
import com.google.maps.internal.DistanceAdapter;
import com.google.maps.internal.DurationAdapter;
import com.google.maps.internal.FareAdapter;
import com.google.maps.internal.InstantAdapter;
import com.google.maps.internal.LatLngAdapter;
import com.google.maps.internal.LocalTimeAdapter;
import com.google.maps.internal.PriceLevelAdaptor;
import com.google.maps.internal.SafeEnumAdapter;
import com.google.maps.model.AddressComponentType;
import com.google.maps.model.AddressType;
import com.google.maps.model.Distance;
import com.google.maps.model.Duration;
import com.google.maps.model.Fare;
import com.google.maps.model.LatLng;
import com.google.maps.model.LocationType;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.PhotoResult;
import com.google.maps.model.PlaceDetails;
import com.google.maps.model.TravelMode;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalTime;

public class OkHttpPendingResult<T, R extends ApiResponse<T>>
implements PendingResult<T>,
Callback {
    private final Request request;
    private final OkHttpClient client;
    private final Class<R> responseClass;
    private final FieldNamingPolicy fieldNamingPolicy;
    private Call call;
    private PendingResult.Callback<T> callback;
    private long errorTimeOut;
    private int retryCounter = 0;
    private long cumulativeSleepTime = 0L;
    private static final Logger LOG = Logger.getLogger(OkHttpPendingResult.class.getName());
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);

    public OkHttpPendingResult(Request request, OkHttpClient client, Class<R> responseClass, FieldNamingPolicy fieldNamingPolicy, long errorTimeOut) {
        this.request = request;
        this.client = client;
        this.responseClass = responseClass;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.errorTimeOut = errorTimeOut;
        this.call = client.newCall(request);
    }

    @Override
    public void setCallback(PendingResult.Callback<T> callback) {
        this.callback = callback;
        this.call.enqueue((Callback)this);
    }

    @Override
    public T await() throws Exception {
        if (this.retryCounter > 0) {
            double delaySecs = 0.5 * Math.pow(1.5, this.retryCounter - 1);
            long delayMillis = (long)(delaySecs * (Math.random() + 0.5) * 1000.0);
            LOG.config(String.format("Sleeping between errors for %dms (retry #%d, already slept %dms)", delayMillis, this.retryCounter, this.cumulativeSleepTime));
            this.cumulativeSleepTime += delayMillis;
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        final ArrayBlockingQueue waiter = new ArrayBlockingQueue(1);
        final OkHttpPendingResult parent = this;
        this.call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                waiter.add(new QueuedResponse(parent, e));
            }

            public void onResponse(Response response) throws IOException {
                waiter.add(new QueuedResponse(parent, response));
            }
        });
        QueuedResponse r = (QueuedResponse)waiter.take();
        if (r.response != null) {
            return this.parseResponse(r.request, r.response);
        }
        throw r.e;
    }

    @Override
    public T awaitIgnoreError() {
        try {
            return this.await();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void onFailure(Request request, IOException ioe) {
        if (this.callback != null) {
            this.callback.onFailure(ioe);
        }
    }

    public void onResponse(Response response) throws IOException {
        if (this.callback != null) {
            try {
                this.callback.onResult(this.parseResponse(this, response));
            }
            catch (Exception e) {
                this.callback.onFailure(e);
            }
        }
    }

    private T parseResponse(OkHttpPendingResult<T, R> request, Response response) throws Exception {
        ApiResponse resp;
        if (RETRY_ERROR_CODES.contains(response.code()) && this.cumulativeSleepTime < this.errorTimeOut) {
            return super.retry();
        }
        byte[] bytes = this.getBytes(response);
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("image") && this.responseClass == PhotoRequest.Response.class && response.code() == 200) {
            PhotoResult result = new PhotoResult();
            result.contentType = contentType;
            result.imageData = bytes;
            return (T)result;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new DateTimeAdapter()).registerTypeAdapter(Distance.class, (Object)new DistanceAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(Fare.class, (Object)new FareAdapter()).registerTypeAdapter(LatLng.class, (Object)new LatLngAdapter()).registerTypeAdapter(AddressComponentType.class, new SafeEnumAdapter<AddressComponentType>(AddressComponentType.UNKNOWN)).registerTypeAdapter(AddressType.class, new SafeEnumAdapter<AddressType>(AddressType.UNKNOWN)).registerTypeAdapter(TravelMode.class, new SafeEnumAdapter<TravelMode>(TravelMode.UNKNOWN)).registerTypeAdapter(LocationType.class, new SafeEnumAdapter<LocationType>(LocationType.UNKNOWN)).registerTypeAdapter(PlaceDetails.Review.AspectRating.RatingType.class, new SafeEnumAdapter<PlaceDetails.Review.AspectRating.RatingType>(PlaceDetails.Review.AspectRating.RatingType.UNKNOWN)).registerTypeAdapter(OpeningHours.Period.OpenClose.DayOfWeek.class, (Object)new DayOfWeekAdaptor()).registerTypeAdapter(PlaceDetails.PriceLevel.class, (Object)new PriceLevelAdaptor()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeAdapter()).setFieldNamingPolicy(this.fieldNamingPolicy).create();
        try {
            resp = (ApiResponse)gson.fromJson(new String(bytes, "utf8"), this.responseClass);
        }
        catch (JsonSyntaxException e) {
            if (!response.isSuccessful()) {
                throw new IOException(String.format("Server Error: %d %s", response.code(), response.message()));
            }
            throw e;
        }
        if (resp.successful()) {
            return resp.getResult();
        }
        ApiException e = resp.getError();
        if (e instanceof OverQueryLimitException && this.cumulativeSleepTime < this.errorTimeOut) {
            return super.retry();
        }
        throw e;
    }

    private byte[] getBytes(Response response) throws IOException {
        int bytesRead;
        InputStream in = response.body().byteStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((bytesRead = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private T retry() throws Exception {
        ++this.retryCounter;
        int n = this.retryCounter;
        LOG.info(new StringBuilder(36).append("Retrying request. Retry #").append(n).toString());
        this.call = this.client.newCall(this.request);
        return this.await();
    }

    private class QueuedResponse {
        private final OkHttpPendingResult<T, R> request;
        private final Response response;
        private final Exception e;

        public QueuedResponse(OkHttpPendingResult<T, R> request, Response response) {
            this.request = request;
            this.response = response;
            this.e = null;
        }

        public QueuedResponse(OkHttpPendingResult<T, R> request, Exception e) {
            this.request = request;
            this.response = null;
            this.e = e;
        }
    }
}

