/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.internal.StringJoin;
import com.google.maps.model.AddressComponent;
import com.google.maps.model.Geometry;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.Photo;
import com.google.maps.model.PlaceIdScope;
import java.net.URL;
import org.joda.time.Instant;

public class PlaceDetails {
    public AddressComponent[] addressComponents;
    public String formattedAddress;
    public String formattedPhoneNumber;
    public Geometry geometry;
    public URL icon;
    public String internationalPhoneNumber;
    public String name;
    public OpeningHours openingHours;
    public Photo[] photos;
    public String placeId;
    public PlaceIdScope scope;
    public AlternatePlaceIds[] altIds;
    public PriceLevel priceLevel;
    public float rating;
    public Review[] reviews;
    public String[] types;
    public URL url;
    public int utcOffset;
    public String vicinity;
    public URL website;
    public String[] htmlAttributions;

    public static class Review {
        public AspectRating[] aspects;
        public String authorName;
        public URL authorUrl;
        public String language;
        public int rating;
        public String text;
        public Instant time;

        public static class AspectRating {
            public RatingType type;
            public int rating;

            public static enum RatingType {
                APPEAL,
                ATMOSPHERE,
                DECOR,
                FACILITIES,
                FOOD,
                OVERALL,
                QUALITY,
                SERVICE,
                UNKNOWN;

            }
        }
    }

    public static enum PriceLevel implements StringJoin.UrlValue
    {
        FREE("0"),
        INEXPENSIVE("1"),
        MODERATE("2"),
        EXPENSIVE("3"),
        VERY_EXPENSIVE("4"),
        UNKNOWN("Unknown");

        private final String priceLevel;

        private PriceLevel(String priceLevel) {
            this.priceLevel = priceLevel;
        }

        public String toString() {
            return this.priceLevel;
        }

        @Override
        public String toUrlValue() {
            if (this == UNKNOWN) {
                throw new UnsupportedOperationException("Shouldn't use PriceLevel.UNKNOWN in a request.");
            }
            return this.priceLevel;
        }
    }

    public static class AlternatePlaceIds {
        public String placeId;
        public PlaceIdScope scope;
    }
}

