/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.OkHttpRequestHandler;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.ExceptionResult;
import com.google.maps.internal.UrlSigner;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class GeoApiContext {
    private static final String VERSION = "0.1.14";
    private static final String USER_AGENT = "GoogleGeoApiClientJava/0.1.14";
    private static final int DEFAULT_BACKOFF_TIMEOUT_MILLIS = 60000;
    private String baseUrlOverride;
    private String apiKey;
    private String clientId;
    private UrlSigner urlSigner;
    private String channel;
    private RequestHandler requestHandler;
    private static final Logger LOG = Logger.getLogger(GeoApiContext.class.getName());
    private long errorTimeout = 60000L;

    public GeoApiContext() {
        this(new OkHttpRequestHandler());
    }

    public GeoApiContext(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(ApiConfig config, Class<? extends R> clazz, Map<String, String> params) {
        if (this.channel != null && !this.channel.isEmpty() && !params.containsKey("channel")) {
            params.put("channel", this.channel);
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            query.append('&').append(param.getKey()).append("=");
            try {
                query.append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new ExceptionResult(e);
            }
        }
        return this.getWithPath(clazz, config.fieldNamingPolicy, config.hostName, config.path, config.supportsClientId, query.toString());
    }

    <T, R extends ApiResponse<T>> PendingResult<T> get(ApiConfig config, Class<? extends R> clazz, String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Params must be matching key/value pairs.");
        }
        StringBuilder query = new StringBuilder();
        boolean channelSet = false;
        for (int i = 0; i < params.length; ++i) {
            if (params[i].equals("channel")) {
                channelSet = true;
            }
            query.append('&').append(params[i]).append('=');
            ++i;
            try {
                query.append(URLEncoder.encode(params[i], "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                return new ExceptionResult(e);
            }
        }
        if (!channelSet && this.channel != null && !this.channel.isEmpty()) {
            query.append("&channel=").append(this.channel);
        }
        return this.getWithPath(clazz, config.fieldNamingPolicy, config.hostName, config.path, config.supportsClientId, query.toString());
    }

    private <T, R extends ApiResponse<T>> PendingResult<T> getWithPath(Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, String hostName, String path, boolean canUseClientId, String encodedPath) {
        this.checkContext(canUseClientId);
        if (!encodedPath.startsWith("&")) {
            throw new IllegalArgumentException("encodedPath must start with &");
        }
        StringBuilder url = new StringBuilder(path);
        if (canUseClientId && this.clientId != null) {
            url.append("?client=").append(this.clientId);
        } else {
            url.append("?key=").append(this.apiKey);
        }
        url.append(encodedPath);
        if (canUseClientId && this.clientId != null) {
            try {
                String signature = this.urlSigner.getSignature(url.toString());
                url.append("&signature=").append(signature);
            }
            catch (Exception e) {
                return new ExceptionResult(e);
            }
        }
        if (this.baseUrlOverride != null) {
            hostName = this.baseUrlOverride;
        }
        return this.requestHandler.handle(hostName, url.toString(), USER_AGENT, clazz, fieldNamingPolicy, this.errorTimeout);
    }

    private void checkContext(boolean canUseClientId) {
        if (this.urlSigner == null && this.apiKey == null) {
            throw new IllegalStateException("Must provide either API key or Maps for Work credentials.");
        }
        if (!canUseClientId && this.apiKey == null) {
            throw new IllegalStateException("API does not support client ID & secret - you must provide a key");
        }
        if (this.urlSigner == null && !this.apiKey.startsWith("AIza")) {
            throw new IllegalStateException("Invalid API key.");
        }
    }

    GeoApiContext setBaseUrlForTesting(String baseUrl) {
        this.baseUrlOverride = baseUrl;
        return this;
    }

    public GeoApiContext setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public GeoApiContext setEnterpriseCredentials(String clientId, String cryptographicSecret) {
        this.clientId = clientId;
        this.urlSigner = new UrlSigner(cryptographicSecret);
        return this;
    }

    public GeoApiContext setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public GeoApiContext setConnectTimeout(long timeout, TimeUnit unit) {
        this.requestHandler.setConnectTimeout(timeout, unit);
        return this;
    }

    public GeoApiContext setReadTimeout(long timeout, TimeUnit unit) {
        this.requestHandler.setReadTimeout(timeout, unit);
        return this;
    }

    public GeoApiContext setWriteTimeout(long timeout, TimeUnit unit) {
        this.requestHandler.setWriteTimeout(timeout, unit);
        return this;
    }

    public GeoApiContext setRetryTimeout(long timeout, TimeUnit unit) {
        this.errorTimeout = unit.toMillis(timeout);
        return this;
    }

    public GeoApiContext setQueryRateLimit(int maxQps) {
        this.requestHandler.setQueriesPerSecond(maxQps);
        return this;
    }

    public GeoApiContext setQueryRateLimit(int maxQps, int minimumInterval) {
        this.requestHandler.setQueriesPerSecond(maxQps, minimumInterval);
        return this;
    }

    public GeoApiContext setProxy(Proxy proxy) {
        this.requestHandler.setProxy(proxy == null ? Proxy.NO_PROXY : proxy);
        return this;
    }

    public static interface RequestHandler {
        public <T, R extends ApiResponse<T>> PendingResult<T> handle(String var1, String var2, String var3, Class<R> var4, FieldNamingPolicy var5, long var6);

        public void setConnectTimeout(long var1, TimeUnit var3);

        public void setReadTimeout(long var1, TimeUnit var3);

        public void setWriteTimeout(long var1, TimeUnit var3);

        public void setQueriesPerSecond(int var1);

        public void setQueriesPerSecond(int var1, int var2);

        public void setProxy(Proxy var1);
    }
}

