/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.errors;

import com.google.maps.errors.AccessNotConfiguredException;
import com.google.maps.errors.InvalidRequestException;
import com.google.maps.errors.MaxElementsExceededException;
import com.google.maps.errors.NotFoundException;
import com.google.maps.errors.OverQueryLimitException;
import com.google.maps.errors.RequestDeniedException;
import com.google.maps.errors.UnknownErrorException;
import com.google.maps.errors.ZeroResultsException;

public class ApiException
extends Exception {
    private static final long serialVersionUID = -6550606366694345191L;

    protected ApiException(String message) {
        super(message);
    }

    public static ApiException from(String status, String errorMessage) {
        if ("OK".equals(status)) {
            return null;
        }
        if ("INVALID_REQUEST".equals(status)) {
            return new InvalidRequestException(errorMessage);
        }
        if ("MAX_ELEMENTS_EXCEEDED".equals(status)) {
            return new MaxElementsExceededException(errorMessage);
        }
        if ("NOT_FOUND".equals(status)) {
            return new NotFoundException(errorMessage);
        }
        if ("OVER_QUERY_LIMIT".equals(status)) {
            return new OverQueryLimitException(errorMessage);
        }
        if ("REQUEST_DENIED".equals(status)) {
            return new RequestDeniedException(errorMessage);
        }
        if ("UNKNOWN_ERROR".equals(status)) {
            return new UnknownErrorException(errorMessage);
        }
        if ("ZERO_RESULTS".equals(status)) {
            return new ZeroResultsException(errorMessage);
        }
        if ("ACCESS_NOT_CONFIGURED".equals(status)) {
            return new AccessNotConfiguredException(errorMessage);
        }
        if ("INVALID_ARGUMENT".equals(status)) {
            return new InvalidRequestException(errorMessage);
        }
        if ("RESOURCE_EXHAUSTED".equals(status)) {
            return new OverQueryLimitException(errorMessage);
        }
        if ("PERMISSION_DENIED".equals(status)) {
            return new RequestDeniedException(errorMessage);
        }
        String string = String.valueOf("An unexpected error occurred. Status: ");
        return new UnknownErrorException(new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(status).length() + String.valueOf(errorMessage).length()).append(string).append(status).append(", ").append("Message: ").append(errorMessage).toString());
    }
}

