/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResult;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.GaePendingResult;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GaeRequestHandler
implements GeoApiContext.RequestHandler {
    private static final Logger LOG = Logger.getLogger(GaeRequestHandler.class.getName());
    private final URLFetchService client = URLFetchServiceFactory.getURLFetchService();

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handle(String hostName, String url, String userAgent, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries) {
        FetchOptions fetchOptions = FetchOptions.Builder.withDeadline((double)10.0);
        HTTPRequest req = null;
        try {
            req = new HTTPRequest(new URL(hostName + url), HTTPMethod.POST, fetchOptions);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.SEVERE, String.format("Request: %s%s", hostName, url), e);
            throw new RuntimeException(e);
        }
        return new GaePendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries);
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handlePost(String hostName, String url, String payload, String userAgent, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries) {
        FetchOptions fetchOptions = FetchOptions.Builder.withDeadline((double)10.0);
        HTTPRequest req = null;
        try {
            req = new HTTPRequest(new URL(hostName + url), HTTPMethod.POST, fetchOptions);
            req.setHeader(new HTTPHeader("Content-Type", "application/json; charset=utf-8"));
            req.setPayload(payload.getBytes());
        }
        catch (MalformedURLException e) {
            LOG.log(Level.SEVERE, String.format("Request: %s%s", hostName, url), e);
            throw new RuntimeException(e);
        }
        return new GaePendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries);
    }

    @Override
    public void setConnectTimeout(long timeout, TimeUnit unit) {
        throw new RuntimeException("setConnectTimeout not implemented for Google App Engine");
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit unit) {
        throw new RuntimeException("setReadTimeout not implemented for Google App Engine");
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit unit) {
        throw new RuntimeException("setWriteTimeout not implemented for Google App Engine");
    }

    @Override
    public void setQueriesPerSecond(int maxQps) {
        throw new RuntimeException("setQueriesPerSecond not implemented for Google App Engine");
    }

    @Override
    public void setQueriesPerSecond(int maxQps, int minimumInterval) {
        throw new RuntimeException("setQueriesPerSecond not implemented for Google App Engine");
    }

    @Override
    public void setProxy(Proxy proxy) {
        throw new RuntimeException("setProxy not implemented for Google App Engine");
    }
}

